/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.gui.freezing.FreezeFactory;
import pl.mpak.orbada.sqlite.gui.freezing.FreezeViewService;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FreezeAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    private String objectType;

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (FreezeAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)FreezeAction.this.getComponent()).getSelectedRow() >= 0) {
                    PerspectivePanel panel = (PerspectivePanel)SwingUtil.getOwnerComponent(PerspectivePanel.class, (Component)FreezeAction.this.getComponent());
                    IViewAccesibilities accesibilities = panel.getViewAccesibilitiesForChild(FreezeAction.this.getComponent());
                    FreezeFactory freezeFactory = new FreezeFactory(accesibilities);
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String catalogName = vt.getQuery().fieldByName("database").getString();
                        String objectName = vt.getQuery().fieldByName("name").getString();
                        FreezeViewService service = freezeFactory.createInstance(FreezeAction.this.objectType, catalogName, objectName);
                        if (service != null) {
                            accesibilities.createView((ViewProvider)service);
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)FreezeAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"SQLite".equals(database.getDriverType())) {
            return false;
        }
        if ("sqlite-tables-actions".equals(actionType)) {
            this.objectType = "TABLE";
        } else if ("sqlite-views-actions".equals(actionType)) {
            this.objectType = "VIEW";
        } else if ("sqlite-triggers-actions".equals(actionType)) {
            this.objectType = "TRIGGER";
        } else {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("FreezeAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.setShortCut(114, 0);
        this.setActionCommandKey("FreezeAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public boolean isToolButton() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("FreezeAction-description");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

