/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.gui.databases.DatabasesPanelView;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PragmaDatabaseIntegrityCheckAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    public PragmaDatabaseIntegrityCheckAction() {
    }

    public PragmaDatabaseIntegrityCheckAction(Database database) {
        this.setDatabase(database);
        this.setApplication((IApplication)Application.get());
        this.setProperties();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (PragmaDatabaseIntegrityCheckAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)PragmaDatabaseIntegrityCheckAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        IRootTabObjectInfo ip;
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String databaseName = vt.getQuery().fieldByName("name").getString();
                        if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)PragmaDatabaseIntegrityCheckAction.this.stringManager.getString("integrity"), (String)String.format(PragmaDatabaseIntegrityCheckAction.this.stringManager.getString("PragmaDatabaseIntegrityCheckAction-integrity-q"), databaseName), (int[])ModalResult.YESNO, (int)3) == 5 && (ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)PragmaDatabaseIntegrityCheckAction.this.getComponent())) instanceof DatabasesPanelView) {
                            ((DatabasesPanelView)ip).getQueryDetails().open("PRAGMA " + SQLUtil.createSqlName((String)databaseName) + ".INTEGRITY_CHECK");
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)PragmaDatabaseIntegrityCheckAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    private void setProperties() {
        this.setText(this.getDescription());
        this.setActionCommandKey("PragmaDatabaseIntegrityCheckAction");
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/check.gif"));
        this.addActionListener(this.createActionListener());
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"SQLite".equals(database.getDriverType())) {
            return false;
        }
        if (!"sqlite-databases-actions".equals(actionType)) {
            return false;
        }
        this.setProperties();
        return true;
    }

    public boolean isToolButton() {
        return false;
    }

    public String getDescription() {
        return this.stringManager.getString("PragmaDatabaseIntegrityCheckAction-description");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

