/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.gui.wizards.PragmaDatabaseLockingModeWizard;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PragmaDatabaseLockingModeAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    public PragmaDatabaseLockingModeAction() {
    }

    public PragmaDatabaseLockingModeAction(Database database) {
        this.setDatabase(database);
        this.setApplication((IApplication)Application.get());
        this.setProperties();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (PragmaDatabaseLockingModeAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)PragmaDatabaseLockingModeAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        IRootTabObjectInfo ip;
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new PragmaDatabaseLockingModeWizard(PragmaDatabaseLockingModeAction.this.getDatabase(), vt.getQuery().fieldByName("name").getString()), (boolean)true);
                        if (result != null && PragmaDatabaseLockingModeAction.this.getComponent() != null && (ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)PragmaDatabaseLockingModeAction.this.getComponent())) != null) {
                            ip.refresh();
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)PragmaDatabaseLockingModeAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    private void setProperties() {
        this.setText(this.getDescription());
        this.setActionCommandKey("PragmaDatabaseLockingModeAction");
        this.addActionListener(this.createActionListener());
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"SQLite".equals(database.getDriverType())) {
            return false;
        }
        if (!"sqlite-databases-actions".equals(actionType)) {
            return false;
        }
        this.setProperties();
        return true;
    }

    public boolean isToolButton() {
        return false;
    }

    public String getDescription() {
        return this.stringManager.getString("database-locking-mode");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

