/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.util;

import java.awt.EventQueue;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.sqlite.Sql;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class SourceCreator {
    private Database database;
    private SyntaxTextArea textArea;

    public SourceCreator(Database database) {
        this.database = database;
    }

    public SourceCreator(Database database, SyntaxTextArea textArea) {
        this(database);
        this.textArea = textArea;
    }

    public String getSource(final String databaseName, final String objectType, final String objectName) {
        final String source = this.createSource(databaseName, objectType, objectName);
        if (this.textArea != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (SourceCreator.this.textArea instanceof AbsOrbadaSyntaxTextArea) {
                        ((OrbadaSyntaxTextArea)SourceCreator.this.textArea).setDatabaseObject(databaseName, objectType, objectName, source);
                    }
                    SourceCreator.this.textArea.getEditorArea().setCaretPosition(0);
                }
            });
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createSource(String databaseName, String objectType, String objectName) {
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getObjectSource(databaseName, objectType.toLowerCase(), objectName));
            source.open();
            if (!source.eof()) {
                String text = source.fieldByName("sql").getString();
                source.close();
                if (!StringUtil.isEmpty((String)text)) {
                    text = text.replaceFirst("(" + objectName + ")|(\"" + objectName + ")\"", this.database.quoteName(databaseName, objectName));
                    if (StringUtil.equalsIgnoreCase((String)objectType, (String)"view")) {
                        text = "DROP VIEW " + this.database.quoteName(databaseName, objectName) + "\n/\n" + text + "\n/\n";
                    } else if (StringUtil.equalsIgnoreCase((String)objectType, (String)"trigger")) {
                        text = "DROP TRIGGER " + this.database.quoteName(databaseName, objectName) + "\n/\n" + text + "\n/\n";
                    } else if (StringUtil.equalsIgnoreCase((String)objectType, (String)"table")) {
                        text = text + "\n/\n" + this.createIndexSource(databaseName, objectName);
                    }
                }
                String string = text;
                return string;
            }
            String text = "";
            return text;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createIndexSource(String databaseName, String tableName) {
        Query source = this.database.createQuery();
        try {
            StringBuilder sb = new StringBuilder();
            source.setSqlText(Sql.getIndexListSource(databaseName, tableName));
            source.open();
            if (!source.eof()) {
                String text = source.fieldByName("sql").getString();
                String name = source.fieldByName("name").getString();
                if (!StringUtil.isEmpty((String)text)) {
                    text = text.replaceFirst("(" + name + ")|(\"" + name + ")\"", this.database.quoteName(databaseName, name));
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(text);
                sb.append("\n/");
                String string = sb.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return "";
    }
}

