/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.excel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JTable;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import pl.mpak.orbada.export.excel.ExportToExcelDialog;
import pl.mpak.orbada.export.excel.OrbadaExportExcelPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ExportToExcel
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportExcelPlugin.class);
    private String nullDataValue;
    private String fileName;
    private String charset;

    public ExportToExcel() {
        this.setText(this.stringManager.getString("ExportToExcel-text"));
        this.setActionCommandKey("ExportToExcel");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToExcel-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-excel-file");
    }

    private void localConfig() {
        try {
            this.nullDataValue = this.getConfig().getValue("null-data-value").getString();
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void exportTable(JTable table) {
        try {
            Object wb = null;
            String ext = FileUtil.fileExtension((String)this.fileName);
            wb = "xls".equalsIgnoreCase(ext) ? new HSSFWorkbook() : new SXSSFWorkbook();
            Sheet s = wb.createSheet();
            wb.setSheetName(0, "Orbada Export");
            Row row = s.createRow(0);
            for (int c = 0; c < table.getColumnCount(); ++c) {
                Cell cell = row.createCell((int)((short)c));
                cell.setCellType(1);
                cell.setCellValue(new String(table.getColumnModel().getColumn(c).getHeaderValue().toString().getBytes(), this.charset));
            }
            for (int r = 0; r < table.getRowCount(); ++r) {
                Row trow = s.createRow(r + 1);
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    Cell cell;
                    Object o = table.getValueAt(r, c);
                    Variant v = o instanceof Variant ? (Variant)o : new Variant(o);
                    if (v.isNullValue()) {
                        cell = trow.createCell((int)((short)c));
                        cell.setCellType(1);
                        cell.setCellValue(new String(this.nullDataValue.getBytes(), this.charset));
                        continue;
                    }
                    cell = trow.createCell((int)((short)c));
                    cell.setCellType(1);
                    cell.setCellValue(new String(v.toString().getBytes(), this.charset));
                }
            }
            FileOutputStream fileOut = new FileOutputStream(this.fileName);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToExcel.this.getTable(event);
                if (table != null && ExportToExcelDialog.showDialog(ExportToExcel.this.getConfig())) {
                    ExportToExcel.this.localConfig();
                    ExportToExcel.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

