/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.excel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pl.mpak.orbada.export.excel.OrbadaExportExcelPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class ExportToExcelDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportExcelPlugin.class);
    private ISettings config;
    private int modalResult = 0;
    private DocumentListener changeListener;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JComboBox comboCharset;
    private JLabel jLabel17;
    private JLabel jLabel7;
    private TextField textNullDataValue;

    public ExportToExcelDialog(ISettings config) {
        super(SwingUtil.getRootFrame());
        this.config = config;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(ISettings config) {
        ExportToExcelDialog dialog = new ExportToExcelDialog(config);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharset.addItem(charset.displayName());
        }
        this.changeListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.configToDialog();
    }

    private void configToDialog() {
        try {
            this.textNullDataValue.setText(this.config.getValue("null-data-value", new Variant("")).getString());
            this.comboCharset.setSelectedItem(this.config.getValue("charset", new Variant(Charset.defaultCharset().displayName())).getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void dialogToConfig() {
        this.config.setValue("null-data-value", this.textNullDataValue.getText());
        this.config.setValue("charset", new Variant(this.comboCharset.getSelectedItem().toString()));
        this.config.store();
    }

    private boolean selectFile() {
        File lastFile = null;
        try {
            if (!this.config.getValue("file-name").getString().equals("")) {
                lastFile = new File(this.config.getValue("file-name").getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFile = FileUtil.selectFileToSave((Component)this, null, null, (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("ExportToExcelDialog-excel-files"), new String[]{".xls"}), new FileExtensionFilter(this.stringManager.getString("ExportToExcelDialog-excel-files-2003"), new String[]{".xlsx"})});
        if (lastFile != null) {
            this.config.setValue("file-name", new Variant((Object)lastFile.getAbsoluteFile()));
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel7 = new JLabel();
        this.comboCharset = new JComboBox();
        this.jLabel17 = new JLabel();
        this.textNullDataValue = new TextField();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToExcelDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToExcelDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExportToExcelDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("ExportToExcelDialog-charset-dd"));
        this.comboCharset.setEditable(true);
        this.comboCharset.setFont(new Font("Courier New", 0, 12));
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText(this.stringManager.getString("ExportToExcelDialog-empty-value-dd"));
        this.textNullDataValue.setFont(new Font("Courier New", 0, 12));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING, -2, 89, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboCharset, 0, 197, Short.MAX_VALUE).addComponent((Component)this.textNullDataValue, -1, 197, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboCharset, -2, 22, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.textNullDataValue, -2, 22, -2).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (this.selectFile()) {
            this.modalResult = 1;
            this.dialogToConfig();
            this.dispose();
        }
    }
}

