/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import oracle.i18n.text.OraCharsetAL16UTF16;
import oracle.i18n.text.OraCharsetAL16UTF16LE;
import oracle.i18n.text.OraCharsetAL32UTF8;
import oracle.i18n.text.OraCharsetISO2022JP;
import oracle.i18n.text.OraCharsetUTF;
import oracle.i18n.text.OraCharsetUTFE;
import oracle.i18n.text.OraCharsetWithConverter;
import oracle.i18n.text.UTFUtility;
import oracle.i18n.text.converter.CharsetMeta;

public abstract class OraCharset
extends Charset {
    private static final int CONCAIN_CHARSET_TABLE = 2;
    private static final int AL16UTF16_CHARSET = 2000;
    private static final int AL16UTF16LE_CHARSET = 2002;
    private static final int UNICODE_1_CHARSET = 870;
    private static final int UNICODE_2_CHARSET = 871;
    private static final int UTFE_CHARSET = 872;
    private static final int AL32UTF8_CHARSET = 873;
    private static final int ISO2022JP_CHARSET = 9999;
    private static final int ISO2022_JP_OUTLOOK_CHARSET = 9994;
    private static final int ISO2022_JP_OUTLOOK_HWKANA_CHARSET = 9995;
    private static final byte[] REP_CHAR_UTF8 = new byte[]{-17, -65, -67};
    static final String ORACHARSET_PREFIX = "X-ORACLE-";
    private static HashMap OraCharsetCache = null;
    protected int oracleId;

    OraCharset(String string, int n) {
        super(string, null);
        this.oracleId = n;
    }

    static OraCharset getInstance(String string) {
        String string2;
        int n;
        if (!string.toUpperCase(Locale.US).startsWith(ORACHARSET_PREFIX)) {
            return null;
        }
        OraCharset oraCharset = null;
        String string3 = string.substring(ORACHARSET_PREFIX.length()).toUpperCase(Locale.US);
        if (OraCharsetCache != null) {
            oraCharset = (OraCharset)OraCharsetCache.get(string3);
            if (oraCharset != null) {
                return oraCharset;
            }
        } else {
            OraCharsetCache = new HashMap();
        }
        int n2 = n = (string2 = CharsetMeta.getInstance().getCharSetId(string3)) == null ? -1 : Integer.parseInt(string2);
        if (n == -1) {
            return null;
        }
        switch (n) {
            case 2000: {
                oraCharset = new OraCharsetAL16UTF16(string, n);
                break;
            }
            case 870: 
            case 871: {
                oraCharset = new OraCharsetUTF(string, n);
                break;
            }
            case 873: {
                oraCharset = new OraCharsetAL32UTF8(string, n);
                break;
            }
            case 872: {
                oraCharset = new OraCharsetUTFE(string, n);
                break;
            }
            case 2002: {
                oraCharset = new OraCharsetAL16UTF16LE(string, n);
                break;
            }
            case 9999: {
                oraCharset = new OraCharsetISO2022JP(string, n);
                break;
            }
            default: {
                oraCharset = OraCharsetWithConverter.getInstance(string, n);
            }
        }
        OraCharsetCache.put(string3, oraCharset);
        return oraCharset;
    }

    public boolean contains(Charset charset) {
        String string = charset.name().toUpperCase(Locale.US);
        int n = 0;
        if (!string.startsWith(ORACHARSET_PREFIX)) {
            return false;
        }
        n = ((OraCharset)charset).oracleId;
        if (this.oracleId == n) {
            return true;
        }
        CharsetMeta charsetMeta = CharsetMeta.getInstance();
        int[] nArray = charsetMeta.getContainsCharset(this.oracleId);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    abstract String toStringWithReplacement(byte[] var1, int var2, int var3);

    abstract String toString(byte[] var1, int var2, int var3) throws SQLException;

    abstract byte[] convertWithReplacement(String var1);

    abstract byte[] convert(String var1) throws SQLException;

    static int UTFToJavaChar(byte[] byArray, int n, int n2, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n3 = n;
        int n4 = n + n2;
        if (n4 > byArray.length) {
            n4 = byArray.length;
        }
        int n5 = 0;
        block5: while (n3 < n4) {
            byte by = byArray[n3++];
            int n6 = by & 0xF0;
            switch (n6 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)(by & 0xFFFFFFFF);
                    break;
                }
                case 12: 
                case 13: {
                    if (n3 >= n4) {
                        n3 = n4;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c = UTFUtility.conv2ByteUTFtoUTF16(by, byArray[n3++]);
                    cArray[n5++] = c;
                    characterConverterBehavior.onFailConversion(c);
                    break;
                }
                case 14: {
                    if (n3 + 1 >= n4) {
                        n3 = n4;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c = UTFUtility.conv3ByteUTFtoUTF16(by, byArray[n3++], byArray[n3++]);
                    if (by != REP_CHAR_UTF8[0] || byArray[n3 - 2] != REP_CHAR_UTF8[1] || byArray[n3 - 1] != REP_CHAR_UTF8[2]) {
                        characterConverterBehavior.onFailConversion(c);
                    }
                    if (UTFUtility.isHiSurrogate(c)) {
                        char c2;
                        if (n3 >= n4) continue block5;
                        by = byArray[n3];
                        if ((byte)(by & 0xF0) != -32) {
                            cArray[n5++] = 65533;
                            characterConverterBehavior.onFailConversion();
                            break;
                        }
                        if (++n3 + 1 >= n4) {
                            n3 = n4;
                            characterConverterBehavior.onFailConversion();
                            break;
                        }
                        if (UTFUtility.isLoSurrogate(c2 = UTFUtility.conv3ByteUTFtoUTF16(by, byArray[n3++], byArray[n3++]))) {
                            cArray[n5++] = c;
                        } else {
                            cArray[n5++] = 65533;
                            characterConverterBehavior.onFailConversion();
                        }
                        cArray[n5++] = c2;
                        break;
                    }
                    cArray[n5++] = c;
                    break;
                }
                default: {
                    cArray[n5++] = 65533;
                    characterConverterBehavior.onFailConversion();
                }
            }
        }
        return n5;
    }

    static int AL32UTF8ToJavaChar(byte[] byArray, int n, int n2, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n3 = n;
        int n4 = n + n2;
        if (n4 > byArray.length) {
            n4 = byArray.length;
        }
        int n5 = 0;
        block6: while (n3 < n4) {
            byte by = byArray[n3++];
            int n6 = by & 0xF0;
            switch (n6 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)(by & 0xFFFFFFFF);
                    break;
                }
                case 12: 
                case 13: {
                    if (n3 >= n4) {
                        n3 = n4;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c = UTFUtility.conv2ByteUTFtoUTF16(by, byArray[n3++]);
                    cArray[n5++] = c;
                    characterConverterBehavior.onFailConversion(c);
                    break;
                }
                case 14: {
                    if (n3 + 1 >= n4) {
                        n3 = n4;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c = UTFUtility.conv3ByteAL32UTF8toUTF16(by, byArray[n3++], byArray[n3++]);
                    cArray[n5++] = c;
                    if (by == REP_CHAR_UTF8[0] && byArray[n3 - 2] == REP_CHAR_UTF8[1] && byArray[n3 - 1] == REP_CHAR_UTF8[2]) continue block6;
                    characterConverterBehavior.onFailConversion(c);
                    break;
                }
                case 15: {
                    char c;
                    if (n3 + 2 >= n4) {
                        n3 = n4;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    if ((c = UTFUtility.conv4ByteAL32UTF8toUTF16(by, byArray[n3++], byArray[n3++], byArray[n3++], cArray, n5)) == '\u0001') {
                        characterConverterBehavior.onFailConversion();
                        ++n5;
                        break;
                    }
                    n5 += 2;
                    break;
                }
                default: {
                    cArray[n5++] = 65533;
                    characterConverterBehavior.onFailConversion();
                }
            }
        }
        return n5;
    }

    static int AL16UTF16BytesToJavaChars(byte[] byArray, int n, int n2, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n; n4 < cArray.length && i < n3; i += 2) {
            int n5 = (byArray[i] << 8) + (byArray[i + 1] & 0xFF);
            if (UTFUtility.isHiSurrogate((char)n5)) {
                if (n4 + 1 >= cArray.length || (i += 2) >= n3) continue;
                char c = (char)((byArray[i] << 8) + (byArray[i + 1] & 0xFF));
                cArray[n4++] = UTFUtility.isLoSurrogate(c) ? n5 : 65533;
                cArray[n4++] = c;
                continue;
            }
            cArray[n4++] = n5;
        }
        return n4;
    }

    static int AL16UTF16LEBytesToJavaChars(byte[] byArray, int n, int n2, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n; n4 < cArray.length && i < n3; i += 2) {
            int n5 = (byArray[i + 1] << 8) + (byArray[i] & 0xFF);
            if (UTFUtility.isHiSurrogate((char)n5)) {
                if (n4 + 1 >= cArray.length || (i += 2) >= n3) continue;
                char c = (char)((byArray[i + 1] << 8) + (byArray[i] & 0xFF));
                cArray[n4++] = UTFUtility.isLoSurrogate(c) ? n5 : 65533;
                cArray[n4++] = c;
                continue;
            }
            cArray[n4++] = n5;
        }
        return n4;
    }

    static int javaCharsToAL16UTF16Bytes(char[] cArray, int n, byte[] byArray) {
        int n2 = Math.min(n, byArray.length >>> 1);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byArray[n4] = (byte)(cArray[n3] >>> 8);
            byArray[n4 + 1] = (byte)(cArray[n3] & 0xFF);
            ++n3;
            n4 += 2;
        }
        return n4;
    }

    static int javaCharsToAL16UTF16LEBytes(char[] cArray, int n, byte[] byArray) {
        int n2 = Math.min(n, byArray.length >>> 1);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byArray[n4] = (byte)(cArray[n3] & 0xFF);
            byArray[n4 + 1] = (byte)(cArray[n3] >>> 8);
            ++n3;
            n4 += 2;
        }
        return n4;
    }

    public static int UTFStringLength(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = n + n2;
        block6: while (n4 < n5) {
            switch ((byArray[n4] & 0xF0) >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n4;
                    ++n3;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if (n4 + 1 >= n5) {
                        n4 = n5;
                        continue block6;
                    }
                    ++n3;
                    n4 += 2;
                    continue block6;
                }
                case 14: {
                    if (n4 + 2 >= n5) {
                        n4 = n5;
                        continue block6;
                    }
                    ++n3;
                    n4 += 3;
                    continue block6;
                }
                case 15: {
                    if (n4 + 3 >= n5) {
                        n4 = n5;
                        continue block6;
                    }
                    n3 += 2;
                    n4 += 4;
                    continue block6;
                }
            }
            ++n4;
            ++n3;
        }
        return n3;
    }

    static int javaCharsToUTF(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = n;
        int n5 = n + n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 > cArray.length) {
            n5 = cArray.length;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n6 = n3;
        for (int i = n4; i < n5; ++i) {
            char c = cArray[i];
            if (c >= '\u0000' && c <= '\u007f') {
                byArray[n6++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n6++] = (byte)(0xE0 | c >>> 12 & 0xF);
                byArray[n6++] = (byte)(0x80 | c >>> 6 & 0x3F);
                byArray[n6++] = (byte)(0x80 | c >>> 0 & 0x3F);
                continue;
            }
            byArray[n6++] = (byte)(0xC0 | c >>> 6 & 0x1F);
            byArray[n6++] = (byte)(0x80 | c >>> 0 & 0x3F);
        }
        return n6 - n3;
    }

    static int javaCharsToAL32UTF8(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = n;
        int n5 = n + n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 > cArray.length) {
            n5 = cArray.length;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n6 = n3;
        for (int i = n4; i < n5; ++i) {
            char c = cArray[i];
            char c2 = '\u0000';
            if (c >= '\u0000' && c <= '\u007f') {
                byArray[n6++] = (byte)c;
                continue;
            }
            if (UTFUtility.isHiSurrogate(c)) {
                if (i + 1 < n5 && UTFUtility.isLoSurrogate(c2 = cArray[i + 1])) {
                    int n7 = (c >>> 6 & 0xF) + 1;
                    byArray[n6++] = (byte)(n7 >>> 2 | 0xF0);
                    byArray[n6++] = (byte)((n7 & 3) << 4 | c >>> 2 & 0xF | 0x80);
                    byArray[n6++] = (byte)((c & 3) << 4 | c2 >>> 6 & 0xF | 0x80);
                    byArray[n6++] = (byte)(c2 & 0x3F | 0x80);
                    ++i;
                    continue;
                }
                byArray[n6++] = -17;
                byArray[n6++] = -65;
                byArray[n6++] = -67;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n6++] = (byte)(0xE0 | c >>> 12 & 0xF);
                byArray[n6++] = (byte)(0x80 | c >>> 6 & 0x3F);
                byArray[n6++] = (byte)(0x80 | c >>> 0 & 0x3F);
                continue;
            }
            byArray[n6++] = (byte)(0xC0 | c >>> 6 & 0x1F);
            byArray[n6++] = (byte)(0x80 | c >>> 0 & 0x3F);
        }
        return n6 - n3;
    }

    public static int stringUTFLength(String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (c >= '\u0000' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    public static int string32UTF8Length(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (c >= '\u0000' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                if (UTFUtility.isHiSurrogate(c)) {
                    if (i + 1 >= n2) continue;
                    n += 4;
                    ++i;
                    continue;
                }
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    public static boolean isDefined(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\udc00' && c <= '\udfff') {
                return false;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i + 1 >= n) {
                    return false;
                }
                char c2 = string.charAt(i + 1);
                if (c2 < '\udc00' || c2 > '\udfff') {
                    return false;
                }
                ++i;
                continue;
            }
            if (c != '\ufffe' && c != '\uffff') continue;
            return false;
        }
        return true;
    }

    static abstract class CharacterConverterBehavior {
        public static final char[] NULL_CHARS = new char[1];
        public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior("Report Error"){

            public void onFailConversion() throws UTFDataFormatException {
                throw new UTFDataFormatException();
            }

            public void onFailConversion(char c) throws UTFDataFormatException {
                if (c == '\ufffd') {
                    throw new UTFDataFormatException();
                }
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior("Replacement"){

            public void onFailConversion() throws UTFDataFormatException {
            }

            public void onFailConversion(char c) throws UTFDataFormatException {
            }
        };
        private final String m_name;

        public CharacterConverterBehavior(String string) {
            this.m_name = string;
        }

        public abstract void onFailConversion(char var1) throws UTFDataFormatException;

        public abstract void onFailConversion() throws UTFDataFormatException;
    }
}

