/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.jsondataview.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pl.mpak.orbada.jsondataview.OrbadaJsonDataViewPlugin;
import pl.mpak.orbada.jsondataview.gui.ITag;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ViewJsonDataPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaJsonDataViewPlugin.class);
    private Object value;
    private JScrollPane jScrollPane1;
    private JTree treeXml;

    public ViewJsonDataPanel(Object value) {
        this.value = value;
        this.initComponents();
        this.init();
    }

    private void expandObject(DefaultMutableTreeNode aNode, JSONObject object) throws JSONException {
        Iterator i = object.keys();
        while (i.hasNext()) {
            DefaultMutableTreeNode node;
            Object key = i.next();
            Object json = object.get(key.toString());
            if (json instanceof JSONObject) {
                node = new DefaultMutableTreeNode(new ITag(key.toString(), "<object>"));
                this.expandObject(node, (JSONObject)json);
                aNode.add(node);
                continue;
            }
            if (json instanceof JSONArray) {
                node = new DefaultMutableTreeNode(new ITag(key.toString(), "[array]"));
                this.expandArray(node, (JSONArray)json);
                aNode.add(node);
                continue;
            }
            aNode.add(new DefaultMutableTreeNode(new ITag(key.toString(), json.toString())));
        }
    }

    private void expandArray(DefaultMutableTreeNode aNode, JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            DefaultMutableTreeNode node;
            Object o = array.get(i);
            if (o instanceof JSONObject) {
                node = new DefaultMutableTreeNode(new ITag("(noname)", "<object>"));
                this.expandObject(node, (JSONObject)o);
                aNode.add(node);
                continue;
            }
            if (o instanceof JSONArray) {
                node = new DefaultMutableTreeNode(new ITag("(noname)", "[array]"));
                this.expandArray(node, (JSONArray)o);
                aNode.add(node);
                continue;
            }
            aNode.add(new DefaultMutableTreeNode(new ITag(o.toString())));
        }
    }

    private TreeModel parse(String source) throws Exception {
        source = source.trim();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ITag("root"));
        if (source.length() >= 2 && source.charAt(0) == '[' && source.charAt(source.length() - 1) == ']') {
            JSONArray array = new JSONArray(source);
            this.expandArray(root, array);
        } else {
            JSONObject object = new JSONObject(source);
            this.expandObject(root, object);
        }
        return new DefaultTreeModel(root);
    }

    private void init() {
        if (this.value != null) {
            try {
                this.treeXml.setModel(this.parse(this.value.toString()));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    public void close() throws IOException {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.treeXml = new JTree();
        this.setLayout(new BorderLayout());
        this.treeXml.setModel(null);
        this.jScrollPane1.setViewportView(this.treeXml);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

