/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.csv;

import com.csvreader.CsvWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JTable;
import pl.mpak.orbada.export.csv.ExportToCsvDialog;
import pl.mpak.orbada.export.csv.OrbadaExportCsvPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class ExportToCsv
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportCsvPlugin.class);
    private String nullDataValue;
    private String fileName;
    private String charset;
    private String fieldDelimiter;
    private Boolean columnNames;
    private String textQualifier;
    private Boolean forceTextQualifier;
    private String escapeMode;
    private String endOfLineChar;

    public ExportToCsv() {
        this.setText(this.stringManager.getString("ExportToCsv-text"));
        this.setActionCommandKey("ExportToCsv");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToCsv-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-csv-file");
    }

    private void localConfig() {
        try {
            this.nullDataValue = this.getConfig().getValue("null-data-value").getString();
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
            this.fieldDelimiter = this.getConfig().getValue("field-delimiter", ",");
            if (StringUtil.isEmpty((String)this.fieldDelimiter)) {
                this.fieldDelimiter = ",";
            } else if (StringUtil.equals((String)"TAB", (String)this.fieldDelimiter)) {
                this.fieldDelimiter = "\t";
            } else if (StringUtil.equals((String)"SPACE", (String)this.fieldDelimiter)) {
                this.fieldDelimiter = " ";
            }
            this.columnNames = this.getConfig().getValue("column-names", Boolean.valueOf(true));
            this.textQualifier = this.getConfig().getValue("text-qualifier", "\"").trim();
            this.forceTextQualifier = this.getConfig().getValue("force-text-qualifier", Boolean.valueOf(false));
            this.escapeMode = this.getConfig().getValue("escape-mode", "\\");
            this.endOfLineChar = this.getConfig().getValue("end-of-line-char", "\\n");
            if (StringUtil.equals((String)"\\n", (String)this.endOfLineChar)) {
                this.endOfLineChar = "\n";
            } else if (StringUtil.equals((String)"\\r", (String)this.endOfLineChar)) {
                this.endOfLineChar = "\r";
            } else if (StringUtil.equals((String)"\\f", (String)this.endOfLineChar)) {
                this.endOfLineChar = "\f";
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTable(JTable table) {
        File file = new File(this.fileName);
        if (file.exists()) {
            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("ExportToCsv-csv-save"), (String)this.stringManager.getString("ExportToCsv-file-exist-rewrite-q"), (int[])ModalResult.YESNO, (int)3) == 6) {
                return;
            }
            file.delete();
        }
        CsvWriter writer = null;
        try {
            writer = new CsvWriter((OutputStream)new FileOutputStream(file), this.fieldDelimiter.charAt(0), Charset.forName(this.charset));
            if ("BACKSLASH".equals(this.escapeMode)) {
                writer.setEscapeMode(2);
            } else if ("DOUBLED".equals(this.escapeMode)) {
                writer.setEscapeMode(1);
            }
            writer.setRecordDelimiter(this.endOfLineChar.charAt(0));
            if (!"".equals(this.textQualifier)) {
                writer.setTextQualifier(this.textQualifier.charAt(0));
                writer.setForceQualifier(this.forceTextQualifier.booleanValue());
            }
            if (this.columnNames.booleanValue()) {
                String[] names = new String[table.getColumnCount()];
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    if (table.getColumnModel().getColumn(c) instanceof QueryTableColumn) {
                        QueryTableColumn column = (QueryTableColumn)table.getColumnModel().getColumn(c);
                        names[c] = column.getFieldName();
                        continue;
                    }
                    names[c] = table.getColumnModel().getColumn(c).getHeaderValue().toString();
                }
                writer.writeRecord(names);
            }
            String[] values = new String[table.getColumnCount()];
            for (int r = 0; r < table.getRowCount(); ++r) {
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    String s = "";
                    Object o = table.getValueAt(r, c);
                    if (o != null) {
                        s = o instanceof Variant ? ((Variant)o).getString() : o.toString();
                        values[c] = s;
                        continue;
                    }
                    values[c] = this.nullDataValue;
                }
                writer.writeRecord(values);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToCsv.this.getTable(event);
                if (table != null && ExportToCsvDialog.showDialog(ExportToCsv.this.getConfig())) {
                    ExportToCsv.this.localConfig();
                    ExportToCsv.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

