/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.csv;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.export.csv.OrbadaExportCsvPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class ExportToCsvDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportCsvPlugin.class);
    private ISettings config;
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkColumnNames;
    private JCheckBox checkForceTextQualifier;
    private Action cmCancel;
    private Action cmOk;
    private JComboBox comboCharset;
    private ComboBox comboDelimiter;
    private ComboBox comboEndOfLineChar;
    private ComboBox comboEscapeMode;
    private ComboBox comboTextQualifier;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel7;
    private TextField textNullDataValue;

    public ExportToCsvDialog(ISettings config) {
        super(SwingUtil.getRootFrame());
        this.config = config;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(ISettings config) {
        ExportToCsvDialog dialog = new ExportToCsvDialog(config);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharset.addItem(charset.displayName());
        }
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.configToDialog();
    }

    private void configToDialog() {
        try {
            this.textNullDataValue.setText(this.config.getValue("null-data-value", ""));
            this.comboCharset.setSelectedItem(this.config.getValue("charset", Charset.defaultCharset().displayName()));
            this.comboDelimiter.setText(this.config.getValue("field-delimiter", ","));
            this.checkColumnNames.setSelected(this.config.getValue("column-names", Boolean.valueOf(true)));
            this.comboTextQualifier.setSelectedItem((Object)this.config.getValue("text-qualifier", "\""));
            this.checkForceTextQualifier.setSelected(this.config.getValue("force-text-qualifier", Boolean.valueOf(false)));
            this.comboEscapeMode.setSelectedItem((Object)this.config.getValue("escape-mode", "BACKSLASH"));
            this.comboEndOfLineChar.setSelectedItem((Object)this.config.getValue("end-of-line-char", "\\n"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void dialogToConfig() {
        this.config.setValue("null-data-value", this.textNullDataValue.getText());
        this.config.setValue("charset", new Variant(this.comboCharset.getSelectedItem().toString()));
        this.config.setValue("field-delimiter", this.comboDelimiter.getText());
        this.config.setValue("column-names", Boolean.valueOf(this.checkColumnNames.isSelected()));
        this.config.setValue("text-qualifier", this.comboTextQualifier.getText());
        this.config.setValue("force-text-qualifier", Boolean.valueOf(this.checkForceTextQualifier.isSelected()));
        this.config.setValue("escape-mode", this.comboEscapeMode.getText());
        this.config.setValue("end-of-line-char", this.comboEndOfLineChar.getText());
        this.config.store();
    }

    private boolean selectFile() {
        File lastFile = null;
        try {
            if (!this.config.getValue("file-name").getString().equals("")) {
                lastFile = new File(this.config.getValue("file-name").getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFile = FileUtil.selectFileToSave((Component)this, null, null, (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("ExportToCsvDialog-csv-files"), new String[]{".csv"})});
        if (lastFile != null) {
            this.config.setValue("file-name", new Variant((Object)lastFile.getAbsoluteFile()));
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel7 = new JLabel();
        this.comboCharset = new JComboBox();
        this.jLabel17 = new JLabel();
        this.textNullDataValue = new TextField();
        this.jLabel18 = new JLabel();
        this.comboDelimiter = new ComboBox();
        this.checkColumnNames = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.comboTextQualifier = new ComboBox();
        this.checkForceTextQualifier = new JCheckBox();
        this.jLabel20 = new JLabel();
        this.comboEscapeMode = new ComboBox();
        this.jLabel21 = new JLabel();
        this.comboEndOfLineChar = new ComboBox();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToCsvDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToCsvDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExportToCsvDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("ExportToCsvDialog-charset-dd"));
        this.comboCharset.setEditable(true);
        this.comboCharset.setFont(new Font("Courier New", 0, 12));
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText(this.stringManager.getString("ExportToCsvDialog-empty-value-dd"));
        this.textNullDataValue.setFont(new Font("Courier New", 0, 12));
        this.jLabel18.setHorizontalAlignment(4);
        this.jLabel18.setText(this.stringManager.getString("ExportToCsvDialog-separator-dd"));
        this.comboDelimiter.setEditable(true);
        this.comboDelimiter.setModel(new DefaultComboBoxModel<String>(new String[]{",", ";", "|", "TAB", "SPACE"}));
        this.checkColumnNames.setText(this.stringManager.getString("ExportToCsvDialog-checkColumnNames-text"));
        this.jLabel19.setHorizontalAlignment(4);
        this.jLabel19.setText(this.stringManager.getString("ExportToCsvDialog-text-qualifier-dd"));
        this.comboTextQualifier.setModel(new DefaultComboBoxModel<String>(new String[]{"\"", "'", "`"}));
        this.checkForceTextQualifier.setText(this.stringManager.getString("ExportToCsvDialog-force-text-qualifier"));
        this.jLabel20.setHorizontalAlignment(4);
        this.jLabel20.setText(this.stringManager.getString("ExportToCsvDialog-escape-mode-dd"));
        this.comboEscapeMode.setModel(new DefaultComboBoxModel<String>(new String[]{"BACKSLASH", "DOUBLED"}));
        this.jLabel21.setHorizontalAlignment(4);
        this.jLabel21.setText(this.stringManager.getString("ExportToCsvDialog-end-of-line-char-dd"));
        this.comboEndOfLineChar.setModel(new DefaultComboBoxModel<String>(new String[]{"\\n", "\\r", "\\f"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.jLabel18, -1, 117, Short.MAX_VALUE).addComponent(this.jLabel19, -1, 117, Short.MAX_VALUE).addComponent(this.jLabel17, -1, 117, Short.MAX_VALUE).addComponent(this.jLabel7, -1, 117, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboCharset, 0, 226, Short.MAX_VALUE).addComponent((Component)this.textNullDataValue, -1, 226, Short.MAX_VALUE).addComponent(this.checkColumnNames).addComponent((Component)this.comboDelimiter, -1, 226, Short.MAX_VALUE).addComponent((Component)this.comboTextQualifier, -1, 226, Short.MAX_VALUE).addComponent(this.checkForceTextQualifier)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel20, -1, 117, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboEscapeMode, -1, 226, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel21, -1, 117, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboEndOfLineChar, -1, 226, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboCharset, -2, 22, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.textNullDataValue, -2, 22, -2).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboDelimiter, -2, -1, -2).addComponent(this.jLabel18)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkColumnNames).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent((Component)this.comboTextQualifier, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkForceTextQualifier).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent((Component)this.comboEscapeMode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboEndOfLineChar, -2, -1, -2).addComponent(this.jLabel21)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (this.selectFile()) {
            this.modalResult = 1;
            this.dialogToConfig();
            this.dispose();
        }
    }
}

