/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.xdb.RealInputStream;
import oracle.xdb.XDBError;
import oracle.xdb.XMLTypeFactory;
import oracle.xdb.dom.XDBDocFragment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.spi.XDBResource;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLType
extends OPAQUE
implements ORAData {
    public static final int _SQL_TYPECODE = 2007;
    public static final String _SQL_NAME = "SYS.XMLTYPE";
    public static final int CONNTYPE_THIN = 0;
    public static final int CONNTYPE_OCI8 = 1;
    public static final int CONNTYPE_KPRB = 2;
    private static final int LOBTYPE_BLOB = 1;
    int m_conntype;
    long m_gpCState = 0L;
    String m_stringval = null;
    ByteArrayOutputStream m_bytesval = null;
    CLOB m_clobval = null;
    BLOB m_blobval = null;
    long m_cstate = 0L;
    OracleConnection m_local_conn;
    Document m_dom = null;
    CharacterSet m_charSet = CharacterSet.make((int)-1);
    private boolean m_isClosed = false;
    private static boolean m_libLoaded = false;
    private int m_csid = 0;
    private CharacterSet m_blobCS = null;
    private static final XMLTypeFactory xmlfactory = new XMLTypeFactory();
    private int m_thinflags;
    private byte[] m_thinsnapshot;
    private byte[] m_thinschoid;
    private byte[] m_thinelemnum;
    static final int XMLTYPE_VERSION = 1;
    static final int XMLTYPE_LOB = 1;
    static final int XMLTYPE_STR = 4;
    static final int XMLTYPE_PTR = 8;
    static final int XMLTYPE_FLAG_SNAPSHOT = 4096;
    static final int XMLTYPE_FLAG_SCHMOID = 8;
    static final int XMLTYPE_SCHMOIDLEN = 16;
    static final int XMLTYPE_ELEMNUMLEN = 4;
    static final int XMLTYPE_KOSNPLEN = 24;

    public XMLType() throws SQLException {
        super(null, null, (Object)new byte[1]);
    }

    private XMLType(Connection connection, long l) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        this.m_cstate = l;
    }

    public XMLType(Connection connection, InputStream inputStream) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (inputStream == null) {
            return;
        }
        byte[] byArray = new byte[1024];
        switch (this.m_conntype) {
            case 0: {
                this.m_bytesval = new ByteArrayOutputStream();
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        this.m_bytesval.write(byArray, 0, n);
                    }
                    break;
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
            }
            case 1: 
            case 2: {
                try {
                    long l = 0L;
                    try {
                        int n;
                        int n2 = 0;
                        while ((n = inputStream.read(byArray)) != -1) {
                            l = this.WriteToSegStreamNative(this.m_gpCState, this.getErrHandle(), l, byArray, n2, n);
                            n2 += byArray.length;
                        }
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                    this.m_cstate = this.createXMLTypeFromStreamNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), l);
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_bytesval = new ByteArrayOutputStream();
                    try {
                        int n;
                        while ((n = inputStream.read(byArray)) != -1) {
                            this.m_bytesval.write(byArray, 0, n);
                        }
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                }
            }
        }
    }

    public XMLType(Connection connection, String string) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (string == null) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                this.m_stringval = string;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), string, null, false, false);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_stringval = string;
                }
                break;
            }
        }
    }

    public XMLType(Connection connection, String string, String string2, boolean bl, boolean bl2) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (string == null) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                this.m_stringval = string;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromStringNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), string, string2, bl, bl2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_stringval = string;
                }
                break;
            }
        }
    }

    public XMLType(Connection connection, BLOB bLOB, int n) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        if (n < 0 || this.m_conntype == 0 && n == 0) {
            throw new SQLException(XDBError.getMsg("INVALID_CSID"));
        }
        this.m_csid = n;
        this.m_blobCS = CharacterSet.make((int)this.m_csid);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (bLOB == null) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                this.m_blobval = bLOB;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), bLOB.getLocator(), n, 1, null, false, false);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_blobval = bLOB;
                }
                break;
            }
        }
    }

    public XMLType(Connection connection, CLOB cLOB) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (cLOB == null) {
            return;
        }
        this.getCStateFromLocator(cLOB);
    }

    public XMLType(Connection connection, CLOB cLOB, String string, boolean bl, boolean bl2) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (cLOB == null) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                this.m_clobval = cLOB;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), cLOB.getLocator(), 0, 0, string, bl, bl2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_clobval = cLOB;
                }
                break;
            }
        }
    }

    public XMLType(Connection connection, Document document) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (document instanceof XDBDocument) {
            this.m_cstate = XMLType.getCStateFromXobd(connection, document);
        } else if (document instanceof XMLDocument) {
            CLOB cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            try {
                PrintWriter printWriter = new PrintWriter(cLOB.getCharacterOutputStream());
                ((XMLDocument)document).print(printWriter);
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
            this.getCStateFromLocator(cLOB);
        }
    }

    public XMLType(OpaqueDescriptor opaqueDescriptor, Connection connection, Object object) throws SQLException {
        super(opaqueDescriptor, connection, object == null ? (Object)new byte[1] : object);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.getDbCsId());
        if (object == null) {
            return;
        }
        byte[] byArray = (byte[])object;
        int n = 0;
        switch (this.m_conntype) {
            case 0: {
                this.processThin(byArray, n);
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.processCState(byArray, n);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.processThin(byArray, 0);
                    this.m_cstate = 0L;
                }
                break;
            }
        }
    }

    private synchronized native long WriteToSegStreamNative(long var1, long var3, long var5, byte[] var7, int var8, int var9);

    private static int bytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 24;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 16;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 8;
        return n2 += XMLType.unsignedByteToInt(byArray[n++]);
    }

    public void close() {
        this.freeXMLType();
    }

    private synchronized native void closeNative(long var1, long var3, long var5, long var7);

    public XMLType createSchemaBasedXML(String string) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return new XMLType((Connection)this.m_local_conn, this.getClobVal(), string, false, false);
    }

    public static XMLType createXML(Connection connection, InputStream inputStream) throws SQLException {
        return new XMLType(connection, inputStream);
    }

    public static XMLType createXML(Connection connection, String string) throws SQLException {
        return new XMLType(connection, string);
    }

    public static XMLType createXML(Connection connection, String string, String string2, boolean bl, boolean bl2) throws SQLException {
        return new XMLType(connection, string, string2, bl, bl2);
    }

    public static XMLType createXML(Connection connection, CLOB cLOB) throws SQLException {
        return new XMLType(connection, cLOB);
    }

    public static XMLType createXML(Connection connection, CLOB cLOB, String string, boolean bl, boolean bl2) throws SQLException {
        return new XMLType(connection, cLOB, string, bl, bl2);
    }

    public static XMLType createXML(Connection connection, Document document) throws SQLException {
        if (document instanceof XDBDocument) {
            long l = XMLType.getCStateFromXobd(connection, document);
            XMLType xMLType = new XMLType(connection, l);
            return xMLType;
        }
        if (document instanceof XMLDocument) {
            Object object;
            CLOB cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            try {
                object = new PrintWriter(cLOB.getCharacterOutputStream());
                ((XMLDocument)document).print(object);
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
            object = XMLType.createXML(connection, cLOB);
            return object;
        }
        return null;
    }

    public static XMLType createXML(OPAQUE oPAQUE) throws SQLException {
        String string = oPAQUE.getSQLTypeName();
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        SQLName.setHandleDoubleQuote((boolean)true);
        SQLName.parse((String)string, (String[])stringArray, (String[])stringArray2);
        if (stringArray2[0].compareTo("XMLTYPE") != 0) {
            return null;
        }
        return new XMLType(oPAQUE.getDescriptor(), oPAQUE.getJavaSqlConnection(), oPAQUE.getBytesValue());
    }

    private synchronized native long createXMLTypeFromLobNative(long var1, long var3, long var5, byte[] var7, int var8, int var9, String var10, boolean var11, boolean var12);

    private synchronized native long createXMLTypeFromStreamNative(long var1, long var3, long var5, long var7);

    private synchronized native long createXMLTypeFromStringNative(long var1, long var3, long var5, String var7, String var8, boolean var9, boolean var10);

    public boolean existsNode(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean bl = this.existsNodeNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, string, string2);
        return bl;
    }

    private synchronized native boolean existsNodeNative(long var1, long var3, long var5, String var7, String var8);

    public XMLType extract(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long l = this.extractNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, string, string2);
        if (l != 0L) {
            return new XMLType((Connection)this.m_local_conn, l);
        }
        return null;
    }

    private synchronized native long extractNative(long var1, long var3, long var5, String var7, String var8);

    public void finalize() {
    }

    private void freeXMLType() {
        if (this.m_isClosed) {
            return;
        }
        switch (this.m_conntype) {
            case 0: {
                if (this.m_clobval != null) {
                    try {
                        if (CLOB.isTemporary((CLOB)this.m_clobval)) {
                            this.m_clobval.freeTemporary();
                        } else {
                            this.m_clobval.close();
                        }
                        this.m_clobval = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.m_blobval == null) break;
                try {
                    if (BLOB.isTemporary((BLOB)this.m_blobval)) {
                        this.m_blobval.freeTemporary();
                    } else {
                        this.m_blobval.close();
                    }
                    this.m_blobval = null;
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 1: 
            case 2: {
                if (this.m_dom != null) {
                    ((XDBDocument)this.m_dom).close();
                }
                try {
                    this.closeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                    this.m_cstate = 0L;
                }
                catch (SQLException sQLException) {
                    this.m_cstate = 0L;
                }
                break;
            }
        }
        this.m_isClosed = true;
    }

    private ByteArrayOutputStream getBinaryStream(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[1024];
            InputStream inputStream = bLOB.getBinaryStream();
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        return byteArrayOutputStream;
    }

    public BLOB getBlobVal(int n) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (n <= 0) {
            throw new SQLException(XDBError.getMsg("INVALID_CSID"));
        }
        if (this.m_blobval != null && this.m_csid == n) {
            return this.m_blobval;
        }
        BLOB bLOB = BLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
        CharacterSet characterSet = CharacterSet.make((int)n);
        if (this.m_blobval != null) {
            ByteArrayOutputStream byteArrayOutputStream = this.getBinaryStream(this.m_blobval);
            byte[] byArray = characterSet.convert(this.m_blobCS, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            bLOB.putBytes(1L, byArray);
        } else if (this.m_bytesval != null) {
            if (this.m_csid == 0) {
                bLOB.putBytes(1L, this.m_bytesval.toByteArray());
            } else {
                byte[] byArray = characterSet.convert(this.m_blobCS, this.m_bytesval.toByteArray(), 0, this.m_bytesval.size());
                bLOB.putBytes(1L, byArray);
            }
        } else if (this.m_conntype == 0) {
            if (this.m_stringval == null) {
                this.m_stringval = this.getStringVal();
            }
            if (this.m_stringval != null) {
                byte[] byArray = characterSet.convert(this.m_stringval);
                bLOB.putBytes(1L, byArray);
            }
        } else if (this.m_cstate != 0L) {
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, bLOB.getLocator(), n);
        }
        return bLOB;
    }

    private byte[] getBytesBytes() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 4);
            byteArrayOutputStream.write(this.m_bytesval.toByteArray());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getBytesLob() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 1);
            byteArrayOutputStream.write(this.m_clobval.getLocator());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getBytesPtr(OracleConnection oracleConnection) throws SQLException {
        byte[] byArray = this.pickleXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
        return byArray;
    }

    private byte[] getBytesString() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 4);
            byteArrayOutputStream.write(this.m_charSet.convert(this.m_stringval));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getBytesValue() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_blobval != null) {
            this.m_clobval = this.getClobVal();
        }
        if (this.m_clobval != null) {
            return this.getBytesLob();
        }
        if (this.m_stringval != null) {
            return this.getBytesString();
        }
        if (this.m_bytesval != null) {
            return this.getBytesBytes();
        }
        if (this.m_conntype == 2 || this.m_conntype == 1) {
            return this.getBytesPtr(this.m_local_conn);
        }
        return null;
    }

    private void getCStateFromLocator(CLOB cLOB) throws SQLException {
        switch (this.m_conntype) {
            case 0: {
                this.m_clobval = cLOB;
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.m_cstate = this.createXMLTypeFromLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), cLOB.getLocator(), 0, 0, null, false, false);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.m_conntype = 0;
                    this.m_clobval = cLOB;
                }
                break;
            }
        }
    }

    private static long getCStateFromXobd(Connection connection, Document document) throws SQLException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (((OracleConnection)connection).getProtocolType().equals("kprb")) {
            l = XDBResource.getServerEnv();
        } else {
            Properties properties = ((OracleConnection)connection).getOCIHandles();
            l2 = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            l3 = Long.parseLong(properties.getProperty("OCIErrHandle"));
        }
        l4 = XMLType.getXMLTypeFromXobd(l, l2, l3, ((XDBDocument)document).toCState());
        return l4;
    }

    private String getClobStr(CLOB cLOB) throws SQLException {
        String string = null;
        try {
            int n;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            char[] cArray = new char[1024];
            Reader reader = cLOB.getCharacterStream();
            while ((n = reader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n);
            }
            reader.close();
            string = charArrayWriter.toString();
            charArrayWriter.close();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        return string;
    }

    public CLOB getClobVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_clobval != null) {
            return this.m_clobval;
        }
        if (this.m_stringval != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            cLOB.putString(1L, this.m_stringval);
            return cLOB;
        }
        if (this.m_blobval != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            cLOB.putString(1L, this.getStringVal());
            return cLOB;
        }
        if (this.m_cstate != 0L) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, cLOB.getLocator(), 0);
            return cLOB;
        }
        if (this.m_bytesval != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            cLOB.putString(1L, this.getStringFromBinaryStream());
            return cLOB;
        }
        return null;
    }

    public static int getConnType(Connection connection) throws SQLException {
        int n;
        block10: {
            OracleConnection oracleConnection = (OracleConnection)connection;
            if (connection == null) {
                return 2;
            }
            if (oracleConnection.getProtocolType().equals("thin")) {
                n = 0;
            } else if (oracleConnection.getProtocolType().equals("oci8") || oracleConnection.getProtocolType().equals("oci")) {
                n = 1;
                try {
                    if (m_libLoaded) break block10;
                    String string = System.getProperty("os.name");
                    if (string.toUpperCase().startsWith("WINDOWS")) {
                        System.loadLibrary("orageneric10");
                        m_libLoaded = true;
                        break block10;
                    }
                    m_libLoaded = true;
                }
                catch (Exception exception) {
                    n = 0;
                }
            } else if (oracleConnection.getProtocolType().equals("kprb")) {
                n = 2;
            } else {
                throw new SQLException("Unknown connection type.");
            }
        }
        return n;
    }

    public Document getDOM() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            return this.m_dom;
        }
        switch (this.m_conntype) {
            case 0: {
                DOMParser dOMParser = new DOMParser();
                if (this.m_blobval != null && this.m_clobval == null) {
                    this.m_clobval = this.getClobVal();
                }
                if (this.m_stringval != null) {
                    try {
                        dOMParser.parse((Reader)new StringReader(this.m_stringval));
                    }
                    catch (XMLParseException xMLParseException) {
                        throw new SQLException();
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                    catch (SAXException sAXException) {
                        throw new SQLException();
                    }
                    this.m_dom = dOMParser.getDocument();
                    break;
                }
                if (this.m_clobval != null) {
                    try {
                        dOMParser.parse(this.m_clobval.getCharacterStream());
                    }
                    catch (XMLParseException xMLParseException) {
                        throw new SQLException(((SAXException)((Object)xMLParseException)).getMessage());
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getMessage());
                    }
                    catch (SAXException sAXException) {
                        throw new SQLException(sAXException.getMessage());
                    }
                    this.m_dom = dOMParser.getDocument();
                    break;
                }
                if (this.m_bytesval == null) break;
                try {
                    dOMParser.parse((Reader)new StringReader(this.getStringFromBinaryStream()));
                }
                catch (XMLParseException xMLParseException) {
                    throw new SQLException();
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                catch (SAXException sAXException) {
                    throw new SQLException();
                }
                this.m_dom = dOMParser.getDocument();
                break;
            }
            case 1: 
            case 2: {
                long l = this.getXobdFromXMLType(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate);
                this.m_dom = new XDBDocument(this, (Connection)this.m_local_conn, l);
                break;
            }
        }
        return this.m_dom;
    }

    public XDBDocFragment getDocumentFragment() throws SQLException {
        XDBDocFragment xDBDocFragment = null;
        switch (this.m_conntype) {
            case 1: 
            case 2: {
                if (this.isFragment()) {
                    XDBDocument xDBDocument = (XDBDocument)this.getDOM();
                    xDBDocFragment = new XDBDocFragment(xDBDocument, this.m_cstate);
                    break;
                }
                throw new SQLException();
            }
            default: {
                throw new SQLException();
            }
        }
        return xDBDocFragment;
    }

    private long getErrHandle() throws SQLException {
        return XMLType.getErrorHandle((Connection)this.m_local_conn, this.m_conntype);
    }

    public static long getErrorHandle(Connection connection, int n) throws SQLException {
        long l;
        switch (n) {
            case 1: {
                Properties properties = ((OracleConnection)connection).getOCIHandles();
                l = Long.parseLong(properties.getProperty("OCIErrHandle"));
                break;
            }
            default: {
                l = 0L;
            }
        }
        return l;
    }

    public InputStream getInputStream() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        long l = this.getInputStreamNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
        return new RealInputStream(this.getErrHandle(), l);
    }

    private synchronized native long getInputStreamNative(long var1, long var3, long var5);

    public String getNamespace() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getNamespaceNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, this.getSvcHandle());
    }

    private synchronized native String getNamespaceNative(long var1, long var3, long var5, long var7);

    public NUMBER getNumberVal() throws SQLException {
        NUMBER nUMBER = null;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        String string = this.getStringVal();
        nUMBER = NUMBER.formattedTextToNumber((String)string, null, null);
        return nUMBER;
    }

    public static ORADataFactory getORADataFactory() {
        return xmlfactory;
    }

    public String getRootElement() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getRootElementNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, this.getSvcHandle());
    }

    private synchronized native String getRootElementNative(long var1, long var3, long var5, long var7);

    public String getSchemaURL() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.getSchemaURLNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, this.getSvcHandle());
    }

    private synchronized native String getSchemaURLNative(long var1, long var3, long var5, long var7);

    public static long getServiceHandle(Connection connection, int n) throws SQLException {
        long l;
        switch (n) {
            case 1: {
                Properties properties = ((OracleConnection)connection).getOCIHandles();
                l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                break;
            }
            default: {
                l = 0L;
            }
        }
        return l;
    }

    private String getStringFromBinaryStream() throws SQLException {
        if (this.m_bytesval == null) {
            return null;
        }
        if (this.m_csid == 0) {
            return this.m_bytesval.toString();
        }
        return this.processString(this.m_blobCS, this.m_bytesval.toByteArray(), 0);
    }

    public String getStringVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_stringval != null) {
            return this.m_stringval;
        }
        if (this.m_clobval != null) {
            return this.getClobStr(this.m_clobval);
        }
        if (this.m_blobval != null) {
            String string = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = this.getBinaryStream(this.m_blobval);
                string = this.processString(this.m_blobCS, byteArrayOutputStream.toByteArray(), 0);
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            return string;
        }
        if (this.m_cstate != 0L) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            byte[] byArray = cLOB.getLocator();
            this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, cLOB.getLocator(), 0);
            String string = this.getClobStr(cLOB);
            CLOB.freeTemporary((CLOB)cLOB);
            return string;
        }
        if (this.m_bytesval != null) {
            return this.getStringFromBinaryStream();
        }
        if (this.m_dom != null) {
            Object object;
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)10);
            switch (this.m_conntype) {
                case 0: {
                    try {
                        object = cLOB.getCharacterOutputStream();
                        ((XMLDocument)this.m_dom).print((Writer)object);
                        ((Writer)object).flush();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLException();
                    }
                }
                case 1: 
                case 2: {
                    this.printToLobNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), this.m_cstate, cLOB.getLocator(), 0);
                    break;
                }
            }
            object = this.getClobStr(cLOB);
            CLOB.freeTemporary((CLOB)cLOB);
            return object;
        }
        return null;
    }

    private long getSvcHandle() throws SQLException {
        return XMLType.getServiceHandle((Connection)this.m_local_conn, this.m_conntype);
    }

    private static synchronized native long getXMLTypeFromXobd(long var0, long var2, long var4, long var6);

    private native long getXMLTypeNative(long var1, long var3, long var5, byte[] var7, int var8);

    private synchronized native long getXobdFromXMLType(long var1, long var3, long var5, long var7);

    private void initConn(Connection connection) throws SQLException {
        this.m_local_conn = (OracleConnection)connection;
        this.m_conntype = XMLType.getConnType(connection);
        if (this.m_conntype == 2) {
            this.m_gpCState = XDBResource.getServerEnv();
        }
    }

    private void int2Byte(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)((n &= 0xFFFFFF) >> 16);
        byArray[2] = (byte)((n &= 0xFFFF) >> 8);
        byArray[3] = (byte)(n &= 0xFF);
    }

    public boolean isFragment() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean bl = this.isFragmentNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
        return bl;
    }

    private synchronized native boolean isFragmentNative(long var1, long var3, long var5);

    public boolean isSchemaBased() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaBasedNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native boolean isSchemaBasedNative(long var1, long var3, long var5);

    public boolean isSchemaValid(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        boolean bl = this.isSchemaValidNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, string, string2);
        return bl;
    }

    private synchronized native boolean isSchemaValidNative(long var1, long var3, long var5, String var7, String var8);

    public boolean isSchemaValidated() throws SQLException {
        boolean bl = false;
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        return this.isSchemaValidatedNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native boolean isSchemaValidatedNative(long var1, long var3, long var5);

    private synchronized native byte[] pickleXMLTypeNative(long var1, long var3, long var5, long var7);

    private synchronized native void printToLobNative(long var1, long var3, long var5, long var7, byte[] var9, int var10);

    private void processCState(byte[] byArray, int n) throws SQLException {
        this.m_cstate = this.getXMLTypeNative(this.m_gpCState, this.getSvcHandle(), this.getErrHandle(), byArray, this.m_local_conn.getDbCsId());
    }

    private void processLob(byte[] byArray, int n) throws SQLException {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.m_clobval = new CLOB((oracle.jdbc.OracleConnection)this.m_local_conn, byArray2);
    }

    private String processString(CharacterSet characterSet, byte[] byArray, int n) throws SQLException {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        return characterSet.toString(byArray2, 0, byArray2.length);
    }

    private void processThin(byte[] byArray, int n) throws SQLException {
        short s = Util.getUnsignedByte((byte)byArray[n]);
        ++n;
        if (s != 1) {
            throw new SQLException("error occurred in XMLtype conversion" + s);
        }
        this.m_thinflags = XMLType.bytesToInt(byArray, n);
        n += 4;
        if ((this.m_thinflags & 0x1000) == 4096) {
            this.m_thinsnapshot = new byte[24];
            System.arraycopy(byArray, n, this.m_thinsnapshot, 0, 24);
            n += 24;
        }
        if ((this.m_thinflags & 8) == 8) {
            this.m_thinschoid = new byte[16];
            System.arraycopy(byArray, n, this.m_thinschoid, 0, 16);
            this.m_thinelemnum = new byte[16];
            System.arraycopy(byArray, n += 16, this.m_thinelemnum, 0, 4);
            n += 4;
        }
        if ((this.m_thinflags & 1) == 1) {
            this.processLob(byArray, n);
        } else if ((this.m_thinflags & 4) == 4) {
            this.m_stringval = this.processString(this.m_charSet, byArray, n);
        } else {
            throw new SQLException("Only LOB or thin Storage is supported in Thin XMLType");
        }
    }

    public void schemaValidate() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.schemaValidateNative(this.m_gpCState, this.getErrHandle(), this.m_cstate);
    }

    private synchronized native void schemaValidateNative(long var1, long var3, long var5);

    public void setSchemaValidated(boolean bl) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        this.setSchemaValidatedNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, bl);
    }

    private synchronized native void setSchemaValidatedNative(long var1, long var3, long var5, boolean var7);

    public byte[] toBytes() throws SQLException {
        return ((OPAQUE)this.toDatum((Connection)this.m_local_conn)).toBytes();
    }

    public Datum toDatum(Connection connection) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        switch (this.m_conntype) {
            case 0: {
                return new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)this.getBytesValue());
            }
            case 1: 
            case 2: {
                byte[] byArray = this.getBytesPtr((OracleConnection)connection);
                OPAQUE oPAQUE = new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_NAME, (Connection)connection), connection, (Object)byArray);
                return oPAQUE;
            }
        }
        return null;
    }

    public XMLType transform(XMLType xMLType, String string) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0 || xMLType == null) {
            throw new SQLException();
        }
        long l = this.transformNative(this.m_gpCState, this.getErrHandle(), this.m_cstate, xMLType.m_cstate, string);
        if (l != 0L) {
            return new XMLType((Connection)this.m_local_conn, l);
        }
        return null;
    }

    private synchronized native long transformNative(long var1, long var3, long var5, long var7, String var9);

    private static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private void writePreamble(ByteArrayOutputStream byteArrayOutputStream, int n, int n2) throws IOException {
        byteArrayOutputStream.write(1);
        byte[] byArray = new byte[4];
        if ((this.m_thinflags & 0x1000) == 4096) {
            n2 &= 0x1000;
        }
        if ((this.m_thinflags & 8) == 8) {
            n2 &= 8;
        }
        this.int2Byte(n2, byArray);
        byteArrayOutputStream.write(byArray);
        if ((this.m_thinflags & 0x1000) == 4096) {
            byteArrayOutputStream.write(this.m_thinsnapshot);
        }
        if ((this.m_thinflags & 8) == 8) {
            byteArrayOutputStream.write(this.m_thinschoid);
            byteArrayOutputStream.write(this.m_thinelemnum);
        }
    }

    public void writeToOutputStream(OutputStream outputStream) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_conntype == 0) {
            throw new SQLException();
        }
        InputStream inputStream = this.getInputStream();
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException();
        }
    }
}

