/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gadgets.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.gadgets.OrbadaGadgetsPlugin;
import pl.mpak.orbada.gadgets.db.OgQueryInfo;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.usedb.gui.swing.QueryComboBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OgQueryInfoDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaGadgetsPlugin.class);
    private IApplication application;
    private int modalResult = 0;
    private OgQueryInfo info;
    private RecordLink dataLink;
    private String gqi_id;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkAllUsers;
    private Action cmCancel;
    private Action cmOk;
    private QueryComboBox comboDriverType;
    private TextField editName;
    private OrbadaSyntaxTextArea editSql;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private Query queryDriverTypes;

    public OgQueryInfoDialog(IApplication application, String gqi_id) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame(), true);
        this.application = application;
        this.gqi_id = gqi_id;
        this.initComponents();
        this.init();
    }

    public static String show(IApplication application, String gqi_id) throws IntrospectionException, UseDBException {
        OgQueryInfoDialog dialog = new OgQueryInfoDialog(application, gqi_id);
        dialog.setVisible(true);
        return dialog.modalResult == 1 ? dialog.gqi_id : null;
    }

    private void init() throws IntrospectionException, UseDBException {
        try {
            this.queryDriverTypes.open();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.dataLink = new RecordLink();
        this.dataLink.add("GQI_NAME", (Component)this.editName, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("name-of-information-query")));
        this.dataLink.add("GQI_DTP_ID", (Component)this.comboDriverType, "selectedItem");
        this.dataLink.add("GQI_SQL", (Component)this.editSql, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("sql-command")));
        this.info = this.gqi_id != null ? new OgQueryInfo(this.application.getOrbadaDatabase(), this.gqi_id) : new OgQueryInfo(this.application.getOrbadaDatabase());
        this.dataLink.updateComponents((BufferedRecord)this.info);
        this.checkAllUsers.setSelected(this.info.getUsrId() == null);
        if (!this.application.isUserAdmin()) {
            this.checkAllUsers.setEnabled(false);
            this.checkAllUsers.setSelected(true);
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        this.queryDriverTypes.close();
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.queryDriverTypes = new Query();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.editName = new TextField();
        this.jLabel2 = new JLabel();
        this.comboDriverType = new QueryComboBox();
        this.jLabel3 = new JLabel();
        this.editSql = new OrbadaSyntaxTextArea();
        this.checkAllUsers = new JCheckBox();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OgQueryInfoDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OgQueryInfoDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.queryDriverTypes.setDatabase(this.application.getOrbadaDatabase());
        try {
            this.queryDriverTypes.setSqlText("select * from driver_types order by dtp_name");
        }
        catch (UseDBException e1) {
            e1.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("OgQueryInfoDialog-title"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("query-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("for-driver-dd"));
        this.comboDriverType.setDisplayField("DTP_NAME");
        this.comboDriverType.setKeyField("DTP_ID");
        this.comboDriverType.setQuery(this.queryDriverTypes);
        this.jLabel3.setText(this.stringManager.getString("information-sql-command-dd"));
        this.checkAllUsers.setText(this.stringManager.getString("for-all-users-dd"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.editSql, GroupLayout.Alignment.LEADING, -1, 556, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.checkAllUsers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 235, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editName, -1, 421, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboDriverType, -1, 421, Short.MAX_VALUE)).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.editName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.comboDriverType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editSql, -1, 224, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.checkAllUsers)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.dataLink.updateRecord((BufferedRecord)this.info);
            if (this.checkAllUsers.isSelected()) {
                this.info.setUsrId(null);
            } else {
                this.info.setUsrId(this.application.getUserId());
            }
            if (this.info.isChanged()) {
                if (this.gqi_id == null) {
                    this.info.applyInsert();
                    this.gqi_id = this.info.getId();
                } else {
                    this.info.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

