/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gadgets.gui;

import java.io.Serializable;
import pl.mpak.orbada.gadgets.OrbadaGadgetsPlugin;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class QueryInformation
implements Serializable,
Cloneable {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaGadgetsPlugin.class);
    private transient String info = "";
    private transient long lastTime;
    private transient Database database;
    private String sqlText;
    private int interval;

    public QueryInformation() {
        this.lastTime = System.currentTimeMillis();
    }

    public QueryInformation(Database database, String sqlText, int interval) {
        this.database = database;
        this.sqlText = sqlText;
        this.interval = interval;
        this.lastTime = 0L;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public void setSqlText(String sqlText) {
        this.sqlText = sqlText;
    }

    public boolean isChange() {
        return System.currentTimeMillis() >= this.lastTime + (long)this.interval * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo() {
        if (System.currentTimeMillis() >= this.lastTime + (long)this.interval * 1000L) {
            this.lastTime = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            Query query = this.database.createQuery();
            try {
                query.open(this.sqlText);
                if (query.getFieldCount() >= 2) {
                    while (!query.eof()) {
                        String trAttr = null;
                        if (query.findFieldByName("attr") != null) {
                            trAttr = query.fieldByName("attr").getString();
                        }
                        sb.append("<tr" + (trAttr != null ? " " + trAttr : "") + "><td align=right>" + query.getField(0).getString() + "</td><td>" + query.getField(1).getString() + "</td></tr>\n");
                        query.next();
                    }
                } else {
                    sb.append(this.stringManager.getString("wrong-number-of-columns-in-the-result"));
                }
            }
            catch (Exception ex) {
                sb.append(ex.getMessage());
            }
            finally {
                query.close();
            }
            this.info = sb.toString();
        }
        return this.info;
    }

    public String toString() {
        return SQLUtil.removeWhiteSpaces((String)this.sqlText);
    }

    public Object clone() {
        return new QueryInformation(this.database, this.sqlText, this.interval);
    }
}

