/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gadgets.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.db.DriverType;
import pl.mpak.orbada.gadgets.OrbadaGadgetsPlugin;
import pl.mpak.orbada.gadgets.db.OgQueryInfoPerspectiveUpdater;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class QueryInformationConfigDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaGadgetsPlugin.class);
    private IPerspectiveAccesibilities accesibilities;
    private DriverType driverType;
    private ArrayList<OgQueryInfoPerspectiveUpdater> list;
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JScrollPane jScrollPane1;
    private Table tableQueryInfo;

    public QueryInformationConfigDialog(IPerspectiveAccesibilities accesibilities) throws UseDBException {
        this.accesibilities = accesibilities;
        this.driverType = new DriverType(accesibilities.getApplication().getOrbadaDatabase());
        this.list = new ArrayList();
        this.initComponents();
        this.init();
    }

    public static boolean show(IPerspectiveAccesibilities accesibilities) throws UseDBException {
        QueryInformationConfigDialog dialog = new QueryInformationConfigDialog(accesibilities);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() throws UseDBException {
        this.driverType.loadRecordBy("DTP_NAME", new Variant(this.accesibilities.getDatabase().getDriverType()));
        this.tableQueryInfo.setModel((TableModel)new AbstractTableModel(){
            private Class<?>[] classes = new Class[]{Boolean.class, String.class, String.class, Integer.class, Integer.class};

            @Override
            public int getRowCount() {
                return QueryInformationConfigDialog.this.list.size();
            }

            @Override
            public int getColumnCount() {
                return 0;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                OgQueryInfoPerspectiveUpdater i = (OgQueryInfoPerspectiveUpdater)((Object)QueryInformationConfigDialog.this.list.get(rowIndex));
                return columnIndex == 0 || (columnIndex == 3 || columnIndex == 4) && i.isChecked();
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.classes[columnIndex];
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return ((OgQueryInfoPerspectiveUpdater)((Object)QueryInformationConfigDialog.this.list.get(rowIndex))).isChecked();
                }
                if (columnIndex == 1) {
                    return ((OgQueryInfoPerspectiveUpdater)((Object)QueryInformationConfigDialog.this.list.get(rowIndex))).getGqiName();
                }
                if (columnIndex == 2) {
                    return ((OgQueryInfoPerspectiveUpdater)((Object)QueryInformationConfigDialog.this.list.get(rowIndex))).getDtpName();
                }
                if (columnIndex == 3) {
                    return ((OgQueryInfoPerspectiveUpdater)((Object)QueryInformationConfigDialog.this.list.get(rowIndex))).getIntervalSec();
                }
                if (columnIndex == 4) {
                    return ((OgQueryInfoPerspectiveUpdater)((Object)QueryInformationConfigDialog.this.list.get(rowIndex))).getOrder();
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                OgQueryInfoPerspectiveUpdater i = (OgQueryInfoPerspectiveUpdater)((Object)QueryInformationConfigDialog.this.list.get(rowIndex));
                if (columnIndex == 0) {
                    if (!i.isChecked()) {
                        i.setIntervalSec(60);
                        i.setOrder(rowIndex);
                    }
                    i.setChecked((Boolean)aValue);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                } else if (columnIndex == 3) {
                    i.setIntervalSec((Integer)aValue);
                } else if (columnIndex == 4) {
                    i.setOrder((Integer)aValue);
                }
            }
        });
        this.tableQueryInfo.setSelectionMode(0);
        this.tableQueryInfo.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(0, 30, this.stringManager.getString("ch")));
        this.tableQueryInfo.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(1, 250, this.stringManager.getString("name")));
        this.tableQueryInfo.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(2, 150, this.stringManager.getString("driver")));
        this.tableQueryInfo.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(3, 60, this.stringManager.getString("sec-interval")));
        this.tableQueryInfo.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(4, 60, this.stringManager.getString("order")));
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        this.list.clear();
        Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
        try {
            query.setSqlText(OgQueryInfoPerspectiveUpdater.getSql());
            query.paramByName("usr_id").setString(this.accesibilities.getApplication().getUserId());
            query.paramByName("pps_id").setString(this.accesibilities.getPerspectiveId());
            query.paramByName("dtp_id").setString(this.driverType.getId());
            query.open();
            while (!query.eof()) {
                OgQueryInfoPerspectiveUpdater i = new OgQueryInfoPerspectiveUpdater(query.getDatabase());
                i.updateFrom(query);
                i.setGqiName(query.fieldByName("gqi_name").getString());
                i.setDtpName(query.fieldByName("dtp_name").getString());
                i.setExists(!"".equals(i.getId()));
                this.list.add(i);
                query.next();
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            query.close();
        }
        this.tableQueryInfo.revalidate();
    }

    private void apply() throws Exception {
        for (OgQueryInfoPerspectiveUpdater u : this.list) {
            if (!u.isExists() && u.isChecked()) {
                u.setPrimaryKeyValue(new Variant(new UniqueID().toString()));
                u.applyInsert();
                continue;
            }
            if (u.isExists() && !u.isChecked()) {
                u.applyDelete();
                continue;
            }
            if (!u.isChanged()) continue;
            u.applyUpdate();
        }
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableQueryInfo = new Table();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryInformationConfigDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryInformationConfigDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("QueryInformationConfigDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.tableQueryInfo.setAutoResizeMode(0);
        this.tableQueryInfo.setRowHeight(18);
        this.jScrollPane1.setViewportView((Component)this.tableQueryInfo);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.jScrollPane1, -1, 581, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 242, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.apply();
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

