/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gadgets.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.mpak.orbada.gadgets.OrbadaGadgetsPlugin;
import pl.mpak.orbada.gadgets.gui.QueryInformation;
import pl.mpak.orbada.gadgets.gui.QueryInformationConfigDialog;
import pl.mpak.orbada.plugins.IGadgetAccesibilities;
import pl.mpak.orbada.plugins.IProcessMessagable;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.HtmlEditorPane;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.Configurable;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.Titleable;
import pl.mpak.util.task.Task;
import pl.mpak.util.timer.Timer;

public class QueryInformationPanel
extends JPanel
implements Titleable,
Closeable,
Configurable,
IProcessMessagable {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaGadgetsPlugin.class);
    private IGadgetAccesibilities accesibilities;
    private ArrayList<QueryInformation> infoList;
    private Timer timer;
    private boolean refreshing;
    private HtmlEditorPane editInfo;
    private JScrollPane jScrollPane1;

    public QueryInformationPanel(IGadgetAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.infoList = new ArrayList();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(1000L){

            public void run() {
                if (!QueryInformationPanel.this.refreshing) {
                    QueryInformationPanel.this.refresh();
                }
            }
        };
        OrbadaGadgetsPlugin.refreshQueue.add(this.timer);
        this.accesibilities.getApplication().getOrbadaDatabase().getTaskPool().addTask(new Task(){

            public void run() {
                QueryInformationPanel.this.reload();
            }
        });
        this.accesibilities.getApplication().registerRequestMessager((IProcessMessagable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        ArrayList<QueryInformation> arrayList = this.infoList;
        synchronized (arrayList) {
            this.infoList.clear();
            Query query = this.accesibilities.getApplication().getOrbadaDatabase().createQuery();
            try {
                query.setSqlText("select gqi_sql, qip_interval_s, qip_order\n  from og_queryinfos, og_queryinfo_perspectives\n where gqi_id = qip_gqi_id \n   and qip_pps_id = :PPS_ID\n order by qip_order");
                query.paramByName("PPS_ID").setString(this.accesibilities.getPerspectiveAccesibilities().getPerspectiveId());
                query.open();
                while (!query.eof()) {
                    this.infoList.add(new QueryInformation(this.accesibilities.getDatabase(), query.fieldByName("gqi_sql").getString(), query.fieldByName("qip_interval_s").getInteger()));
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (!SwingUtil.isVisible((Component)this)) {
            return;
        }
        this.refreshing = true;
        try {
            ArrayList<QueryInformation> arrayList = this.infoList;
            synchronized (arrayList) {
                boolean mustRefresh = false;
                for (QueryInformation info : this.infoList) {
                    if (!info.isChange()) continue;
                    mustRefresh = true;
                    break;
                }
                if (mustRefresh) {
                    StringBuffer sb = new StringBuffer("<html>");
                    sb.append("<style>");
                    sb.append("  body { font-family: Tahoma, Arial, serif; font-size: 9px; }");
                    sb.append("</style>");
                    sb.append("<head></head>");
                    sb.append("<body>");
                    if (this.infoList.size() > 0) {
                        sb.append("<center><table cellspacing=0 cellpading=0 width=\"100%\">\n");
                        for (QueryInformation info : this.infoList) {
                            sb.append(info.getInfo());
                        }
                        sb.append("</table></center>\n");
                    } else {
                        sb.append(this.stringManager.getString("QueryInformationPanel-info-1"));
                        sb.append(this.stringManager.getString("QueryInformationPanel-info-2"));
                    }
                    sb.append("</body>");
                    sb.append("</html>");
                    this.editInfo.setText(sb.toString());
                }
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public String getTitle() {
        return String.format(this.stringManager.getString("QueryInformationPanel-title"), this.accesibilities.getDatabase().getPublicName());
    }

    public void close() throws IOException {
        this.accesibilities.getApplication().unregisterRequestMessager((IProcessMessagable)this);
        this.timer.cancel();
        this.infoList.clear();
    }

    public boolean configure() {
        try {
            boolean result = QueryInformationConfigDialog.show(this.accesibilities.getPerspectiveAccesibilities());
            if (result) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        QueryInformationPanel.this.reload();
                    }
                });
            }
            return result;
        }
        catch (UseDBException ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    public boolean isConfig() {
        return true;
    }

    public void processMessage(PluginMessage message) {
        if (message.isMessageId("og-query-info-panel-reload")) {
            this.accesibilities.getApplication().getOrbadaDatabase().getTaskPool().addTask(new Task(){

                public void run() {
                    QueryInformationPanel.this.reload();
                }
            });
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.editInfo = new HtmlEditorPane();
        this.setLayout(new BorderLayout());
        this.editInfo.setDoubleBuffered(true);
        this.jScrollPane1.setViewportView((Component)this.editInfo);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

