/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gadgets.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gadgets.OrbadaGadgetsPlugin;
import pl.mpak.orbada.gadgets.db.OgQueryInfo;
import pl.mpak.orbada.gadgets.gui.OgQueryInfoDialog;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class QueryInformationSettingsPanel
extends JPanel
implements ISettingsComponent,
Closeable {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaGadgetsPlugin.class);
    private IApplication application;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonNew;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmNew;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable tableQueryInfos;

    public QueryInformationSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableQueryInfos.getQuery().setDatabase(this.application.getOrbadaDatabase());
        this.tableQueryInfos.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void afterOpen(EventObject e) {
                QueryInformationSettingsPanel.this.updateActions();
            }

            public void afterClose(EventObject e) {
                QueryInformationSettingsPanel.this.updateActions();
            }
        });
        this.tableQueryInfos.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (QueryInformationSettingsPanel.this.tableQueryInfos.getSelectedRow() >= 0) {
                    try {
                        QueryInformationSettingsPanel.this.tableQueryInfos.getQuery().getRecord(QueryInformationSettingsPanel.this.tableQueryInfos.getSelectedRow());
                        QueryInformationSettingsPanel.this.updateActions();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    QueryInformationSettingsPanel.this.cmEdit.setEnabled(false);
                    QueryInformationSettingsPanel.this.cmDelete.setEnabled(false);
                }
            }
        });
        this.tableQueryInfos.addColumn((TableColumn)new QueryTableColumn("scope", this.stringManager.getString("scope"), 100));
        this.tableQueryInfos.addColumn((TableColumn)new QueryTableColumn("gqi_name", this.stringManager.getString("name"), 250, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableQueryInfos.addColumn((TableColumn)new QueryTableColumn("dtp_name", this.stringManager.getString("driver"), 150));
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonEdit, this.buttonDelete});
        this.refresh(null);
    }

    private void updateActions() {
        block5: {
            if (this.tableQueryInfos.getQuery().isActive() && this.tableQueryInfos.getSelectedRow() >= 0) {
                try {
                    if (this.tableQueryInfos.getQuery().fieldByName("gqi_usr_id").isNull()) {
                        this.cmEdit.setEnabled(this.application.isUserAdmin());
                        this.cmDelete.setEnabled(this.application.isUserAdmin());
                        break block5;
                    }
                    this.cmEdit.setEnabled(true);
                    this.cmDelete.setEnabled(true);
                }
                catch (Exception ex) {
                    this.cmEdit.setEnabled(false);
                    this.cmDelete.setEnabled(false);
                }
            } else {
                this.cmEdit.setEnabled(false);
                this.cmDelete.setEnabled(false);
            }
        }
        this.cmNew.setEnabled(this.tableQueryInfos.getQuery().isActive());
    }

    private void refresh(String gqi_id) {
        try {
            if (gqi_id == null && this.tableQueryInfos.getQuery().isActive() && this.tableQueryInfos.getSelectedRow() >= 0) {
                this.tableQueryInfos.getQuery().getRecord(this.tableQueryInfos.getSelectedRow());
                gqi_id = this.tableQueryInfos.getQuery().fieldByName("gqi_id").getString();
            }
            this.tableQueryInfos.getQuery().close();
            this.tableQueryInfos.getQuery().setSqlText("select gqi_id, gqi_usr_id, case when gqi_usr_id is null then 'Globalne' else 'U\u017cytkownika' end scope, gqi_name, dtp_name\n  from og_queryinfos left outer join driver_types on (gqi_dtp_id = dtp_id)\n where (gqi_usr_id = :USR_ID or gqi_usr_id is null)\n order by gqi_name");
            this.tableQueryInfos.getQuery().paramByName("usr_id").setString(this.application.getUserId());
            this.tableQueryInfos.getQuery().open();
            if (gqi_id != null && this.tableQueryInfos.getQuery().locate("gqi_id", new Variant(gqi_id))) {
                this.tableQueryInfos.changeSelection(this.tableQueryInfos.getQuery().getCurrentRecord().getIndex(), 0, false, false);
            } else {
                this.tableQueryInfos.changeSelection(0, 0, false, false);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void restoreSettings() {
    }

    public void applySettings() {
    }

    public void cancelSettings() {
    }

    public void close() throws IOException {
        this.tableQueryInfos.getQuery().close();
    }

    private void initComponents() {
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableQueryInfos = new ViewTable();
        this.cmNew.setActionCommandKey("cmNew");
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(this.stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryInformationSettingsPanel.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setActionCommandKey("cmEdit");
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(this.stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryInformationSettingsPanel.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setActionCommandKey("cmDelete");
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(this.stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryInformationSettingsPanel.this.cmDeleteActionPerformed(evt);
            }
        });
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 23));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 23));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 23));
        this.jLabel1.setText(this.stringManager.getString("QueryInformationSettingsPanel-def-sql-command-into"));
        this.jScrollPane1.setViewportView((Component)this.tableQueryInfos);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 467, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, 467, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2)).addContainerGap()));
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            String gqi_id;
            if (this.tableQueryInfos.getQuery().isActive() && (gqi_id = OgQueryInfoDialog.show(this.application, null)) != null) {
                this.refresh(gqi_id);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableQueryInfos.getQuery().isActive() && this.tableQueryInfos.getSelectedRow() >= 0) {
                this.tableQueryInfos.getQuery().getRecord(this.tableQueryInfos.getSelectedRow());
                String gqi_id = OgQueryInfoDialog.show(this.application, this.tableQueryInfos.getQuery().fieldByName("gqi_id").getString());
                if (gqi_id != null) {
                    this.refresh(gqi_id);
                    this.application.postPluginMessage(new PluginMessage(null, "og-query-info-panel-reload", null));
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        try {
            if (this.tableQueryInfos.getQuery().isActive() && this.tableQueryInfos.getSelectedRow() >= 0) {
                this.tableQueryInfos.getQuery().getRecord(this.tableQueryInfos.getSelectedRow());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("QueryInformationSettingsPanel-delete-sql-command-q"), this.tableQueryInfos.getQuery().fieldByName("gqi_name").getString()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    OgQueryInfo info = new OgQueryInfo(this.application.getOrbadaDatabase());
                    info.setPrimaryKeyValue(new Variant(this.tableQueryInfos.getQuery().fieldByName("gqi_id").getString()));
                    info.applyDelete();
                    this.refresh(null);
                    this.application.postPluginMessage(new PluginMessage(null, "og-query-info-panel-reload", null));
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

