/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.autocomplete.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.autocomplete.OrbadaMySQLAutocompletePlugin;
import pl.mpak.orbada.mysql.services.MySQLDbInfoProvider;
import pl.mpak.orbada.mysql.util.MySQLUtil;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.sky.gui.swing.AutoCompleteItem;
import pl.mpak.sky.gui.swing.ParametrizedAutoCompleteItem;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLAutoCompleteDatabaseService
extends DatabaseProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLAutocompletePlugin.class);
    public static MySQLAutoCompleteDatabaseService instance;
    private static HashMap<String, HashMap<String, ArrayList<AutoCompleteItem>>> databaseSyntaxList;
    private static String sqlProcedureList;
    private static String sqlFunctionList;

    public MySQLAutoCompleteDatabaseService() {
        instance = this;
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "MySQL".equals(database.getDriverType());
    }

    public void afterConnection(Database database) {
    }

    private String getWordId(Database database, String[] words) {
        String result = "";
        for (int i = 0; i < words.length - 1; ++i) {
            if (result.length() > 0) {
                result = result + ".";
            }
            result = result + words[i];
        }
        return "".equals(result) ? "root" : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AutoCompleteItem> getAutoCompleteList(Database database, String[] words, boolean bracketMode, int commaCount) {
        Database database2 = database;
        synchronized (database2) {
            ArrayList<AutoCompleteItem> items;
            HashMap<String, ArrayList<Object>> map = databaseSyntaxList.get(database.getUniqueID());
            if (map == null) {
                map = new HashMap();
                databaseSyntaxList.put(database.getUniqueID(), map);
            }
            if ((items = map.get(this.getWordId(database, words))) == null) {
                items = this.prepareInfo(database, words);
                map.put(this.getWordId(database, words), items);
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareColumnsInfo(Database database, String databaseName, String objectName, ArrayList<AutoCompleteItem> items) throws Exception {
        Query query = database.createQuery();
        try {
            StringBuffer sb = new StringBuffer();
            query.setSqlText(Sql.getColumnList(null));
            query.paramByName("schema_name").setString(databaseName);
            query.paramByName("table_name").setString(objectName);
            query.open();
            while (!query.eof()) {
                AutoCompleteItem item = new AutoCompleteItem(query.fieldByName("column_name").getString(), "COLUMN", (String)null);
                sb.setLength(0);
                sb.append("<html>");
                sb.append("<b>" + item.getWord() + "</b>");
                sb.append(ParametrizedAutoCompleteItem.dataTypeString((String)query.fieldByName("column_type").getString()));
                sb.append(ParametrizedAutoCompleteItem.commentString((String)query.fieldByName("column_comment").getString()));
                item.setReturnDataType(query.fieldByName("data_type").getString());
                item.setDisplayText(sb.toString());
                item.setIcon(MySQLUtil.getObjectIcon((String)item.getType()));
                items.add(item);
                query.next();
            }
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareObjectsInfo(Database database, String databaseName, ArrayList<AutoCompleteItem> items) throws Exception {
        Query query = database.createQuery();
        try {
            ParametrizedAutoCompleteItem item;
            query.setSqlText(Sql.getObjectsType((String)"object_type not in ('PROCEDURE', 'FUNCTION', 'TRIGGER', 'INDEX')"));
            query.paramByName("schema_name").setString(databaseName);
            query.open();
            while (!query.eof()) {
                item = new AutoCompleteItem(query.fieldByName("OBJECT_NAME").getString(), query.fieldByName("OBJECT_TYPE").getString(), "<html><b>" + query.fieldByName("OBJECT_NAME").getString() + "</b>" + ParametrizedAutoCompleteItem.commentString((String)query.fieldByName("COMMENT").getString()));
                item.setIcon(MySQLUtil.getObjectIcon((String)item.getType()));
                items.add((AutoCompleteItem)item);
                query.next();
            }
            query.setSqlText(Sql.getDatabaseRoutineParameterList());
            query.paramByName("schema_name").setString(databaseName);
            query.open();
            while (!query.eof()) {
                item = new ParametrizedAutoCompleteItem(query.fieldByName("name").getString(), query.fieldByName("type").getString());
                while (!query.eof()) {
                    if ("RETURNS".equals(query.fieldByName("param_type").getString())) {
                        item.setReturnDataType(query.fieldByName("param").getString());
                    } else {
                        String paramName = "";
                        String paramType = query.fieldByName("param").getString();
                        if (paramType.indexOf(32) > 0) {
                            paramName = paramType.substring(0, paramType.indexOf(32));
                            paramType = paramType.substring(paramType.indexOf(32)).trim();
                        }
                        item.add(paramName, paramType);
                    }
                    query.next();
                    if (query.eof() || query.fieldByName("name").getString().equals(item.getWord())) continue;
                }
                item.setIcon(MySQLUtil.getObjectIcon((String)item.getType()));
                items.add((AutoCompleteItem)item);
            }
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AutoCompleteItem> prepareInfo(Database database, String[] words) {
        Query resolver = database.createQuery();
        ArrayList<AutoCompleteItem> items = new ArrayList<AutoCompleteItem>();
        try {
            resolver.setSqlText(Sql.getObjectsType());
            String databaseName = null;
            String objectName = null;
            String objectType = null;
            if (words.length <= 1) {
                databaseName = MySQLDbInfoProvider.getCurrentDatabase((Database)database);
            } else {
                for (int i = 0; i < words.length - 1; ++i) {
                    resolver.close();
                    resolver.paramByName("SCHEMA_NAME").setString(databaseName);
                    resolver.paramByName("OBJECT_NAME").setString(words[i]);
                    resolver.open();
                    if (resolver.eof()) {
                        databaseName = null;
                        objectName = null;
                        objectType = null;
                        break;
                    }
                    if ("DATABASE".equals(resolver.fieldByName("OBJECT_TYPE").getString())) {
                        databaseName = resolver.fieldByName("OBJECT_NAME").getString();
                        continue;
                    }
                    databaseName = resolver.fieldByName("OBJECT_SCHEMA").getString();
                    objectName = resolver.fieldByName("OBJECT_NAME").getString();
                    objectType = resolver.fieldByName("OBJECT_TYPE").getString();
                }
            }
            if (databaseName != null) {
                if (objectType == null) {
                    this.prepareObjectsInfo(database, databaseName, items);
                } else if (StringUtil.anyOfString(objectType, (String[])new String[]{"TABLE", "VIEW"}) != -1) {
                    this.prepareColumnsInfo(database, databaseName, objectName, items);
                }
            }
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            resolver.close();
        }
        Collections.sort(items);
        return items;
    }

    public void removeAutoCompleteInfo(Database database) {
        databaseSyntaxList.remove(database.getUniqueID());
    }

    public void beforeDisconnect(Database database) {
        this.removeAutoCompleteInfo(database);
    }

    public String getDescription() {
        return this.stringManager.getString("MySQLAutoCompleteDatabaseService-description");
    }

    public String getGroupName() {
        return "MySQL";
    }

    static {
        databaseSyntaxList = new HashMap();
        sqlProcedureList = "SELECT TRIM(P.RDB$PROCEDURE_NAME) OBJECT_NAME, A.RDB$PARAMETER_NUMBER SEQ, TRIM(A.RDB$PARAMETER_NAME) ARGUMENT,\n       CASE WHEN A.RDB$PARAMETER_TYPE = 0 THEN 'IN' WHEN A.RDB$PARAMETER_TYPE = 1 THEN 'OUT' ELSE A.RDB$PARAMETER_TYPE END IN_OUT,\n       (SELECT TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$FIELD_TYPE' AND T.RDB$TYPE = F.RDB$FIELD_TYPE)||\n       CASE\n         WHEN F.RDB$FIELD_TYPE IN (7, 8, 2, 13, 35) THEN ''\n         WHEN F.RDB$FIELD_TYPE IN (10, 11, 27) AND F.RDB$FIELD_SCALE <> 0 THEN '('||F.RDB$FIELD_LENGTH||','||F.RDB$FIELD_SCALE||')'\n         ELSE '('||F.RDB$FIELD_LENGTH||')'\n       END||\n       COALESCE((SELECT ' ['||D.RDB$LOWER_BOUND||'..'||D.RDB$UPPER_BOUND||']' FROM RDB$FIELD_DIMENSIONS D WHERE D.RDB$FIELD_NAME = F.RDB$FIELD_NAME), '')||\n       COALESCE(' ('||(SELECT TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$FIELD_SUB_TYPE' AND T.RDB$TYPE = F.RDB$FIELD_SUB_TYPE)||')', '') ARGUMENT_TYPE\n  FROM RDB$PROCEDURES P, RDB$PROCEDURE_PARAMETERS A, RDB$FIELDS F\n WHERE P.RDB$PROCEDURE_NAME = A.RDB$PROCEDURE_NAME\n   AND A.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME\n   AND (P.RDB$SYSTEM_FLAG IS NULL OR P.RDB$SYSTEM_FLAG = 0)\n ORDER BY OBJECT_NAME, SEQ";
        sqlFunctionList = "SELECT TRIM(P.RDB$FUNCTION_NAME) OBJECT_NAME, F.RDB$ARGUMENT_POSITION SEQ, TRIM('P_'||F.RDB$ARGUMENT_POSITION) ARGUMENT,\n       (SELECT TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$FIELD_TYPE' AND T.RDB$TYPE = F.RDB$FIELD_TYPE)||\n       CASE\n         WHEN F.RDB$FIELD_TYPE IN (7, 8, 2, 13, 35) THEN ''\n         WHEN F.RDB$FIELD_TYPE IN (10, 11, 27) AND F.RDB$FIELD_SCALE <> 0 THEN '('||F.RDB$FIELD_LENGTH||','||F.RDB$FIELD_SCALE||')'\n         ELSE '('||F.RDB$FIELD_LENGTH||')'\n       END||\n       COALESCE(' ('||(SELECT TRIM(RDB$TYPE_NAME) FROM RDB$TYPES T WHERE T.RDB$FIELD_NAME = 'RDB$FIELD_SUB_TYPE' AND T.RDB$TYPE = F.RDB$FIELD_SUB_TYPE)||')', '') ARGUMENT_TYPE\n  FROM RDB$FUNCTIONS P, RDB$FUNCTION_ARGUMENTS F\n WHERE P.RDB$FUNCTION_NAME = F.RDB$FUNCTION_NAME\n   AND (P.RDB$SYSTEM_FLAG IS NULL OR P.RDB$SYSTEM_FLAG = 0)\n  ORDER BY OBJECT_NAME, SEQ";
    }
}

