/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.autocomplete.services;

import java.util.ArrayList;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.mysql.autocomplete.OrbadaMySQLAutocompletePlugin;
import pl.mpak.orbada.mysql.autocomplete.services.MySQLAutoCompleteDatabaseService;
import pl.mpak.orbada.plugins.providers.SyntaxEditorAutoCompleteProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.swing.AutoCompleteItem;
import pl.mpak.sky.gui.swing.ParametrizedAutoCompleteItem;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class MySQLAutoCompleteService
extends SyntaxEditorAutoCompleteProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLAutocompletePlugin.class);
    private OrbadaSyntaxTextArea syntaxTextArea;

    public boolean isForEditor(SyntaxTextArea syntaxTextArea) {
        if (syntaxTextArea instanceof OrbadaSyntaxTextArea) {
            this.syntaxTextArea = (OrbadaSyntaxTextArea)syntaxTextArea;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.stringManager.getString("MySQLAutoCompleteService-description");
    }

    public String getGroupName() {
        return "MySQL";
    }

    public AutoCompleteItem[] populate(String[] words, boolean bracketMode, int commaCount) {
        Database database = this.syntaxTextArea.getDatabase();
        if (database == null || !"MySQL".equals(database.getDriverType())) {
            return null;
        }
        if (database.isExecutingSql()) {
            this.application.postPluginMessage(new PluginMessage("orbada-system-plugin", "status-text", (Object)this.stringManager.getString("MySQLAutoCompleteService-sql-executing")));
            return null;
        }
        ArrayList<AutoCompleteItem> items = MySQLAutoCompleteDatabaseService.instance.getAutoCompleteList(database, words, bracketMode, commaCount);
        ArrayList<Object> populated = new ArrayList();
        if (words.length == 0 || items.size() == 0) {
            populated = items;
        } else {
            populated = new ArrayList();
            String word = words[words.length - 1].toUpperCase();
            if (bracketMode) {
                for (AutoCompleteItem item : items) {
                    if (!item.getWord().toUpperCase().equals(word)) continue;
                    if (item instanceof ParametrizedAutoCompleteItem) {
                        ((ParametrizedAutoCompleteItem)item).setCommaCount(commaCount);
                    }
                    populated.add(item);
                }
            } else {
                for (AutoCompleteItem item : items) {
                    if (!item.getWord().toUpperCase().startsWith(word)) continue;
                    if (item instanceof ParametrizedAutoCompleteItem) {
                        ((ParametrizedAutoCompleteItem)item).setCommaCount(-1);
                    }
                    populated.add(item);
                }
            }
        }
        return populated.toArray(new AutoCompleteItem[populated.size()]);
    }
}

