/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLFormat;
import oracle.xml.binxml.BinXMLNamespaceToken;
import oracle.xml.binxml.BinXMLOpcode;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLQNameToken;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLTokenManager;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.parser.v2.SAXAttrList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

class BinXMLDecodeReader
implements BinXMLConstants {
    BinXMLDecoderImpl decoder;
    BinXMLTokenManager tokenMngr;
    BinXMLVocabularyManager vocabMngr;
    BinXMLProcessorImpl binXMLProc;
    BinXMLStreamImpl binStream;
    ArrayList streamTable;
    Stack streamStack;
    int mark;
    int lastmark;
    ArrayList markMap;
    DecodeStream curStream;
    private final int INFINITY = Integer.MAX_VALUE;
    ElemStack elemStack;
    Stack schemaStack;
    ArrayList nsStack;
    DecodeElem curElem;
    DecodeElem prevSibling;
    SAXAttrList attrlist;
    int pitgtlen;
    short state;
    byte event;
    int eventMark;
    BinXMLSchema schema;
    ArrayList schemaTable;
    ArrayList prefixTable;
    short datastatus;
    short noseq;
    short opcode;
    BinXMLOpcode opinfo;
    long[] opdata;
    long datalen;
    byte datatype;
    String curValue;
    short oldKidnum;
    short prtOpcode;
    String prtBuf;
    String version = null;
    String standalone = null;
    String encoding = null;
    String dtdName;
    String publicId;
    String systemId;
    String elemName;
    String contentSpec;
    String attrName;
    String attrType;
    String attrMode;
    String value;
    String entName;
    String notName;
    String parName;
    String piTarget;
    long locId;
    byte[] buf;
    int curBufLen;
    static final short SELFMODE = 0;
    static final short ARRMODE = 1;
    static final short SEQMODE = 2;
    static final short ARRSEQMODE = 3;
    static final short SELFSTRMMODE = 4;
    static final short ARRSTRMMODE = 5;
    static final short OPTARRMODE = 6;
    static final short OPTSEQMODE = 7;
    static final short OPTMODE = 8;
    static final short ARRNEXTMODE = 9;
    static final short ARRNEXTSEQMODE = 10;
    static final short STRMMODE = 4;
    static final short LOCF_SCHPRP = 1;
    static final short LOCF_QNAMEID = 2;
    static final short LOCF_DATA = 4;
    static final short LOCF_TEXT = 8;
    static final short LOCF_INARR = 16;
    static final short LOCF_INSCHSEQ = 32;
    static final short LOCF_SCHSEQ = 64;
    static final short LOCF_NOTDECTYP = 128;
    static final short LOCF_IMPTYP = 256;
    static final short LOCF_PFXID = 512;
    static final short LOCF_TWOBYTE = 1024;
    static final short LOCF_FOURBYTE = 2048;
    static final short LOCF_DOC = 4096;
    static final byte EVENT_DTDSTART = 100;
    static final byte EVENT_ELEMDECL = 101;
    static final byte EVENT_ATTRDECL = 102;
    static final byte EVENT_INT_ENTDECL = 103;
    static final byte EVENT_UNPAR_ENTDECL = 104;
    static final byte EVENT_EXT_ENTDECL = 105;
    static final byte EVENT_PARDECL = 106;
    static final byte EVENT_NOTDECL = 107;
    static final byte EVENT_DTDEND = 108;
    static final byte EVENT_NOOP = 99;
    static final byte EVENT_ERROR = -1;
    static final short STATE_ZERO = 1;
    static final short STATE_START_ELEM_OPT = 2;
    static final short STATE_CHARS_OPT = 3;
    static final short STATE_CHARS_LOC = 4;
    static final short STATE_PRT = 5;
    static final short LENGTH_DATA = 2;
    static final short DATA_ONLY = 1;
    static final short NO_DATA = 0;
    static final short NOOP = 255;
    static final int HDR_RGUID_LEN = 16;
    static final byte CSX_MAX_SCHID_LEN = 16;
    static final byte CSX_MAX_PFX_LEN = 100;
    static final byte CSX_DEFQNF_ATTR = 1;
    BinXMLVocabId vocabId = new BinXMLVocabId();
    boolean printInst = false;
    boolean printStacks = false;
    boolean printLocator = false;

    BinXMLDecodeReader(BinXMLStreamImpl binXMLStreamImpl, BinXMLDecoderImpl binXMLDecoderImpl) throws BinXMLException {
        this.binStream = binXMLStreamImpl;
        this.decoder = binXMLDecoderImpl;
        this.init();
    }

    void init() throws BinXMLException {
        this.binXMLProc = (BinXMLProcessorImpl)this.binStream.getBinXMLProcessor();
        this.vocabMngr = this.binXMLProc.getVocabularyManager();
        this.tokenMngr = this.binXMLProc.getTokenManager();
        this.streamTable = new ArrayList(5);
        this.streamStack = new Stack();
        this.markMap = new ArrayList(10);
        this.nsStack = new ArrayList(20);
        this.opdata = new long[10];
        this.curBufLen = 128;
        this.buf = new byte[this.curBufLen];
        this.elemStack = new ElemStack();
        this.schemaStack = new Stack();
        this.lastmark = 0;
        this.locId = 0L;
        this.attrlist = new SAXAttrList(100);
        this.reset();
        if (this.binXMLProc.getDebugMode()) {
            this.printInst = true;
            this.printStacks = true;
            this.printLocator = true;
        }
    }

    void setDecoder(BinXMLDecoder binXMLDecoder) {
        this.decoder = (BinXMLDecoderImpl)binXMLDecoder;
    }

    long readBytes(byte[] byArray, long l) {
        return this.curStream.readBytes(byArray, l);
    }

    long skipBytes(long l) {
        return this.curStream.skipBytes(l);
    }

    long readBytes(BinXMLStreamImpl binXMLStreamImpl, byte[] byArray, long l) {
        return this.readBytes(byArray, l);
    }

    long skipBytes(BinXMLStreamImpl binXMLStreamImpl, long l) {
        return this.skipBytes(l);
    }

    short nextByte() throws BinXMLException {
        if (this.datastatus != 0) {
            this.getEventText();
        }
        DecodeStream decodeStream = this.nextDecodeStream();
        return decodeStream.nextByte();
    }

    DecodeStream getDecodeStream(byte by) throws BinXMLException {
        for (int i = 0; i < this.streamTable.size(); ++i) {
            DecodeStream decodeStream = (DecodeStream)this.streamTable.get(i);
            if (decodeStream.id != by) continue;
            return decodeStream;
        }
        return null;
    }

    DecodeStream getDecodeStream(String string) throws BinXMLException {
        for (int i = 0; i < this.streamTable.size(); ++i) {
            DecodeStream decodeStream = (DecodeStream)this.streamTable.get(i);
            if (decodeStream.href == null || !decodeStream.href.equals(string)) continue;
            return decodeStream;
        }
        return this.createStream(string);
    }

    DecodeStream nextDecodeStream() throws BinXMLException {
        if (this.curElem.streamId == this.elemStack.peek().streamId) {
            return this.curStream;
        }
        return this.getDecodeStream(this.elemStack.peek().streamId);
    }

    BinXMLStream getStream(byte by) throws BinXMLException {
        for (int i = 0; i < this.streamTable.size(); ++i) {
            DecodeStream decodeStream = (DecodeStream)this.streamTable.get(i);
            if (decodeStream.id != by) continue;
            return decodeStream.stream;
        }
        throw new BinXMLException("Invalid stream id: " + by);
    }

    DecodeStream createStream(String string) throws BinXMLException {
        DecodeStream decodeStream = string != null ? new DecodeStream(string, (byte)this.streamTable.size()) : new DecodeStream(this.binStream, (byte)this.streamTable.size());
        this.streamTable.add(decodeStream);
        return decodeStream;
    }

    void activateStream(DecodeStream decodeStream, int n) {
        this.curStream = decodeStream;
        if (n >= 0) {
            decodeStream.setLMark(n);
        }
        this.schemaTable = decodeStream.schemaTable;
        this.prefixTable = decodeStream.prefixTable;
        this.datastatus = 0;
        this.state = 1;
    }

    void pushStream(byte by) throws BinXMLException {
        int n;
        int n2 = n = this.curStream != null && this.curStream.ladata > 0 ? this.curStream.ladata : this.mark;
        if (by > 0) {
            this.updateMarkMapEndMark(this.curStream.id, this.lastmark);
        }
        this.appendMarkMap(by, 0, n);
        DecodeStream decodeStream = this.getDecodeStream(by);
        this.streamStack.add(decodeStream);
        this.activateStream(decodeStream, 0);
    }

    void pushStream(byte by, int n) throws BinXMLException {
        DecodeStream decodeStream = this.getDecodeStream(by);
        this.streamStack.add(decodeStream);
        this.activateStream(decodeStream, n);
    }

    void popStream() throws BinXMLException {
        if (this.streamStack.size() < 1) {
            throw new BinXMLException("Invalid popStream().");
        }
        this.updateMarkMapEndMark(this.curStream.id, this.eventMark);
        this.streamStack.pop();
        DecodeStream decodeStream = (DecodeStream)this.streamStack.peek();
        this.activateStream(decodeStream, -1);
        this.appendMarkMap(decodeStream.id, this.curStream.getLMark(), this.mark);
    }

    byte pushStreamMark(int n) throws BinXMLException {
        for (int i = 0; i < this.markMap.size(); ++i) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(i);
            if (markInfo.endmark < n) continue;
            int n2 = markInfo.lmark + (n - markInfo.gmark);
            this.pushStream(markInfo.id, n2);
            return markInfo.id;
        }
        return 0;
    }

    byte pushStreamParentMark(byte by, int n) throws BinXMLException {
        int n2;
        MarkInfo markInfo;
        int n3;
        for (n3 = 0; n3 < this.markMap.size(); ++n3) {
            markInfo = (MarkInfo)this.markMap.get(n3);
            if (markInfo.endmark >= n) break;
        }
        if ((n2 = n3 + 1) < this.markMap.size()) {
            while (n2 < this.markMap.size()) {
                markInfo = (MarkInfo)this.markMap.get(n2);
                if (markInfo.id == by) {
                    this.pushStream(markInfo.id, markInfo.lmark);
                    break;
                }
                ++n2;
            }
        } else {
            markInfo = (MarkInfo)this.markMap.get(n2 - 2);
            this.pushStream(markInfo.id, markInfo.endmark - markInfo.lmark);
        }
        return by;
    }

    void appendMarkMap(byte by, int n, int n2) {
        if (this.markMap.size() > 0) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(this.markMap.size() - 1);
            if (markInfo.endmark > n2) {
                return;
            }
        }
        this.markMap.add(new MarkInfo(by, n, n2));
    }

    void updateMarkMapEndMark(byte by, int n) {
        MarkInfo markInfo = (MarkInfo)this.markMap.get(this.markMap.size() - 1);
        if (markInfo.id == by && markInfo.gmark < n) {
            markInfo.endmark = n;
        }
    }

    void updateMarkMapLMark(byte by, int n) {
        MarkInfo markInfo = (MarkInfo)this.markMap.get(this.markMap.size() - 1);
        if (markInfo.id == by && markInfo.lmark < n) {
            markInfo.lmark = n;
        }
    }

    int getLMark(int n) {
        int n2 = n;
        for (int i = 0; i < this.markMap.size(); ++i) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(i);
            if (markInfo.gmark > n || markInfo.gmark < 0) break;
            n2 = markInfo.lmark + (n - markInfo.gmark);
        }
        return n2;
    }

    void printMarkMap() {
        System.out.println("MarkMap");
        for (int i = 0; i < this.markMap.size(); ++i) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(i);
            System.out.println(markInfo.id + ", " + markInfo.lmark + "' " + markInfo.gmark + "-" + markInfo.endmark);
        }
    }

    void decode(ContentHandler contentHandler, ErrorHandler errorHandler) throws BinXMLException {
        this.reset();
        boolean bl = false;
        while (!bl) {
            try {
                switch (this.getNextEvent()) {
                    case 7: {
                        contentHandler.startDocument();
                        break;
                    }
                    case 8: {
                        contentHandler.endDocument();
                        bl = true;
                        break;
                    }
                    case 1: {
                        contentHandler.startElement(this.getEventURI(), this.getEventLocalName(), this.getEventName(), this.getEventAttrList());
                        break;
                    }
                    case 2: {
                        contentHandler.endElement(this.getEventURI(), this.getEventLocalName(), this.getEventName());
                        break;
                    }
                    case 4: {
                        String string = this.getEventText();
                        if (string == null) break;
                        char[] cArray = string.toCharArray();
                        contentHandler.characters(cArray, 0, cArray.length);
                        break;
                    }
                    case 3: {
                        contentHandler.processingInstruction(this.piTarget, this.value);
                        break;
                    }
                    case 5: {
                        if (this.decoder.lexHdlr == null) break;
                        this.decoder.lexHdlr.comment(this.value.toCharArray(), 0, this.value.length());
                        break;
                    }
                    case 12: {
                        if (this.decoder.lexHdlr != null) {
                            this.decoder.lexHdlr.startCDATA();
                        }
                        contentHandler.characters(this.value.toCharArray(), 0, this.value.length());
                        if (this.decoder.lexHdlr == null) break;
                        this.decoder.lexHdlr.endCDATA();
                        break;
                    }
                    case 100: {
                        if (this.decoder.lexHdlr == null) break;
                        this.decoder.lexHdlr.startDTD(this.dtdName, this.publicId, this.systemId);
                        break;
                    }
                    case 101: {
                        if (this.decoder.decHdlr == null) break;
                        this.decoder.decHdlr.elementDecl(this.elemName, this.contentSpec);
                        break;
                    }
                    case 102: {
                        if (this.decoder.decHdlr == null) break;
                        this.decoder.decHdlr.attributeDecl(this.elemName, this.attrName, this.attrType, this.attrMode, this.value);
                        break;
                    }
                    case 103: {
                        if (this.decoder.decHdlr == null) break;
                        this.decoder.decHdlr.internalEntityDecl(this.entName, this.value);
                        break;
                    }
                    case 104: {
                        if (this.decoder.dtdHdlr != null) {
                            this.decoder.dtdHdlr.unparsedEntityDecl(this.entName, this.publicId, this.systemId, this.notName);
                        }
                    }
                    case 105: {
                        if (this.decoder.decHdlr == null) break;
                        this.decoder.decHdlr.externalEntityDecl(this.entName, this.publicId, this.systemId);
                        break;
                    }
                    case 106: {
                        break;
                    }
                    case 107: {
                        if (this.decoder.dtdHdlr == null) break;
                        this.decoder.dtdHdlr.notationDecl(this.notName, this.publicId, this.systemId);
                        break;
                    }
                    case 108: {
                        if (this.decoder.lexHdlr == null) break;
                        this.decoder.lexHdlr.endDTD();
                        break;
                    }
                }
            }
            catch (SAXException sAXException) {
                throw new BinXMLException(sAXException.getMessage());
            }
        }
    }

    void skipNode() throws BinXMLException {
        if (this.event == 1) {
            int n = 1;
            block4: while (n > 0) {
                switch (this.getNextEvent()) {
                    case 1: {
                        ++n;
                        continue block4;
                    }
                    case 2: {
                        --n;
                        continue block4;
                    }
                }
            }
        } else if (this.event != 4 && this.event != 3 && this.event != 5) {
            throw new BinXMLException("Invalid instruction.");
        }
    }

    byte getNextEvent() throws BinXMLException {
        if (this.state == 2) {
            this.state = (short)3;
            this.getDataLen();
            return 4;
        }
        if (this.state == 3) {
            this.popElem();
            this.state = 1;
            return 2;
        }
        if (this.state == 4) {
            this.state = 1;
            this.popStream();
        }
        do {
            this.event = this.getNext();
            if (this.event != 1) continue;
            this.event = this.checkOraXInclude();
        } while (this.event == 99);
        if (this.printStacks) {
            this.elemStack.print();
        }
        return this.event;
    }

    private byte checkOraXInclude() throws BinXMLException {
        if (this.curElem.nsid == this.decoder.nsidxi && this.curElem.local.equals("include") && this.attrlist.getLength() != 0) {
            String string = null;
            String string2 = null;
            int n = this.attrlist.getLength();
            for (int i = 0; i < n; ++i) {
                String string3 = this.attrlist.getLocalName(i);
                String string4 = this.attrlist.getValue(i);
                if (string3.equals("xpointer")) {
                    if (!string4.startsWith("ora:csxloc")) continue;
                    string = string4.substring(11, string4.length() - 1);
                    continue;
                }
                if (!string3.equals("href")) continue;
                string2 = string4;
            }
            if (string2 != null && string != null) {
                this.processXInclude(string2, string);
                this.event = (byte)99;
            }
        }
        return this.event;
    }

    private void processXInclude(String string, String string2) throws BinXMLException {
        while (this.event != 2) {
            this.event = this.getNext();
        }
        try {
            DecodeStream decodeStream = this.getDecodeStream(string);
            this.pushStream(decodeStream.id);
            String[] stringArray = string2.split(",");
            this.skipOffsetCSXData(Integer.parseInt(stringArray[1]));
            switch (stringArray[0].charAt(0)) {
                case 'A': {
                    this.locId = Long.parseLong(stringArray[2]);
                    this.curStream.locator = string2;
                    break;
                }
                case 'S': {
                    this.vocabId.setVocabID(stringArray[3].getBytes());
                    this.schema = this.vocabMngr.getBinXMLSchema(this.vocabId);
                    this.addSchema(this.schema);
                    this.pushSchema(this.schema);
                    this.locId = Long.parseLong(stringArray[2]);
                    this.curStream.locator = string2;
                    break;
                }
                case 'T': {
                    this.locId = 1L;
                    this.curStream.locator = string2;
                    break;
                }
                case 'E': {
                    this.locId = 0L;
                }
            }
        }
        catch (Exception exception) {
            throw new BinXMLException(exception.getMessage());
        }
    }

    String getlocator() {
        String string = new Integer(this.getLMark(this.eventMark)).toString();
        if (this.event == 4) {
            return new String("T," + string);
        }
        DecodeElem decodeElem = this.elemStack.get(this.elemStack.size() - 2);
        switch (decodeElem.flags & 0xF) {
            case 0: {
                return new String("E," + string);
            }
            case 1: {
                String string2 = new Long(this.curElem.id).toString();
                return new String("A," + string + "," + string2);
            }
            case 2: {
                long l = 1L - this.curElem.id;
                String string3 = new Long(l).toString();
                BinXMLVocabId binXMLVocabId = this.schema.getSchemaId();
                String string4 = new String(binXMLVocabId.getVocabID(), 0, 16);
                return new String("A," + string + "," + string3 + "," + string4);
            }
        }
        return new String("E," + string);
    }

    private void skipOffsetCSXData(int n) throws BinXMLException {
        block6: while (this.curStream.getLMark() < n) {
            short s = this.nextCSXInstr();
            switch (s) {
                case 159: {
                    this.readSectionHeader(s);
                    continue block6;
                }
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    if (this.mark != this.lastmark) continue block6;
                    long l2 = this.opdata[1];
                    this.tokenMngr.registerNamespace(l2, string);
                    continue block6;
                }
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    if (this.mark != this.lastmark) continue block6;
                    long l3 = this.opdata[2];
                    long l2 = this.opdata[3];
                    boolean bl = ((int)this.opdata[1] & 1) > 0;
                    this.tokenMngr.registerTokenId(l3, string, l2, bl);
                    continue block6;
                }
                case 178: 
                case 179: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    long l3 = this.opdata[2];
                    long l2 = this.opdata[1];
                    this.addPrefix((short)l3, string, l2);
                    continue block6;
                }
            }
            long l = this.getdatalen(s);
            if (l <= 0L) continue;
            this.curStream.readString((int)l);
        }
    }

    protected byte getNext() throws BinXMLException {
        if (this.datastatus != 0) {
            this.skipData();
        }
        this.eventMark = this.mark;
        this.curValue = null;
        if (this.state != 5) {
            this.prtBuf = null;
        }
        this.attrlist.reset();
        if (this.elemStack.empty()) {
            throw new BinXMLException("No more siblings.");
        }
        this.oldKidnum = this.elemStack.peek().kidnum;
        short s = this.nextCSXInstr();
        if (this.noseq > 0) {
            this.noseq = (short)(this.noseq - 1);
        }
        switch (s) {
            case 159: {
                this.readSectionHeader(s);
                return 99;
            }
            case 160: {
                return 8;
            }
            case 158: {
                int n = (int)this.opdata[1];
                this.version = null;
                this.standalone = null;
                this.encoding = null;
                if ((n & 8) > 0) {
                    String string = this.version = (n & 0xFF00) > 0 ? "1.1" : "1.0";
                }
                if ((n & 1) > 0) {
                    String string = this.standalone = (n & 0x10) > 0 ? "yes" : "no";
                }
                if ((n & 4) > 0) {
                    long l = (int)this.opdata[0];
                    this.encoding = this.curStream.readString((int)l);
                }
                return 7;
            }
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                long l = this.getdatalen(s);
                String string = this.curStream.readString((int)l);
                if (this.mark == this.lastmark) {
                    long l2 = this.opdata[1];
                    this.tokenMngr.registerNamespace(l2, string);
                }
                this.state = 1;
                return 99;
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                long l = this.getdatalen(s);
                String string = this.curStream.readString((int)l);
                if (this.mark == this.lastmark) {
                    long l3 = this.opdata[2];
                    long l4 = this.opdata[3];
                    boolean bl = ((int)this.opdata[1] & 1) > 0;
                    this.tokenMngr.registerTokenId(l3, string, l4, bl);
                }
                this.state = 1;
                return 99;
            }
            case 178: 
            case 179: {
                long l = this.getdatalen(s);
                String string = this.curStream.readString((int)l);
                long l5 = this.opdata[2];
                long l6 = this.opdata[1];
                this.addPrefix((short)l5, string, l6);
                return 99;
            }
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 211: 
            case 212: 
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                DecodeElem decodeElem;
                byte by;
                String string = null;
                int n = 0;
                boolean bl = false;
                if (s >= 203 && s <= 207) {
                    by = (byte)this.opdata[1];
                } else if (s >= 208 && s <= 212 || s >= 224 && s <= 227) {
                    by = (byte)this.opdata[2];
                    bl = true;
                } else {
                    by = 0;
                }
                if (this.locId > 0L) {
                    long l = this.locId;
                    this.locId = 0L;
                    decodeElem = this.getProperty(l);
                } else if (this.curStream.laElem != null) {
                    decodeElem = this.curStream.laElem;
                    this.curStream.laElem = null;
                } else if ((this.opinfo.flags & 1) > 0) {
                    DecodeElem decodeElem2 = this.peekElem();
                    if (decodeElem2.prop == null) {
                        throw new BinXMLException("Invalid instruction.");
                    }
                    short s2 = (short)(bl ? this.opdata[1] : this.opdata[0]);
                    decodeElem = this.getProperty(this.schema, decodeElem2.prop, s2);
                } else {
                    long l = bl ? this.opdata[1] : this.opdata[0];
                    decodeElem = this.getProperty(l);
                }
                if (decodeElem.isAttr) {
                    throw new BinXMLException("Invalid attribute.");
                }
                if (bl) {
                    if ((by & 2) > 0) {
                        n = this.readNum4();
                    }
                    if ((by & 8) > 0) {
                        short s3 = this.readNum2();
                        string = this.getPrefix(s3);
                    }
                }
                if (s >= 224 && s <= 227) {
                    decodeElem.setArrMode(true);
                    this.curElem = decodeElem;
                    this.event = (byte)99;
                } else {
                    this.pushElem(decodeElem);
                    this.processAttrs();
                    this.event = 1;
                }
                decodeElem.setPrefix(string);
                decodeElem.setSeqMode((by & 1) > 0);
                this.state = 1;
                return this.event;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: {
                DecodeElem decodeElem;
                Object var11_23 = null;
                if (this.locId > 0L) {
                    if (this.locId == 1L) {
                        this.locId = 0L;
                        this.datastatus = (short)2;
                        this.state = (short)4;
                        return 1;
                    }
                    long l = this.locId;
                    this.locId = 0L;
                    decodeElem = this.getProperty(l);
                } else if (this.curStream.laElem != null) {
                    decodeElem = this.curStream.laElem;
                    this.curStream.laElem = null;
                } else if ((this.opinfo.flags & 1) > 0) {
                    DecodeElem decodeElem3 = this.peekElem();
                    if (decodeElem3.prop == null) {
                        throw new BinXMLException("Invalid instruction.");
                    }
                    short s4 = (short)this.opdata[1];
                    decodeElem = this.getProperty(this.schema, decodeElem3.prop, s4);
                } else {
                    long l = this.opdata[1];
                    decodeElem = this.getProperty(l);
                }
                if (decodeElem.isAttr) {
                    throw new BinXMLException("Invalid attribute.");
                }
                decodeElem.setPrefix(null);
                this.pushElem(decodeElem);
                this.datastatus = (short)2;
                this.state = (short)2;
                return 1;
            }
            case 213: 
            case 214: {
                DecodeElem decodeElem;
                DecodeElem decodeElem4 = this.peekElem();
                if (this.locId > 0L) {
                    long l = this.locId;
                    this.locId = 0L;
                    decodeElem = this.getProperty(l);
                } else if (decodeElem4.isArrMode()) {
                    decodeElem = this.elemStack.getNew(this.curElem);
                } else if (decodeElem4.isSeqMode()) {
                    decodeElem4.kidnum = (short)(decodeElem4.kidnum + 1);
                    decodeElem = this.getProperty(this.schema, decodeElem4.prop, decodeElem4.kidnum);
                } else {
                    throw new BinXMLException("Invalid ELEMSTART.");
                }
                this.pushElem(decodeElem);
                this.processAttrs();
                if (s == 214) {
                    decodeElem.setSeqMode(true);
                }
                this.state = 1;
                return 1;
            }
            case 218: {
                this.noseq = (short)2;
                return 99;
            }
            case 144: {
                DecodeElem decodeElem = this.peekElem();
                if (!decodeElem.isSeqMode()) {
                    throw new BinXMLException("Invalid DATNULL.");
                }
                decodeElem.kidnum = (short)(decodeElem.kidnum + 1);
                return 99;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: {
                this.datastatus = (short)2;
                if (this.state == 5) {
                    if (this.prtOpcode != 228) {
                        throw new BinXMLException("Invalid PRT* sequence");
                    }
                    this.state = 1;
                    this.getEventText();
                    this.curValue = this.prtBuf + this.curValue;
                    return 4;
                }
                DecodeElem decodeElem = this.peekElem();
                if (this.locId > 0L) {
                    if (this.locId == 1L) {
                        this.locId = 0L;
                        this.state = (short)4;
                        return 4;
                    }
                    long l = this.locId;
                    this.locId = 0L;
                    DecodeElem decodeElem5 = this.getProperty(l);
                    this.pushElem(decodeElem5);
                    this.state = (short)2;
                    return 1;
                }
                if (decodeElem.isArrMode()) {
                    DecodeElem decodeElem6 = this.elemStack.getNew(this.curElem);
                    this.pushElem(decodeElem6);
                    this.state = (short)2;
                    return 1;
                }
                if (decodeElem.isSeqMode() && this.noseq == 0) {
                    decodeElem.kidnum = (short)(decodeElem.kidnum + 1);
                    DecodeElem decodeElem7 = this.getProperty(this.schema, decodeElem.prop, decodeElem.kidnum);
                    this.pushElem(decodeElem7);
                    this.state = (short)2;
                    return 1;
                }
                this.state = 1;
                return 4;
            }
            case 228: 
            case 230: {
                this.getDataLen(s);
                this.addPRTdata((int)this.datalen, s);
                this.state = (short)5;
                return 99;
            }
            case 231: 
            case 233: {
                this.addPRTdata((int)this.opdata[0], s);
                this.state = (short)5;
                return 99;
            }
            case 232: {
                this.addPRTdata((int)this.opdata[1], s);
                this.state = (short)5;
                return 99;
            }
            case 163: 
            case 164: 
            case 165: {
                if (this.state == 5) {
                    if (this.prtOpcode != 230) {
                        throw new BinXMLException("Invalid PRT* sequence");
                    }
                    this.state = 1;
                    this.getEventText();
                    this.curValue = this.prtBuf + this.curValue;
                    return 4;
                }
                this.state = 1;
                if (this.locId > 0L) {
                    this.locId = 0L;
                    this.state = (short)4;
                }
                this.datastatus = (short)2;
                return 4;
            }
            case 171: 
            case 172: 
            case 173: {
                long l = this.opdata[0];
                this.value = this.curStream.readString((int)l);
                if (this.state == 5) {
                    if (this.prtOpcode != 233) {
                        throw new BinXMLException("Invalid PRT* sequence");
                    }
                    this.state = 1;
                    this.value = this.prtBuf + this.value;
                }
                return 5;
            }
            case 221: {
                throw new BinXMLException("Invalid CSX instruction.");
            }
            case 217: {
                this.popElem();
                return 2;
            }
            case 169: 
            case 170: {
                long l = this.opdata[0];
                this.pitgtlen = (int)this.opdata[1];
                this.piTarget = this.curStream.readString(this.pitgtlen);
                this.value = this.curStream.readString((int)(l - (long)this.pitgtlen));
                if (this.state == 5) {
                    if (this.prtOpcode != 232) {
                        throw new BinXMLException("Invalid PRT* sequence");
                    }
                    this.state = 1;
                    this.value = this.prtBuf + this.value;
                }
                return 3;
            }
            case 166: 
            case 167: 
            case 168: {
                long l = this.opdata[0];
                this.value = this.curStream.readString((int)l);
                if (this.state == 5) {
                    if (this.prtOpcode != 231) {
                        throw new BinXMLException("Invalid PRT* sequence");
                    }
                    this.state = 1;
                    this.value = this.prtBuf + this.value;
                }
                return 12;
            }
            case 215: 
            case 216: {
                DecodeElem decodeElem = this.peekElem();
                decodeElem.setArrMode(s == 215);
                return 99;
            }
            case 145: 
            case 146: 
            case 147: {
                long l = this.opdata[0];
                byte[] byArray = new byte[(int)l];
                this.readBytes(byArray, (int)l);
                this.schema = this.vocabMngr.getBinXMLSchema(byArray);
                this.addSchema(this.schema);
                this.pushSchema(this.schema);
                return 99;
            }
            case 148: {
                this.schema = this.popSchema();
                return 99;
            }
            case 149: {
                short s5 = this.readNum2();
                this.dtdName = s5 > 0 ? this.curStream.readString(s5) : null;
                s5 = this.readNum2();
                this.publicId = s5 > 0 ? this.curStream.readString(s5) : null;
                s5 = this.readNum2();
                this.systemId = s5 > 0 ? this.curStream.readString(s5) : null;
                return 100;
            }
            case 150: {
                short s6 = this.readNum2();
                this.elemName = s6 > 0 ? this.curStream.readString(s6) : null;
                s6 = this.readNum2();
                this.contentSpec = s6 > 0 ? this.curStream.readString(s6) : null;
                return 101;
            }
            case 151: {
                short s7 = this.readNum2();
                this.elemName = s7 > 0 ? this.curStream.readString(s7) : null;
                s7 = this.readNum2();
                this.attrName = s7 > 0 ? this.curStream.readString(s7) : null;
                s7 = this.readNum2();
                this.attrType = s7 > 0 ? this.curStream.readString(s7) : null;
                s7 = this.readNum2();
                this.attrMode = s7 > 0 ? this.curStream.readString(s7) : null;
                s7 = this.readNum2();
                this.value = s7 > 0 ? this.curStream.readString(s7) : null;
                return 102;
            }
            case 152: {
                short s8 = this.readNum2();
                this.entName = s8 > 0 ? this.curStream.readString(s8) : null;
                s8 = this.readNum2();
                this.value = s8 > 0 ? this.curStream.readString(s8) : null;
                s8 = this.readNum2();
                this.publicId = s8 > 0 ? this.curStream.readString(s8) : null;
                s8 = this.readNum2();
                this.systemId = s8 > 0 ? this.curStream.readString(s8) : null;
                s8 = this.readNum2();
                String string = this.notName = s8 > 0 ? this.curStream.readString(s8) : null;
                if (this.value != null) {
                    return 103;
                }
                if (this.notName != null) {
                    return 104;
                }
                return 105;
            }
            case 153: {
                short s9 = this.readNum2();
                this.parName = s9 > 0 ? this.curStream.readString(s9) : null;
                s9 = this.readNum2();
                this.publicId = s9 > 0 ? this.curStream.readString(s9) : null;
                s9 = this.readNum2();
                this.systemId = s9 > 0 ? this.curStream.readString(s9) : null;
                return 106;
            }
            case 154: {
                short s10 = this.readNum2();
                this.notName = s10 > 0 ? this.curStream.readString(s10) : null;
                s10 = this.readNum2();
                this.publicId = s10 > 0 ? this.curStream.readString(s10) : null;
                s10 = this.readNum2();
                this.systemId = s10 > 0 ? this.curStream.readString(s10) : null;
                return 107;
            }
            case 155: {
                return 108;
            }
            case 156: {
                return 99;
            }
            case 157: {
                return 99;
            }
            case 234: 
            case 235: 
            case 236: {
                this.skipData();
                return 99;
            }
            case 161: {
                return 99;
            }
        }
        throw new BinXMLException("Invalid opcode '" + s + "'");
    }

    private void processAttrs() throws BinXMLException {
        int n;
        block10: while (true) {
            n = this.mark;
            short s = this.nextCSXInstr();
            if (s == 255) {
                throw new BinXMLException("Invalid opcode '" + s + "'");
            }
            switch (s) {
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    long l;
                    short s2;
                    long l2;
                    DecodeElem decodeElem;
                    short s3;
                    DecodeElem decodeElem2;
                    byte by;
                    int n2 = 0;
                    boolean bl = false;
                    String string = null;
                    if (s >= 203 && s <= 207) {
                        by = (byte)this.opdata[1];
                    } else if (s >= 208 && s <= 212 || s >= 224 && s <= 227) {
                        by = (byte)this.opdata[2];
                        bl = true;
                    } else {
                        by = 0;
                    }
                    if ((this.opinfo.flags & 1) > 0) {
                        decodeElem2 = this.peekElem();
                        if (decodeElem2.prop == null) {
                            throw new BinXMLException("Invalid instruction.");
                        }
                        s3 = (short)(bl ? this.opdata[1] : this.opdata[0]);
                        decodeElem = this.getProperty(this.schema, decodeElem2.prop, s3);
                    } else {
                        l2 = bl ? this.opdata[1] : this.opdata[0];
                        decodeElem = this.getProperty(l2);
                    }
                    if (!decodeElem.isAttr) {
                        this.curStream.ladata = n;
                        this.curStream.laElem = decodeElem;
                        return;
                    }
                    if (bl) {
                        if ((by & 2) > 0) {
                            n2 = this.readNum4();
                        }
                        if ((by & 8) > 0) {
                            s2 = this.readNum2();
                            string = this.getPrefix(s2);
                        }
                    }
                    string = decodeElem.setPrefix(string);
                    String string2 = null;
                    while ((s = this.nextCSXInstr()) != 217) {
                        if (!this.opinfo.hasfixeddata && s != 138 && s != 139) {
                            throw new BinXMLException("Invalid opcode '" + s + "'");
                        }
                        l = this.getdatalen(s);
                        string2 = this.curStream.readString((int)l);
                    }
                    if (string == null || string.length() == 0) {
                        this.addAttr(string, decodeElem.local, decodeElem.local, string2);
                        continue block10;
                    }
                    this.addAttr(string, decodeElem.local, string + ":" + decodeElem.local, string2);
                    continue block10;
                }
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: {
                    long l2;
                    DecodeElem decodeElem;
                    short s3;
                    DecodeElem decodeElem2;
                    String string = null;
                    if ((this.opinfo.flags & 1) > 0) {
                        decodeElem2 = this.peekElem();
                        if (decodeElem2.prop == null) {
                            throw new BinXMLException("Invalid instruction.");
                        }
                        s3 = (short)this.opdata[1];
                        decodeElem = this.getProperty(this.schema, decodeElem2.prop, s3);
                    } else {
                        l2 = this.opdata[1];
                        decodeElem = this.getProperty(l2);
                    }
                    if (!decodeElem.isAttr) {
                        this.curStream.ladata = n;
                        this.curStream.laElem = decodeElem;
                        return;
                    }
                    long l = this.getdatalen(s);
                    String string2 = this.curStream.readString((int)l);
                    string = decodeElem.setPrefix(null);
                    if (string == null || string.length() == 0) {
                        this.addAttr(string, decodeElem.local, decodeElem.local, string2);
                        continue block10;
                    }
                    this.addAttr(string, decodeElem.local, string + ":" + decodeElem.local, string2);
                    continue block10;
                }
                case 221: {
                    short s2 = (short)this.opdata[0];
                    PrefixInfo prefixInfo = this.getPrefixInfo(s2);
                    this.pushNamespace(prefixInfo);
                    if (prefixInfo.prefix == null || prefixInfo.prefix.length() == 0) {
                        this.addAttr(null, "xmlns", "xmlns", prefixInfo.getUri());
                        continue block10;
                    }
                    this.addAttr("xmlns", prefixInfo.prefix, "xmlns:" + prefixInfo.prefix, prefixInfo.getUri());
                    continue block10;
                }
                case 222: 
                case 223: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    long l3 = this.opdata[1];
                    BinXMLNamespaceToken binXMLNamespaceToken = this.tokenMngr.getNamespaceToken(l3);
                    String string2 = binXMLNamespaceToken.getLocalName();
                    this.addPrefix((short)0, string, l3);
                    PrefixInfo prefixInfo = this.getPrefixInfo(l3);
                    this.pushNamespace(prefixInfo);
                    if (string == null || string.length() == 0) {
                        this.addAttr(null, "xmlns", "xmlns", string2);
                        continue block10;
                    }
                    this.addAttr("xmlns", string, "xmlns:" + string, string2);
                    continue block10;
                }
                case 218: {
                    continue block10;
                }
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    long l3 = this.opdata[1];
                    this.tokenMngr.registerNamespace(l3, string);
                    continue block10;
                }
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    long l4 = this.opdata[2];
                    long l3 = this.opdata[3];
                    boolean bl = ((int)this.opdata[1] & 1) > 0;
                    this.tokenMngr.registerTokenId(l4, string, l3, bl);
                    continue block10;
                }
                case 178: 
                case 179: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    long l4 = this.opdata[2];
                    long l3 = this.opdata[1];
                    this.addPrefix((short)l4, string, l3);
                    continue block10;
                }
            }
            break;
        }
        this.curStream.ladata = n;
    }

    void decodeVocabDoc(BinXMLTokenManager binXMLTokenManager) throws BinXMLException {
        long l;
        long l2;
        this.reset();
        short s = this.readOpcode();
        this.readSectionHeader(s);
        s = this.nextCSXInstr();
        if (s == 174) {
            l2 = this.getdatalen(s);
            String string = this.curStream.readString((int)l2);
            l = this.opdata[1];
            binXMLTokenManager.registerNamespace(l, string);
        } else {
            throw new BinXMLException("Invalid CSX instruction.");
        }
        block3: while ((s = this.nextCSXInstr()) != 160) {
            switch (s) {
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: {
                    l2 = this.getdatalen(s);
                    String string = this.curStream.readString((int)l2);
                    long l3 = this.opdata[2];
                    l = this.opdata[3];
                    boolean bl = ((int)this.opdata[1] & 1) > 0;
                    binXMLTokenManager.registerTokenId(l3, string, l, bl);
                    continue block3;
                }
            }
            throw new BinXMLException("Invalid CSX instruction.");
        }
    }

    private void readSectionHeader(short s) throws BinXMLException {
        byte by;
        if (s != 159) {
            throw new BinXMLException("Invalid CSX instruction.");
        }
        this.decoder.version = this.readNum1();
        if (this.decoder.version != 1) {
            throw new BinXMLException("Invalid STRTSEC version.");
        }
        byte by2 = this.readNum1();
        if ((by2 & 8) > 0) {
            by = this.readNum1();
            this.decoder.docid = new byte[by];
            this.readBytes(this.decoder.docid, by);
        }
        if ((by2 & 0x10) > 0) {
            by = this.readNum1();
            this.decoder.pathid = new byte[by];
            this.readBytes(this.decoder.pathid, by);
            byte by3 = this.readNum1();
            this.skipBytes(by3);
        }
        if ((by2 & 4) > 0) {
            this.decoder.rguid = new byte[16];
            this.readBytes(this.decoder.rguid, 16L);
        }
    }

    private boolean isPropertyId(long l) {
        return l < 0L;
    }

    void addPRTdata(int n, short s) throws BinXMLException {
        String string = this.curStream.readString(n);
        if (this.prtBuf != null) {
            if (this.prtOpcode != s) {
                throw new BinXMLException("Invalid PRT* sequence");
            }
            this.prtBuf = this.prtBuf + string;
        } else {
            this.prtBuf = string;
            this.prtOpcode = s;
        }
    }

    void pushElem(DecodeElem decodeElem) {
        decodeElem.nsinx = this.nsStack.size();
        this.elemStack.push(decodeElem);
        this.curElem = decodeElem;
        this.curElem.streamId = this.curStream.id;
        this.prevSibling = null;
    }

    DecodeElem popElem() throws BinXMLException {
        if (this.elemStack.empty()) {
            throw new BinXMLException("Invalid EndElement event");
        }
        this.prevSibling = this.curElem = this.elemStack.pop();
        this.popNamespace(this.curElem.nsinx);
        if (!this.elemStack.empty()) {
            DecodeElem decodeElem = this.elemStack.peek();
            if (this.curElem.streamId != decodeElem.streamId) {
                decodeElem.flags = 0;
                this.popStream();
            }
        }
        return this.curElem;
    }

    DecodeElem peekElem() throws BinXMLException {
        if (this.elemStack.empty()) {
            throw new BinXMLException("Invalid peek element");
        }
        return this.elemStack.peek();
    }

    DecodeElem getProperty(BinXMLSchema binXMLSchema, BinXMLProperty binXMLProperty, short s) throws BinXMLException {
        BinXMLProperty binXMLProperty2;
        if (binXMLProperty.getBinXMLSchema() == null) {
            binXMLProperty.setBinXMLSchema(binXMLSchema);
        }
        if ((binXMLProperty2 = binXMLSchema.getProperty(binXMLProperty, s)) == null) {
            throw new BinXMLException("Invalid kidnum:" + s);
        }
        binXMLProperty2.setBinXMLSchema(binXMLSchema);
        QName qName = binXMLProperty2.getQName();
        DecodeElem decodeElem = this.elemStack.getNew();
        decodeElem.local = qName.getLocalPart();
        decodeElem.uri = qName.getNamespaceURI();
        decodeElem.prefix = qName.getPrefix();
        decodeElem.nsid = 0L;
        decodeElem.id = -binXMLProperty2.propId;
        decodeElem.isAttr = binXMLProperty2.isAttribute();
        decodeElem.prop = binXMLProperty2;
        return decodeElem;
    }

    DecodeElem getProperty(long l) throws BinXMLException {
        DecodeElem decodeElem = this.elemStack.getNew();
        if (this.isPropertyId(l)) {
            int n = -((int)l);
            BinXMLProperty binXMLProperty = this.schema.getProperty(n);
            if (binXMLProperty == null) {
                throw new BinXMLException("Invalid propid:" + n);
            }
            QName qName = binXMLProperty.getQName();
            decodeElem.local = qName.getLocalPart();
            decodeElem.uri = qName.getNamespaceURI();
            decodeElem.prefix = qName.getPrefix();
            decodeElem.nsid = 0L;
            decodeElem.isAttr = binXMLProperty.isAttribute();
            decodeElem.id = l;
            decodeElem.prop = binXMLProperty;
        } else {
            BinXMLQNameToken binXMLQNameToken = this.tokenMngr.getToken(l);
            long l2 = binXMLQNameToken.getNamespaceId();
            if (l2 == this.decoder.nsidnull) {
                l2 = 0L;
            }
            decodeElem.local = binXMLQNameToken.getLocalName();
            if (l2 != 0L) {
                BinXMLNamespaceToken binXMLNamespaceToken = this.tokenMngr.getNamespaceToken(l2);
                decodeElem.uri = binXMLNamespaceToken.getLocalName();
            } else {
                decodeElem.uri = null;
            }
            decodeElem.prefix = null;
            decodeElem.nsid = l2;
            decodeElem.id = l;
            decodeElem.isAttr = binXMLQNameToken.isAttr();
            decodeElem.prop = null;
        }
        return decodeElem;
    }

    void addAttr(String string, String string2, String string3, String string4) {
        this.attrlist.addAttr(string == null ? "" : string, string2, string3, string4, true, 0);
    }

    BinXMLSchema popSchema() {
        return (BinXMLSchema)this.schemaStack.pop();
    }

    void pushSchema(BinXMLSchema binXMLSchema) {
        this.schemaStack.push(binXMLSchema);
    }

    void pushNamespace(PrefixInfo prefixInfo) throws BinXMLException {
        this.nsStack.add(prefixInfo);
    }

    String getNSPrefix(long l) throws BinXMLException {
        for (int i = 0; i < this.nsStack.size(); ++i) {
            PrefixInfo prefixInfo = (PrefixInfo)this.nsStack.get(i);
            if (prefixInfo.nsid != l) continue;
            return prefixInfo.prefix;
        }
        return this.getPrefix(l);
    }

    String getNSPrefix(String string) throws BinXMLException {
        for (int i = 0; i < this.nsStack.size(); ++i) {
            PrefixInfo prefixInfo = (PrefixInfo)this.nsStack.get(i);
            if (!prefixInfo.getUri().equals(string)) continue;
            return prefixInfo.prefix;
        }
        return this.getPrefix(string);
    }

    void popNamespace(int n) {
        for (int i = this.nsStack.size() - 1; i >= n; --i) {
            this.nsStack.remove(i);
        }
    }

    short addSchema(BinXMLSchema binXMLSchema) {
        boolean bl = false;
        for (int i = 0; i < this.schemaTable.size(); ++i) {
            if (this.schemaTable.get(i) != binXMLSchema) continue;
            return (short)i;
        }
        this.schemaTable.add(binXMLSchema);
        return (short)(this.schemaTable.size() - 1);
    }

    short getSchemaId(BinXMLSchema binXMLSchema) {
        for (int i = 0; i < this.schemaTable.size(); ++i) {
            if (this.schemaTable.get(i) != binXMLSchema) continue;
            return (short)i;
        }
        return 0;
    }

    BinXMLSchema getSchema(short s) {
        if (s >= 0 && s < this.schemaTable.size()) {
            return (BinXMLSchema)this.schemaTable.get(s);
        }
        return null;
    }

    void addPrefix(short s, String string, long l) throws BinXMLException {
        this.prefixTable.add(new PrefixInfo(s, string, l));
    }

    PrefixInfo getPrefixInfo(short s) throws BinXMLException {
        for (int i = 0; i < this.prefixTable.size(); ++i) {
            PrefixInfo prefixInfo = (PrefixInfo)this.prefixTable.get(i);
            if (prefixInfo.pfxid != s) continue;
            return prefixInfo;
        }
        throw new BinXMLException("Invalid prefixid: " + s);
    }

    PrefixInfo getPrefixInfo(long l) throws BinXMLException {
        for (int i = 0; i < this.prefixTable.size(); ++i) {
            PrefixInfo prefixInfo = (PrefixInfo)this.prefixTable.get(i);
            if (prefixInfo.nsid != l) continue;
            return prefixInfo;
        }
        throw new BinXMLException("Invalid nsid: " + l);
    }

    String getPrefix(String string) throws BinXMLException {
        if (string.equals("http://xmlns.oracle.com/xdb/nonamespace")) {
            return "";
        }
        for (int i = 0; i < this.prefixTable.size(); ++i) {
            PrefixInfo prefixInfo = (PrefixInfo)this.prefixTable.get(i);
            if (!prefixInfo.getUri().equals(string)) continue;
            return prefixInfo.prefix;
        }
        throw new BinXMLException("Invalid URI: " + string);
    }

    String getPrefix(short s) throws BinXMLException {
        for (int i = 0; i < this.prefixTable.size(); ++i) {
            PrefixInfo prefixInfo = (PrefixInfo)this.prefixTable.get(i);
            if (prefixInfo.pfxid != s) continue;
            return prefixInfo.prefix;
        }
        throw new BinXMLException("Invalid prefixid: " + s);
    }

    String getPrefix(long l) throws BinXMLException {
        for (int i = 0; i < this.prefixTable.size(); ++i) {
            PrefixInfo prefixInfo = (PrefixInfo)this.prefixTable.get(i);
            if (prefixInfo.nsid != l) continue;
            return prefixInfo.prefix;
        }
        throw new BinXMLException("Invalid nsid: " + l);
    }

    void copyPrefixTable(ArrayList arrayList) {
        for (int i = 0; i < this.prefixTable.size(); ++i) {
            arrayList.add(this.prefixTable.get(i));
        }
    }

    String getEventName() {
        String string = this.getEventPrefix();
        if (string == null || string.length() == 0) {
            return this.getEventLocalName();
        }
        return string + ":" + this.getEventLocalName();
    }

    String getEventLocalName() {
        return this.curElem.local;
    }

    String getEventPrefix() {
        return this.curElem.prefix;
    }

    String getEventURI() {
        return this.curElem.uri;
    }

    long getEventQNameID() {
        return this.curElem.id;
    }

    Attributes getEventAttrList() {
        return this.attrlist;
    }

    String getEventText() throws BinXMLException {
        if (this.datastatus == 0) {
            return this.curValue;
        }
        this.getDataLen(this.opcode);
        switch (this.datatype) {
            case 1: {
                this.curValue = this.curStream.readString((int)this.datalen);
                break;
            }
            case 7: {
                this.curValue = "";
                break;
            }
            case 2: {
                byte[] byArray = new byte[(int)this.datalen];
                this.readBytes(byArray, this.datalen);
                this.curValue = BinXMLUtil.convBytesToHexString(byArray);
                break;
            }
            case 4: {
                int n = this.readNum4();
                this.curValue = Integer.toString(n);
                break;
            }
            case 5: {
                int n = this.readNum4();
                this.curValue = Integer.toString(n);
                break;
            }
            case 6: {
                int n = this.readNum4();
                float f = Float.intBitsToFloat(n);
                this.curValue = Float.toString(f);
                break;
            }
            case 14: {
                long l = this.curStream.readLong8();
                double d = Double.longBitsToDouble(l);
                this.curValue = Double.toString(d);
                break;
            }
            case 9: {
                this.curValue = "";
                break;
            }
            case 8: {
                this.curValue = "";
                break;
            }
            case 13: {
                this.curValue = "";
                break;
            }
            case 3: {
                byte by = this.readNum1();
                this.curValue = by == 0 ? "false" : "true";
                break;
            }
            default: {
                this.curValue = null;
            }
        }
        this.datastatus = 0;
        return this.curValue;
    }

    short nextCSXInstr() throws BinXMLException {
        int n;
        if (this.curStream.ladata > 0) {
            this.eventMark = this.curStream.ladata;
            this.curStream.ladata = 0;
            return this.opcode;
        }
        this.opcode = this.curStream.readOpcode();
        if (this.opcode < 0 || this.opcode >= 237) {
            throw new BinXMLException("Invalid opcode:" + this.opcode);
        }
        this.opinfo = BinXMLFormat.opcodes[this.opcode];
        block6: for (n = 0; n < this.opinfo.opnum; ++n) {
            switch (this.opinfo.oplen[n]) {
                case 1: {
                    this.opdata[n] = this.curStream.readLong1();
                    continue block6;
                }
                case 2: {
                    this.opdata[n] = this.curStream.readLong2();
                    continue block6;
                }
                case 4: {
                    this.opdata[n] = this.curStream.readLong4();
                    continue block6;
                }
                case 8: {
                    this.opdata[n] = this.curStream.readLong8();
                }
            }
        }
        if (this.printInst) {
            System.out.print("[" + this.eventMark + "-" + this.getLMark(this.eventMark) + "] " + this.opinfo.name + "   ");
            for (n = 0; n < this.opinfo.opnum; ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(" " + this.opdata[n]);
            }
            System.out.println("");
        }
        return this.opcode;
    }

    void skipCSXInstr() throws BinXMLException {
        short s = this.readOpcode();
        this.opinfo = BinXMLFormat.opcodes[s];
        this.curStream.readString(this.opinfo.skiplen);
        long l = this.getdatalen(s);
        if (l > 0L) {
            this.curStream.readString((int)l);
        }
    }

    void skipData() throws BinXMLException {
        if (this.datastatus != 0) {
            this.getdatalen(this.opcode);
            this.skipBytes((int)this.datalen);
            this.datastatus = 0;
        }
    }

    long getDataLen() {
        return this.getDataLen(this.opcode);
    }

    long getDataLen(short s) {
        if (this.datastatus != 2) {
            if (this.datastatus == 1) {
                return this.datalen;
            }
            return 0L;
        }
        this.datastatus = 1;
        return this.getdatalen(s);
    }

    long getdatalen(short s) {
        if (this.opinfo.hasfixeddata) {
            this.datalen = this.opinfo.fixeddatalen;
            this.datatype = BinXMLFormat.dataType[s];
        } else if (this.opinfo.hasvardata) {
            if ((this.opinfo.flags & 8) > 0) {
                this.datalen = this.opdata[0];
                this.datatype = 1;
                switch (s) {
                    case 149: 
                    case 154: {
                        this.datalen += 6L;
                        break;
                    }
                    case 150: {
                        this.datalen += 4L;
                        break;
                    }
                    case 151: 
                    case 152: 
                    case 153: {
                        this.datalen += 10L;
                        break;
                    }
                }
            } else if ((this.opinfo.flags & 4) == 0) {
                this.datalen = this.opdata[0];
                this.datatype = 1;
            } else {
                switch (this.opinfo.oplen[0]) {
                    case 1: {
                        BinXMLOpcode binXMLOpcode = BinXMLFormat.opcodes[(int)this.opdata[0]];
                        if (!binXMLOpcode.hasfixeddata) {
                            // empty if block
                        }
                        this.datalen = binXMLOpcode.fixeddatalen;
                        this.datatype = BinXMLFormat.dataType[(short)this.opdata[0]];
                        break;
                    }
                    case 2: {
                        this.datalen = this.opdata[0] & 0xFFFFFFFFFFFF3FFFL;
                        this.datatype = (byte)((this.opdata[0] & 0xC000L) == 0L ? 1 : 2);
                        break;
                    }
                    case 4: {
                        this.datalen = this.opdata[0] & 0xFFFFFFFF3FFFFFFFL;
                        this.datatype = (byte)((this.opdata[0] & 0xFFFFFFFFC0000000L) == 0L ? 1 : 2);
                        break;
                    }
                    case 8: {
                        this.datalen = this.opdata[0] & 0x3FFFFFFFFFFFFFFFL;
                        this.datatype = (byte)((this.opdata[0] & 0xC000000000000000L) == 0L ? 1 : 2);
                        break;
                    }
                }
            }
        } else {
            this.datalen = 0L;
            this.datatype = 1;
        }
        return this.datalen;
    }

    short readOpcode() throws BinXMLException {
        long l = this.readBytes(this.buf, 1L);
        if (l < 1L) {
            throw new BinXMLException("Reached EOF.");
        }
        return (short)(this.buf[0] & 0xFF);
    }

    byte readNum1() throws BinXMLException {
        long l = this.readBytes(this.buf, 1L);
        if (l < 1L) {
            throw new BinXMLException("Reached EOF.");
        }
        return this.buf[0];
    }

    short readNum2() throws BinXMLException {
        long l = this.readBytes(this.buf, 2L);
        if (l < 2L) {
            throw new BinXMLException("Reached EOF.");
        }
        return (short)((this.buf[0] & 0xFF) << 8 | this.buf[1] & 0xFF);
    }

    int readNum4() throws BinXMLException {
        long l = this.readBytes(this.buf, 4L);
        if (l < 4L) {
            throw new BinXMLException("Reached EOF.");
        }
        return (this.buf[0] & 0xFF) << 24 | (this.buf[1] & 0xFF) << 16 | (this.buf[2] & 0xFF) << 8 | this.buf[3] & 0xFF;
    }

    protected void resetSimple() throws BinXMLException {
        this.elemStack.clear();
        this.schemaStack.clear();
        this.nsStack.clear();
        this.streamStack.clear();
        this.schema = null;
        this.datastatus = 0;
        this.state = 1;
        this.curStream = null;
        this.mark = 0;
    }

    protected void reset() throws BinXMLException {
        this.resetSimple();
        this.streamTable.clear();
        DecodeStream decodeStream = this.createStream(null);
        this.pushStream(decodeStream.id);
        this.pushElem(new DecodeElem());
    }

    NodeProperty getNodeProperty(BinXMLSchema binXMLSchema, BinXMLProperty binXMLProperty, short s) throws BinXMLException {
        BinXMLProperty binXMLProperty2 = binXMLSchema.getProperty(binXMLProperty, s);
        if (binXMLProperty2 == null) {
            throw new BinXMLException("Invalid kidnum:" + s);
        }
        QName qName = binXMLProperty2.getQName();
        return new NodeProperty(qName.getLocalPart(), qName.getNamespaceURI(), 0L, binXMLProperty2.isAttribute(), binXMLProperty2);
    }

    NodeProperty getNodeProperty(long l) throws BinXMLException {
        if (this.isPropertyId(l)) {
            int n = -((int)l);
            BinXMLProperty binXMLProperty = this.schema.getProperty(n);
            if (binXMLProperty == null) {
                throw new BinXMLException("Invalid propid:" + n);
            }
            QName qName = binXMLProperty.getQName();
            return new NodeProperty(qName.getLocalPart(), qName.getNamespaceURI(), 0L, binXMLProperty.isAttribute(), binXMLProperty);
        }
        QName qName = this.tokenMngr.getTokenName(l);
        BinXMLQNameToken binXMLQNameToken = this.tokenMngr.getToken(l);
        long l2 = binXMLQNameToken.getNamespaceId();
        if (l2 == this.decoder.nsidnull) {
            l2 = 0L;
        }
        return new NodeProperty(qName.getLocalPart(), qName.getNamespaceURI(), l2, binXMLQNameToken.isAttr(), null);
    }

    class NodeProperty {
        String local;
        String uri;
        long nsid;
        boolean isAttribute;
        BinXMLProperty prop;

        NodeProperty(String string, String string2, long l, boolean bl, BinXMLProperty binXMLProperty) {
            this.local = string;
            this.uri = string2;
            this.nsid = l;
            this.isAttribute = bl;
            this.prop = binXMLProperty;
        }

        boolean hasNS() {
            return this.nsid != 0L || this.uri != null && this.uri.length() > 0;
        }

        String getPrefix() throws BinXMLException {
            if (this.nsid != 0L) {
                return BinXMLDecodeReader.this.getNSPrefix(this.nsid);
            }
            if (this.uri != null && this.uri.length() > 0) {
                return BinXMLDecodeReader.this.getNSPrefix(this.uri);
            }
            return null;
        }
    }

    class PrefixInfo {
        String prefix;
        String uri;
        long nsid;
        short pfxid;

        PrefixInfo(short s, String string, long l) throws BinXMLException {
            BinXMLNamespaceToken binXMLNamespaceToken = BinXMLDecodeReader.this.tokenMngr.getNamespaceToken(l);
            this.uri = binXMLNamespaceToken != null ? binXMLNamespaceToken.getLocalName() : null;
            this.pfxid = s;
            this.prefix = string;
            this.nsid = l;
        }

        String getUri() throws BinXMLException {
            if (this.uri != null) {
                return this.uri;
            }
            BinXMLNamespaceToken binXMLNamespaceToken = BinXMLDecodeReader.this.tokenMngr.getNamespaceToken(this.nsid);
            if (binXMLNamespaceToken == null) {
                throw new BinXMLException("Invalid nsid: " + this.nsid);
            }
            this.uri = binXMLNamespaceToken.getLocalName();
            return this.uri;
        }
    }

    class DecodeElem
    implements BinXMLConstants {
        byte streamId = (byte)-1;
        String local;
        String prefix;
        String uri;
        long nsid;
        int typeid;
        BinXMLProperty prop;
        boolean isAttr;
        short flags;
        long id;
        int offset;
        short kidnum;
        byte schid;
        int nsinx;

        void print() {
            System.out.println("[" + (this.isArrMode() ? "A" : " ") + (this.isSeqMode() ? "S" : " ") + "](" + this.streamId + ") " + this.local);
        }

        DecodeElem(String string, String string2, String string3, long l, long l2, BinXMLProperty binXMLProperty) {
            this.uri = string;
            this.local = string2;
            this.nsid = l;
            this.prefix = string3;
            this.id = l2;
            this.prop = binXMLProperty;
            this.flags = 0;
            this.typeid = 0;
            this.kidnum = 0;
        }

        DecodeElem(DecodeElem decodeElem) {
            this.prop = decodeElem.prop;
            this.id = decodeElem.id;
            this.uri = decodeElem.uri;
            this.prefix = decodeElem.prefix;
            this.local = decodeElem.local;
            this.nsid = decodeElem.nsid;
            this.flags = 0;
            this.typeid = 0;
            this.kidnum = 0;
        }

        DecodeElem() {
            this.local = null;
            this.prop = null;
            this.id = 0L;
            this.prefix = null;
            this.flags = 0;
        }

        void setArrMode(boolean bl) {
            this.flags = bl ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
        }

        void setSeqMode(boolean bl) {
            this.flags = bl ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
        }

        QName getQName() {
            if (this.uri == null) {
                if (this.local == null) {
                    return new QName("");
                }
                return new QName(this.local);
            }
            if (this.prefix == null) {
                return new QName(this.uri, this.local);
            }
            return new QName(this.uri, this.local, this.prefix);
        }

        boolean hasNS() {
            return this.nsid != 0L || this.uri != null && this.uri.length() > 0;
        }

        String setPrefix(String string) throws BinXMLException {
            this.prefix = string != null ? string : (this.nsid != 0L ? BinXMLDecodeReader.this.getNSPrefix(this.nsid) : (this.uri != null && this.uri.length() > 0 ? BinXMLDecodeReader.this.getNSPrefix(this.uri) : null));
            return this.prefix;
        }

        String getLocal() {
            return this.local == null ? "" : this.local;
        }

        String getPrefix() {
            return this.prefix == null ? "" : this.prefix;
        }

        String getURI() {
            return this.uri == null ? "" : this.uri;
        }

        boolean isArrMode() {
            return (this.flags & 1) > 0;
        }

        boolean isSeqMode() {
            return (this.flags & 2) > 0;
        }
    }

    class ElemStack {
        DecodeElem[] stack = new DecodeElem[this.size];
        int sp = 0;
        int size = 128;

        ElemStack() {
            for (int i = 0; i < this.size - 1; ++i) {
                this.stack[i] = new DecodeElem();
            }
        }

        void clear() {
            this.sp = 0;
        }

        void push(DecodeElem decodeElem) {
            if (this.stack[this.sp] != decodeElem) {
                this.stack[this.sp] = decodeElem;
            }
            ++this.sp;
        }

        DecodeElem pop() throws BinXMLException {
            if (this.sp <= 0) {
                throw new BinXMLException("Stack underflow");
            }
            --this.sp;
            return this.stack[this.sp];
        }

        DecodeElem peek() {
            if (this.sp <= 0) {
                return null;
            }
            return this.stack[this.sp - 1];
        }

        DecodeElem get(int n) {
            if (n < 0) {
                return null;
            }
            return this.stack[n];
        }

        DecodeElem getNew(DecodeElem decodeElem) {
            DecodeElem decodeElem2 = this.stack[this.sp];
            decodeElem2.streamId = BinXMLDecodeReader.this.curStream.id;
            decodeElem2.prop = decodeElem.prop;
            decodeElem2.id = decodeElem.id;
            decodeElem2.uri = decodeElem.uri;
            decodeElem2.prefix = decodeElem.prefix;
            decodeElem2.local = decodeElem.local;
            decodeElem2.nsid = decodeElem.nsid;
            decodeElem2.flags = 0;
            decodeElem2.typeid = 0;
            decodeElem2.kidnum = 0;
            return decodeElem2;
        }

        DecodeElem getNew() {
            DecodeElem decodeElem = this.stack[this.sp];
            decodeElem.flags = 0;
            decodeElem.typeid = 0;
            decodeElem.kidnum = 0;
            return decodeElem;
        }

        int size() {
            return this.sp;
        }

        boolean empty() {
            return this.sp <= 0;
        }

        void print() {
            System.out.println("\n-----------------------");
            for (int i = this.sp - 1; i >= 0; --i) {
                this.stack[i].print();
            }
            System.out.println("-----------------------");
        }
    }

    private class MarkInfo {
        byte id;
        int lmark;
        int gmark;
        int endmark;

        MarkInfo(byte by, int n, int n2) {
            this.id = by;
            this.lmark = n;
            this.gmark = n2;
            this.endmark = Integer.MAX_VALUE;
        }
    }

    class DecodeStream {
        byte id;
        String href;
        BinXMLStreamImpl stream;
        ArrayList schemaTable;
        ArrayList prefixTable;
        int ladata;
        DecodeElem laElem;
        int readPos;
        int writePos;
        int pageid;
        byte[] buffer;
        int curBufLen;
        byte[] buf;
        String locator;

        DecodeStream(BinXMLStreamImpl binXMLStreamImpl, byte by) {
            this.stream = binXMLStreamImpl;
            this.id = by;
            this.href = null;
            this.init();
        }

        DecodeStream(String string, byte by) throws BinXMLException {
            File file = new File(string);
            this.stream = (BinXMLStreamImpl)BinXMLDecodeReader.this.binXMLProc.createBinXMLStream(file);
            this.id = by;
            this.href = string;
            this.init();
        }

        private void init() {
            this.schemaTable = new ArrayList(10);
            this.prefixTable = new ArrayList(20);
            this.buffer = new byte[128];
            this.buffer = this.stream.load(0, false);
            this.readPos = 0;
            this.writePos = BinXMLStreamImpl.BUFSIZE;
            this.ladata = 0;
            this.laElem = null;
            this.locator = null;
            this.curBufLen = 128;
            this.buf = new byte[this.curBufLen];
        }

        short nextByte() {
            try {
                if (this.readPos >= this.writePos) {
                    this.stream.unload(this.pageid, false);
                    this.buffer = this.stream.load(++this.pageid, false);
                    this.readPos = 0;
                    this.writePos = BinXMLStreamImpl.BUFSIZE;
                }
                return (short)(this.buffer[this.readPos] & 0xFF);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                return -1;
            }
        }

        short readOpcode() throws BinXMLException {
            if (this.readPos >= this.writePos) {
                this.upload();
            }
            ++BinXMLDecodeReader.this.mark;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return (short)(this.buffer[this.readPos++] & 0xFF);
        }

        long readLong1() throws BinXMLException {
            if (this.readPos >= this.writePos) {
                this.upload();
            }
            ++BinXMLDecodeReader.this.mark;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return this.buffer[this.readPos++] & 0xFF;
        }

        long readLong2() throws BinXMLException {
            long l;
            if (this.readPos + 2 < this.writePos) {
                l = (this.buffer[this.readPos++] & 0xFF) << 8;
                l += (long)(this.buffer[this.readPos++] & 0xFF);
            } else {
                if (this.readPos >= this.writePos) {
                    this.upload();
                }
                l = (this.buffer[this.readPos++] & 0xFF) << 8;
                if (this.readPos >= this.writePos) {
                    this.upload();
                }
                l += (long)(this.buffer[this.readPos++] & 0xFF);
            }
            BinXMLDecodeReader.this.mark += 2;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return l;
        }

        long readLong4() throws BinXMLException {
            long l;
            if (this.readPos + 4 < this.writePos) {
                l = (this.buffer[this.readPos++] & 0xFF) << 24;
                l += (long)((this.buffer[this.readPos++] & 0xFF) << 16);
                l += (long)((this.buffer[this.readPos++] & 0xFF) << 8);
                l += (long)(this.buffer[this.readPos++] & 0xFF);
            } else {
                l = 0L;
                for (int i = 24; i >= 0; i -= 8) {
                    if (this.readPos >= this.writePos) {
                        this.upload();
                    }
                    l += (long)((this.buffer[this.readPos++] & 0xFF) << i);
                }
            }
            BinXMLDecodeReader.this.mark += 4;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return l;
        }

        long readLong8() throws BinXMLException {
            long l = BinXMLDecodeReader.this.readNum4();
            long l2 = BinXMLDecodeReader.this.readNum4();
            if (l != 0L) {
                l *= 0x100000000L;
            }
            return l + l2;
        }

        String readString(long l) throws BinXMLException {
            String string;
            int n = this.readPos + (int)l;
            try {
                if (n >= this.writePos) {
                    long l2;
                    if (l > (long)this.curBufLen) {
                        this.buf = new byte[(int)l + 1];
                        this.curBufLen = (int)l;
                    }
                    if ((l2 = this.readBytes(this.buf, l)) < l) {
                        throw new BinXMLException("Reached EOF.");
                    }
                    string = new String(this.buf, 0, (int)l, "UTF-8");
                } else {
                    string = new String(this.buffer, this.readPos, (int)l, "UTF-8");
                    this.readPos = n;
                    BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                    if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                        BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                    }
                }
            }
            catch (Exception exception) {
                return null;
            }
            return string;
        }

        long readBytes(byte[] byArray, long l) {
            long l2;
            try {
                for (l2 = 0L; l2 < l; ++l2) {
                    if (this.readPos >= this.writePos) {
                        this.stream.unload(this.pageid, false);
                        this.buffer = this.stream.load(++this.pageid, false);
                        this.readPos = 0;
                        this.writePos = BinXMLStreamImpl.BUFSIZE;
                    }
                    byArray[(int)l2] = this.buffer[this.readPos++];
                }
                BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                    BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                return l2 - 1L;
            }
            return l;
        }

        void upload() throws BinXMLException {
            try {
                this.stream.unload(this.pageid, false);
                this.buffer = this.stream.load(++this.pageid, false);
                this.readPos = 0;
                this.writePos = BinXMLStreamImpl.BUFSIZE;
            }
            catch (Exception exception) {
                throw new BinXMLException(exception.getMessage());
            }
        }

        long skipBytes(long l) {
            int n = (int)l + this.readPos;
            try {
                if (n >= this.writePos) {
                    this.setLMark(BinXMLDecodeReader.this.mark + (int)l);
                } else {
                    this.readPos = n;
                }
                BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                    BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                }
            }
            catch (Exception exception) {
                return 0L;
            }
            return l;
        }

        void setLMark(int n) {
            int n2 = n / BinXMLStreamImpl.BUFSIZE;
            if (n2 != this.pageid) {
                this.stream.unload(this.pageid, false);
                this.pageid = n2;
                this.buffer = this.stream.load(this.pageid, false);
                this.writePos = BinXMLStreamImpl.BUFSIZE;
            }
            this.readPos = n % BinXMLStreamImpl.BUFSIZE;
            this.ladata = 0;
        }

        int getLMark() {
            return this.readPos + this.pageid * BinXMLStreamImpl.BUFSIZE;
        }
    }
}

