/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMPTZ;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLFormat;
import oracle.xml.binxml.BinXMLInfosetWriter;
import oracle.xml.binxml.BinXMLNamespaceToken;
import oracle.xml.binxml.BinXMLOpcode;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLQNameToken;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLSchemaResolver;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLTokenList;
import oracle.xml.binxml.BinXMLTokenManager;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.binxml.DBBinXMLMetadataProvider;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

class BinXMLEncoderImpl
implements BinXMLEncoder,
ContentHandler,
ErrorHandler,
DTDHandler,
DeclHandler,
LexicalHandler,
BinXMLConstants {
    boolean schemaAware = false;
    boolean inlineTokenDefs = true;
    boolean implicitSchemaReg = false;
    boolean saveSchemaValidationInfo = false;
    String schemaURL;
    BinXMLTokenManager tokenManager;
    BinXMLVocabularyManager vocabManager;
    BinXMLProcessorImpl binXMLProcessor;
    BinXMLStreamImpl binStream;
    BinXMLSectionState secState;
    BinXMLPageWriter writer;
    BinXMLSchemaResolver schemaResolver;
    XSDValidator validator;
    Stack elementStack;
    byte[] docId = null;
    Locator locator = null;
    byte[] page;
    boolean dtd = false;
    String xmlVersion = null;
    String standalone = null;
    String encoding = null;
    PrintWriter debugWriter;
    XMLError validatorErr = new XMLError();
    int depth;
    int cdataDepth;
    BinXMLElement currentElem;
    BinXMLEncBuffer buffer;
    static final byte NO_EVENT = 0;
    static final byte START_ELEM_EVENT = 1;
    static final byte END_ELEM_EVENT = 2;
    static final byte CHARS_EVENT = 3;
    static final byte DTD_EVENT = 4;
    static final byte OTHER_EVENT = 5;
    static final byte BUFSTATE_NONE = 1;
    static final byte BUFSTATE_GOTSTART = 2;
    static final byte BUFSTATE_GOTFIRSTTEXT = 3;
    static final byte BUFSTATE_GOTEND = 4;
    static final byte BUFSTATE_LAST = 5;
    static final byte SIMPLENODE_QNAMEID = 1;
    static final byte SIMPLENODE_ARRAY = 2;
    static final byte SIMPLENODE_DATAONLY = 3;
    static final byte SIMPLENODE_KIDNUM = 4;
    static final byte SIMPLENODE_SCHEMASEQ = 5;

    public void setProperty(int n, boolean bl) throws BinXMLException {
        switch (n) {
            case 1: {
                this.schemaAware = bl;
                if (!this.schemaAware) break;
                this.inlineTokenDefs = false;
                break;
            }
            case 2: {
                this.saveSchemaValidationInfo = bl;
                break;
            }
            case 3: {
                this.implicitSchemaReg = bl;
                break;
            }
            case 4: {
                this.inlineTokenDefs = this.schemaAware ? false : bl;
            }
        }
    }

    public void setSchema(String string) throws BinXMLException {
        this.schemaURL = string;
    }

    public ContentHandler getContentHandler() throws BinXMLException {
        if (this.schemaAware || this.saveSchemaValidationInfo) {
            try {
                this.validator = new XSDValidator();
                this.validator.addContentHandler(this);
                this.schemaResolver = new BinXMLSchemaResolver(this.vocabManager);
                this.validator.setProperty("SCHEMA_RESOLVER", this.schemaResolver);
                this.validatorErr.reset();
                this.validator.setError(this.validatorErr);
                if (this.schemaURL != null) {
                    URL uRL = BinXMLSchemaResolver.createURL(this.schemaURL);
                    BinXMLSchema binXMLSchema = this.schemaResolver.getSchema(uRL);
                    this.validator.setXMLSchema(binXMLSchema.getXMLSchema());
                    binXMLSchema.setValidator(this.validator);
                }
                return this.validator;
            }
            catch (XSDException xSDException) {
                throw new BinXMLException(xSDException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new BinXMLException(sAXException.getMessage());
            }
        }
        return this;
    }

    public ErrorHandler getErrorHandler() throws BinXMLException {
        return this;
    }

    public DTDHandler getDTDHandler() throws BinXMLException {
        return this;
    }

    public DeclHandler getDeclHandler() throws BinXMLException {
        return this;
    }

    public LexicalHandler getLexicalHandler() throws BinXMLException {
        return this;
    }

    public InfosetWriter createInfosetWriter() throws BinXMLException {
        return new BinXMLInfosetWriter(this);
    }

    private void validate() throws BinXMLException {
        if (this.validatorErr.getNumMessages() > 0) {
            int n = this.validatorErr.getFirstError();
            throw new BinXMLException(this.validatorErr.getMessage(n));
        }
    }

    BinXMLEncoderImpl(BinXMLStream binXMLStream) {
        this.elementStack = new Stack();
        this.binStream = (BinXMLStreamImpl)binXMLStream;
        this.page = this.binStream.getWriteBuffer();
        this.writer = new BinXMLPageWriter(this.page, this.binStream);
        this.binXMLProcessor = (BinXMLProcessorImpl)this.binStream.getBinXMLProcessor();
        this.tokenManager = this.binXMLProcessor.getTokenManager();
        this.vocabManager = this.binXMLProcessor.getVocabularyManager();
        if (this.binXMLProcessor.getDebugMode()) {
            File file = new File("encoder.log");
            try {
                this.debugWriter = new PrintWriter(new FileWriter(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            if (!this.dtd) {
                this.secState = new BinXMLSectionState(this.binStream);
                this.secState.encodeSectionHeader();
            }
            this.writer.writeOpcode((short)158);
            int n = this.encoding != null ? this.encoding.length() : 0;
            this.writer.writeByte((byte)n);
            short s = 1;
            if (this.standalone != null && this.standalone.equalsIgnoreCase("yes")) {
                s = (short)(s | 1);
                s = (short)(s | 0x10);
            }
            if (this.locator != null && this.locator instanceof Locator2) {
                this.xmlVersion = ((Locator2)this.locator).getXMLVersion();
            }
            if (this.xmlVersion == "1.1") {
                s = (short)(s | 0x1100);
                s = (short)(s | 8);
            }
            if (this.encoding != null) {
                s = (short)(s | 4);
            }
            this.writer.writeShort(s);
            if (this.encoding != null) {
                this.writer.writeString(this.encoding);
            }
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDocument", iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.secState.encodeSectionEnd();
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in endDocument", iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            short s;
            String string4;
            long l;
            String string5;
            String string6;
            String string7;
            String string8;
            int n;
            long l2;
            this.validate();
            boolean bl = false;
            BinXMLElement binXMLElement = null;
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            this.currentElem = new BinXMLElement();
            if (this.schemaAware) {
                this.currentElem.binSchema = this.schemaResolver.getCurrentSchema();
            }
            ++this.depth;
            if (this.depth > 1) {
                binXMLElement = (BinXMLElement)this.elementStack.peek();
            } else if (this.schemaAware) {
                this.writeSchemaScopeStart(this.currentElem.binSchema);
            }
            this.elementStack.push(this.currentElem);
            if (string.length() > 0) {
                l2 = this.tokenManager.getNamespaceTokenId(string);
                if (this.secState.addNamespaceId(new Long(l2))) {
                    this.encodeNamespace(l2, string);
                }
            } else {
                l2 = 7L;
            }
            if (this.schemaAware) {
                this.currentElem.prop = this.currentElem.binSchema.getCurrentProperty();
                if (this.currentElem.prop == null) {
                    this.currentElem.any = true;
                } else {
                    this.currentElem.kidNum = this.currentElem.prop.getKidNum();
                    if (this.currentElem.prop.isAnyElement() || this.currentElem.kidNum == -1) {
                        this.currentElem.any = true;
                    }
                }
            }
            if (!this.schemaAware) {
                BinXMLQNameToken binXMLQNameToken = this.tokenManager.getElementToken(string2, l2, string);
                if (binXMLQNameToken == null) {
                    binXMLQNameToken = this.tokenManager.putElement(string2, l2);
                    if (this.tokenManager.metaProvider != null && this.tokenManager.metaProvider instanceof DBBinXMLMetadataProvider || this.inlineTokenDefs) {
                        this.encodeToken(binXMLQNameToken, false);
                    }
                }
                this.currentElem.qnameId = binXMLQNameToken.getTokenId();
            }
            int n2 = attributes.getLength();
            short s2 = 0;
            boolean bl2 = false;
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                string8 = attributes.getLocalName(n);
                string7 = attributes.getURI(n);
                string6 = attributes.getValue(n);
                string5 = XMLUtil.getPrefix(attributes.getQName(n));
                if (this.schemaAware && string7.equals("http://www.w3.org/2001/XMLSchema-instance") && string8.equals("schemaLocation")) {
                    this.currentElem.binSchema = this.schemaResolver.getCurrentSchema();
                    continue;
                }
                if (this.schemaAware && this.currentElem.binSchema != null && string7.equals("http://www.w3.org/2001/XMLSchema-instance") && string8.equals("type")) {
                    bl2 = true;
                    continue;
                }
                if (!string5.equals("xmlns") && (string5.length() != 0 || !string8.equals("xmlns"))) continue;
                if (string8.length() > 255) {
                    throw new BinXMLException("Too long prefix.");
                }
                l = this.tokenManager.getNamespaceTokenId(string6);
                this.secState.addNamespaceId(new Long(l));
                s2 = string5.length() > 0 ? this.secState.insertPrefix(string8, string6) : this.secState.insertPrefix(null, string6);
                if (!this.inlineTokenDefs) continue;
                this.encodeNamespace(l, string6);
            }
            if (this.currentElem.prop != null && this.currentElem.prop.isSequential()) {
                this.currentElem.schemaSeqMode = true;
                this.currentElem.maxKidNum = this.currentElem.prop.getMaxKidNum();
            }
            if (!this.schemaAware || this.currentElem.prop == null || this.depth == 1 || this.currentElem.any || this.currentElem.prop.isSubstitutionGroupMember()) {
                if (this.currentElem.prop != null) {
                    this.currentElem.qnameId = 0xFFFFFFFFFFFFFFFFL & (long)(-this.currentElem.prop.getPropId());
                } else {
                    BinXMLQNameToken binXMLQNameToken = this.tokenManager.getElementToken(string2, l2, string);
                    if (binXMLQNameToken == null) {
                        binXMLQNameToken = this.tokenManager.putElement(string2, l2);
                        if (this.tokenManager.metaProvider != null && this.tokenManager.metaProvider instanceof DBBinXMLMetadataProvider || this.inlineTokenDefs) {
                            this.encodeToken(binXMLQNameToken, false);
                        }
                    }
                    this.currentElem.qnameId = binXMLQNameToken.getTokenId();
                }
            }
            n = 0;
            boolean bl3 = false;
            if (string.length() > 0 && (n = (int)this.secState.getPfxId(string4 = XMLUtil.getPrefix(string3), l2, false)) >= 0) {
                bl3 = true;
            }
            byte by = 0;
            if (bl3) {
                by = (byte)(by | 8);
            }
            if (bl2) {
                by = (byte)(by | 2);
            }
            if (this.currentElem.schemaSeqMode) {
                by = (byte)(by | 1);
            }
            if (binXMLElement != null) {
                if (binXMLElement.firstChild) {
                    binXMLElement.firstChild = false;
                    binXMLElement.kidNum = 0;
                } else if (!this.currentElem.any && this.currentElem.prop != null && this.currentElem.prop == binXMLElement.prevChildProp || this.currentElem.prop == null && this.currentElem.qnameId == binXMLElement.prevChildQnameId && by == binXMLElement.prevChildFlag && (!bl3 || n == binXMLElement.prevChildPfxId) && n3 == binXMLElement.prevChildTypeId) {
                    bl = true;
                    if (!binXMLElement.arrayMode) {
                        this.writer.writeOpcode((short)215);
                        binXMLElement.arrayMode = true;
                    }
                } else if (binXMLElement.arrayMode) {
                    this.writer.writeOpcode((short)216);
                    binXMLElement.arrayMode = false;
                }
                if (!binXMLElement.arrayMode) {
                    binXMLElement.prevChildQnameId = this.currentElem.qnameId;
                    binXMLElement.prevChildProp = this.currentElem.prop;
                    binXMLElement.prevChildFlag = by;
                    binXMLElement.prevChildPfxId = n;
                    binXMLElement.prevChildTypeId = n3;
                }
            }
            if (n2 == 0 && by == 0) {
                this.buffer = new BinXMLEncBuffer(this.currentElem.qnameId, bl3, bl, (short)n, by, bl2, n3);
                return;
            }
            boolean bl4 = false;
            if (bl) {
                this.writeELMST();
                bl4 = true;
            } else if (binXMLElement != null && binXMLElement.schemaSeqMode) {
                s = binXMLElement.maxKidNum;
                if (!(this.currentElem.any || this.currentElem.prop == null || this.currentElem.kidNum <= binXMLElement.kidNum || this.currentElem.kidNum > s || bl3 || bl2 || this.currentElem.prop.isSubstitutionGroupMember())) {
                    for (int i = 1; i < this.currentElem.kidNum - binXMLElement.kidNum; ++i) {
                        this.writer.writeOpcode((short)144);
                    }
                    this.writeELMST();
                    bl4 = true;
                    binXMLElement.kidNum = this.currentElem.kidNum;
                } else {
                    this.writer.writeOpcode((short)218);
                }
            }
            if (!bl4) {
                if (this.currentElem.prop != null && this.depth != 1 && !this.currentElem.any && !this.currentElem.prop.isSubstitutionGroupMember()) {
                    this.writeNodeStartKidnum(this.currentElem.kidNum, by, bl3, (short)n, bl2, n3);
                } else {
                    this.writeElementAttrStart(this.currentElem.qnameId, bl3, by, (short)n, bl2, n3);
                }
            }
            s = 0;
            BinXMLProperty binXMLProperty = null;
            for (int i = 0; i < n2; ++i) {
                string8 = attributes.getLocalName(i);
                string7 = attributes.getURI(i);
                string6 = attributes.getValue(i);
                string5 = XMLUtil.getPrefix(attributes.getQName(i));
                if (string5.equals("xmlns") || string5.length() == 0 && string8.equals("xmlns")) {
                    l = this.tokenManager.getNamespaceTokenId(string6);
                    s2 = string5.length() > 0 ? this.secState.getPfxId(string8, l, true) : this.secState.getPfxId("", l, true);
                    this.writer.writeOpcode((short)221);
                    this.writer.writeShort(s2);
                    continue;
                }
                if (this.schemaAware) {
                    binXMLProperty = this.currentElem.binSchema.getAttrProperty(string7, string8);
                }
                if (string7.length() > 0) {
                    l = this.tokenManager.getNamespaceTokenId(string7);
                    this.secState.addNamespaceId(new Long(l));
                    s2 = this.secState.getPfxId(string5, l, false);
                    s = s2 >= 0;
                } else {
                    l = 7L;
                    s = 0;
                }
                if (this.currentElem.schemaSeqMode) {
                    this.writer.writeOpcode((short)218);
                }
                if (binXMLProperty != null && !binXMLProperty.isAnyAttr()) {
                    this.writeNodeKidnum(s != 0, s2, false, 0, binXMLProperty.getKidNum(), (byte)0, this.currentElem.prop, binXMLProperty, string6);
                    continue;
                }
                BinXMLQNameToken binXMLQNameToken = this.tokenManager.getAttrToken(string8, l, string7);
                if (binXMLQNameToken == null) {
                    binXMLQNameToken = this.tokenManager.putAttr(string8, l);
                    if (this.tokenManager.metaProvider instanceof DBBinXMLMetadataProvider || this.inlineTokenDefs) {
                        this.encodeToken(binXMLQNameToken, true);
                    }
                } else if (this.inlineTokenDefs) {
                    this.encodeToken(binXMLQNameToken, true);
                }
                this.writeElementAttr(binXMLQNameToken.getTokenId(), s != 0, s2, string6, false, 0);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("Error in startElement", iOException);
        }
        catch (BinXMLException binXMLException) {
            throw new SAXException(binXMLException.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.buffer != null && (this.buffer.state == 2 || this.buffer.state == 3)) {
                this.buffer.state = (byte)4;
                this.buffer.flush();
            } else {
                if (this.currentElem.arrayMode) {
                    this.writer.writeOpcode((short)216);
                }
                this.writer.writeOpcode((short)217);
            }
        }
        catch (IOException iOException) {
            new SAXException("Error in endElement", iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException("Error in endElement", binXMLException);
        }
        --this.depth;
        this.currentElem = (BinXMLElement)this.elementStack.pop();
        this.currentElem = this.depth > 0 ? (BinXMLElement)this.elementStack.peek() : null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.validate();
            if (this.cdataDepth > 0) {
                if (this.buffer != null && this.buffer.state != 1) {
                    this.buffer.flush();
                }
                this.writeCDATA(new String(cArray, n, n2));
                return;
            }
            if (this.buffer != null && this.buffer.state == 2) {
                if (n2 <= 16383) {
                    this.buffer.state = (byte)3;
                    this.buffer.textdata = new String(cArray, n, n2);
                } else {
                    this.buffer.flush();
                    this.writeText(new String(cArray, n, n2));
                }
                return;
            }
            if (this.buffer != null && this.buffer.state == 3) {
                this.buffer.flush();
            }
            if (this.currentElem.arrayMode || this.currentElem.schemaSeqMode) {
                this.writeText(new String(cArray, n, n2));
            } else {
                if (this.buffer != null && this.buffer.state == 1) {
                    this.buffer.flush();
                }
                String string = new String(cArray, n, n2);
                this.writeSimpleNode(0L, null, null, (short)0, string, (byte)3);
            }
        }
        catch (IOException iOException) {
            new SAXException("Error in characters", iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException("Error in characters", binXMLException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            String string3;
            int n;
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            if ((n = (string3 = string.concat(string2)).length()) <= 255) {
                this.writer.writeOpcode((short)169);
                this.writer.writeByte((byte)n);
                this.writer.writeByte((byte)string.length());
            } else {
                this.writer.writeOpcode((short)170);
                this.writer.writeInt(n);
                this.writer.writeShort(string.length());
            }
            this.writer.writeString(string3);
        }
        catch (IOException iOException) {
            new SAXException("Error in processingInstruction", iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException("Error in processingInstruction", binXMLException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.writer.writeOpcode((short)154);
            int n = string != null ? string.length() : 0;
            int n2 = string2 != null ? string2.length() : 0;
            int n3 = string3 != null ? string3.length() : 0;
            this.writer.writeShort(n + n2 + n3);
            this.writeShortString(string);
            this.writeShortString(string2);
            this.writeShortString(string3);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDTD", iOException);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        try {
            this.writer.writeOpcode((short)152);
            int n = string != null ? string.length() : 0;
            int n2 = string2 != null ? string2.length() : 0;
            int n3 = string3 != null ? string3.length() : 0;
            int n4 = string4 != null ? string4.length() : 0;
            this.writer.writeShort(n + n2 + n3 + n4);
            this.writeShortString(string);
            this.writer.writeShort(0);
            this.writeShortString(string2);
            this.writeShortString(string3);
            this.writeShortString(string4);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDTD", iOException);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        try {
            this.writer.writeOpcode((short)151);
            int n = string != null ? string.length() : 0;
            int n2 = string2 != null ? string2.length() : 0;
            int n3 = string3 != null ? string3.length() : 0;
            int n4 = string4 != null ? string4.length() : 0;
            int n5 = string5 != null ? string5.length() : 0;
            this.writer.writeShort(n + n2 + n3 + n4 + n5);
            this.writeShortString(string);
            this.writeShortString(string2);
            this.writeShortString(string3);
            this.writeShortString(string4);
            this.writeShortString(string5);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDTD", iOException);
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        try {
            this.writer.writeOpcode((short)150);
            int n = string != null ? string.length() : 0;
            int n2 = string2 != null ? string2.length() : 0;
            this.writer.writeShort(n + n2);
            this.writeShortString(string);
            this.writeShortString(string2);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDTD", iOException);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.writer.writeOpcode((short)152);
            int n = string != null ? string.length() : 0;
            int n2 = string2 != null ? string2.length() : 0;
            int n3 = string3 != null ? string3.length() : 0;
            this.writer.writeShort(n + n2 + n3);
            this.writeShortString(string);
            this.writer.writeShort(0);
            this.writeShortString(string2);
            this.writeShortString(string3);
            this.writer.writeShort(0);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDTD", iOException);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        try {
            this.writer.writeOpcode((short)152);
            int n = string != null ? string.length() : 0;
            int n2 = string2 != null ? string2.length() : 0;
            this.writer.writeShort(n + n2);
            this.writeShortString(string);
            this.writeShortString(string2);
            this.writer.writeShort(0);
            this.writer.writeShort(0);
            this.writer.writeShort(0);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDTD", iOException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (n2 <= 255) {
                this.writer.writeOpcode((short)171);
                this.writer.writeByte((byte)n2);
            } else if (n2 <= 65535) {
                this.writer.writeOpcode((short)172);
                this.writer.writeShort(n2);
            } else {
                this.writer.writeOpcode((short)173);
                this.writer.writeLong8(n2);
            }
            this.writer.writeString(new String(cArray, n, n2));
        }
        catch (IOException iOException) {
            new SAXException("Error in comment", iOException);
        }
    }

    public void endCDATA() throws SAXException {
        --this.cdataDepth;
    }

    public void endDTD() throws SAXException {
        try {
            this.writer.writeOpcode((short)155);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in endDTD", iOException);
        }
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        try {
            this.validate();
            if (this.buffer.state != 1) {
                this.buffer.flush();
            }
        }
        catch (IOException iOException) {
            new SAXException("Error in startCDATA", iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException("Error in startCDATA", binXMLException);
        }
        ++this.cdataDepth;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        try {
            this.dtd = true;
            this.secState = new BinXMLSectionState(this.binStream);
            this.secState.encodeSectionHeader();
            this.writer.writeOpcode((short)149);
            int n = string != null ? string.length() : 0;
            int n2 = string2 != null ? string2.length() : 0;
            int n3 = string3 != null ? string3.length() : 0;
            this.writer.writeShort(n + n2 + n3);
            this.writeShortString(string);
            this.writeShortString(string2);
            this.writeShortString(string3);
        }
        catch (IOException iOException) {
            new SAXException("Error writing to CSX stream in startDTD", iOException);
        }
    }

    public void startEntity(String string) throws SAXException {
    }

    void writeELMST() throws IOException {
        if (this.currentElem.schemaSeqMode) {
            this.writer.writeOpcode((short)214);
        } else {
            this.writer.writeOpcode((short)213);
        }
    }

    void writeElementAttrStart(long l, boolean bl, int n, short s, boolean bl2, int n2) throws IOException {
        if (n == 0) {
            if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)201);
                this.writer.writeLong4(l);
            } else {
                this.writer.writeOpcode((short)202);
                this.writer.writeLong8(l);
            }
        } else if (!bl && !bl2) {
            if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)206);
                this.writer.writeLong4(l);
            } else {
                this.writer.writeOpcode((short)207);
                this.writer.writeLong8(l);
            }
            this.writer.writeByte(n);
        } else {
            if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)211);
                this.writer.writeByte(6);
                this.writer.writeLong4(l);
            } else {
                this.writer.writeOpcode((short)212);
                this.writer.writeByte(6);
                this.writer.writeLong8(l);
            }
            this.writer.writeByte(n);
            if (bl2) {
                this.writer.writeInt(n2);
            }
            if (bl) {
                this.writer.writeShort(s);
            }
        }
    }

    void writeElementAttr(long l, boolean bl, short s, String string, boolean bl2, int n) throws IOException, BinXMLException {
        long l2 = string.length();
        if (!bl && l2 <= 65535L) {
            this.writeSimpleNode(l, null, null, (short)0, string, (byte)1);
            return;
        }
        this.writeElementAttrStart(l, bl, bl ? 8 : 0, s, bl2, n);
        this.writeSimpleNode(0L, null, null, (short)0, string, (byte)3);
        this.writer.writeOpcode((short)217);
    }

    void writeNodeKidnum(boolean bl, short s, boolean bl2, int n, short s2, byte by, BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, String string) throws IOException, BinXMLException {
        long l = string.length();
        if (!bl && !bl2 && l <= 65535L) {
            this.writeSimpleNode(0L, binXMLProperty, binXMLProperty2, s2, string, (byte)4);
            return;
        }
        if (bl) {
            by = (byte)(by | 8);
        }
        if (bl2) {
            by = (byte)(by | 2);
        }
        this.writeNodeStartKidnum(s2, by, bl, s, bl2, n);
        this.writeSimpleNode(0L, binXMLProperty, binXMLProperty2, s2, string, (byte)3);
        this.writer.writeOpcode((short)217);
    }

    void writeNodeStartKidnum(short s, byte by, boolean bl, short s2, boolean bl2, int n) throws IOException {
        if (by == 0) {
            if (s <= 255) {
                this.writer.writeOpcode((short)198);
                this.writer.writeByte((byte)s);
            } else {
                this.writer.writeOpcode((short)199);
                this.writer.writeShort(s);
            }
        } else if (!bl && !bl2) {
            if (s <= 255) {
                this.writer.writeOpcode((short)203);
                this.writer.writeByte((byte)s);
                this.writer.writeByte(by);
            } else {
                this.writer.writeOpcode((short)204);
                this.writer.writeShort(s);
                this.writer.writeByte(by);
            }
        } else {
            int n2 = 6;
            if (bl) {
                n2 = (byte)(n2 + 2);
            }
            if (bl2) {
                n2 = (byte)(n2 + 4);
            }
            if (s <= 255) {
                this.writer.writeOpcode((short)208);
                this.writer.writeByte(n2);
                this.writer.writeByte((byte)s);
                this.writer.writeByte(by);
                if (bl2) {
                    this.writer.writeInt(n);
                }
                if (bl) {
                    this.writer.writeShort(s2);
                }
            } else {
                this.writer.writeOpcode((short)209);
                this.writer.writeByte(n2);
                this.writer.writeShort(s);
                this.writer.writeByte(by);
                if (bl2) {
                    this.writer.writeInt(n);
                }
                if (bl) {
                    this.writer.writeShort(s2);
                }
            }
        }
    }

    static int bindXMLTypeToEncodingType(int n) {
        return 1;
    }

    void writeSimpleNode(long l, BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, short s, String string, byte by) throws IOException, BinXMLException {
        byte[] byArray = null;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (binXMLProperty2 != null) {
            n2 = binXMLProperty2.getTypeId();
        }
        if (string != null && binXMLProperty2 != null && (n3 = BinXMLEncoderImpl.bindXMLTypeToEncodingType(n2)) != 1) {
            if (n2 != n3) {
                byArray = n3 == 13 ? this.convTextToQName(string, binXMLProperty2, this.secState) : this.convTextToCSX(string, n2, n3, binXMLProperty2);
            }
        } else {
            n3 = 1;
            if (string != null) {
                byArray = this.convTextToCSXString(string);
                l2 = byArray.length;
            }
        }
        n = n3 == 2 && l2 <= 32L || n3 != 2 && l2 <= 64L ? 1 : (l2 <= 16383L ? 2 : 8);
        switch (by) {
            case 2: 
            case 3: 
            case 5: {
                if (n == 1) break;
                if (n == 2) {
                    this.writer.writeOpcode((short)138);
                    break;
                }
                this.writer.writeOpcode((short)139);
                break;
            }
            case 4: {
                if (s <= 255) {
                    if (n == 1) {
                        this.writer.writeOpcode((short)188);
                        break;
                    }
                    if (n != 2) break;
                    this.writer.writeOpcode((short)189);
                    break;
                }
                if (n == 1) {
                    this.writer.writeOpcode((short)190);
                    break;
                }
                if (n != 2) break;
                this.writer.writeOpcode((short)191);
                break;
            }
            case 1: {
                if (l <= 0xFFFFFFFFL) {
                    if (n == 1) {
                        this.writer.writeOpcode((short)194);
                        break;
                    }
                    if (n != 2) break;
                    this.writer.writeOpcode((short)195);
                    break;
                }
                if (n == 1) {
                    this.writer.writeOpcode((short)196);
                    break;
                }
                if (n != 2) break;
                this.writer.writeOpcode((short)197);
                break;
            }
        }
        if (n == 1) {
            int n4 = 0;
            if (l2 == 0L) {
                n4 = 143;
            } else {
                block5 : switch (n3) {
                    case 12: {
                        if (l2 == 1L) {
                            n4 = 136;
                            break;
                        }
                        n4 = 137;
                        break;
                    }
                    case 1: {
                        n4 = (short)(0L + l2 - 1L);
                        break;
                    }
                    case 3: {
                        n4 = 134;
                        break;
                    }
                    case 7: {
                        if (l2 > 22L) {
                            throw new BinXMLException("Invalid Binary XML");
                        }
                        n4 = (short)(96L + l2 - 1L);
                        break;
                    }
                    case 2: {
                        n4 = (short)(64L + l2 - 1L);
                        break;
                    }
                    case 6: {
                        if (n2 == 6) {
                            if (l2 != 4L) {
                                throw new BinXMLException("Invalid Binary XML");
                            }
                            n4 = 125;
                            break;
                        }
                        if (n2 != 14) break;
                        if (l2 != 8L) {
                            throw new BinXMLException("Invalid Binary XML");
                        }
                        n4 = 126;
                        break;
                    }
                    case 4: {
                        switch (n2) {
                            case 15: {
                                if (l2 != 1L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                n4 = 117;
                                break block5;
                            }
                            case 16: {
                                if (l2 != 2L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                n4 = 118;
                                break block5;
                            }
                            case 4: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                n4 = (short)(117L + l2 / 2L);
                                break block5;
                            }
                            case 17: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L && l2 != 8L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                if (l2 != 8L) {
                                    n4 = (short)(117L + l2 / 2L);
                                    break block5;
                                }
                                n4 = 120;
                                break block5;
                            }
                        }
                        throw new BinXMLException(" Error while encoding, type not supported");
                    }
                    case 20: {
                        switch (n2) {
                            case 18: {
                                if (l2 != 1L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                n4 = 121;
                                break block5;
                            }
                            case 19: {
                                if (l2 != 2L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                n4 = 122;
                                break block5;
                            }
                            case 20: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                n4 = (short)(121L + l2 / 2L);
                                break block5;
                            }
                            case 21: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L && l2 != 8L) {
                                    throw new BinXMLException("Invalid Binary XML");
                                }
                                if (l2 != 8L) {
                                    n4 = (short)(121L + l2 / 2L);
                                    break block5;
                                }
                                n4 = 124;
                                break block5;
                            }
                        }
                        throw new BinXMLException(" Error while encoding, type not supported");
                    }
                    case 9: {
                        n4 = 132;
                        break;
                    }
                    case 8: {
                        n4 = 131;
                        break;
                    }
                    case 13: {
                        n4 = 135;
                        break;
                    }
                    default: {
                        throw new BinXMLException(" Error while encoding, type not supported");
                    }
                }
            }
            this.writer.writeOpcode((short)n4);
        } else if (l2 <= 16383L) {
            int n5 = (int)l2;
            this.writer.writeShort(n5 |= n3 == 1 ? 0 : 16384);
        } else {
            long l3 = l2;
            this.writer.writeLong8(l3 |= n3 == 1 ? 0L : 0x4000000000000000L);
        }
        switch (by) {
            case 4: {
                if (s <= 255) {
                    this.writer.writeByte(s);
                    break;
                }
                this.writer.writeShort(s);
                break;
            }
            case 1: {
                if (l <= 0xFFFFFFFFL) {
                    this.writer.writeLong4(l);
                    break;
                }
                this.writer.writeLong8(l);
                break;
            }
        }
        if (l2 > 0L) {
            this.writer.writeByteArray(byArray);
        }
    }

    void writeShortString(String string) throws SAXException {
        try {
            int n = string != null ? string.length() : 0;
            this.writer.writeShort(n);
            if (n != 0) {
                this.writer.writeString(string);
            }
        }
        catch (IOException iOException) {
            new SAXException("Error writing a string to CSX stream.", iOException);
        }
    }

    void writeText(String string) throws IOException {
        int n = string.length();
        if (n <= 255) {
            this.writer.writeOpcode((short)163);
            this.writer.writeByte((byte)n);
        } else if (n <= 65535) {
            this.writer.writeOpcode((short)164);
            this.writer.writeShort(n);
        } else {
            this.writer.writeOpcode((short)165);
            this.writer.writeLong8(n);
        }
        this.writer.writeString(string);
    }

    void writeCDATA(String string) throws IOException {
        int n = string.length();
        if (n <= 255) {
            this.writer.writeOpcode((short)166);
            this.writer.writeByte((byte)n);
        } else if (n <= 65535) {
            this.writer.writeOpcode((short)167);
            this.writer.writeShort(n);
        } else {
            this.writer.writeOpcode((short)168);
            this.writer.writeLong8(n);
        }
        this.writer.writeString(string);
    }

    void encodeSectionTokenSet(BinXMLSectionState binXMLSectionState, BinXMLStreamImpl binXMLStreamImpl) throws IOException, BinXMLException {
        BinXMLSectionState binXMLSectionState2 = new BinXMLSectionState(binXMLStreamImpl);
        byte[] byArray = binXMLStreamImpl.getWriteBuffer();
        binXMLSectionState2.encodeSectionHeader();
        Enumeration enumeration = binXMLSectionState.getNamespaceIdEnnumeration();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            this.encodeTokenSet(l, binXMLStreamImpl);
        }
        binXMLSectionState2.encodeSectionEnd();
        binXMLStreamImpl.flush();
    }

    void encodeNamespace(long l, String string) throws IOException, BinXMLException {
        int n = string.length();
        if (n >= 65535) {
            throw new BinXMLException("the namespace URL must be less than 65535 bytes");
        }
        if (n <= 255) {
            if (l < 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)174);
                this.writer.writeByte((byte)n);
                this.writer.writeInt((int)l);
            } else {
                this.writer.writeOpcode((short)176);
                this.writer.writeByte((byte)n);
                this.writer.writeLong8(l);
            }
        } else if (l < 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)175);
            this.writer.writeShort(n);
            this.writer.writeInt((int)l);
        } else {
            this.writer.writeOpcode((short)177);
            this.writer.writeShort(n);
            this.writer.writeLong8(l);
        }
        this.writer.writeString(string);
    }

    void encodeTokenSet(long l, BinXMLStreamImpl binXMLStreamImpl) throws IOException, BinXMLException {
        int n;
        BinXMLNamespaceToken binXMLNamespaceToken = this.tokenManager.getNamespaceToken(l);
        String string = binXMLNamespaceToken.getLocalName();
        if (string.length() <= 255) {
            this.writer.writeOpcode((short)174);
        } else {
            this.writer.writeOpcode((short)175);
        }
        BinXMLTokenList binXMLTokenList = this.tokenManager.getElementTokens(l);
        if (binXMLTokenList != null) {
            for (n = 0; n < binXMLTokenList.size(); ++n) {
                this.encodeToken((BinXMLQNameToken)binXMLTokenList.get(n), false);
            }
        }
        if ((binXMLTokenList = this.tokenManager.getAttrTokens(l)) != null) {
            for (n = 0; n < binXMLTokenList.size(); ++n) {
                this.encodeToken((BinXMLQNameToken)binXMLTokenList.get(n), true);
            }
        }
    }

    void encodeToken(BinXMLQNameToken binXMLQNameToken, boolean bl) throws IOException {
        String string = binXMLQNameToken.getLocalName();
        int n = string.length();
        long l = binXMLQNameToken.getTokenId();
        long l2 = binXMLQNameToken.getNamespaceId();
        if (n <= 255 && l <= 0xFFFFFFFFL && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)180);
            this.writer.writeByte((byte)n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong4(l);
            this.writer.writeLong4(l2);
        } else if (l <= 0xFFFFFFFFL && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)181);
            this.writer.writeShort(n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong4(l);
            this.writer.writeLong4(l2);
        } else if (n <= 255 && l <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)182);
            this.writer.writeByte((byte)n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong4(l);
            this.writer.writeLong8(l2);
        } else if (l <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)183);
            this.writer.writeShort(n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong4(l);
            this.writer.writeLong8(l2);
        } else if (n <= 255 && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)184);
            this.writer.writeByte((byte)n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong8(l);
            this.writer.writeLong4(l2);
        } else if (l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)185);
            this.writer.writeShort(n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong8(l);
            this.writer.writeLong4(l2);
        } else if (n <= 255) {
            this.writer.writeOpcode((short)186);
            this.writer.writeByte((byte)n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong8(l);
            this.writer.writeLong8(l2);
        } else {
            this.writer.writeOpcode((short)187);
            this.writer.writeShort(n);
            this.writer.writeBoolean(bl);
            this.writer.writeLong8(l);
            this.writer.writeLong8(l2);
        }
        this.writer.writeString(string);
    }

    private void writeSchemaScopeStart(BinXMLSchema binXMLSchema) throws IOException {
        byte[] byArray = binXMLSchema.getSchemaId().getVocabID();
        int n = binXMLSchema.getSchemaVer();
        if (n <= 255) {
            this.writer.writeOpcode((short)145);
            this.writer.writeByte(byArray.length);
            this.writer.writeByte(n);
        } else {
            this.writer.writeOpcode((short)146);
            this.writer.writeByte(byArray.length);
            this.writer.writeInt(n);
        }
        this.writer.writeByteArray(byArray);
    }

    byte[] convTextToQName(String string, BinXMLProperty binXMLProperty, BinXMLSectionState binXMLSectionState) {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(Character.getNumericValue(':'), 0);
        if (n > 0) {
            string2 = string.substring(n);
            string3 = string.substring(0, n - 1);
        }
        return null;
    }

    byte[] convTextToCSXString(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    byte[] convTextToCSX(String string, int n, int n2, BinXMLProperty binXMLProperty) throws BinXMLException {
        byte[] byArray = null;
        block4 : switch (n2) {
            case 12: {
                int n3 = binXMLProperty.getEnumID(string.trim());
                if (n3 < 255) {
                    byArray = new byte[]{(byte)n3};
                    break;
                }
                byArray = new byte[2];
                this.writer.copyInt2ToArray(n3, byArray, 0);
                break;
            }
            case 3: {
                byArray = new byte[1];
                boolean bl = Boolean.getBoolean(string);
                if (bl) {
                    byArray[0] = 1;
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 7: {
                int n4 = 0;
                if (string.trim().indexOf(46) >= 0) {
                    n4 = string.length() - 1 - string.indexOf(46);
                }
                try {
                    NUMBER nUMBER = new NUMBER(string, n4);
                    byArray = nUMBER.toBytes();
                }
                catch (SQLException sQLException) {
                    byArray = this.convTextToCSXString(string);
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 22: {
                        byArray = BinXMLUtil.convHexStringToBytes(string);
                        break block4;
                    }
                    case 23: {
                        byArray = BinXMLUtil.convBase64StringToBytes(string);
                        break block4;
                    }
                }
                throw new BinXMLException("Type conversion error while encoding");
            }
            case 6: {
                switch (n) {
                    case 6: {
                        int n5 = Float.floatToRawIntBits(Float.parseFloat(string));
                        byArray = new byte[4];
                        this.writer.copyInt4ToArray(n5, byArray, 0);
                        break block4;
                    }
                    case 14: {
                        long l = Double.doubleToRawLongBits(Double.parseDouble(string));
                        byArray = new byte[8];
                        this.writer.copyLong8ToArray(l, byArray, 0);
                        break block4;
                    }
                }
                new BinXMLException("Type conversion error while encoding");
                break;
            }
            case 4: 
            case 20: {
                switch (n) {
                    case 4: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        try {
                            int n6 = Integer.parseInt(string);
                            if (n6 < 255) {
                                byArray = new byte[]{(byte)n6};
                                break block4;
                            }
                            if (n6 < 65535) {
                                byArray = new byte[2];
                                this.writer.copyInt2ToArray(n6, byArray, 0);
                                break block4;
                            }
                            byArray = new byte[4];
                            this.writer.copyInt4ToArray(n6, byArray, 0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                long l = Long.parseLong(string);
                                byArray = new byte[8];
                                this.writer.copyLong8ToArray(l, byArray, 0);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                BigInteger bigInteger = new BigInteger(string);
                                byArray = bigInteger.toByteArray();
                            }
                        }
                        break block4;
                    }
                }
                throw new BinXMLException("Type conversion error while encoding");
            }
            case 9: {
                if (this.tokenManager.metaProvider == null || !(this.tokenManager.metaProvider instanceof DBBinXMLMetadataProviderImpl)) break;
                Connection connection = ((DBBinXMLMetadataProviderImpl)this.tokenManager.metaProvider).getConnection();
                try {
                    TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ(connection, string);
                    byArray = tIMESTAMPTZ.toBytes();
                }
                catch (SQLException sQLException) {
                    byArray = this.convTextToCSXString(string);
                }
                break;
            }
            default: {
                throw new BinXMLException("Type conversion error while encoding");
            }
        }
        return byArray;
    }

    void setXMLVersion(String string) {
        this.xmlVersion = string;
    }

    void setStandalone(String string) {
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    private class BinXMLSectionState {
        BinXMLStreamImpl binStream;
        Vector nsTokenIds;
        HashMap elemTokenIds;
        HashMap attrTokenIds;
        Vector prefixMap;
        short nextPfxId = 1;

        BinXMLSectionState(BinXMLStreamImpl binXMLStreamImpl) {
            this.binStream = binXMLStreamImpl;
        }

        void encodeSectionHeader() throws IOException {
            if (!BinXMLEncoderImpl.this.inlineTokenDefs) {
                this.nsTokenIds = new Vector(5);
            }
            byte by = 0;
            BinXMLEncoderImpl.this.writer.writeOpcode((short)159);
            BinXMLEncoderImpl.this.writer.writeByte(1);
            if (!BinXMLEncoderImpl.this.inlineTokenDefs) {
                by = (byte)(by | 1);
            }
            if (!BinXMLEncoderImpl.this.schemaAware) {
                by = (byte)(by | 2);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getGUID() != null) {
                by = (byte)(by | 4);
            }
            if (BinXMLEncoderImpl.this.docId != null) {
                by = (byte)(by | 8);
            }
            if (BinXMLEncoderImpl.this.standalone != null) {
                by = (byte)(by | 0x40);
                if (BinXMLEncoderImpl.this.standalone.equalsIgnoreCase("yes")) {
                    by = (byte)(by | 0x80);
                }
            }
            if (BinXMLEncoderImpl.this.encoding != null) {
                by = (byte)(by | 0x100);
            }
            BinXMLEncoderImpl.this.writer.writeByte(by);
            if (BinXMLEncoderImpl.this.docId != null) {
                BinXMLEncoderImpl.this.writer.writeByte((byte)BinXMLEncoderImpl.this.docId.length);
                BinXMLEncoderImpl.this.writer.writeByteArray(BinXMLEncoderImpl.this.docId);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getGUID() != null) {
                BinXMLEncoderImpl.this.writer.writeByteArray(BinXMLEncoderImpl.this.binXMLProcessor.getGUID());
            }
        }

        void encodeSectionEnd() throws IOException {
            if (BinXMLEncoderImpl.this.schemaAware) {
                BinXMLEncoderImpl.this.writer.writeOpcode((short)148);
            }
            BinXMLEncoderImpl.this.writer.writeOpcode((short)160);
            BinXMLEncoderImpl.this.writer.flushToStream();
        }

        boolean addNamespaceId(Long l) {
            if (!BinXMLEncoderImpl.this.inlineTokenDefs && !this.nsTokenIds.contains(l)) {
                this.nsTokenIds.add(l);
                return true;
            }
            return false;
        }

        Enumeration getNamespaceIdEnnumeration() {
            return this.nsTokenIds.elements();
        }

        boolean addElemToken(BinXMLQNameToken binXMLQNameToken) {
            Long l = new Long(binXMLQNameToken.getTokenId());
            if (this.elemTokenIds.get(l) != null) {
                return false;
            }
            this.elemTokenIds.put(l, binXMLQNameToken);
            return true;
        }

        short insertPrefix(String string, String string2) throws IOException, BinXMLException {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            if (string == null) {
                string = "";
            }
            long l = string2 == null ? 7L : BinXMLEncoderImpl.this.tokenManager.getNamespaceTokenId(string2);
            for (n = BinXMLEncoderImpl.this.depth; n > 0; --n) {
                if (this.prefixMap != null) {
                    for (int i = this.prefixMap.size() - 1; i >= 0; --i) {
                        BinXMLPrefix binXMLPrefix = (BinXMLPrefix)this.prefixMap.elementAt(i);
                        if (binXMLPrefix.nspid != l) continue;
                        if (binXMLPrefix.pfx.equals(string)) {
                            bl = true;
                            break;
                        }
                        bl2 = true;
                        if (i != BinXMLEncoderImpl.this.depth - 1) continue;
                        binXMLPrefix.dup = true;
                    }
                    if (!bl) continue;
                    break;
                }
                this.prefixMap = new Vector();
            }
            BinXMLPrefix binXMLPrefix = new BinXMLPrefix();
            binXMLPrefix.pfx = string;
            binXMLPrefix.nsuri = string2;
            binXMLPrefix.nspid = l;
            binXMLPrefix.dup = bl2;
            short s = this.nextPfxId;
            this.nextPfxId = (short)(s + 1);
            binXMLPrefix.pfxid = s;
            this.prefixMap.add(binXMLPrefix);
            binXMLPrefix.writePrefixDef();
            return binXMLPrefix.pfxid;
        }

        short getPfxId(String string, long l, boolean bl) {
            boolean bl2 = false;
            if (l == 1L) {
                return -1;
            }
            if (this.prefixMap == null) {
                return -1;
            }
            for (int i = this.prefixMap.size() - 1; i >= 0; --i) {
                BinXMLPrefix binXMLPrefix = (BinXMLPrefix)this.prefixMap.elementAt(i);
                if (binXMLPrefix.nspid != l) continue;
                if (!binXMLPrefix.dup && !bl) {
                    return -1;
                }
                if (binXMLPrefix.pfx.equals(string)) {
                    return binXMLPrefix.pfxid;
                }
                bl2 = true;
            }
            return -1;
        }

        short getPfxId(String string, String string2, boolean bl) {
            return -1;
        }
    }

    private class BinXMLPrefix {
        String pfx;
        String nsuri;
        long nspid;
        short pfxid;
        boolean dup;

        private BinXMLPrefix() {
        }

        private void writePrefixDef() throws IOException {
            boolean bl = this.nspid <= 0xFFFFFFFFL;
            BinXMLEncoderImpl.this.writer.writeOpcode(bl ? (short)178 : 179);
            BinXMLEncoderImpl.this.writer.writeByte(this.pfx.length());
            if (bl) {
                BinXMLEncoderImpl.this.writer.writeLong4(this.nspid);
            } else {
                BinXMLEncoderImpl.this.writer.writeLong8(this.nspid);
            }
            BinXMLEncoderImpl.this.writer.writeShort(this.pfxid);
            if (this.pfx.length() > 0) {
                BinXMLEncoderImpl.this.writer.writeString(this.pfx);
            }
        }
    }

    private class BinXMLEncBuffer {
        byte state = (byte)2;
        long qnameid;
        boolean needpfxid;
        boolean arrayMode;
        short pfxid;
        byte flag;
        boolean needtypeid;
        int xsitypeid;
        String textdata;

        BinXMLEncBuffer(long l, boolean bl, boolean bl2, short s, byte by, boolean bl3, int n) {
            this.qnameid = l;
            this.flag = by;
            this.needpfxid = bl;
            this.pfxid = s;
            this.arrayMode = bl2;
            this.needtypeid = bl3;
            this.xsitypeid = n;
        }

        void flush() throws IOException, BinXMLException {
            BinXMLElement binXMLElement = (BinXMLElement)BinXMLEncoderImpl.this.elementStack.peek();
            BinXMLProperty binXMLProperty = binXMLElement.prop;
            BinXMLElement binXMLElement2 = null;
            if (BinXMLEncoderImpl.this.depth > 1) {
                binXMLElement2 = (BinXMLElement)BinXMLEncoderImpl.this.elementStack.get(BinXMLEncoderImpl.this.depth - 2);
            }
            switch (this.state) {
                case 1: {
                    return;
                }
                case 2: 
                case 3: {
                    boolean bl = false;
                    if (this.arrayMode) {
                        BinXMLEncoderImpl.this.writeELMST();
                        bl = true;
                    } else if (binXMLElement2 != null && binXMLElement2.schemaSeqMode) {
                        short s = binXMLElement2.maxKidNum;
                        if (!(binXMLElement.any || binXMLProperty == null || binXMLElement.kidNum <= binXMLElement2.kidNum || binXMLElement.kidNum > s || this.needpfxid || this.needtypeid || binXMLElement.prop.isSubstitutionGroupMember())) {
                            for (int i = 1; i < binXMLElement.kidNum - binXMLElement2.kidNum; ++i) {
                                BinXMLEncoderImpl.this.writer.writeOpcode((short)144);
                            }
                            BinXMLEncoderImpl.this.writeELMST();
                            bl = true;
                            binXMLElement2.kidNum = binXMLElement.kidNum;
                            break;
                        }
                        BinXMLEncoderImpl.this.writer.writeOpcode((short)218);
                    }
                    if (!bl) {
                        if (binXMLProperty != null && BinXMLEncoderImpl.this.depth != 1 && !binXMLElement.any && !binXMLProperty.isSubstitutionGroupMember()) {
                            BinXMLEncoderImpl.this.writeNodeStartKidnum(BinXMLEncoderImpl.this.currentElem.kidNum, this.flag, this.needpfxid, this.pfxid, this.needtypeid, this.xsitypeid);
                        } else {
                            BinXMLEncoderImpl.this.writeElementAttrStart(this.qnameid, this.needpfxid, this.flag, this.pfxid, this.needtypeid, this.xsitypeid);
                        }
                    }
                    if (this.state != 3) break;
                    BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2 != null ? binXMLElement2.prop : null, binXMLProperty, BinXMLEncoderImpl.this.currentElem.kidNum, this.textdata, (byte)3);
                    this.textdata = null;
                    break;
                }
                case 4: {
                    if (this.arrayMode) {
                        BinXMLEncoderImpl.this.writeSimpleNode(0L, null, null, (short)0, this.textdata, (byte)2);
                        break;
                    }
                    if (binXMLElement2 != null && binXMLElement2.schemaSeqMode) {
                        short s = binXMLElement2.maxKidNum;
                        if (!(binXMLElement.any || binXMLElement.prop == null || binXMLElement.kidNum <= binXMLElement2.kidNum || binXMLElement.kidNum > s || this.needpfxid || this.needtypeid || binXMLElement.prop.isSubstitutionGroupMember())) {
                            for (int i = 1; i < binXMLElement.kidNum - binXMLElement2.kidNum; ++i) {
                                BinXMLEncoderImpl.this.writer.writeOpcode((short)144);
                            }
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2.prop, binXMLElement.prop, binXMLElement.kidNum, this.textdata, (byte)5);
                            binXMLElement2.kidNum = binXMLElement.kidNum;
                            break;
                        }
                        BinXMLEncoderImpl.this.writer.writeOpcode((short)218);
                        if (binXMLElement.prop != null && BinXMLEncoderImpl.this.depth != 1 && !binXMLElement.any && !binXMLElement.prop.isSubstitutionGroupMember()) {
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2.prop, binXMLElement.prop, binXMLElement.kidNum, this.textdata, (byte)4);
                        } else {
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, null, null, (short)0, this.textdata, (byte)1);
                        }
                        this.textdata = null;
                        break;
                    }
                    BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, null, null, (short)0, this.textdata, (byte)1);
                }
            }
            this.state = 1;
        }
    }

    private class BinXMLElement {
        long qnameId;
        BinXMLSchema binSchema;
        BinXMLProperty prop;
        boolean any;
        boolean arrayMode = false;
        boolean firstChild = true;
        long prevChildQnameId;
        BinXMLProperty prevChildProp;
        byte prevChildFlag;
        short prevChildPfxId;
        int prevChildTypeId;
        boolean schemaSeqMode = false;
        short kidNum = 0;
        short maxKidNum;
    }

    private class BinXMLPageWriter {
        byte[] buf;
        BinXMLStreamImpl bstream;
        int writePos;

        BinXMLPageWriter(byte[] byArray, BinXMLStreamImpl binXMLStreamImpl) {
            this.buf = byArray;
            this.bstream = binXMLStreamImpl;
            this.writePos = 0;
        }

        void flushToStream() throws IOException {
            this.bstream.flushWriBuffer(this.writePos);
        }

        void flushByte(byte by) throws IOException {
            if (this.writePos == BinaryStream.BUFSIZE) {
                this.bstream.flushWriBuffer();
                this.writePos = 0;
            }
            this.buf[this.writePos++] = by;
        }

        void writeByte(int n) throws IOException {
            this.flushByte((byte)(n & 0xFF));
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeBoolean(boolean bl) throws IOException {
            this.flushByte((byte)(bl ? 1 : 0));
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + bl);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeShort(int n) throws IOException {
            this.flushByte((byte)(n >>> 8 & 0xFF));
            this.flushByte((byte)(n >>> 0 & 0xFF));
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeOpcode(short s) throws IOException {
            if (s < 255) {
                this.flushByte((byte)s);
            } else {
                this.flushByte((byte)(s >>> 8 & 0xFF));
                this.flushByte((byte)(s >>> 0 & 0xFF));
            }
            BinXMLOpcode binXMLOpcode = BinXMLFormat.opcodes[s];
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println(binXMLOpcode.name);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeByteArray(byte[] byArray) throws IOException {
            for (int i = 0; i < byArray.length; ++i) {
                this.flushByte(byArray[i]);
            }
        }

        void writeInt(int n) throws IOException {
            this.flushByte((byte)(n >>> 24 & 0xFF));
            this.flushByte((byte)(n >>> 16 & 0xFF));
            this.flushByte((byte)(n >>> 8 & 0xFF));
            this.flushByte((byte)(n >>> 0 & 0xFF));
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeLong4(long l) throws IOException {
            byte[] byArray = new byte[4];
            this.copyLong4ToArray(l, byArray, 0);
            this.writeByteArray(byArray);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + l);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeLong8(long l) throws IOException {
            byte[] byArray = new byte[8];
            this.copyLong8ToArray(l, byArray, 0);
            this.writeByteArray(byArray);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + l);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeString(String string) throws IOException {
            byte[] byArray = string.getBytes("UTF-8");
            this.writeByteArray(byArray);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + string);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void copyByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
            while (n2 > 0) {
                byArray2[n3++] = byArray[n++];
                --n2;
            }
        }

        void copyInt2ToArray(int n, byte[] byArray, int n2) {
            byArray[n2 + 1] = (byte)(n & 0xFF);
            byArray[n2] = (byte)((n >>= 8) & 0xFF);
        }

        void copyInt4ToArray(int n, byte[] byArray, int n2) {
            n2 += 3;
            byArray[n2--] = (byte)(n & 0xFF);
            byArray[n2--] = (byte)((n >>= 8) & 0xFF);
            byArray[n2--] = (byte)((n >>= 8) & 0xFF);
            byArray[n2] = (byte)((n >>= 8) & 0xFF);
        }

        void copyLong4ToArray(long l, byte[] byArray, int n) {
            n += 3;
            byArray[n--] = (byte)(l & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n] = (byte)((l >>= 8) & 0xFFL);
        }

        void copyLong8ToArray(long l, byte[] byArray, int n) {
            n += 7;
            byArray[n--] = (byte)(l & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n] = (byte)((l >>= 8) & 0xFFL);
        }
    }
}

