/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLDecodeReader;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.QxNameHash;

public class BinXMLInfosetReader
extends BinXMLDecodeReader
implements InfosetReader {
    BinXMLInfosetReader(BinXMLStreamImpl binXMLStreamImpl, BinXMLDecoderImpl binXMLDecoderImpl) throws BinXMLException {
        super(binXMLStreamImpl, binXMLDecoderImpl);
    }

    BinXMLInfosetReader(BinXMLStreamImpl binXMLStreamImpl) throws BinXMLException {
        super(binXMLStreamImpl, null);
    }

    public InfosetReader.Offset getOffset() {
        short s;
        BinXMLDecodeReader.DecodeElem decodeElem;
        Locator locator = null;
        if (this.event == 4 || this.elemStack.size() < 2) {
            decodeElem = this.elemStack.peek();
            if (this.state == 3) {
                decodeElem = this.elemStack.get(this.elemStack.size() - 2);
                s = decodeElem.isArrMode() ? (short)6 : (decodeElem.isSeqMode() ? (short)7 : 8);
            } else if (this.prevSibling != null) {
                switch (decodeElem.flags & 0xF) {
                    case 0: {
                        s = 9;
                        break;
                    }
                    case 2: {
                        s = 10;
                        break;
                    }
                    default: {
                        s = decodeElem.flags;
                        break;
                    }
                }
            } else {
                s = decodeElem.flags;
            }
        } else {
            decodeElem = this.elemStack.get(this.elemStack.size() - 2);
            s = decodeElem.flags;
        }
        switch (s & 0xF) {
            case 0: {
                locator = new Locator(s, this.eventMark);
                break;
            }
            case 1: {
                locator = new LocatorArray(s, this.eventMark, this.curElem.id);
                break;
            }
            case 2: {
                locator = new LocatorSchema(s, this.eventMark, decodeElem.id, this.oldKidnum, (byte)this.getSchemaId(this.schema));
                break;
            }
            case 3: {
                locator = new LocatorArraySchema(s, this.eventMark, this.curElem.id, decodeElem.id, this.oldKidnum, (byte)this.getSchemaId(this.schema));
                break;
            }
            case 6: {
                locator = new LocatorArray(s, this.eventMark, this.curElem.id);
                break;
            }
            case 7: {
                locator = new LocatorSchema(s, this.eventMark, decodeElem.id, this.oldKidnum, (byte)this.getSchemaId(this.schema));
                break;
            }
            case 8: {
                locator = new Locator(s, this.eventMark);
                break;
            }
            case 9: {
                locator = new LocatorArray(s, this.eventMark, this.curElem.id);
                break;
            }
            case 10: {
                locator = new LocatorArraySchema(s, this.eventMark, this.curElem.id, decodeElem.id, this.oldKidnum, (byte)this.getSchemaId(this.schema));
            }
        }
        if (this.schema != null) {
            locator.schid = (byte)this.getSchemaId(this.schema);
        }
        if (decodeElem.streamId != this.curStream.id && this.state != 3) {
            locator.streamId = decodeElem.streamId;
            locator.flags = (short)(locator.flags | 4);
        }
        if (this.printLocator) {
            System.out.print("getOffset - ");
            locator.print();
        }
        return locator;
    }

    public void seek(InfosetReader.Offset offset) {
        BinXMLDecodeReader.PrefixInfo prefixInfo = null;
        String string = null;
        Locator locator = (Locator)offset;
        if (locator == null) {
            return;
        }
        if (this.printLocator) {
            System.out.print("seek - ");
            locator.print();
        }
        try {
            this.resetSimple();
            if (locator.schid >= 0) {
                this.schema = this.getSchema(locator.schid);
                this.pushSchema(this.schema);
            }
            switch (locator.flags & 0xF) {
                case 0: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    this.curElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(this.curElem);
                    break;
                }
                case 1: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArray locatorArray = (LocatorArray)locator;
                    BinXMLDecodeReader.NodeProperty nodeProperty = this.schema != null ? this.getNodeProperty(locatorArray.qnameid) : this.getNodeProperty(locatorArray.qnameid);
                    if (nodeProperty.nsid != 0L) {
                        prefixInfo = this.getPrefixInfo(nodeProperty.nsid);
                        string = prefixInfo.prefix;
                    }
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem();
                    decodeElem.setArrMode(true);
                    this.pushElem(decodeElem);
                    this.curElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorArray.qnameid, nodeProperty.prop);
                    break;
                }
                case 2: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorSchema locatorSchema = (LocatorSchema)locator;
                    BinXMLDecodeReader.NodeProperty nodeProperty = this.getNodeProperty(locatorSchema.propid);
                    if (nodeProperty.nsid != 0L) {
                        prefixInfo = this.getPrefixInfo(nodeProperty.nsid);
                        string = prefixInfo.prefix;
                    }
                    this.curElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorSchema.propid, nodeProperty.prop);
                    this.curElem.kidnum = locatorSchema.kidnum;
                    this.curElem.setSeqMode(true);
                    this.pushElem(this.curElem);
                    BinXMLDecodeReader.DecodeElem decodeElem = this.curElem;
                    break;
                }
                case 3: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArraySchema locatorArraySchema = (LocatorArraySchema)locator;
                    BinXMLDecodeReader.NodeProperty nodeProperty = this.getNodeProperty(locatorArraySchema.propid);
                    if (nodeProperty.nsid != 0L) {
                        prefixInfo = this.getPrefixInfo(nodeProperty.nsid);
                        string = prefixInfo.prefix;
                    }
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorArraySchema.propid, nodeProperty.prop);
                    decodeElem.kidnum = locatorArraySchema.kidnum;
                    decodeElem.setArrMode(true);
                    decodeElem.setSeqMode(true);
                    this.pushElem(decodeElem);
                    nodeProperty = this.getNodeProperty(locatorArraySchema.qnameid);
                    if (nodeProperty.nsid != 0L) {
                        string = this.getPrefix(nodeProperty.nsid);
                    }
                    this.curElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorArraySchema.qnameid, nodeProperty.prop);
                    break;
                }
                case 4: {
                    this.pushStreamParentMark(locator.streamId, locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    this.curElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(this.curElem);
                    this.pushStreamMark(locator.mark);
                    if (this.curStream.locator == null) break;
                    String[] stringArray = this.curStream.locator.split(",");
                    switch (stringArray[0].charAt(0)) {
                        case 'A': {
                            this.locId = Long.parseLong(stringArray[2]);
                            this.curElem.setArrMode(true);
                            break;
                        }
                        case 'S': {
                            this.vocabId.setVocabID(stringArray[3].getBytes());
                            this.schema = this.vocabMngr.getBinXMLSchema(this.vocabId);
                            this.addSchema(this.schema);
                            this.pushSchema(this.schema);
                            this.locId = Long.parseLong(stringArray[2]);
                            break;
                        }
                        case 'T': {
                            this.locId = 1L;
                            break;
                        }
                        case 'E': {
                            this.locId = 0L;
                        }
                    }
                    break;
                }
                case 6: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArray locatorArray = (LocatorArray)locator;
                    BinXMLDecodeReader.NodeProperty nodeProperty = this.getNodeProperty(locatorArray.qnameid);
                    if (nodeProperty.nsid != 0L) {
                        prefixInfo = this.getPrefixInfo(nodeProperty.nsid);
                        string = prefixInfo.prefix;
                    }
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem();
                    decodeElem.setArrMode(true);
                    this.pushElem(decodeElem);
                    this.curElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorArray.qnameid, nodeProperty.prop);
                    this.getNext();
                    break;
                }
                case 7: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorSchema locatorSchema = (LocatorSchema)locator;
                    BinXMLDecodeReader.NodeProperty nodeProperty = this.getNodeProperty(locatorSchema.propid);
                    if (nodeProperty.nsid != 0L) {
                        prefixInfo = this.getPrefixInfo(nodeProperty.nsid);
                        string = prefixInfo.prefix;
                    }
                    this.curElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorSchema.propid, nodeProperty.prop);
                    this.curElem.setSeqMode(true);
                    this.curElem.kidnum = locatorSchema.kidnum;
                    this.pushElem(this.curElem);
                    BinXMLDecodeReader.DecodeElem decodeElem = this.curElem;
                    this.getNext();
                    break;
                }
                case 8: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(decodeElem);
                    this.getNext();
                    break;
                }
                case 9: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArray locatorArray = (LocatorArray)locator;
                    BinXMLDecodeReader.NodeProperty nodeProperty = this.getNodeProperty(locatorArray.qnameid);
                    if (nodeProperty.nsid != 0L) {
                        prefixInfo = this.getPrefixInfo(nodeProperty.nsid);
                        string = prefixInfo.prefix;
                    }
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(decodeElem);
                    this.prevSibling = this.curElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorArray.qnameid, nodeProperty.prop);
                    break;
                }
                case 10: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    LocatorArraySchema locatorArraySchema = (LocatorArraySchema)locator;
                    BinXMLDecodeReader.NodeProperty nodeProperty = this.getNodeProperty(locatorArraySchema.propid);
                    if (nodeProperty.nsid != 0L) {
                        prefixInfo = this.getPrefixInfo(nodeProperty.nsid);
                        string = prefixInfo.prefix;
                    }
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorArraySchema.propid, nodeProperty.prop);
                    decodeElem.kidnum = locatorArraySchema.kidnum;
                    decodeElem.setSeqMode(true);
                    this.pushElem(decodeElem);
                    nodeProperty = this.getNodeProperty(locatorArraySchema.qnameid);
                    if (nodeProperty.nsid != 0L) {
                        string = this.getPrefix(nodeProperty.nsid);
                    }
                    this.prevSibling = this.curElem = new BinXMLDecodeReader.DecodeElem(nodeProperty.uri, nodeProperty.local, string, nodeProperty.nsid, locatorArraySchema.qnameid, nodeProperty.prop);
                    break;
                }
                default: {
                    this.pushStreamMark(locator.mark);
                    this.copyPrefixTable(this.nsStack);
                    BinXMLDecodeReader.DecodeElem decodeElem = new BinXMLDecodeReader.DecodeElem();
                    this.pushElem(decodeElem);
                }
            }
            this.mark = locator.mark;
            if (prefixInfo != null) {
                this.pushNamespace(prefixInfo);
            }
            this.event = this.getNextEvent();
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
    }

    public boolean hasNext() {
        if (this.event == 8 || this.state == 3) {
            return false;
        }
        try {
            short s = this.nextByte();
            if (s == 217 || s == 160) {
                return false;
            }
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
        return true;
    }

    public void next() {
        try {
            this.event = this.getNextEvent();
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
    }

    public void skip() {
        try {
            this.skipNode();
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
        }
    }

    public int getEventType() {
        return this.event;
    }

    public QName getQName() {
        switch (this.event) {
            case 3: {
                return QxNameHash.create("", this.piTarget, "");
            }
            case 1: 
            case 2: {
                return QxNameHash.create(this.curElem.getURI(), this.curElem.getLocal(), this.curElem.getPrefix());
            }
        }
        return QxNameHash.create("", "", "");
    }

    public String getNamespaceURI(String string) {
        return this.curElem.uri;
    }

    public String getPrefix(String string) {
        return this.curElem.prefix;
    }

    public TypedAttributes getAttributes() {
        return this.attrlist;
    }

    public String getAttribute(QName qName) {
        return null;
    }

    public String getValue() {
        try {
            switch (this.event) {
                case 4: {
                    return this.getEventText();
                }
                case 3: 
                case 5: 
                case 12: {
                    return this.value;
                }
            }
            return null;
        }
        catch (BinXMLException binXMLException) {
            return null;
        }
    }

    public char[] getData() {
        try {
            String string = this.getEventText();
            return string.toCharArray();
        }
        catch (BinXMLException binXMLException) {
            return null;
        }
    }

    public int getDataStart() {
        return 0;
    }

    public int getDataLength() {
        return (int)this.datalen;
    }

    public boolean isNSResolutionSupported() {
        return false;
    }

    public boolean isSeekSupported() {
        return true;
    }

    public byte offsetToBytes(InfosetReader.Offset offset, byte[] byArray, int n) {
        return 0;
    }

    public InfosetReader.Offset offsetFromBytes(byte[] byArray, int n) {
        return null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public DTD getDoctype() {
        return null;
    }

    public QName getTypeName() {
        return null;
    }

    public int getPrimitiveTypeId() {
        return 0;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    public int getEventFlags() {
        return 0;
    }

    public void close() {
    }

    public Object clone() {
        return null;
    }

    public String getLocator() {
        return this.getlocator();
    }

    protected class LocatorArraySchema
    extends Locator {
        long qnameid;
        long propid;
        short kidnum;
        byte schid;

        LocatorArraySchema(short s, int n, long l, long l2, short s2, byte by) {
            super(s, n);
            this.qnameid = l;
            this.propid = l2;
            this.kidnum = s2;
            this.schid = by;
        }

        public void print() {
            System.out.println("LocatorArraySchema(" + this.flags + ", " + this.qnameid + ") at " + this.mark);
        }
    }

    protected class LocatorSchema
    extends Locator {
        long propid;
        short kidnum;

        LocatorSchema(short s, int n, long l, short s2, byte by) {
            super(s, n);
            this.propid = l;
            this.kidnum = s2;
            this.schid = by;
        }

        public void print() {
            System.out.println("LocatorSchema(" + this.flags + ", " + this.propid + ") at " + this.mark);
        }
    }

    protected class LocatorArray
    extends Locator {
        long qnameid;

        LocatorArray(short s, int n, long l) {
            super(s, n);
            this.qnameid = l;
        }

        public void print() {
            System.out.println("LocatorArray(" + this.flags + ", " + this.qnameid + ") at " + this.mark);
        }
    }

    protected class Locator
    implements InfosetReader.Offset {
        short flags;
        int mark;
        byte schid;
        byte streamId = (byte)-1;

        Locator(short s, int n) {
            this.flags = s;
            this.mark = n;
            this.schid = (byte)-1;
        }

        public int compareTo(Object object) {
            Locator locator = (Locator)object;
            return this.mark == locator.mark ? 0 : (this.mark < locator.mark ? -1 : 1);
        }

        public void print() {
            System.out.println("Locator(" + this.flags + ") at " + this.mark);
        }
    }
}

