/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLEncoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.scalable.StreamWriter;
import oracle.xml.util.QxName;
import org.xml.sax.SAXException;

class BinXMLInfosetWriter
extends StreamWriter
implements InfosetWriter {
    BinXMLEncoderImpl encoder;
    DTD dtd;
    QxName qname;
    QxName typename;
    boolean global;
    boolean nilled;
    byte event;
    int typeid;
    int flags;
    String curValue;
    SAXAttrList attrlist;
    Stack tags;

    BinXMLInfosetWriter(BinXMLEncoderImpl binXMLEncoderImpl) throws BinXMLException {
        this.encoder = binXMLEncoderImpl;
        this.attrlist = new SAXAttrList(100);
        this.tags = new Stack();
    }

    public void close() {
    }

    public void setVersion(String string) {
        this.encoder.setXMLVersion(string);
    }

    public void setEncoding(String string) {
        this.encoder.setEncoding(string);
    }

    public void setStandalone(String string) {
        this.encoder.setStandalone(string);
    }

    public void setDoctype(DTD dTD) {
        this.dtd = dTD;
    }

    public void setQName(QName qName) {
        this.qname = (QxName)qName;
    }

    public void setTypeName(QName qName) {
        this.typename = (QxName)qName;
    }

    public void setPrimitiveTypeId(int n) {
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    public void setNilled(boolean bl) {
        this.nilled = bl;
    }

    public void setAttributes(TypedAttributes typedAttributes) {
        this.attrlist = (SAXAttrList)typedAttributes;
    }

    public void setAttribute(QName qName, String string) {
        this.setQName(qName);
        this.setValue(string);
    }

    public void setValue(String string) {
        if (string == null) {
            this.curValue = "";
        }
        this.curValue = string;
    }

    public void setData(char[] cArray, int n, int n2) {
        this.curValue = new String(cArray, n, n2);
    }

    public void setEventFlags(int n) {
    }

    public void createEvent(int n) {
        this.event = (byte)n;
    }

    public void save() {
        try {
            char[] cArray = null;
            switch (this.event) {
                case 1: {
                    this.tags.push(this.qname);
                    this.encoder.startElement(this.qname.getNamespaceURI(), this.qname.getLocalPart(), this.qname.getQName(), this.attrlist);
                    break;
                }
                case 2: {
                    this.qname = (QxName)this.tags.pop();
                    this.encoder.endElement(this.qname.getNamespaceURI(), this.qname.getLocalPart(), this.qname.getQName());
                    break;
                }
                case 3: {
                    this.encoder.processingInstruction(this.qname.getQName(), this.curValue);
                    break;
                }
                case 4: 
                case 6: {
                    cArray = this.curValue.toCharArray();
                    this.encoder.characters(cArray, 0, cArray.length);
                    break;
                }
                case 7: {
                    this.encoder.startDocument();
                    break;
                }
                case 10: {
                    break;
                }
                case 12: {
                    this.encoder.startCDATA();
                    cArray = this.curValue.toCharArray();
                    this.encoder.characters(cArray, 0, cArray.length);
                    this.encoder.endCDATA();
                    break;
                }
                case 5: {
                    cArray = this.curValue.toCharArray();
                    this.encoder.comment(cArray, 0, cArray.length);
                    break;
                }
                case 9: 
                case 14: {
                    this.encoder.startEntity(this.qname.getQName());
                    break;
                }
                case 15: {
                    this.encoder.endEntity(this.qname.getQName());
                    break;
                }
                case 8: {
                    this.encoder.endDocument();
                    break;
                }
                case 11: {
                    if (this.dtd != null) {
                        this.dtd.writeNodeInfo(this, true, false);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        catch (SAXException sAXException) {
            RuntimeException runtimeException = new RuntimeException(sAXException.getMessage());
            runtimeException.initCause(sAXException);
            throw runtimeException;
        }
    }
}

