/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;

public class BinXMLProperty
implements XSDConstantValues {
    boolean sequential = false;
    int typeId;
    int propId;
    int csxencodingtypeid;
    int xtypecode;
    QName qname;
    short maxkidnum = 0;
    XSDNode xnode;
    XSDComplexType typenode;
    int phashcode;
    int hashcode;
    Vector enums;
    BinXMLSchema bxschema;
    static final int BIN_XML_PROPERTY_ELEMENT = 1;
    static final int BIN_XML_PROPERTY_ATTRIBUTE = 2;
    static final int BIN_XML_PROPERTY_COMPLEX_TYPE = 4;
    static final int BIN_XML_PROPERTY_SIMPLE_TYPE = 8;

    BinXMLProperty() {
    }

    void setBinXMLSchema(BinXMLSchema binXMLSchema) {
        this.bxschema = binXMLSchema;
    }

    BinXMLSchema getBinXMLSchema() {
        return this.bxschema;
    }

    void setXSDTypeCode(int n) {
        this.xtypecode = n;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    void setIsSequential(boolean bl) {
        this.sequential = bl;
    }

    public int getTypeId() {
        return this.typeId;
    }

    void setTypeId(int n) {
        this.typeId = n;
    }

    void setCSXEncodingType(int n) {
        this.csxencodingtypeid = n;
    }

    public int getCSXEncodingType() {
        return this.csxencodingtypeid;
    }

    void setTypeNode(XSDComplexType xSDComplexType) {
        this.typenode = xSDComplexType;
    }

    XSDComplexType getTypeNode() {
        return this.typenode;
    }

    public QName getQName() {
        return this.qname;
    }

    void setQName(QName qName) {
        this.qname = qName;
    }

    void setPropId(int n) {
        this.propId = n;
    }

    public int getPropId() {
        return this.propId;
    }

    boolean isSubstitutionGroupMember() {
        if (!(this.xnode instanceof XSDElement)) {
            return false;
        }
        XMLElement xMLElement = this.xnode.getDomNode();
        Attr attr = xMLElement.getAttributeNodeNS("", "substitutionGroup");
        return attr != null;
    }

    boolean isAnyAttr() {
        return this.qname.getLocalPart().equals("anyAttribute") && this.qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema");
    }

    boolean isAnyElement() {
        return this.xnode instanceof XSDAny;
    }

    boolean isAttribute() {
        return this.xtypecode == 2;
    }

    boolean isElement() {
        return this.xtypecode == 1;
    }

    boolean isSimpleType() {
        return this.xtypecode == 8;
    }

    boolean isComplexType() {
        return this.xtypecode == 4;
    }

    XSDNode getXSDNode() {
        return this.xnode;
    }

    void setXSDNode(XSDNode xSDNode) {
        this.xnode = xSDNode;
        this.enums = this.generateEnumerationVector();
    }

    public int getHashCode() {
        return this.hashcode;
    }

    void setHashCode(int n) {
        this.hashcode = n;
    }

    void setParentHashCode(int n) {
        this.phashcode = n;
    }

    public int getParentHashCode() {
        return this.phashcode;
    }

    int getEnumID(XSDDataValue xSDDataValue) {
        if (this.enums == null) {
            return -1;
        }
        for (int i = 0; i < this.enums.size(); ++i) {
            XSDDataValue xSDDataValue2 = (XSDDataValue)this.enums.get(i);
            if (xSDDataValue2 != xSDDataValue) continue;
            return i;
        }
        return -1;
    }

    int getEnumID(String string) {
        if (this.enums == null) {
            return -1;
        }
        for (int i = 0; i < this.enums.size(); ++i) {
            XSDDataValue xSDDataValue = (XSDDataValue)this.enums.get(i);
            if (!xSDDataValue.getLexicalValue().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public short getKidNum() {
        XSDElement xSDElement = this.bxschema.getValidator().getElementDeclaration();
        XSDElement xSDElement2 = this.bxschema.getValidator().getParentDeclaration();
        BinXMLProperty binXMLProperty = this.bxschema.getBinXMLPropertyFromXSDNode(xSDElement);
        if (this.xtypecode == 1) {
            if (xSDElement2 == null) {
                return -1;
            }
            BinXMLProperty binXMLProperty2 = this.bxschema.getBinXMLPropertyFromXSDNode(xSDElement2);
            return this.bxschema.getKidNum(binXMLProperty2, binXMLProperty);
        }
        if (this.xtypecode == 2) {
            return this.bxschema.getKidNum(this.phashcode, this.hashcode, binXMLProperty);
        }
        return -1;
    }

    public short getMaxKidNum() {
        if (this.maxkidnum != 0) {
            return this.maxkidnum;
        }
        if (this.bxschema == null || this.bxschema.getValidator() == null) {
            return Short.MAX_VALUE;
        }
        XSDElement xSDElement = this.bxschema.getValidator().getElementDeclaration();
        if (xSDElement == null) {
            return 0;
        }
        BinXMLProperty binXMLProperty = this.bxschema.getBinXMLPropertyFromXSDNode(xSDElement);
        Hashtable hashtable = this.bxschema.getParentKids();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (n.intValue() != binXMLProperty.getHashCode()) continue;
            Vector vector = (Vector)hashtable.get(n);
            this.maxkidnum = (short)vector.size();
            return this.maxkidnum;
        }
        return 0;
    }

    private Vector generateEnumerationVector() {
        Vector vector = null;
        int n = this.xnode.getNodeType();
        switch (n) {
            case 3: {
                XSDElement xSDElement = (XSDElement)this.xnode;
                vector = xSDElement.getEnumeratedValues();
                break;
            }
            case 4: {
                XSDAttribute xSDAttribute = (XSDAttribute)this.xnode;
                XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAttribute.getType();
                vector = xSDSimpleType.getEnumeration();
                break;
            }
            case 2: {
                XSDSimpleType xSDSimpleType = (XSDSimpleType)this.xnode;
                vector = xSDSimpleType.getEnumeration();
                break;
            }
            case 1: {
                XSDComplexType xSDComplexType = (XSDComplexType)this.xnode;
                if (!xSDComplexType.isSimpleContent()) break;
                XSDSimpleType xSDSimpleType = xSDComplexType.getSimpleType();
                vector = xSDSimpleType.getEnumeration();
                break;
            }
        }
        return vector;
    }
}

