/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.parser.schema.CSXConstants;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class BinXMLSchemaAnnotator
implements XSDConstantValues,
CSXConstants {
    URL schemaurl;
    Reader reader;
    XMLDocument root = null;
    BinXMLProperty rootprop = null;
    String rootprefix;
    int propId = 0;
    int typeId = 101;
    private static int DEFAULT_COMPLEX_TYPE_ID = 47;
    private static int UNDEFINED_COMPLEX_TYPE_ID = -99;
    BinXMLSchema bxschema;

    BinXMLSchemaAnnotator() {
    }

    void setBinXMLSchema(BinXMLSchema binXMLSchema) {
        this.bxschema = binXMLSchema;
    }

    void setSchemaURL(URL uRL) {
        this.schemaurl = uRL;
    }

    void setSchemaReader(Reader reader) {
        this.reader = reader;
    }

    void init() {
        this.propId = 0;
        this.typeId = 101;
    }

    void reset() {
        this.propId = 0;
        this.typeId = 101;
    }

    XMLDocument processBinXMLSchemaAnnotations() throws XSDException {
        int n;
        XMLSchemaNode[] xMLSchemaNodeArray = this.getSchemaNodes();
        if (xMLSchemaNodeArray == null) {
            return null;
        }
        for (n = 0; n < xMLSchemaNodeArray.length; ++n) {
            this.processSimpleTypeSet(xMLSchemaNodeArray[n], -1);
        }
        for (n = 0; n < xMLSchemaNodeArray.length; ++n) {
            this.processAttributeDecls(xMLSchemaNodeArray[n], true, -1);
        }
        for (n = 0; n < xMLSchemaNodeArray.length; ++n) {
            this.processElementSet(xMLSchemaNodeArray[n], true, -1);
        }
        for (n = 0; n < xMLSchemaNodeArray.length; ++n) {
            this.processComplexTypeSet(xMLSchemaNodeArray[n], -1);
        }
        this.postProcessTypeIds();
        return this.root;
    }

    private void postProcessTypeIds() {
        Vector vector = this.bxschema.getBinXMLProperties();
        for (int i = 0; i < vector.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)vector.get(i);
            if (binXMLProperty.getTypeId() != UNDEFINED_COMPLEX_TYPE_ID) continue;
            XSDComplexType xSDComplexType = binXMLProperty.getTypeNode();
            BinXMLProperty binXMLProperty2 = this.bxschema.getBinXMLPropertyFromXSDNode(xSDComplexType);
            binXMLProperty.setTypeId(binXMLProperty2.getTypeId());
            binXMLProperty.setTypeNode(null);
        }
    }

    private int getAssociatedType(XMLElement xMLElement, XSDNode xSDNode, BinXMLProperty binXMLProperty) {
        XSDNode xSDNode2;
        String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "encodingType");
        if (string != null && string.length() > 0) {
            QxName qxName = QxNameHash.create("http://www.w3.org/2001/XMLSchema", string, "", string);
            return XSDSimpleType.getBuiltInTypeId(qxName);
        }
        int n = xSDNode.getNodeType();
        switch (n) {
            case 3: {
                xSDNode2 = ((XSDElement)xSDNode).getType();
                break;
            }
            case 4: {
                xSDNode2 = ((XSDAttribute)xSDNode).getType();
                break;
            }
            default: {
                return -1;
            }
        }
        n = xSDNode2.getNodeType();
        switch (n) {
            case 1: {
                String string2 = xSDNode2.getName();
                if (string2 == null) {
                    return -1;
                }
                binXMLProperty.setTypeNode((XSDComplexType)xSDNode2);
                return UNDEFINED_COMPLEX_TYPE_ID;
            }
            case 2: {
                boolean bl = xSDNode2.isBuiltInDataType();
                if (bl) {
                    return XSDSimpleType.getBuiltInTypeId(xSDNode2.getQName());
                }
                String string3 = xSDNode2.getName();
                if (string3 == null) {
                    return -1;
                }
                BinXMLProperty binXMLProperty2 = this.bxschema.getBinXMLPropertyFromXSDNode(xSDNode2);
                return binXMLProperty2.getTypeId();
            }
        }
        return -1;
    }

    private int generateCSXEncodingTypeID(XMLElement xMLElement) {
        NodeList nodeList = xMLElement.getElementsByTagNameNS("http://xmlns.oracle.com/2004/CSX", "encodingType");
        if (nodeList == null || nodeList.getLength() == 0) {
            return -1;
        }
        if (nodeList.getLength() > 1) {
            return -1;
        }
        XMLElement xMLElement2 = (XMLElement)nodeList.item(0);
        String string = xMLElement2.getText();
        for (int i = 0; i < BinXMLConstants.ENCODING_TYPES.length; ++i) {
            if (!BinXMLConstants.ENCODING_TYPES[i].equals(string)) continue;
            return i + 1;
        }
        return -1;
    }

    private int processUserDefinedAnnotations(XSDNode xSDNode) {
        int n = -1;
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        if (xSDAnnotation == null) {
            return n;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null || vector.size() == 0) {
            return n;
        }
        for (int i = 0; i < vector.size(); ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            if (n != -1) continue;
            n = this.generateCSXEncodingTypeID(xMLElement);
        }
        return n;
    }

    private BinXMLProperty createProperty(XSDNode xSDNode, boolean bl, int n) {
        int n2 = xSDNode.getNodeType();
        QName qName = xSDNode.getQName();
        XMLElement xMLElement = xSDNode.getDomNode();
        int n3 = xMLElement.hashCode();
        BinXMLProperty binXMLProperty = null;
        int n4 = -1;
        int n5 = this.processUserDefinedAnnotations(xSDNode);
        switch (n2) {
            case 3: {
                n4 = ((XSDElement)xSDNode).getRefState();
                binXMLProperty = this.bxschema.locateDefinedProperty(n4, qName, 3);
                if (binXMLProperty != null) {
                    this.bxschema.putProperty(n, binXMLProperty.getHashCode(), this.root);
                    return binXMLProperty;
                }
                binXMLProperty = new BinXMLProperty();
                String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "propertyID");
                if (string != null && string.length() > 0) {
                    Integer n6 = new Integer(string);
                    binXMLProperty.setPropId(n6);
                } else {
                    binXMLProperty.setPropId(++this.typeId);
                }
                binXMLProperty.setQName(qName);
                xMLElement.setAttributeNS("http://xmlns.oracle.com/2004/CSX", "csx:propertyID", new Integer(this.propId).toString());
                if (bl) {
                    binXMLProperty.setParentHashCode(-1);
                } else {
                    binXMLProperty.setParentHashCode(n);
                }
                binXMLProperty.setTypeId(this.getAssociatedType(xMLElement, xSDNode, binXMLProperty));
                binXMLProperty.setHashCode(n3);
                binXMLProperty.setXSDNode(xSDNode);
                binXMLProperty.setXSDTypeCode(1);
                binXMLProperty.setCSXEncodingType(n5);
                binXMLProperty.setIsSequential(true);
                this.bxschema.putProperty(binXMLProperty, this.root, 1);
                return binXMLProperty;
            }
            case 4: {
                n4 = ((XSDAttribute)xSDNode).getRefState();
                binXMLProperty = this.bxschema.locateDefinedProperty(n4, qName, 4);
                if (binXMLProperty != null) {
                    return binXMLProperty;
                }
                binXMLProperty = new BinXMLProperty();
                String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "propertyID");
                if (string != null && string.length() > 0) {
                    Integer n7 = new Integer(string);
                    binXMLProperty.setPropId(n7);
                } else {
                    binXMLProperty.setPropId(++this.typeId);
                }
                binXMLProperty.setQName(qName);
                xMLElement.setAttributeNS("http://xmlns.oracle.com/2004/CSX", "csx:propertyID", new Integer(this.propId).toString());
                if (bl) {
                    binXMLProperty.setParentHashCode(-1);
                } else {
                    binXMLProperty.setParentHashCode(n);
                }
                binXMLProperty.setHashCode(n3);
                binXMLProperty.setTypeId(this.getAssociatedType(xMLElement, xSDNode, binXMLProperty));
                binXMLProperty.setCSXEncodingType(n5);
                binXMLProperty.setXSDNode(xSDNode);
                binXMLProperty.setXSDTypeCode(2);
                this.bxschema.putProperty(binXMLProperty, this.root, 2);
                return binXMLProperty;
            }
            case 1: {
                binXMLProperty = new BinXMLProperty();
                String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "typeID");
                if (string != null && string.length() > 0) {
                    Integer n8 = new Integer(string);
                    binXMLProperty.setTypeId(n8);
                } else {
                    binXMLProperty.setTypeId(++this.typeId);
                }
                binXMLProperty.setCSXEncodingType(n5);
                binXMLProperty.setQName(qName);
                xMLElement.setAttributeNS("http://xmlns.oracle.com/2004/CSX", "csx:typeID", new Integer(this.typeId).toString());
                binXMLProperty.setParentHashCode(-1);
                binXMLProperty.setHashCode(n3);
                binXMLProperty.setXSDNode(xSDNode);
                binXMLProperty.setXSDTypeCode(4);
                this.bxschema.putProperty(binXMLProperty, this.root, 4);
                return binXMLProperty;
            }
            case 2: {
                binXMLProperty = new BinXMLProperty();
                String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "typeID");
                if (string != null && string.length() > 0) {
                    Integer n9 = new Integer(string);
                    binXMLProperty.setTypeId(n9);
                } else {
                    binXMLProperty.setTypeId(++this.typeId);
                }
                binXMLProperty.setCSXEncodingType(n5);
                binXMLProperty.setQName(qName);
                xMLElement.setAttributeNS("http://xmlns.oracle.com/2004/CSX", "csx:typeID", new Integer(this.typeId).toString());
                binXMLProperty.setParentHashCode(-1);
                binXMLProperty.setHashCode(n3);
                binXMLProperty.setXSDNode(xSDNode);
                binXMLProperty.setXSDTypeCode(8);
                this.bxschema.putProperty(binXMLProperty, this.root, 8);
                return binXMLProperty;
            }
        }
        return binXMLProperty;
    }

    private XMLSchemaNode[] getSchemaNodes() throws XSDException {
        XSDBuilder xSDBuilder = new XSDBuilder();
        XMLSchema xMLSchema = this.reader != null ? xSDBuilder.build(this.reader, this.schemaurl) : xSDBuilder.build(this.schemaurl);
        this.bxschema.setXMLSchema(xMLSchema);
        String[] stringArray = xMLSchema.getAllTargetNS();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray.length;
        XMLSchemaNode[] xMLSchemaNodeArray = new XMLSchemaNode[n];
        for (int i = 0; i < n; ++i) {
            xMLSchemaNodeArray[i] = xMLSchema.getSchemaByTargetNS(stringArray[i]);
        }
        return xMLSchemaNodeArray;
    }

    private void processElementSet(XMLSchemaNode xMLSchemaNode, boolean bl, int n) {
        XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return;
        }
        this.processXSDElementNodes(xSDNodeArray, bl, n);
    }

    private void processComplexTypeSet(XMLSchemaNode xMLSchemaNode, int n) throws XSDException {
        XSDNode[] xSDNodeArray = xMLSchemaNode.getComplexTypeSet();
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return;
        }
        this.processXSDComplexTypeNodes(xSDNodeArray, n);
    }

    private boolean isBuiltinSimpleType(XSDSimpleType xSDSimpleType) {
        if (xSDSimpleType.getDomNode() == null) {
            return true;
        }
        XSDSimpleType[] xSDSimpleTypeArray = XSDSimpleType.getBuiltInArray();
        for (int i = 0; i < xSDSimpleTypeArray.length; ++i) {
            if (xSDSimpleTypeArray[i] != xSDSimpleType) continue;
            return true;
        }
        return false;
    }

    private void processAttributeDecls(XSDNode xSDNode, boolean bl, int n) {
        if (!(xSDNode instanceof XMLSchemaNode || xSDNode instanceof XSDComplexType || xSDNode instanceof XSDElement)) {
            return;
        }
        XSDAttribute[] xSDAttributeArray = null;
        if (xSDNode instanceof XMLSchemaNode) {
            xSDAttributeArray = ((XMLSchemaNode)xSDNode).getAttributeDeclarations();
        } else if (xSDNode instanceof XSDComplexType) {
            xSDAttributeArray = ((XSDComplexType)xSDNode).getAttributeDeclarations();
        } else if (xSDNode instanceof XSDElement) {
            xSDAttributeArray = ((XSDElement)xSDNode).getAttributeDeclarations();
        }
        if (xSDAttributeArray == null || xSDAttributeArray.length == 0) {
            return;
        }
        this.processXSDAttributeNodes(xSDAttributeArray, bl, n);
    }

    private void processSimpleTypeSet(XMLSchemaNode xMLSchemaNode, int n) {
        XSDNode[] xSDNodeArray = xMLSchemaNode.getSimpleTypeSet();
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return;
        }
        this.processXSDSimpleTypeNodes(xSDNodeArray, n);
    }

    private void processXSDNode(XSDNode xSDNode) {
        int n = xSDNode.getNodeType();
        switch (n) {
            case 1: {
                this.processXSDComplexTypeNode((XSDComplexType)xSDNode);
            }
            case 3: {
                this.processXSDElementNode((XSDElement)xSDNode);
            }
        }
    }

    private int getRefParentHashCode(XSDElement xSDElement) {
        int n = xSDElement.getRefState();
        BinXMLProperty binXMLProperty = this.bxschema.locateDefinedProperty(n, xSDElement.getQName(), 3);
        if (binXMLProperty != null) {
            return binXMLProperty.getHashCode();
        }
        return xSDElement.getDomNode().hashCode();
    }

    private void processXSDElementNode(XSDElement xSDElement) {
        int n = xSDElement.getContent();
        if (this.bxschema.getDebugMode()) {
            this.printDOMNode(xSDElement);
        }
        this.root = this.getRootNode(xSDElement);
        this.processAttributeDecls(xSDElement, false, this.getRefParentHashCode(xSDElement));
        switch (n) {
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                XSDNode[] xSDNodeArray = xSDElement.getChildElements();
                if (xSDNodeArray == null) break;
                this.processXSDElementNodes(xSDNodeArray, false, this.getRefParentHashCode(xSDElement));
                break;
            }
        }
    }

    private void processXSDAttributeNode(XSDAttribute xSDAttribute, boolean bl, int n) {
        this.createProperty(xSDAttribute, bl, n);
    }

    private void processXSDSimpleTypeNode(XSDSimpleType xSDSimpleType, int n) {
        this.createProperty(xSDSimpleType, true, n);
    }

    private boolean processXSDComplexTypeNode(XSDComplexType xSDComplexType) {
        this.processAttributeDecls(xSDComplexType, false, xSDComplexType.getDomNode().hashCode());
        XSDGroup xSDGroup = xSDComplexType.getTypeGroup();
        if (xSDGroup == null) {
            return false;
        }
        Vector vector = xSDGroup.getNodeVector();
        if (vector == null || vector.size() == 0) {
            return false;
        }
        int n = xSDGroup.getOrder();
        int n2 = xSDGroup.getMaxOccurs();
        if (n2 > 1) {
            return false;
        }
        switch (n) {
            case 0: 
            case 1: {
                Object object;
                int n3;
                int n4 = vector.size();
                for (n3 = 0; n3 < n4 && (object = (XSDNode)vector.get(n3)) instanceof XSDElement; ++n3) {
                }
                if (n3 == n4) {
                    object = this.bxschema.getHashCodeFromXSDNode(xSDComplexType);
                    XMLElement xMLElement = this.bxschema.putNotationRoot(this.root, xSDComplexType, (Integer)object);
                    for (int i = 0; i < n4; ++i) {
                        BinXMLProperty binXMLProperty = this.bxschema.getBinXMLPropertyFromXSDNode((XSDNode)vector.get(i));
                        if (binXMLProperty == null) {
                            binXMLProperty = this.createProperty((XSDNode)vector.get(i), false, (Integer)object);
                        }
                        this.bxschema.insertKidsNotationNode(binXMLProperty, xMLElement, this.root);
                    }
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.processXSDElementNode((XSDElement)vector.get(n3));
                    }
                } else {
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.processXSDNode((XSDNode)vector.get(n3));
                    }
                }
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    private void processXSDElementNodes(XSDNode[] xSDNodeArray, boolean bl, int n) {
        int n2;
        if (this.bxschema.getDebugMode()) {
            for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
                System.out.println(xSDNodeArray[n2].getName());
            }
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            if (xSDNodeArray[n2] instanceof XSDAny) continue;
            this.createProperty((XSDElement)xSDNodeArray[n2], bl, n);
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            if (xSDNodeArray[n2] instanceof XSDAny) continue;
            this.processXSDElementNode((XSDElement)xSDNodeArray[n2]);
        }
    }

    private void processXSDAttributeNodes(XSDAttribute[] xSDAttributeArray, boolean bl, int n) {
        int n2;
        if (this.bxschema.getDebugMode()) {
            for (n2 = 0; n2 < xSDAttributeArray.length; ++n2) {
                System.out.println(xSDAttributeArray[n2].getName());
            }
        }
        for (n2 = 0; n2 < xSDAttributeArray.length; ++n2) {
            this.processXSDAttributeNode(xSDAttributeArray[n2], bl, n);
        }
    }

    private void processXSDComplexTypeNodes(XSDNode[] xSDNodeArray, int n) {
        int n2;
        if (this.bxschema.getDebugMode()) {
            for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
                System.out.println(xSDNodeArray[n2].getName());
            }
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            this.createProperty((XSDComplexType)xSDNodeArray[n2], true, n);
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            boolean bl = this.processXSDComplexTypeNode((XSDComplexType)xSDNodeArray[n2]);
            BinXMLProperty binXMLProperty = this.bxschema.getBinXMLPropertyFromXSDNode((XSDComplexType)xSDNodeArray[n2]);
            binXMLProperty.setIsSequential(bl);
        }
    }

    private void processXSDSimpleTypeNodes(XSDNode[] xSDNodeArray, int n) {
        for (int i = 0; i < xSDNodeArray.length; ++i) {
            if (this.isBuiltinSimpleType((XSDSimpleType)xSDNodeArray[i])) continue;
            this.processXSDSimpleTypeNode((XSDSimpleType)xSDNodeArray[i], n);
        }
    }

    private XMLDocument getRootNode(XSDElement xSDElement) {
        if (this.root != null) {
            return this.root;
        }
        Node node = xSDElement.getDomNode();
        while (!(node instanceof XMLDocument)) {
            node = node.getParentNode();
        }
        this.root = (XMLDocument)node;
        this.setRootPrefix(this.root);
        this.generateRootElementProperty();
        this.bxschema.setRootElemProperty(this.rootprop);
        return this.root;
    }

    String getRootPrefix() {
        return this.rootprefix;
    }

    private void setRootPrefix(XMLDocument xMLDocument) {
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        this.rootprefix = xMLElement.getPrefix();
        this.bxschema.setRootPrefix(this.rootprefix);
    }

    private void generateRootElementProperty() {
        XMLElement xMLElement = (XMLElement)this.root.getDocumentElement();
        QxName qxName = xMLElement.getQName();
        this.rootprop = new BinXMLProperty();
        this.rootprop.setXSDTypeCode(1);
        this.rootprop.setIsSequential(false);
        this.rootprop.setPropId(0);
        this.rootprop.setTypeId(0);
        this.rootprop.setQName(qxName);
    }

    private void printDOMNode(XSDNode xSDNode) {
        XMLElement xMLElement = xSDNode.getDomNode();
        if (xMLElement == null) {
            System.out.println(xSDNode.getName());
            return;
        }
        try {
            xMLElement.print(System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printDOMNode(XSDComplexType xSDComplexType) {
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!");
        XMLElement xMLElement = xSDComplexType.getDomNode();
        try {
            xMLElement.print(System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!");
        XMLElement xMLElement2 = (XMLElement)xMLElement.getParentNode();
        try {
            xMLElement2.print(System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!");
        XMLDocument xMLDocument = (XMLDocument)xMLElement2.getParentNode();
        try {
            xMLDocument.print(System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

