/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.parser.schema.SchemaResolver;
import oracle.xml.parser.schema.XMLSchema;

class BinXMLSchemaResolver
implements SchemaResolver {
    BinXMLVocabularyManager vocabManager;
    BinXMLSchema currentBinSchema;

    BinXMLSchemaResolver(BinXMLVocabularyManager binXMLVocabularyManager) {
        this.vocabManager = binXMLVocabularyManager;
    }

    public XMLSchema resolve(String string, QName qName) {
        URL uRL = null;
        if (string != null) {
            uRL = BinXMLSchemaResolver.createURL(string);
            this.currentBinSchema = this.vocabManager.getBinXMLSchema(uRL);
        }
        if (this.currentBinSchema == null && qName != null) {
            this.currentBinSchema = this.vocabManager.getBinXMLSchema(qName);
        }
        if (this.currentBinSchema == null && string != null) {
            try {
                BinXMLVocabId binXMLVocabId = this.vocabManager.registerSchema(uRL);
                this.currentBinSchema = this.vocabManager.getBinXMLSchema(binXMLVocabId);
            }
            catch (BinXMLException binXMLException) {
                return null;
            }
        }
        if (this.currentBinSchema != null) {
            return this.currentBinSchema.getXMLSchema();
        }
        return null;
    }

    BinXMLSchema getSchema(URL uRL) {
        if (uRL != null) {
            this.currentBinSchema = this.vocabManager.getBinXMLSchema(uRL);
        }
        if (this.currentBinSchema == null && uRL != null) {
            try {
                BinXMLVocabId binXMLVocabId = this.vocabManager.registerSchema(uRL);
                this.currentBinSchema = this.vocabManager.getBinXMLSchema(binXMLVocabId);
            }
            catch (BinXMLException binXMLException) {
                return null;
            }
        }
        return this.currentBinSchema;
    }

    BinXMLSchema getCurrentSchema() {
        return this.currentBinSchema;
    }

    static URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }
}

