/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.CharArrayReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.xdb.XMLType;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.DBBinXMLMetadataProvider;

class DBBinXMLMetadataProviderImpl
implements DBBinXMLMetadataProvider {
    Connection metaconn = null;
    Connection dataconn = null;
    Driver driver;
    HashMap map = new HashMap(1);
    Class cls = null;

    DBBinXMLMetadataProviderImpl() throws BinXMLException {
        try {
            this.cls = Class.forName("oracle.xdb.XMLTypeFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BinXMLException("oracle.xdb.XMLTypeFactory class not found");
        }
        this.map.put("SYS.XMLTYPE", this.cls);
    }

    public void setConnection(Connection connection) throws BinXMLException, SQLException {
        this.metaconn = connection;
        this.metaconn.setTypeMap(this.map);
    }

    public void setConnectionPool(OracleDataSource oracleDataSource) throws BinXMLException, SQLException {
        if (oracleDataSource instanceof OracleOCIConnectionPool) {
            Properties properties = oracleDataSource.getConnectionProperties();
            if (properties == null) {
                properties = new Properties();
            }
            properties.put(OracleOCIConnectionPool.CONNPOOL_INCREMENT, "0");
            properties.put(OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT, "2");
            properties.put(OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT, "1");
            oracleDataSource.setConnectionProperties(properties);
        }
        this.metaconn = oracleDataSource.getConnection();
        this.metaconn.setTypeMap(this.map);
    }

    public void setDriver(Driver driver) {
        this.driver = driver == null ? new OracleDriver() : driver;
    }

    public void setURL(URL uRL, String string, String string2) throws BinXMLException, SQLException {
        String string3 = uRL.getHost();
        String string4 = "";
        if (uRL.getPort() > 0) {
            string4 = new Integer(uRL.getPort()).toString();
        }
        String string5 = uRL.getPath();
        String string6 = string3;
        if (string4.length() > 0) {
            string6 = string6 + ":" + string4;
        }
        if (string5 != null) {
            string6 = string6 + "/" + string5;
        }
        if (this.driver == null) {
            DriverManager.registerDriver((Driver)new OracleDriver());
        } else {
            DriverManager.registerDriver(this.driver);
        }
        this.metaconn = DriverManager.getConnection(string6, string, string2);
        this.metaconn.setTypeMap(this.map);
    }

    public void setConnStr(String string, String string2, String string3) throws BinXMLException, SQLException {
        if (this.driver == null) {
            DriverManager.registerDriver((Driver)new OracleDriver());
        } else {
            DriverManager.registerDriver(this.driver);
        }
        this.metaconn = DriverManager.getConnection(string, string2, string3);
        this.metaconn.setTypeMap(this.map);
    }

    public void associateDataConnection(Connection connection) throws BinXMLException {
        this.dataconn = this.metaconn == null ? connection : this.metaconn;
    }

    public boolean isSchemaAnnotationAvailable() throws BinXMLException {
        return true;
    }

    public Reader getCompiledSchema(BinXMLVocabId binXMLVocabId) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string = "begin ? := dbms_csx_int.getCompiledSchemaByID(?); end;";
            CallableStatement callableStatement = connection.prepareCall(string);
            callableStatement.setBytes(2, binXMLVocabId.getVocabID());
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            String string2 = xMLType.getStringVal();
            char[] cArray = string2.toCharArray();
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            return charArrayReader;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public Reader getCompiledSchema(String string) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string2 = "begin ? := dbms_csx_int.getCompiledSchema(?); end;";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(2, string);
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            String string3 = xMLType.getStringVal();
            char[] cArray = string3.toCharArray();
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            return charArrayReader;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public BinXMLVocabId saveSchema(String string) throws BinXMLException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        this.saveSchema(string, uRL);
        return this.getSchemaID(string);
    }

    public BinXMLVocabId saveCompiledSchema(String string) throws BinXMLException {
        return null;
    }

    public BinXMLStream getDTD(BinXMLVocabId binXMLVocabId) throws BinXMLException {
        return null;
    }

    public BinXMLStream getDTD(String string) throws BinXMLException {
        return null;
    }

    public BinXMLVocabId saveDTD(String string) throws BinXMLException {
        return null;
    }

    public BinXMLStream getTokenSet(String string, boolean bl) throws BinXMLException {
        long l = bl ? 1L : 0L;
        return this.getTokenSet(string, l);
    }

    public Connection getConnection() {
        return this.metaconn;
    }

    BinXMLVocabId getSchemaID(String string) {
        Connection connection = this.getConnectionInUse();
        String string2 = "select SCHEMA_URL, SCHEMA_ID from ALL_XML_SCHEMAS";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (!string3.equals(string)) continue;
                byte[] byArray = (byte[])resultSet.getObject(2);
                BinXMLVocabId binXMLVocabId = new BinXMLVocabId();
                binXMLVocabId.setVocabID(byArray);
                return binXMLVocabId;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    private void saveSchema(String string, URL uRL) throws BinXMLException {
        Connection connection = this.getConnectionInUse();
        String string2 = "begin dbms_xmlschema.registerSchema(?, ?, true, false, false, false, false, '', 2, 2); end;";
        try {
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string);
            XMLType xMLType = this.createXMLType(uRL, connection);
            callableStatement.setObject(2, (Object)xMLType);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private XMLType createXMLType(URL uRL, Connection connection) {
        try {
            InputStream inputStream = uRL.openStream();
            XMLType xMLType = XMLType.createXML((Connection)connection, (InputStream)inputStream);
            return xMLType;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    private BinXMLStream getTokenSet(String string, long l) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string2 = "begin ? := dbms_csx_int.getVocabularyFromToken(?, ?, ?, ?); end;";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(2, string);
            callableStatement.setLong(3, l);
            callableStatement.setLong(4, 0L);
            callableStatement.setLong(5, 0L);
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            return this.getBinXMLStreamFromXMLType(xMLType);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    BinXMLStream getBinXMLStreamFromXMLType(XMLType xMLType) {
        try {
            Class<?> clazz = xMLType.getClass();
            Method method = clazz.getDeclaredMethod("getBinXMLStream", null);
            BinXMLStream binXMLStream = (BinXMLStream)method.invoke((Object)xMLType, null);
            return binXMLStream;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private void insertXMLTypeData() throws BinXMLException {
        try {
            ResultSet resultSet;
            Connection connection = this.getConnectionInUse();
            String string = "delete from csxtab";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.executeUpdate();
            String string2 = "insert into csxtab values (?, ?)";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setInt(1, 1);
            FileInputStream fileInputStream = new FileInputStream("tkxmcsxpo1k.xml");
            XMLType xMLType = new XMLType(connection, (InputStream)fileInputStream);
            preparedStatement.setObject(2, xMLType);
            int n = preparedStatement.executeUpdate();
            if (n == 1 && (resultSet = (preparedStatement = connection.prepareStatement(string2 = "select * from csxtab")).executeQuery()).next()) {
                int n2 = resultSet.getInt(1);
                xMLType = (XMLType)resultSet.getObject(2, this.map);
                BinXMLStream binXMLStream = this.getBinXMLStreamFromXMLType(xMLType);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public BinXMLStream getTokenSet(long l) throws BinXMLException {
        BinXMLStream binXMLStream = this.getTokenSet(l, 1L);
        if (binXMLStream != null) {
            return binXMLStream;
        }
        return this.getTokenSet(l, 0L);
    }

    private BinXMLStream getTokenSet(long l, long l2) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string = "begin ? := dbms_csx_int.getVocabulary(?, ?); end;";
            CallableStatement callableStatement = connection.prepareCall(string);
            callableStatement.setLong(2, l);
            callableStatement.setLong(3, l2);
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            return this.getBinXMLStreamFromXMLType(xMLType);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    String getNamespaceIDfromXDB(String string) throws BinXMLException {
        String string2 = this.getNSTableName();
        if (string2 == null) {
            return null;
        }
        string2 = "xdb.x$nm" + string2;
        return this.getNamespaceIDfromXDB(string, string2);
    }

    private String getNamespaceIDfromXDB(String string, String string2) throws BinXMLException {
        Connection connection = this.getConnectionInUse();
        String string3 = "select id from ";
        string3 = string3 + string2;
        string3 = string3 + " where nmspcuri like ";
        string3 = string3 + "'" + string + "'";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                String string4 = resultSet.getString(1);
                return string4;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    private String getNSTableName() throws BinXMLException {
        Connection connection = this.getConnectionInUse();
        String string = "select TOKSUF from xdb.xdb$ttset where flags = 0";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                return string2;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public BinXMLVocabId saveTokenSet(String string) throws BinXMLException {
        return null;
    }

    private Connection getConnectionInUse() {
        if (this.metaconn != null) {
            return this.metaconn;
        }
        return this.dataconn;
    }

    byte[] getBytes(Blob blob) throws SQLException {
        return blob.getBytes(0L, (int)blob.length());
    }

    InputStream getBinaryStream(Blob blob) throws SQLException {
        return blob.getBinaryStream();
    }
}

