/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.system.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import pl.mpak.orbada.system.OrbadaSystemPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Command;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class CommandPanel
extends JPanel {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSystemPlugin.class);
    private Command command;
    private Timer timer;
    private Action cmCancel;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JLabel labelDatabase;
    private JLabel labelStatus;
    private JTextArea textQuery;

    public CommandPanel(Command query) {
        this.command = query;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setFocusable(true);
    }

    public void update() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CommandPanel.this.updateStatus();
            }
        });
    }

    public void updateStatus() {
        this.setBackground(SwingUtil.addColor((Color)this.getBackground(), (int)120, (int)-10, (int)-10));
        this.labelDatabase.setText(this.command.getDatabase().getPublicName());
        this.textQuery.setText(this.command.getSqlText());
        this.textQuery.setCaretPosition(0);
        this.labelStatus.setText(stringManager.getString("cxecuting"));
    }

    public void close() {
    }

    public Command getCommand() {
        return this.command;
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textQuery = new JTextArea();
        this.labelDatabase = new JLabel();
        this.labelStatus = new JLabel();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/res/icon/stop10.gif")));
        this.cmCancel.setText(stringManager.getString("cancel"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandPanel.this.cmCancelActionPerformed(evt);
            }
        });
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.jButton1.setAction((javax.swing.Action)this.cmCancel);
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.setPreferredSize(new Dimension(60, 20));
        this.textQuery.setColumns(20);
        this.textQuery.setEditable(false);
        this.textQuery.setFont(new Font("Courier New", 0, 11));
        this.textQuery.setRows(5);
        this.jScrollPane1.setViewportView(this.textQuery);
        this.labelDatabase.setText("labelDatabase");
        this.labelStatus.setText("labelStatus");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 345, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelStatus, -1, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2)).addComponent(this.labelDatabase, GroupLayout.Alignment.LEADING, -1, 345, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 85, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDatabase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, -1, -2).addComponent(this.labelStatus)).addContainerGap()));
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        try {
            this.command.cancel();
        }
        catch (SQLException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

