/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.system.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.util.Date;
import java.util.EventObject;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.system.OrbadaSystemPlugin;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.CommandListener;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.usedb.core.DatabaseManagerEvent;
import pl.mpak.usedb.core.DatabaseManagerListener;
import pl.mpak.usedb.core.DatabaseQueryEvent;
import pl.mpak.usedb.core.DatabaseQueryListener;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class QueryExecutedPanel
extends JPanel {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSystemPlugin.class);
    private DatabaseManagerListener databaseManagerListener;
    private DatabaseQueryListener databaseQueryListener;
    private CommandListener commandListener;
    private QueryListener queryListener;
    private JScrollPane jScrollPane1;
    private TextArea textExecuted;

    public QueryExecutedPanel() {
        this.initComponents();
        this.init();
    }

    private void checkTextLength() {
        if (this.textExecuted.getDocument().getLength() > 100000) {
            try {
                this.textExecuted.getDocument().remove(0, this.textExecuted.getDocument().getLength() - 100000);
            }
            catch (BadLocationException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void appendText(final String text) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                QueryExecutedPanel.this.textExecuted.append(text);
                QueryExecutedPanel.this.checkTextLength();
            }
        });
    }

    private void appendQuery(Query query) {
        StringBuffer sb = new StringBuffer();
        sb.append("--- DATABASE ---\n");
        if (query.getDatabase().getPublicName() != null) {
            sb.append(query.getDatabase().getPublicName() + "\n");
        }
        sb.append(query.getDatabase().getUrl() + "\n");
        sb.append("--- SQL QUERY ---\n");
        sb.append(query.getSqlText() + "\n");
        sb.append(String.format(stringManager.getString("opened-records"), query.getRecordCount(), new Variant(new Date(query.getOpenTime())), StringUtil.formatTime((long)query.getOpeningTime())) + "\n");
        if (query.getParameterCount() > 0) {
            sb.append("--- PARAMETERS ---\n");
            for (int i = 0; i < query.getParameterCount(); ++i) {
                sb.append(query.getParameter(i) + "\n");
            }
        }
        sb.append("\n");
        this.appendText(sb.toString());
    }

    private void appendCommand(Command command) {
        StringBuffer sb = new StringBuffer();
        sb.append("--- DATABASE ---\n");
        if (command.getDatabase().getPublicName() != null) {
            sb.append(command.getDatabase().getPublicName() + "\n");
        }
        sb.append(command.getDatabase().getUrl() + "\n");
        sb.append("--- SQL COMMAND ---\n");
        sb.append(command.getSqlText() + "\n");
        sb.append(String.format(stringManager.getString("execution-time"), new Variant(new Date(command.getExecutedTime())), StringUtil.formatTime((long)command.getExecutionTime())) + "\n");
        if (command.getParameterCount() > 0) {
            sb.append("--- PARAMETERS ---\n");
            for (int i = 0; i < command.getParameterCount(); ++i) {
                sb.append(command.getParameter(i) + "\n");
            }
        }
        sb.append("\n");
        this.appendText(sb.toString());
    }

    private void init() {
        this.queryListener = new QueryListener(){

            public void beforeScroll(EventObject event) {
            }

            public void afterScroll(EventObject event) {
            }

            public void beforeOpen(EventObject event) {
            }

            public void afterOpen(EventObject event) {
                QueryExecutedPanel.this.appendQuery((Query)event.getSource());
            }

            public void beforeClose(EventObject event) {
            }

            public void afterClose(EventObject event) {
            }

            public void flushedPerformed(EventObject event) {
            }

            public void errorPerformed(EventObject event) {
                QueryExecutedPanel.this.textExecuted.append("--- ERROR ---\n");
                QueryExecutedPanel.this.appendQuery((Query)event.getSource());
            }
        };
        this.commandListener = new CommandListener(){

            public void beforeExecute(EventObject event) {
            }

            public void afterExecute(EventObject event) {
                QueryExecutedPanel.this.appendCommand((Command)event.getSource());
            }

            public void errorPerformed(EventObject event) {
                QueryExecutedPanel.this.textExecuted.append("--- ERROR ---\n");
                QueryExecutedPanel.this.appendCommand((Command)event.getSource());
            }
        };
        this.databaseQueryListener = new DatabaseQueryListener(){

            public void queryAdded(DatabaseQueryEvent event) {
                event.getQuery().addQueryListener(QueryExecutedPanel.this.queryListener);
            }

            public void queryRemoved(DatabaseQueryEvent event) {
                event.getQuery().removeQueryListener(QueryExecutedPanel.this.queryListener);
            }
        };
        this.databaseManagerListener = new DatabaseManagerListener(){

            public void databaseAdded(DatabaseManagerEvent event) {
                event.getDatabase().addDatabaseQueryListener(QueryExecutedPanel.this.databaseQueryListener);
                event.getDatabase().addCommandListener(QueryExecutedPanel.this.commandListener);
            }

            public void databaseRemoved(DatabaseManagerEvent event) {
                event.getDatabase().removeDatabaseQueryListener(QueryExecutedPanel.this.databaseQueryListener);
                event.getDatabase().removeCommandListener(QueryExecutedPanel.this.commandListener);
            }
        };
        DatabaseManager.getManager().addDatabaseManagerListener(this.databaseManagerListener);
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            Database database = DatabaseManager.getManager().getDatabase(i);
            for (int q = 0; q < database.getQueryCount(); ++q) {
                database.getQuery(q).addQueryListener(this.queryListener);
            }
            database.addDatabaseQueryListener(this.databaseQueryListener);
            database.addCommandListener(this.commandListener);
        }
    }

    public void close() {
        DatabaseManager.getManager().removeDatabaseManagerListener(this.databaseManagerListener);
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            Database database = DatabaseManager.getManager().getDatabase(i);
            for (int q = 0; q < database.getQueryCount(); ++q) {
                database.getQuery(q).removeQueryListener(this.queryListener);
            }
            database.removeDatabaseQueryListener(this.databaseQueryListener);
            database.removeCommandListener(this.commandListener);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textExecuted = new TextArea();
        this.textExecuted.setColumns(20);
        this.textExecuted.setEditable(false);
        this.textExecuted.setRows(5);
        this.textExecuted.setFont(new Font("Courier New", 0, 11));
        this.jScrollPane1.setViewportView((Component)this.textExecuted);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 471, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 155, Short.MAX_VALUE).addContainerGap()));
    }
}

