/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.system.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.mpak.orbada.system.gui.CommandPanel;
import pl.mpak.orbada.system.gui.QueryPanel;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.CommandListener;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.usedb.core.DatabaseManagerEvent;
import pl.mpak.usedb.core.DatabaseManagerListener;
import pl.mpak.usedb.core.DatabaseQueryEvent;
import pl.mpak.usedb.core.DatabaseQueryListener;
import pl.mpak.usedb.core.QueryListener;

public class QueryExecutionPanel
extends JPanel {
    private DatabaseManagerListener databaseManagerListener;
    private DatabaseQueryListener databaseQueryListener;
    private CommandListener commandListener;
    private QueryListener queryListener;
    private JScrollPane jScrollPane1;
    private JPanel panelQueries;

    public QueryExecutionPanel() {
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.queryListener = new QueryListener(){

            public void beforeScroll(EventObject event) {
            }

            public void afterScroll(EventObject event) {
            }

            public void beforeOpen(EventObject event) {
                QueryExecutionPanel.this.refreshList();
            }

            public void afterOpen(EventObject event) {
                QueryExecutionPanel.this.refreshList();
            }

            public void beforeClose(EventObject event) {
                QueryExecutionPanel.this.refreshList();
            }

            public void afterClose(EventObject event) {
                QueryExecutionPanel.this.refreshList();
            }

            public void flushedPerformed(EventObject event) {
                QueryExecutionPanel.this.refreshList();
            }

            public void errorPerformed(EventObject event) {
                QueryExecutionPanel.this.refreshList();
            }
        };
        this.commandListener = new CommandListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void remove(Command command) {
                JPanel jPanel = QueryExecutionPanel.this.panelQueries;
                synchronized (jPanel) {
                    for (int i = 0; i < QueryExecutionPanel.this.panelQueries.getComponentCount(); ++i) {
                        Component c = QueryExecutionPanel.this.panelQueries.getComponent(i);
                        if (!(c instanceof CommandPanel) || !command.equals(((CommandPanel)c).getCommand())) continue;
                        QueryExecutionPanel.this.panelQueries.remove(c);
                    }
                }
                QueryExecutionPanel.this.refreshList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeExecute(EventObject event) {
                JPanel jPanel = QueryExecutionPanel.this.panelQueries;
                synchronized (jPanel) {
                    QueryExecutionPanel.this.panelQueries.add(new CommandPanel((Command)event.getSource()));
                }
                QueryExecutionPanel.this.refreshList();
            }

            public void afterExecute(EventObject event) {
                this.remove((Command)event.getSource());
            }

            public void errorPerformed(EventObject event) {
                this.remove((Command)event.getSource());
            }
        };
        this.databaseQueryListener = new DatabaseQueryListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void queryAdded(DatabaseQueryEvent event) {
                event.getQuery().addQueryListener(QueryExecutionPanel.this.queryListener);
                JPanel jPanel = QueryExecutionPanel.this.panelQueries;
                synchronized (jPanel) {
                    QueryExecutionPanel.this.panelQueries.add(new QueryPanel(event.getQuery()));
                }
                QueryExecutionPanel.this.refreshList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void queryRemoved(DatabaseQueryEvent event) {
                JPanel jPanel = QueryExecutionPanel.this.panelQueries;
                synchronized (jPanel) {
                    for (int i = 0; i < QueryExecutionPanel.this.panelQueries.getComponentCount(); ++i) {
                        Component c = QueryExecutionPanel.this.panelQueries.getComponent(i);
                        if (!(c instanceof QueryPanel) || !event.getQuery().equals(((QueryPanel)c).getQuery())) continue;
                        QueryExecutionPanel.this.panelQueries.remove(c);
                    }
                }
                event.getQuery().removeQueryListener(QueryExecutionPanel.this.queryListener);
                QueryExecutionPanel.this.refreshList();
            }
        };
        this.databaseManagerListener = new DatabaseManagerListener(){

            public void databaseAdded(DatabaseManagerEvent event) {
                event.getDatabase().addDatabaseQueryListener(QueryExecutionPanel.this.databaseQueryListener);
                event.getDatabase().addCommandListener(QueryExecutionPanel.this.commandListener);
                QueryExecutionPanel.this.refreshList();
            }

            public void databaseRemoved(DatabaseManagerEvent event) {
                event.getDatabase().removeDatabaseQueryListener(QueryExecutionPanel.this.databaseQueryListener);
                event.getDatabase().removeCommandListener(QueryExecutionPanel.this.commandListener);
                QueryExecutionPanel.this.refreshList();
            }
        };
        DatabaseManager.getManager().addDatabaseManagerListener(this.databaseManagerListener);
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            int q;
            Database database = DatabaseManager.getManager().getDatabase(i);
            Object object = database.getQueryListLocker();
            synchronized (object) {
                for (q = 0; q < database.getQueryCount(); ++q) {
                    database.getQuery(q).addQueryListener(this.queryListener);
                    this.panelQueries.add(new QueryPanel(database.getQuery(q)));
                }
            }
            object = database.getCommandListLocker();
            synchronized (object) {
                for (q = 0; q < database.getCommandCount(); ++q) {
                    database.getCommand(q).addCommandListener(this.commandListener);
                    this.panelQueries.add(new CommandPanel(database.getCommand(q)));
                }
            }
            database.addDatabaseQueryListener(this.databaseQueryListener);
            database.addCommandListener(this.commandListener);
        }
        this.refreshList();
    }

    private void refreshList() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JPanel jPanel = QueryExecutionPanel.this.panelQueries;
                synchronized (jPanel) {
                    for (int i = 0; i < QueryExecutionPanel.this.panelQueries.getComponentCount(); ++i) {
                        Component c = QueryExecutionPanel.this.panelQueries.getComponent(i);
                        if (c instanceof QueryPanel) {
                            ((QueryPanel)c).update();
                            continue;
                        }
                        if (!(c instanceof CommandPanel)) continue;
                        ((CommandPanel)c).update();
                    }
                }
                QueryExecutionPanel.this.panelQueries.revalidate();
                QueryExecutionPanel.this.panelQueries.repaint();
            }
        });
    }

    public void close() {
        DatabaseManager.getManager().removeDatabaseManagerListener(this.databaseManagerListener);
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            Database database = DatabaseManager.getManager().getDatabase(i);
            for (int q = 0; q < database.getQueryCount(); ++q) {
                database.getQuery(q).removeQueryListener(this.queryListener);
            }
            database.removeDatabaseQueryListener(this.databaseQueryListener);
            database.removeCommandListener(this.commandListener);
        }
        this.panelQueries.removeAll();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.panelQueries = new JPanel();
        this.panelQueries.setLayout(new BoxLayout(this.panelQueries, 1));
        this.jScrollPane1.setViewportView(this.panelQueries);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 471, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 155, Short.MAX_VALUE).addContainerGap()));
    }
}

