/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.system.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import pl.mpak.orbada.system.OrbadaSystemPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class QueryPanel
extends JPanel {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSystemPlugin.class);
    private Query query;
    private Color orgColor;
    private Action cmCancel;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JLabel labelDatabase;
    private JLabel labelStatus;
    private JTextArea textQuery;

    public QueryPanel(Query query) {
        this.query = query;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.orgColor = this.getBackground();
        this.setFocusable(true);
    }

    public void update() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                QueryPanel.this.updateStatus();
            }
        });
    }

    public void updateStatus() {
        this.labelDatabase.setText(this.query.getDatabase().getPublicName());
        this.textQuery.setText(this.query.getSqlText());
        this.textQuery.setCaretPosition(0);
        this.setBackground(this.orgColor);
        switch (this.query.getState()) {
            case CHECKING: {
                this.labelStatus.setText(stringManager.getString("checking"));
                break;
            }
            case CHECKED: {
                this.labelStatus.setText(stringManager.getString("checked"));
                break;
            }
            case OPENING: {
                this.labelStatus.setText(stringManager.getString("opening"));
                this.setBackground(SwingUtil.addColor((Color)this.orgColor, (int)120, (int)-10, (int)-10));
                break;
            }
            case OPENED: {
                this.labelStatus.setText(String.format(stringManager.getString("opened-records"), this.query.getRecordCount(), new Variant(new Date(this.query.getOpenTime())), StringUtil.formatTime((long)this.query.getOpeningTime())));
                break;
            }
            case CLOSING: {
                this.labelStatus.setText(stringManager.getString("closing"));
                break;
            }
            case CLOSE: {
                this.labelStatus.setText(stringManager.getString("closed"));
                break;
            }
            default: {
                this.labelStatus.setText("???");
            }
        }
        this.cmCancel.setEnabled(this.query.getState() == Query.State.OPENING || this.query.getState() == Query.State.OPENED);
        if (this.query.getState() == Query.State.OPENING) {
            this.cmCancel.setText(stringManager.getString("cancel"));
        } else if (this.query.getState() == Query.State.OPENED) {
            this.cmCancel.setText(stringManager.getString("close"));
        }
    }

    public void close() {
    }

    public Query getQuery() {
        return this.query;
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textQuery = new JTextArea();
        this.labelDatabase = new JLabel();
        this.labelStatus = new JLabel();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/res/icon/stop10.gif")));
        this.cmCancel.setText(stringManager.getString("cancel"));
        this.cmCancel.setTooltip("");
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryPanel.this.cmCancelActionPerformed(evt);
            }
        });
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.jButton1.setAction((javax.swing.Action)this.cmCancel);
        this.jButton1.setMargin(new Insets(1, 1, 1, 1));
        this.textQuery.setColumns(20);
        this.textQuery.setEditable(false);
        this.textQuery.setFont(new Font("Courier New", 0, 11));
        this.textQuery.setRows(5);
        this.jScrollPane1.setViewportView(this.textQuery);
        this.labelDatabase.setText("labelDatabase");
        this.labelStatus.setText("labelStatus");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 363, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelStatus, -1, 306, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.labelDatabase, GroupLayout.Alignment.LEADING, -1, 363, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 91, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDatabase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.labelStatus)).addContainerGap()));
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        try {
            if (this.query.getState() == Query.State.OPENING) {
                this.query.cancel();
            } else if (this.query.getState() == Query.State.OPENED) {
                this.query.close();
            }
        }
        catch (SQLException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

