/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.system.gui;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.system.OrbadaSystemPlugin;
import pl.mpak.orbada.system.serives.SystemSettingsProvider;
import pl.mpak.orbada.system.serives.SystemStatusBarProvider;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SystemSettingsPanel
extends JPanel
implements ISettingsComponent {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSystemPlugin.class);
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkHideRunTime;
    private JCheckBox checkHideTime;

    public SystemSettingsPanel(IApplication application) {
        this.initComponents();
        this.application = application;
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(SystemSettingsProvider.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkHideTime.setSelected(this.settings.getValue(SystemSettingsProvider.hideTime, Boolean.valueOf(false)));
        this.checkHideRunTime.setSelected(this.settings.getValue(SystemSettingsProvider.hideRunTime, Boolean.valueOf(false)));
    }

    public void applySettings() {
        this.settings.setValue(SystemSettingsProvider.hideTime, Boolean.valueOf(this.checkHideTime.isSelected()));
        this.settings.setValue(SystemSettingsProvider.hideRunTime, Boolean.valueOf(this.checkHideRunTime.isSelected()));
        this.settings.store();
        if (SystemStatusBarProvider.instance != null) {
            SystemStatusBarProvider.instance.applySettings();
        }
    }

    public void cancelSettings() {
    }

    private void initComponents() {
        this.checkHideTime = new JCheckBox();
        this.checkHideRunTime = new JCheckBox();
        this.checkHideTime.setText(stringManager.getString("hide-os-time"));
        this.checkHideRunTime.setText(stringManager.getString("hide-run-time"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkHideTime).addComponent(this.checkHideRunTime)).addContainerGap(191, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkHideTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkHideRunTime).addContainerGap(247, Short.MAX_VALUE)));
    }
}

