/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.system.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import pl.mpak.orbada.system.OrbadaSystemPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.task.Task;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.timer.TimerManager;

public class TaskPanel
extends JPanel {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSystemPlugin.class);
    private Task task;
    private Timer timer;
    private Action cmCancel;
    private JButton jButton1;
    private JLabel labelStatus;
    private JLabel labelTaskDescription;
    private JLabel labelThreadName;
    private JProgressBar progressTask;

    public TaskPanel(Task task) {
        this.task = task;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(10L){

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TaskPanel.this.labelTaskDescription.setText(TaskPanel.this.task.getDescription());
                        TaskPanel.this.progressTask.setValue(TaskPanel.this.task.getPercenExecution());
                        TaskPanel.this.updateStatus();
                    }
                });
            }
        };
        this.labelThreadName.setText(this.task.getTaskPool().getName());
        this.labelTaskDescription.setText(this.task.getDescription());
        this.progressTask.setMinimum(0);
        this.progressTask.setMaximum(100);
        this.progressTask.setValue(this.task.getPercenExecution());
        this.setFocusable(true);
        this.updateStatus();
        TimerManager.getGlobal().add(this.timer);
    }

    public void updateStatus() {
        if (this.task.isExecuting()) {
            this.labelStatus.setText(stringManager.getString("executing"));
        } else if (this.task.isCanceled()) {
            this.labelStatus.setText(stringManager.getString("canceling"));
            this.cmCancel.setEnabled(false);
        } else {
            this.labelStatus.setText(stringManager.getString("waiting"));
        }
    }

    public void close() {
        this.timer.cancel();
    }

    public Task getTask() {
        return this.task;
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.labelThreadName = new JLabel();
        this.labelTaskDescription = new JLabel();
        this.progressTask = new JProgressBar();
        this.jButton1 = new JButton();
        this.labelStatus = new JLabel();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/res/icon/stop10.gif")));
        this.cmCancel.setText(stringManager.getString("cancel"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaskPanel.this.cmCancelActionPerformed(evt);
            }
        });
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.labelThreadName.setText("labelThreadName");
        this.labelTaskDescription.setText("labelTaskDescription");
        this.jButton1.setAction((javax.swing.Action)this.cmCancel);
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.setPreferredSize(new Dimension(60, 20));
        this.labelStatus.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelThreadName, -1, 345, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelTaskDescription, GroupLayout.Alignment.LEADING, -1, 279, Short.MAX_VALUE).addComponent(this.progressTask, -1, 279, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelStatus, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelThreadName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTaskDescription).addComponent(this.labelStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.progressTask, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.task.setCanceled(true);
        this.updateStatus();
    }
}

