/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.system.serives;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import pl.mpak.orbada.OrbadaCancelCloseException;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.StatusBarProvider;
import pl.mpak.orbada.system.OrbadaSystemPlugin;
import pl.mpak.orbada.system.gui.QueryExecutionDialog;
import pl.mpak.orbada.system.gui.TaskExecutionDialog;
import pl.mpak.orbada.system.serives.SystemSettingsProvider;
import pl.mpak.orbada.universal.gui.ErrorBox;
import pl.mpak.sky.gui.swing.CursorChanger;
import pl.mpak.sky.gui.swing.comp.StatusPanel;
import pl.mpak.sky.gui.swing.comp.SystemStatusBar;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.CommandListener;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.usedb.core.DatabaseManagerEvent;
import pl.mpak.usedb.core.DatabaseManagerListener;
import pl.mpak.usedb.core.DatabaseQueryEvent;
import pl.mpak.usedb.core.DatabaseQueryListener;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.ProcessExceptionListener;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPoolContainerEvent;
import pl.mpak.util.task.TaskPoolContainerListener;
import pl.mpak.util.task.TaskPoolEvent;
import pl.mpak.util.task.TaskPoolListener;
import pl.mpak.util.task.TaskPoolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemStatusBarProvider
extends StatusBarProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSystemPlugin.class);
    public static SystemStatusBarProvider instance;
    private JPanel panelSystemStatus;
    private SystemStatusBar systemStatusBar;
    private StatusPanel panelQuery;
    private StatusPanel panelTask;
    private JButton buttonError;
    private int openingQueries = 0;
    private int openedQueries = 0;
    private int openedQueryCount = 0;
    private int openedDatabases = 0;
    private int runingTasks = 0;
    private int waitingTasks = 0;
    private DatabaseQueryListener databaseQueryListener;
    private QueryListener queryListener;
    private CommandListener commandListener;
    private Throwable exception;
    private static final ArrayList<Task> taskList;
    private int statusTextEnabled = 0;
    private boolean requestUpdateStatusBarQuery = true;

    public SystemStatusBarProvider() {
        instance = this;
    }

    public static ArrayList<Task> getTaskList() {
        return taskList;
    }

    public String getDescription() {
        return stringManager.getString("system-status-bar-provider");
    }

    private void updateStatusBarQuery() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SystemStatusBarProvider.this.updateOpenedQueries();
                if (SystemStatusBarProvider.this.openingQueries > 0) {
                    SystemStatusBarProvider.this.panelQuery.setForeground(Color.RED);
                } else {
                    SystemStatusBarProvider.this.panelQuery.setForeground(null);
                }
                SystemStatusBarProvider.this.panelQuery.setText(String.format("%d, %d/%d/%d ", SystemStatusBarProvider.this.openedDatabases, SystemStatusBarProvider.this.openingQueries, SystemStatusBarProvider.this.openedQueries, SystemStatusBarProvider.this.openedQueryCount));
                SystemStatusBarProvider.this.panelQuery.revalidate();
            }
        });
    }

    private void updateStatusBarTask() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (SystemStatusBarProvider.this.runingTasks > 0) {
                    SystemStatusBarProvider.this.panelTask.setForeground(Color.RED);
                } else {
                    SystemStatusBarProvider.this.panelTask.setForeground(null);
                }
                int count = 0;
                int percentage = 0;
                ArrayList arrayList = taskList;
                synchronized (arrayList) {
                    if (taskList.size() > 0 && SystemStatusBarProvider.this.runingTasks > 0) {
                        for (Task task : taskList) {
                            if (task.getPercenExecution() <= 0) continue;
                            percentage += task.getPercenExecution();
                            ++count;
                        }
                        percentage = (int)((double)percentage / (double)count);
                    }
                }
                if (percentage > 0) {
                    SystemStatusBarProvider.this.panelTask.setText(String.format("%d/%d [%d%%] ", SystemStatusBarProvider.this.runingTasks, SystemStatusBarProvider.this.waitingTasks, percentage));
                } else {
                    SystemStatusBarProvider.this.panelTask.setText(String.format("%d/%d ", SystemStatusBarProvider.this.runingTasks, SystemStatusBarProvider.this.waitingTasks));
                }
                SystemStatusBarProvider.this.panelTask.revalidate();
            }
        });
    }

    private void initStatusBarTask() {
        TaskPoolManager.addTaskPoolListener((TaskPoolListener)new TaskPoolListener(){

            public void beginPool(TaskPoolEvent e) {
            }

            public void endPool(TaskPoolEvent e) {
            }

            public void beginTask(TaskPoolEvent e) {
                SystemStatusBarProvider.this.waitingTasks--;
                SystemStatusBarProvider.this.runingTasks++;
                SystemStatusBarProvider.this.updateStatusBarTask();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void endTask(TaskPoolEvent e) {
                SystemStatusBarProvider.this.runingTasks--;
                SystemStatusBarProvider.this.updateStatusBarTask();
                ArrayList arrayList = taskList;
                synchronized (arrayList) {
                    taskList.remove(e.getTask());
                }
            }
        });
        TaskPoolManager.addTaskPoolContainerListener((TaskPoolContainerListener)new TaskPoolContainerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addTask(TaskPoolContainerEvent e) {
                ArrayList arrayList = taskList;
                synchronized (arrayList) {
                    taskList.add(e.getTask());
                }
                SystemStatusBarProvider.this.waitingTasks++;
                SystemStatusBarProvider.this.updateStatusBarTask();
            }

            public void removeTask(TaskPoolContainerEvent arg0) {
            }
        });
        this.panelTask = this.systemStatusBar.addPanel("task-panel");
        this.panelTask.setToolTipText(stringManager.getString("background-tasks"));
        this.panelTask.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/runing-tasks18.gif")));
        this.panelTask.setDisplayActivation(true);
        this.panelTask.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (!TaskExecutionDialog.showed) {
                    TaskExecutionDialog.showDialog();
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.updateStatusBarTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOpenedQueries() {
        this.openingQueries = 0;
        this.openedQueries = 0;
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            int q;
            Database database = DatabaseManager.getManager().getDatabase(i);
            Object object = database.getQueryListLocker();
            synchronized (object) {
                for (q = 0; q < database.getQueryCount(); ++q) {
                    if (database.getQuery(q).getState() == Query.State.OPENING) {
                        ++this.openingQueries;
                    }
                    if (database.getQuery(q).getState() != Query.State.OPENED) continue;
                    ++this.openedQueries;
                }
            }
            object = database.getCommandListLocker();
            synchronized (object) {
                for (q = 0; q < database.getCommandCount(); ++q) {
                    if (database.getCommand(q).getState() != Command.State.EXECUTEING) continue;
                    ++this.openingQueries;
                }
                continue;
            }
        }
    }

    private void initStatusBarQuery() {
        this.queryListener = new QueryListener(){
            CursorChanger workCursor;
            boolean waitCount;

            private void workCursorSet() {
                if (Thread.currentThread().getName() != null && Thread.currentThread().getName().startsWith("AWT-")) {
                    if (!this.waitCount) {
                        if (this.workCursor == null) {
                            this.workCursor = new CursorChanger((Component)Application.get().getMainFrame().getGlassPane(), Cursor.getPredefinedCursor(3));
                        }
                        this.workCursor.show();
                        Application.get().getMainFrame().getGlassPane().setVisible(true);
                    }
                    this.waitCount = true;
                }
            }

            private void workCursorReset() {
                if (this.waitCount) {
                    if (this.workCursor != null) {
                        Application.get().getMainFrame().getGlassPane().setVisible(false);
                        this.workCursor.restore();
                    }
                    this.waitCount = false;
                }
            }

            public void beforeScroll(EventObject event) {
            }

            public void afterScroll(EventObject event) {
            }

            public void beforeOpen(EventObject event) {
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
                this.workCursorSet();
            }

            public void afterOpen(EventObject event) {
                SystemStatusBarProvider.this.openedQueryCount++;
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
                this.workCursorReset();
            }

            public void beforeClose(EventObject event) {
            }

            public void afterClose(EventObject event) {
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
            }

            public void flushedPerformed(EventObject event) {
            }

            public void errorPerformed(EventObject event) {
                this.workCursorReset();
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
            }
        };
        this.commandListener = new CommandListener(){

            public void beforeExecute(EventObject event) {
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
            }

            public void afterExecute(EventObject event) {
                SystemStatusBarProvider.this.openedQueryCount++;
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
            }

            public void errorPerformed(EventObject event) {
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
            }
        };
        this.databaseQueryListener = new DatabaseQueryListener(){

            public void queryAdded(DatabaseQueryEvent event) {
                event.getQuery().addQueryListener(SystemStatusBarProvider.this.queryListener);
            }

            public void queryRemoved(DatabaseQueryEvent event) {
                event.getQuery().removeQueryListener(SystemStatusBarProvider.this.queryListener);
            }
        };
        DatabaseManager.getManager().addDatabaseManagerListener(new DatabaseManagerListener(){

            public void databaseAdded(DatabaseManagerEvent event) {
                SystemStatusBarProvider.this.openedDatabases++;
                event.getDatabase().addDatabaseQueryListener(SystemStatusBarProvider.this.databaseQueryListener);
                event.getDatabase().addCommandListener(SystemStatusBarProvider.this.commandListener);
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
            }

            public void databaseRemoved(DatabaseManagerEvent event) {
                event.getDatabase().removeDatabaseQueryListener(SystemStatusBarProvider.this.databaseQueryListener);
                event.getDatabase().removeCommandListener(SystemStatusBarProvider.this.commandListener);
                SystemStatusBarProvider.this.openedDatabases--;
                SystemStatusBarProvider.this.requestUpdateStatusBarQuery = true;
            }
        });
        for (int i = 0; i < DatabaseManager.getManager().getDatabaseCount(); ++i) {
            DatabaseManager.getManager().getDatabase(i).addDatabaseQueryListener(this.databaseQueryListener);
            DatabaseManager.getManager().getDatabase(i).addCommandListener(this.commandListener);
        }
        this.panelQuery = this.systemStatusBar.addPanel("query-panel");
        this.panelQuery.setToolTipText(stringManager.getString("usedb-lib-status"));
        this.panelQuery.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/runing-queries18.gif")));
        this.panelQuery.setDisplayActivation(true);
        this.panelQuery.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (!QueryExecutionDialog.showed) {
                    QueryExecutionDialog.showDialog();
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.systemStatusBar.getTimer().schedule(new TimerTask(){

            public void run() {
                if (SystemStatusBarProvider.this.requestUpdateStatusBarQuery) {
                    SystemStatusBarProvider.this.updateStatusBarQuery();
                    SystemStatusBarProvider.this.requestUpdateStatusBarQuery = false;
                }
                if (taskList.size() > 0) {
                    SystemStatusBarProvider.this.updateStatusBarTask();
                }
            }
        }, 1000L, 1000L);
    }

    public void initButtonError() {
        this.buttonError.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SystemStatusBarProvider.this.buttonError.setToolTipText("");
                if (SystemStatusBarProvider.this.exception != null) {
                    ErrorBox.show((Throwable)SystemStatusBarProvider.this.exception);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SystemStatusBarProvider.this.buttonError.setEnabled(false);
                    }
                });
            }
        });
        ExceptionUtil.addProcessExceptionListener((ProcessExceptionListener)new ProcessExceptionListener(){

            public void processException(EventObject evt) {
                SystemStatusBarProvider.this.exception = (Throwable)evt.getSource();
                if (SystemStatusBarProvider.this.exception instanceof OrbadaCancelCloseException) {
                    return;
                }
                if (SystemStatusBarProvider.this.exception != null) {
                    String message = SystemStatusBarProvider.this.exception.getMessage();
                    SystemStatusBarProvider.this.buttonError.setToolTipText(message);
                    SystemStatusBarProvider.this.setStatusText(message);
                } else {
                    SystemStatusBarProvider.this.buttonError.setToolTipText("");
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SystemStatusBarProvider.this.buttonError.setEnabled(true);
                    }
                });
            }
        });
    }

    public void initStatusTextPanel() {
        this.systemStatusBar.addPanel("status-text");
        this.systemStatusBar.getPanel("status-text").setText(" ");
        this.systemStatusBar.getPanel("status-text").setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/status_text.gif")));
        this.systemStatusBar.getTimer().schedule(new TimerTask(){

            public void run() {
                if (SystemStatusBarProvider.this.statusTextEnabled == 0) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SystemStatusBarProvider.this.systemStatusBar.getPanel("status-text").setText("");
                        }
                    });
                } else {
                    SystemStatusBarProvider.this.statusTextEnabled--;
                }
            }
        }, 1000L, 1000L);
    }

    public void applySettings() {
        ISettings settings = this.application.getSettings(SystemSettingsProvider.settingsName);
        this.systemStatusBar.setTimeStatus(settings.getValue(SystemSettingsProvider.hideTime, Boolean.valueOf(false)) == false);
        this.systemStatusBar.setRunTimeStatus(settings.getValue(SystemSettingsProvider.hideRunTime, Boolean.valueOf(false)) == false);
    }

    public Component getComponent() {
        if (this.panelSystemStatus == null) {
            this.panelSystemStatus = new JPanel(new BorderLayout());
            this.systemStatusBar = new SystemStatusBar();
            this.buttonError = new JButton(new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/error_square16.gif")));
            this.buttonError.setMargin(new Insets(1, 1, 1, 1));
            this.buttonError.setPreferredSize(new Dimension(20, 20));
            this.buttonError.setEnabled(false);
            this.buttonError.setFocusable(false);
            this.systemStatusBar.addBefore((Component)this.systemStatusBar.getPanel("memory-panel"), (Component)this.buttonError);
            this.initButtonError();
            this.initStatusBarQuery();
            this.initStatusBarTask();
            this.initStatusTextPanel();
            this.panelSystemStatus.add((Component)this.systemStatusBar, "West");
            this.applySettings();
        }
        return this.panelSystemStatus;
    }

    public void setStatusText(final String text) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (text != null) {
                    SystemStatusBarProvider.this.systemStatusBar.getPanel("status-text").setText(text.substring(0, Math.min(90, text.length())) + (text.length() > 90 ? "... " : " "));
                }
            }
        });
        this.statusTextEnabled = 10;
    }

    public String getGroupName() {
        return "System Orbada";
    }

    static {
        taskList = new ArrayList();
    }
}

