/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.tray;

import java.awt.AWTException;
import java.awt.EventQueue;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.tray.gui.TraySettingsPanel;
import pl.mpak.orbada.tray.services.TraySettingsProvider;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.SystemUtil;
import pl.mpak.util.id.VersionID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaTrayPlugin
extends OrbadaPlugin {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaTrayPlugin.class);
    public static final String pluginGroupName = "Orbada Tools";
    public final ArrayList<Class<? extends IPluginProvider>> classList = new ArrayList();
    private ISettings settings;
    private TrayIcon trayIcon;
    private ImageIcon mainIcon = SystemUtil.isLinux() ? new ImageIcon(((Object)((Object)this)).getClass().getResource("/res/icons/orbada24.png")) : new ImageIcon(((Object)((Object)this)).getClass().getResource("/res/icons/orbada16.png"));
    private JPopupMenu menuTray;
    private boolean changingStat = false;

    public String getInternalName() {
        return "OrbadaTrayPlugin";
    }

    public String getDescriptiveName() {
        return String.format(this.stringManager.getString("OrbadaTrayPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "Tools";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 1, 5).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-tray-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    private void deiconified() {
        if (this.settings.getValue(TraySettingsPanel.setTrayOn, Boolean.valueOf(false)).booleanValue() && !this.changingStat) {
            this.changingStat = true;
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        SystemTray tray = SystemTray.getSystemTray();
                        tray.remove(OrbadaTrayPlugin.this.trayIcon);
                        Application.get().getMainFrame().setState(0);
                        Application.get().getMainFrame().setVisible(true);
                        Application.get().getMainFrame().toFront();
                    }
                    finally {
                        OrbadaTrayPlugin.this.changingStat = false;
                    }
                }
            });
        }
    }

    private void iconified() {
        if (this.settings.getValue(TraySettingsPanel.setTrayOn, Boolean.valueOf(false)).booleanValue() && !this.changingStat) {
            this.changingStat = true;
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SystemTray tray = SystemTray.getSystemTray();
                    try {
                        Application.get().getMainFrame().setVisible(false);
                        tray.add(OrbadaTrayPlugin.this.trayIcon);
                    }
                    catch (AWTException ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                    finally {
                        OrbadaTrayPlugin.this.changingStat = false;
                    }
                }
            });
        }
    }

    private void initTray() {
        this.menuTray = new JPopupMenu();
        JMenuItem item = this.menuTray.add(new JMenuItem("Przywr\u00f3\u0107"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OrbadaTrayPlugin.this.deiconified();
            }
        });
        item.setFont(Application.get().getMainFrame().getFont().deriveFont(1));
        this.trayIcon = new TrayIcon(this.mainIcon.getImage(), Application.get().getMainFrame().getTitle(), null);
        this.trayIcon.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    OrbadaTrayPlugin.this.deiconified();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    OrbadaTrayPlugin.this.menuTray.setLocation(e.getX(), e.getY());
                    OrbadaTrayPlugin.this.menuTray.setInvoker(OrbadaTrayPlugin.this.menuTray);
                    OrbadaTrayPlugin.this.menuTray.setVisible(true);
                }
            }
        });
        Application.get().getMainFrame().addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
                OrbadaTrayPlugin.this.iconified();
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    public void initialize() {
        this.settings = this.application.getSettings(TraySettingsPanel.settingsName);
        if (SystemTray.isSupported()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    OrbadaTrayPlugin.this.initTray();
                }
            });
        }
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            this.classList.add(TraySettingsProvider.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return this.classList.toArray(new Class[this.classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }
}

