/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.tray.gui;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.tray.OrbadaTrayPlugin;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TraySettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaTrayPlugin.class);
    public static String settingsName = "orbada-tray-settings";
    public static String setTrayOn = "tray-on";
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkTrayOn;

    public TraySettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkTrayOn.setSelected(this.settings.getValue(setTrayOn, Boolean.valueOf(false)));
    }

    public void applySettings() {
        this.settings.setValue(setTrayOn, Boolean.valueOf(this.checkTrayOn.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.checkTrayOn = new JCheckBox();
        this.checkTrayOn.setText(this.stringManager.getString("minimize-to-system-tray-icon"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkTrayOn).addContainerGap(264, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkTrayOn).addContainerGap(321, Short.MAX_VALUE)));
    }
}

