/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.MeldBlue;
import org.jmeld.util.prefs.WindowPreference;

public class JMeld
implements Runnable {
    private List<String> fileNameList = new ArrayList<String>();
    private static JMeldPanel jmeldPanel;

    public JMeld(String[] args) {
        for (String arg : args) {
            this.fileNameList.add(arg);
        }
    }

    public static JMeldPanel getJMeldPanel() {
        return jmeldPanel;
    }

    public void run() {
        this.debugKeyboard();
        try {
            System.setProperty("swing.aatext", "true");
            String version = System.getProperty("java.version");
            if (version.startsWith("1.7")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                PlasticLookAndFeel.setPlasticTheme(new MeldBlue());
                PlasticLookAndFeel.setTabStyle("metal");
                UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frame = new JFrame("JMeld");
        jmeldPanel = new JMeldPanel();
        frame.add(jmeldPanel);
        frame.setDefaultCloseOperation(0);
        frame.setIconImage(ImageUtil.getImageIcon("jmeld-small").getImage());
        new WindowPreference(frame.getTitle(), frame);
        frame.addWindowListener(jmeldPanel.getWindowListener());
        frame.setVisible(true);
        frame.toFront();
        jmeldPanel.openComparison(this.fileNameList);
    }

    private void debugKeyboard() {
        KeyboardFocusManager.setCurrentKeyboardFocusManager(new DefaultKeyboardFocusManager(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                return super.dispatchKeyEvent(e);
            }

            public void processKeyEvent(Component focusedComponent, KeyEvent e) {
                super.processKeyEvent(focusedComponent, e);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new JMeld(args));
    }
}

