/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jmeld.JMeldException;
import org.jmeld.diff.EclipseDiff;
import org.jmeld.diff.JMDiffAlgorithmIF;
import org.jmeld.diff.JMRevision;
import org.jmeld.diff.MaxTimeExceededException;
import org.jmeld.diff.MyersDiff;
import org.jmeld.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMDiff {
    private List<JMDiffAlgorithmIF> algorithms;

    public JMDiff() {
        MyersDiff myersDiff = new MyersDiff();
        myersDiff.checkMaxTime(true);
        this.algorithms = new ArrayList<JMDiffAlgorithmIF>();
        this.algorithms.add(myersDiff);
        this.algorithms.add(new EclipseDiff());
    }

    public JMRevision diff(List<String> a, List<String> b) throws JMeldException {
        if (a == null) {
            a = Collections.emptyList();
        }
        if (b == null) {
            b = Collections.emptyList();
        }
        return this.diff(a.toArray(), b.toArray());
    }

    public JMRevision diff(Object[] a, Object[] b) throws JMeldException {
        if (a == null) {
            a = new Object[]{};
        }
        if (b == null) {
            b = new Object[]{};
        }
        StopWatch sp = new StopWatch();
        sp.start();
        for (JMDiffAlgorithmIF algorithm : this.algorithms) {
            try {
                JMRevision revision = algorithm.diff(a, b);
                revision.filter();
                if (a.length > 1000) {
                    System.out.println("diff took " + sp.getElapsedTime() + " msec. [" + algorithm.getClass() + "]");
                }
                return revision;
            }
            catch (JMeldException ex) {
                if (ex.getCause() instanceof MaxTimeExceededException) {
                    System.out.println("Time exceeded for " + algorithm.getClass() + ": try next algorithm");
                    continue;
                }
                throw ex;
            }
        }
        return null;
    }
}

