/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMDiff;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.util.DiffUtil;
import org.jmeld.util.Ignore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMRevision {
    private static boolean incrementalUpdateActivated = false;
    private Object[] orgArray;
    private Object[] revArray;
    private LinkedList<JMDelta> deltaList;
    private LinkedList<JMDelta> filteredDeltaList;
    private List<String> regexList;
    private boolean filterChanged;

    public JMRevision(Object[] orgArray, Object[] revArray) {
        this.orgArray = orgArray;
        this.revArray = revArray;
        this.deltaList = new LinkedList();
        this.skip("Kees Kuip");
    }

    public void add(JMDelta delta) {
        this.deltaList.add(delta);
        delta.setRevision(this);
    }

    public void setFilterChanged() {
        this.filterChanged = true;
    }

    public List<JMDelta> getDeltas() {
        if (this.filteredDeltaList == null || this.filteredDeltaList.size() != this.deltaList.size() || this.filterChanged) {
            this.filteredDeltaList = this.filter(this.deltaList);
            this.filterChanged = false;
        }
        return this.filteredDeltaList;
    }

    public boolean update(Object[] oArray, Object[] rArray, boolean original, int startLine, int numberOfLines) {
        this.orgArray = oArray;
        this.revArray = rArray;
        return this.incrementalUpdate(original, startLine, numberOfLines);
    }

    private boolean incrementalUpdate(boolean original, int startLine, int numberOfLines) {
        JMRevision deltaRevision;
        JMChunk chunk;
        int revEndLine;
        int revStartLine;
        int orgEndLine;
        int orgStartLine;
        if (!incrementalUpdateActivated) {
            return false;
        }
        System.out.println((original ? "left" : "right") + " changed starting at line " + startLine + " #" + numberOfLines);
        if (original) {
            orgStartLine = startLine;
            orgEndLine = startLine + (numberOfLines < 0 ? 0 : numberOfLines) + 1;
            revStartLine = DiffUtil.getRevisedLine(this, startLine);
            revEndLine = DiffUtil.getRevisedLine(this, startLine + (numberOfLines > 0 ? 0 : -numberOfLines)) + 1;
        } else {
            revStartLine = startLine;
            revEndLine = startLine + (numberOfLines < 0 ? 0 : numberOfLines) + 1;
            orgStartLine = DiffUtil.getOriginalLine(this, startLine);
            orgEndLine = DiffUtil.getOriginalLine(this, startLine + (numberOfLines > 0 ? 0 : -numberOfLines)) + 1;
        }
        System.out.println("orgStartLine=" + orgStartLine);
        System.out.println("orgEndLine  =" + orgEndLine);
        System.out.println("revStartLine=" + revStartLine);
        System.out.println("revEndLine  =" + revEndLine);
        ArrayList<JMDelta> deltaListToRemove = new ArrayList<JMDelta>();
        ArrayList<JMChunk> chunkListToChange = new ArrayList<JMChunk>();
        int endLine = startLine + Math.abs(numberOfLines);
        for (JMDelta delta : this.deltaList) {
            chunk = original ? delta.getOriginal() : delta.getRevised();
            if (endLine < chunk.getAnchor() - 5) continue;
            if (startLine > chunk.getAnchor() + chunk.getSize() + 5) {
                if (numberOfLines == 0) continue;
                chunkListToChange.add(chunk);
                continue;
            }
            deltaListToRemove.add(delta);
            chunk = delta.getOriginal();
            if (chunk.getAnchor() < orgStartLine) {
                orgStartLine = chunk.getAnchor();
            }
            if (chunk.getAnchor() + chunk.getSize() > orgEndLine) {
                orgEndLine = chunk.getAnchor() + chunk.getSize();
            }
            if ((chunk = delta.getRevised()).getAnchor() < revStartLine) {
                revStartLine = chunk.getAnchor();
            }
            if (chunk.getAnchor() + chunk.getSize() <= revEndLine) continue;
            revEndLine = chunk.getAnchor() + chunk.getSize();
        }
        orgStartLine = orgStartLine < 0 ? 0 : orgStartLine;
        revStartLine = revStartLine < 0 ? 0 : revStartLine;
        int length = Math.min(this.orgArray.length, orgEndLine) - orgStartLine;
        Object[] orgArrayDelta = new Object[length];
        System.arraycopy(this.orgArray, orgStartLine, orgArrayDelta, 0, orgArrayDelta.length);
        length = Math.min(this.revArray.length, revEndLine) - revStartLine;
        Object[] revArrayDelta = new Object[length];
        System.arraycopy(this.revArray, revStartLine, revArrayDelta, 0, revArrayDelta.length);
        try {
            int i;
            for (i = 0; i < orgArrayDelta.length; ++i) {
                System.out.println("  org[" + i + "]:" + orgArrayDelta[i]);
            }
            for (i = 0; i < revArrayDelta.length; ++i) {
                System.out.println("  rev[" + i + "]:" + revArrayDelta[i]);
            }
            deltaRevision = new JMDiff().diff(orgArrayDelta, revArrayDelta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (!deltaListToRemove.isEmpty()) {
            this.filteredDeltaList = null;
            for (JMDelta delta : deltaListToRemove) {
                this.deltaList.remove(delta);
            }
        }
        for (JMChunk c : chunkListToChange) {
            c.setAnchor(c.getAnchor() + numberOfLines);
        }
        for (JMDelta delta : deltaRevision.deltaList) {
            chunk = delta.getOriginal();
            chunk.setAnchor(chunk.getAnchor() + orgStartLine);
            chunk = delta.getRevised();
            chunk.setAnchor(chunk.getAnchor() + revStartLine);
        }
        if (deltaRevision.deltaList.size() > 0) {
            JMDelta delta;
            JMDelta firstDelta = deltaRevision.deltaList.get(0);
            int index = 0;
            Iterator i$ = this.deltaList.iterator();
            while (i$.hasNext() && (delta = (JMDelta)i$.next()).getOriginal().getAnchor() <= firstDelta.getOriginal().getAnchor()) {
                ++index;
            }
            for (JMDelta diffDelta : deltaRevision.deltaList) {
                diffDelta.setRevision(this);
                this.deltaList.add(index, diffDelta);
                ++index;
            }
        }
        return true;
    }

    private void insert(JMDelta delta) {
        int index = 0;
        int anchor = delta.getOriginal().getAnchor();
        for (JMDelta d : this.deltaList) {
            if (d.getOriginal().getAnchor() > anchor) {
                this.deltaList.add(index, delta);
                return;
            }
            ++index;
        }
        this.deltaList.add(delta);
    }

    private JMDelta findDelta(boolean original, int anchor, int size) {
        size = size == 0 ? 1 : size;
        for (JMDelta delta : this.deltaList) {
            JMChunk chunk;
            JMChunk jMChunk = chunk = original ? delta.getOriginal() : delta.getRevised();
            if (anchor >= chunk.getAnchor() && anchor <= chunk.getAnchor() + chunk.getSize()) {
                return delta;
            }
            if (anchor + size < chunk.getAnchor() || anchor + size > chunk.getAnchor() + chunk.getSize()) continue;
            return delta;
        }
        return null;
    }

    public int getOrgSize() {
        return this.orgArray.length;
    }

    public int getRevSize() {
        return this.revArray.length;
    }

    public String getOriginalString(JMChunk chunk) {
        return this.getObjects(this.orgArray, chunk);
    }

    public String getRevisedString(JMChunk chunk) {
        return this.getObjects(this.revArray, chunk);
    }

    private String getObjects(Object[] objects, JMChunk chunk) {
        if (chunk.getSize() <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int end = chunk.getAnchor() + chunk.getSize();
        for (int offset = chunk.getAnchor(); offset < end; ++offset) {
            sb.append(objects[offset].toString());
        }
        return sb.toString();
    }

    public void skip(String regex) {
        if (this.regexList == null) {
            this.regexList = new ArrayList<String>();
        }
        this.regexList.add(regex);
    }

    private LinkedList<JMDelta> filter(LinkedList<JMDelta> list) {
        Ignore ignore = JMeldSettings.getInstance().getEditor().getIgnore();
        LinkedList<JMDelta> filterList = new LinkedList<JMDelta>();
        for (JMDelta delta : list) {
            if (ignore.ignore && delta.shouldIgnore(ignore)) continue;
            filterList.add(delta);
        }
        return filterList;
    }

    public void filter() {
        if (this.regexList != null) {
            ListIterator<JMDelta> it = this.deltaList.listIterator(0);
            while (it.hasNext()) {
                Object o;
                int index;
                JMDelta delta = it.next();
                JMChunk original = delta.getOriginal();
                JMChunk revised = delta.getRevised();
                boolean[] originalSkip = null;
                boolean[] revisedSkip = null;
                int end = original.getAnchor() + original.getSize();
                for (index = original.getAnchor(); index < end; ++index) {
                    o = this.orgArray[index];
                    if (o == null) continue;
                    for (String regex : this.regexList) {
                        if (!o.toString().contains(regex)) continue;
                        if (originalSkip == null) {
                            originalSkip = new boolean[original.getSize()];
                        }
                        originalSkip[index - original.getAnchor()] = true;
                    }
                }
                end = revised.getAnchor() + revised.getSize();
                for (index = revised.getAnchor(); index < end; ++index) {
                    o = this.revArray[index];
                    if (o == null) continue;
                    for (String regex : this.regexList) {
                        if (!o.toString().contains(regex)) continue;
                        if (revisedSkip == null) {
                            revisedSkip = new boolean[revised.getSize()];
                        }
                        revisedSkip[index - revised.getAnchor()] = true;
                    }
                }
                if (originalSkip != null || revisedSkip == null) continue;
            }
        }
    }
}

