/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.settings;

import java.awt.Color;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.jmeld.settings.ColorSetting;
import org.jmeld.ui.util.Colors;
import org.jmeld.util.Ignore;
import org.jmeld.util.conf.AbstractConfigurationElement;

@XmlAccessorType(value=XmlAccessType.NONE)
public class EditorSettings
extends AbstractConfigurationElement {
    @XmlElement
    private boolean showLineNumbers;
    @XmlElement
    private int tabSize = 4;
    @XmlElement
    private boolean ignoreWhitespace;
    @XmlElement
    private boolean ignoreEOL;
    @XmlElement
    private boolean ignoreBlankLines;
    @XmlElement
    private boolean leftsideReadonly;
    @XmlElement
    private boolean rightsideReadonly;
    @XmlElement
    private ColorSetting addedColor;
    @XmlElement
    private ColorSetting changedColor;
    @XmlElement
    private ColorSetting deletedColor;
    private transient Ignore ignore;

    public boolean getShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
        this.fireChanged();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
        this.fireChanged();
    }

    public Ignore getIgnore() {
        if (this.ignore == null) {
            this.ignore = new Ignore(this.ignoreWhitespace, this.ignoreEOL, this.ignoreBlankLines);
        }
        return this.ignore;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
        this.ignore = null;
        this.fireChanged();
    }

    public void setIgnoreEOL(boolean ignoreEOL) {
        this.ignoreEOL = ignoreEOL;
        this.ignore = null;
        this.fireChanged();
    }

    public void setIgnoreBlankLines(boolean ignoreBlankLines) {
        this.ignoreBlankLines = ignoreBlankLines;
        this.ignore = null;
        this.fireChanged();
    }

    public boolean getLeftsideReadonly() {
        return this.leftsideReadonly;
    }

    public void setLeftsideReadonly(boolean leftsideReadonly) {
        this.leftsideReadonly = leftsideReadonly;
        this.fireChanged();
    }

    public boolean getRightsideReadonly() {
        return this.rightsideReadonly;
    }

    public void setRightsideReadonly(boolean rightsideReadonly) {
        this.rightsideReadonly = rightsideReadonly;
        this.fireChanged();
    }

    public void restoreColors() {
        this.addedColor = null;
        this.changedColor = null;
        this.deletedColor = null;
        this.fireChanged();
    }

    public void setAddedColor(Color color) {
        this.addedColor = new ColorSetting(color);
        this.fireChanged();
    }

    public Color getAddedColor() {
        return this.getColor(this.addedColor, Colors.ADDED);
    }

    public void setChangedColor(Color color) {
        this.changedColor = new ColorSetting(color);
        this.fireChanged();
    }

    public Color getChangedColor() {
        return this.getColor(this.changedColor, Colors.CHANGED);
    }

    public void setDeletedColor(Color color) {
        this.deletedColor = new ColorSetting(color);
        this.fireChanged();
    }

    public Color getDeletedColor() {
        return this.getColor(this.deletedColor, Colors.DELETED);
    }

    private Color getColor(ColorSetting cc, Color defaultColor) {
        Color c = null;
        if (cc != null) {
            c = cc.getColor();
        }
        if (c == null) {
            c = defaultColor;
        }
        return c;
    }
}

