/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.ui.util.RevisionUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class DiffScrollComponent
extends JComponent
implements ChangeListener,
ConfigurationListenerIF {
    private BufferDiffPanel diffPanel;
    private int fromPanelIndex;
    private int toPanelIndex;
    private List<Command> commands;
    private Object antiAlias;
    private boolean leftsideReadonly;
    private boolean rightsideReadonly;

    public DiffScrollComponent(BufferDiffPanel diffPanel, int fromPanelIndex, int toPanelIndex) {
        this.diffPanel = diffPanel;
        this.fromPanelIndex = fromPanelIndex;
        this.toPanelIndex = toPanelIndex;
        this.getFromPanel().getScrollPane().getViewport().addChangeListener(this);
        this.getToPanel().getScrollPane().getViewport().addChangeListener(this);
        this.addMouseListener(this.getMouseListener());
        this.addMouseWheelListener(this.getMouseWheelListener());
        JMeldSettings.getInstance().addConfigurationListener(this);
        this.initSettings();
    }

    private void initSettings() {
        EditorSettings settings = JMeldSettings.getInstance().getEditor();
        this.leftsideReadonly = settings.getLeftsideReadonly();
        this.rightsideReadonly = settings.getRightsideReadonly();
    }

    public void stateChanged(ChangeEvent event) {
        this.repaint();
    }

    public void configurationChanged() {
        this.initSettings();
        this.repaint();
    }

    private MouseWheelListener getMouseWheelListener() {
        return new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent me) {
                DiffScrollComponent.this.diffPanel.toNextDelta(me.getWheelRotation() > 0);
                DiffScrollComponent.this.repaint();
            }
        };
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                DiffScrollComponent.this.executeCommand(me.getX(), me.getY());
            }
        };
    }

    public boolean executeCommand(double x, double y) {
        if (this.commands == null) {
            return false;
        }
        for (Command command : this.commands) {
            if (!command.contains(x, y)) continue;
            command.execute();
            return true;
        }
        return false;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = g.getClipBounds();
        g2.setColor(this.getBackground());
        g2.fill(r);
        int middle = r.height / 2;
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawLine(r.x + 20, r.y + middle, r.x + r.width - 20, r.y + middle);
        this.paintDiffs(g2);
    }

    private void paintDiffs(Graphics2D g2) {
        Rectangle bounds = g2.getClipBounds();
        JMRevision revision = this.diffPanel.getCurrentRevision();
        if (revision == null) {
            return;
        }
        this.commands = new ArrayList<Command>();
        this.antiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        FilePanel fromPanel = this.getFromPanel();
        JViewport viewportFrom = fromPanel.getScrollPane().getViewport();
        JTextArea editorFrom = fromPanel.getEditor();
        BufferDocumentIF bdFrom = fromPanel.getBufferDocument();
        if (bdFrom == null) {
            return;
        }
        Rectangle r = viewportFrom.getViewRect();
        Point p = new Point(r.x, r.y);
        int offset = editorFrom.viewToModel(p);
        int firstLineFrom = bdFrom.getLineForOffset(offset);
        p = new Point(r.x, r.y + r.height);
        offset = editorFrom.viewToModel(p);
        bdFrom = fromPanel.getBufferDocument();
        int lastLineFrom = bdFrom.getLineForOffset(offset) + 1;
        FilePanel toPanel = this.getToPanel();
        JViewport viewportTo = toPanel.getScrollPane().getViewport();
        JTextArea editorTo = toPanel.getEditor();
        BufferDocumentIF bdTo = toPanel.getBufferDocument();
        if (bdTo == null) {
            return;
        }
        r = viewportTo.getViewRect();
        p = new Point(r.x, r.y);
        offset = editorTo.viewToModel(p);
        int firstLineTo = bdTo.getLineForOffset(offset) + 1;
        p = new Point(r.x, r.y + r.height);
        offset = editorTo.viewToModel(p);
        int lastLineTo = bdTo.getLineForOffset(offset) + 1;
        boolean count = false;
        try {
            for (JMDelta delta : revision.getDeltas()) {
                JMChunk original = delta.getOriginal();
                JMChunk revised = delta.getRevised();
                if (original.getAnchor() + original.getSize() < firstLineFrom && revised.getAnchor() + revised.getSize() < firstLineTo) continue;
                if (original.getAnchor() <= lastLineFrom || revised.getAnchor() <= lastLineTo) {
                    Rectangle rect;
                    Polygon shape;
                    int selectionWidth;
                    boolean selected = delta == this.diffPanel.getSelectedDelta();
                    Color color = RevisionUtil.getColor(delta);
                    Color darkerColor = RevisionUtil.getDarkerColor(delta);
                    g2.setColor(color);
                    int fromLine = original.getAnchor();
                    int toLine = original.getAnchor() + original.getSize();
                    Rectangle viewportRect = viewportFrom.getViewRect();
                    offset = bdFrom.getOffsetForLine(fromLine);
                    if (offset < 0) continue;
                    Rectangle fromRect = editorFrom.modelToView(offset);
                    offset = bdFrom.getOffsetForLine(toLine);
                    if (offset < 0) continue;
                    Rectangle toRect = editorFrom.modelToView(offset);
                    int x = 0;
                    int y = fromRect.y - viewportRect.y + 1;
                    y = y < 0 ? 0 : y;
                    int width = 10;
                    int height = 0;
                    if (fromRect.y <= viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = toRect.y - viewportRect.y - 1;
                    } else if (fromRect.y > viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = viewportRect.y + viewportRect.height - fromRect.y - 1;
                    } else if (fromRect.y > viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = toRect.y - fromRect.y - 1;
                    } else if (fromRect.y <= viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = viewportRect.height - 1;
                    }
                    int x0 = x + width;
                    int y0 = y;
                    if (height > 0) {
                        g2.setColor(color);
                        g2.fillRect(x, y, width, height);
                    }
                    g2.setColor(darkerColor);
                    g2.drawLine(x, y, x + width, y);
                    if (height > 0) {
                        g2.drawLine(x + width, y, x + width, y + height);
                        g2.drawLine(x, y + height, x + width, y + height);
                    }
                    if (selected) {
                        x = x + width + 1;
                        selectionWidth = 5;
                        g2.setColor(Color.yellow);
                        g2.fillRect(x, y, selectionWidth, height);
                        g2.setColor(Color.yellow.darker());
                        g2.drawLine(x, y, x + selectionWidth, y);
                        if (height > 0) {
                            g2.drawLine(x + selectionWidth, y, x + selectionWidth, y + height);
                            g2.drawLine(x, y + height, x + selectionWidth, y + height);
                        }
                    }
                    fromLine = revised.getAnchor();
                    toLine = revised.getAnchor() + revised.getSize();
                    viewportRect = viewportTo.getViewRect();
                    offset = bdTo.getOffsetForLine(fromLine);
                    if (offset < 0) continue;
                    fromRect = editorTo.modelToView(offset);
                    offset = bdTo.getOffsetForLine(toLine);
                    if (offset < 0) continue;
                    toRect = editorTo.modelToView(offset);
                    x = bounds.x + bounds.width - 10;
                    y = fromRect.y - viewportRect.y + 1;
                    y = y < 0 ? 0 : y;
                    width = 10;
                    height = 0;
                    if (fromRect.y <= viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = toRect.y - viewportRect.y - 1;
                    } else if (fromRect.y > viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = viewportRect.y + viewportRect.height - fromRect.y - 1;
                    } else if (fromRect.y > viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = toRect.y - fromRect.y - 1;
                    } else if (fromRect.y <= viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = viewportRect.height - 1;
                    }
                    int x1 = x;
                    int y1 = y;
                    if (height > 0) {
                        g2.setColor(color);
                        g2.fillRect(x, y, width, height);
                    }
                    g2.setColor(darkerColor);
                    g2.drawLine(x, y, x + width, y);
                    if (height > 0) {
                        g2.drawLine(x, y, x, y + height);
                        g2.drawLine(x, y + height, x + width, y + height);
                    }
                    if (selected) {
                        selectionWidth = 5;
                        g2.setColor(Color.yellow);
                        g2.fillRect(x -= selectionWidth, y, selectionWidth, height);
                        g2.setColor(Color.yellow.darker());
                        g2.drawLine(x, y, x + selectionWidth, y);
                        if (height > 0) {
                            g2.drawLine(x, y, x, y + height);
                            g2.drawLine(x, y + height, x + selectionWidth, y + height);
                        }
                        g2.setColor(color);
                    }
                    g2.setColor(darkerColor);
                    g2.drawLine(x0, y0, x0 + 15, y0);
                    this.setAntiAlias(g2);
                    g2.drawLine(x0 + 15, y0, x1 - 15, y1);
                    this.resetAntiAlias(g2);
                    g2.drawLine(x1 - 15, y1, x1, y1);
                    if (!this.leftsideReadonly) {
                        shape = new Polygon();
                        shape.addPoint(x0, y0);
                        shape.addPoint(x0 + 11, y0 - 4);
                        shape.addPoint(x0 + 11, y0 + 4);
                        this.setAntiAlias(g2);
                        g2.setColor(color);
                        g2.fill(shape);
                        g2.setColor(darkerColor);
                        g2.draw(shape);
                        this.resetAntiAlias(g2);
                        this.commands.add(new DiffChangeCommand(shape, delta, this.toPanelIndex, this.fromPanelIndex));
                        if (original.getSize() > 0) {
                            g2.setColor(Color.red);
                            g2.drawLine(x0 + 3 - width, y0 + 3, x0 + 7 - width, y0 + 7);
                            g2.drawLine(x0 + 7 - width, y0 + 3, x0 + 3 - width, y0 + 7);
                            rect = new Rectangle(x0 + 2 - width, y0 + 2, 6, 6);
                            this.commands.add(new DiffDeleteCommand(rect, delta, this.fromPanelIndex, this.toPanelIndex));
                        }
                    }
                    if (this.rightsideReadonly) continue;
                    shape = new Polygon();
                    shape.addPoint(x1, y1);
                    shape.addPoint(x1 - 11, y1 - 4);
                    shape.addPoint(x1 - 11, y1 + 4);
                    this.setAntiAlias(g2);
                    g2.setColor(color);
                    g2.fillPolygon(shape);
                    g2.setColor(darkerColor);
                    g2.drawPolygon(shape);
                    this.resetAntiAlias(g2);
                    this.commands.add(new DiffChangeCommand(shape, delta, this.fromPanelIndex, this.toPanelIndex));
                    if (revised.getSize() <= 0) continue;
                    g2.setColor(Color.red);
                    g2.drawLine(x1 + 3, y1 + 3, x1 + 7, y1 + 7);
                    g2.drawLine(x1 + 7, y1 + 3, x1 + 3, y1 + 7);
                    rect = new Rectangle(x1 + 2, y1 + 2, 6, 6);
                    this.commands.add(new DiffDeleteCommand(rect, delta, this.toPanelIndex, this.fromPanelIndex));
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        this.resetAntiAlias(g2);
    }

    private void setAntiAlias(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void resetAntiAlias(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias);
    }

    private FilePanel getFromPanel() {
        return this.diffPanel.getFilePanel(this.fromPanelIndex);
    }

    private FilePanel getToPanel() {
        return this.diffPanel.getFilePanel(this.toPanelIndex);
    }

    abstract class Command {
        Rectangle bounds;
        JMDelta delta;
        int fromIndex;
        int toIndex;

        Command(Shape shape, JMDelta delta, int fromIndex, int toIndex) {
            this.bounds = shape.getBounds();
            this.delta = delta;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        boolean contains(double x, double y) {
            return this.bounds.contains(x, y);
        }

        public abstract void execute();
    }

    class DiffDeleteCommand
    extends Command {
        DiffDeleteCommand(Shape shape, JMDelta delta, int fromIndex, int toIndex) {
            super(shape, delta, fromIndex, toIndex);
        }

        public void execute() {
            DiffScrollComponent.this.diffPanel.setSelectedDelta(this.delta);
            DiffScrollComponent.this.diffPanel.runDelete(this.fromIndex, this.toIndex);
        }
    }

    class DiffChangeCommand
    extends Command {
        DiffChangeCommand(Shape shape, JMDelta delta, int fromIndex, int toIndex) {
            super(shape, delta, fromIndex, toIndex);
        }

        public void execute() {
            DiffScrollComponent.this.diffPanel.setSelectedDelta(this.delta);
            DiffScrollComponent.this.diffPanel.runChange(this.fromIndex, this.toIndex);
        }
    }
}

