/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import javax.swing.undo.CompoundEdit;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.FolderSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.FolderDiffForm;
import org.jmeld.ui.FolderDiffTreeTableModel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.UINode;
import org.jmeld.ui.action.ActionHandler;
import org.jmeld.ui.action.MeldAction;
import org.jmeld.ui.swing.table.JMTreeTableModel;
import org.jmeld.ui.util.Colors;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.SwingUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.file.cmd.AbstractCmd;
import org.jmeld.util.node.JMDiffNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderDiffPanel
extends FolderDiffForm
implements ConfigurationListenerIF {
    private JMeldPanel mainPanel;
    private FolderDiff diff;
    private ActionHandler actionHandler;
    private FolderDiffTreeTableModel treeTableModel;

    FolderDiffPanel(JMeldPanel mainPanel, FolderDiff diff) {
        this.mainPanel = mainPanel;
        this.diff = diff;
        this.init();
    }

    private void init() {
        this.actionHandler = new ActionHandler();
        this.hierarchyComboBox.setModel(new DefaultComboBoxModel<FolderSettings.FolderView>(FolderSettings.FolderView.values()));
        this.hierarchyComboBox.setSelectedItem((Object)this.getFolderSettings().getView());
        this.hierarchyComboBox.setFocusable(false);
        this.initActions();
        this.onlyRightButton.setText(null);
        this.onlyRightButton.setIcon(ImageUtil.getImageIcon("jmeld_only-right"));
        this.onlyRightButton.setFocusable(false);
        this.onlyRightButton.setSelected(this.getFolderSettings().getOnlyRight());
        this.leftRightChangedButton.setText(null);
        this.leftRightChangedButton.setIcon(ImageUtil.getImageIcon("jmeld_left-right-changed"));
        this.leftRightChangedButton.setFocusable(false);
        this.leftRightChangedButton.setSelected(this.getFolderSettings().getLeftRightChanged());
        this.onlyLeftButton.setText(null);
        this.onlyLeftButton.setIcon(ImageUtil.getImageIcon("jmeld_only-left"));
        this.onlyLeftButton.setFocusable(false);
        this.onlyLeftButton.setSelected(this.getFolderSettings().getOnlyLeft());
        this.leftRightUnChangedButton.setText(null);
        this.leftRightUnChangedButton.setIcon(ImageUtil.getImageIcon("jmeld_left-right-unchanged"));
        this.leftRightUnChangedButton.setFocusable(false);
        this.leftRightUnChangedButton.setSelected(this.getFolderSettings().getLeftRightUnChanged());
        this.expandAllButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.expandAllButton.setContentAreaFilled(false);
        this.expandAllButton.setText(null);
        this.expandAllButton.setIcon(ImageUtil.getSmallImageIcon("stock_expand-all"));
        this.expandAllButton.setPressedIcon(ImageUtil.createDarkerIcon((ImageIcon)this.expandAllButton.getIcon()));
        this.expandAllButton.setFocusable(false);
        this.collapseAllButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.collapseAllButton.setContentAreaFilled(false);
        this.collapseAllButton.setText(null);
        this.collapseAllButton.setIcon(ImageUtil.getSmallImageIcon("stock_collapse-all"));
        this.collapseAllButton.setPressedIcon(ImageUtil.createDarkerIcon((ImageIcon)this.collapseAllButton.getIcon()));
        this.collapseAllButton.setFocusable(false);
        this.folder1Label.init();
        this.folder1Label.setText(this.diff.getLeftFolderName(), this.diff.getRightFolderName());
        this.folder2Label.init();
        this.folder2Label.setText(this.diff.getRightFolderName(), this.diff.getLeftFolderName());
        this.treeTableModel = new FolderDiffTreeTableModel();
        this.folderTreeTable.setTreeTableModel(this.treeTableModel);
        this.treeTableModel.setRoot(this.getRootNode());
        this.folderTreeTable.setSelectionMode(2);
        this.folderTreeTable.setToggleClickCount(1);
        this.folderTreeTable.setTerminateEditOnFocusLost(false);
        this.folderTreeTable.setRowSelectionAllowed(true);
        this.folderTreeTable.addMouseListener(this.getMouseListener());
        this.folderTreeTable.expandAll();
        this.folderTreeTable.setHighlighters(new AlternateRowHighlighter(Color.white, Colors.getTableRowHighLighterColor(), Color.black));
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    private void initActions() {
        MeldAction action = this.actionHandler.createAction(this, "SelectNextRow");
        this.installKey("DOWN", action);
        action = this.actionHandler.createAction(this, "SelectPreviousRow");
        this.installKey("UP", action);
        action = this.actionHandler.createAction(this, "NextNode");
        this.installKey("RIGHT", action);
        action = this.actionHandler.createAction(this, "PreviousNode");
        this.installKey("LEFT", action);
        action = this.actionHandler.createAction(this, "OpenFileComparison");
        action.setIcon("stock_compare");
        this.compareButton.setAction(action);
        this.compareButton.setText(null);
        this.compareButton.setFocusable(false);
        this.compareButton.setDisabledIcon(action.getTransparentSmallImageIcon());
        this.installKey("ENTER", action);
        action = this.actionHandler.createAction(this, "OpenFileComparisonBackground");
        action.setIcon("stock_compare");
        this.installKey("alt ENTER", action);
        action = this.actionHandler.createAction(this, "ExpandAll");
        this.expandAllButton.setAction(action);
        action = this.actionHandler.createAction(this, "CollapseAll");
        this.collapseAllButton.setAction(action);
        action = this.actionHandler.createAction(this, "Refresh");
        action.setIcon("stock_refresh");
        this.refreshButton.setAction(action);
        this.refreshButton.setText(null);
        this.refreshButton.setFocusable(false);
        this.refreshButton.setDisabledIcon(action.getTransparentSmallImageIcon());
        action = this.actionHandler.createAction(this, "RemoveRight");
        action.setIcon("stock_delete");
        this.deleteRightButton.setAction(action);
        this.deleteRightButton.setText(null);
        this.deleteRightButton.setFocusable(false);
        this.deleteRightButton.setDisabledIcon(action.getTransparentSmallImageIcon());
        this.installKey("ctrl alt RIGHT", action);
        this.installKey("ctrl alt KP_RIGHT", action);
        action = this.actionHandler.createAction(this, "RemoveLeft");
        action.setIcon("stock_delete");
        this.deleteLeftButton.setAction(action);
        this.deleteLeftButton.setText(null);
        this.deleteLeftButton.setFocusable(false);
        this.deleteLeftButton.setDisabledIcon(action.getTransparentSmallImageIcon());
        this.installKey("ctrl alt LEFT", action);
        this.installKey("ctrl alt KP_LEFT", action);
        action = this.actionHandler.createAction(this, "CopyToLeft");
        action.setIcon("stock_left");
        this.copyToLeftButton.setAction(action);
        this.copyToLeftButton.setText(null);
        this.copyToLeftButton.setFocusable(false);
        this.copyToLeftButton.setDisabledIcon(action.getTransparentSmallImageIcon());
        this.installKey("alt LEFT", action);
        this.installKey("alt KP_LEFT", action);
        action = this.actionHandler.createAction(this, "CopyToRight");
        action.setIcon("stock_right");
        this.copyToRightButton.setAction(action);
        this.copyToRightButton.setText(null);
        this.copyToRightButton.setFocusable(false);
        this.copyToRightButton.setDisabledIcon(action.getTransparentSmallImageIcon());
        this.installKey("alt RIGHT", action);
        this.installKey("alt KP_RIGHT", action);
        action = this.actionHandler.createAction(this, "Filter");
        this.onlyRightButton.setAction(action);
        this.leftRightChangedButton.setAction(action);
        this.onlyLeftButton.setAction(action);
        this.leftRightUnChangedButton.setAction(action);
        this.hierarchyComboBox.setAction(action);
    }

    private void installKey(String key, MeldAction action) {
        SwingUtil.installKey(this.folderTreeTable, key, action);
    }

    public String getTitle() {
        return this.diff.getLeftFolderShortName() + " - " + this.diff.getRightFolderShortName();
    }

    private TreeTableNode getRootNode() {
        return this.filter(this.diff.getRootNode());
    }

    private TreeTableNode filter(JMDiffNode diffNode) {
        UINode rootNode;
        block9: {
            Object hierarchy;
            ArrayList<JMDiffNode> nodes;
            block10: {
                block8: {
                    nodes = new ArrayList<JMDiffNode>();
                    for (JMDiffNode node : this.diff.getNodes()) {
                        if (!node.isLeaf()) continue;
                        if (node.isCompareEqual(JMDiffNode.Compare.Equal)) {
                            if (!this.leftRightUnChangedButton.isSelected()) continue;
                            nodes.add(node);
                            continue;
                        }
                        if (node.isCompareEqual(JMDiffNode.Compare.NotEqual)) {
                            if (!this.leftRightChangedButton.isSelected()) continue;
                            nodes.add(node);
                            continue;
                        }
                        if (node.isCompareEqual(JMDiffNode.Compare.RightMissing)) {
                            if (!this.onlyLeftButton.isSelected()) continue;
                            nodes.add(node);
                            continue;
                        }
                        if (!node.isCompareEqual(JMDiffNode.Compare.LeftMissing) || !this.onlyRightButton.isSelected()) continue;
                        nodes.add(node);
                    }
                    rootNode = new UINode(this.treeTableModel, "<root>", false);
                    hierarchy = this.hierarchyComboBox.getSelectedItem();
                    if (hierarchy != FolderSettings.FolderView.packageView) break block8;
                    for (JMDiffNode node : nodes) {
                        JMDiffNode parent = node.getParent();
                        UINode uiNode = new UINode(this.treeTableModel, node);
                        if (parent != null) {
                            String parentName = parent.getName();
                            UINode uiParentNode = new UINode(this.treeTableModel, parent);
                            uiParentNode = rootNode.addChild(uiParentNode);
                            uiParentNode.addChild(uiNode);
                            continue;
                        }
                        rootNode.addChild(uiNode);
                    }
                    break block9;
                }
                if (hierarchy != FolderSettings.FolderView.fileView) break block10;
                for (JMDiffNode node : nodes) {
                    rootNode.addChild(new UINode(this.treeTableModel, node));
                }
                break block9;
            }
            if (hierarchy != FolderSettings.FolderView.directoryView) break block9;
            for (JMDiffNode node : nodes) {
                this.addDirectoryViewNode(rootNode, node);
            }
        }
        return rootNode;
    }

    private void addDirectoryViewNode(UINode rootNode, JMDiffNode node) {
        ArrayList<JMDiffNode> uiNodes = new ArrayList<JMDiffNode>();
        do {
            uiNodes.add(node);
        } while ((node = node.getParent()) != null);
        Collections.reverse(uiNodes);
        UINode parent = rootNode;
        for (int i = 1; i < uiNodes.size(); ++i) {
            JMDiffNode uiNode = (JMDiffNode)uiNodes.get(i);
            parent = parent.addChild(new UINode(this.treeTableModel, uiNode));
        }
    }

    public void doSelectPreviousRow(ActionEvent ae) {
        int row = this.folderTreeTable.getSelectedRow() - 1;
        row = row < 0 ? this.folderTreeTable.getRowCount() - 1 : row;
        this.folderTreeTable.setRowSelectionInterval(row, row);
        this.folderTreeTable.scrollRowToVisible(row);
    }

    public void doSelectNextRow(ActionEvent ae) {
        int row = this.folderTreeTable.getSelectedRow() + 1;
        row = row >= this.folderTreeTable.getRowCount() ? 0 : row;
        this.folderTreeTable.setRowSelectionInterval(row, row);
        this.folderTreeTable.scrollRowToVisible(row);
    }

    public void doNextNode(ActionEvent ae) {
        int row = this.folderTreeTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (this.folderTreeTable.isCollapsed(row)) {
            this.folderTreeTable.expandRow(row);
        }
        this.doSelectNextRow(ae);
    }

    public void doPreviousNode(ActionEvent ae) {
        int row = this.folderTreeTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (this.folderTreeTable.isExpanded(row)) {
            this.folderTreeTable.collapseRow(row);
        }
        this.doSelectPreviousRow(ae);
    }

    public void doOpenFileComparisonBackground(ActionEvent ae) {
        this.doOpenFileComparison(ae, true);
    }

    public void doOpenFileComparison(ActionEvent ae) {
        this.doOpenFileComparison(ae, false);
    }

    private void doOpenFileComparison(ActionEvent ae, boolean background) {
        for (UINode uiNode : this.getSelectedUINodes()) {
            this.mainPanel.openFileComparison(uiNode.getDiffNode(), background);
        }
    }

    @Override
    public boolean checkExit() {
        return false;
    }

    public void doExpandAll(ActionEvent ae) {
        this.folderTreeTable.expandAll();
    }

    public void doCollapseAll(ActionEvent ae) {
        this.folderTreeTable.collapseAll();
    }

    public boolean isCopyToLeftEnabled() {
        return !this.getEditorSettings().getLeftsideReadonly();
    }

    public void doCopyToLeft(ActionEvent ae) {
        CompoundCommand cc = new CompoundCommand();
        for (UINode uiNode : this.getSelectedUINodes()) {
            try {
                cc.add(uiNode, uiNode.getDiffNode().getCopyToLeftCmd());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        cc.execute();
    }

    public boolean isCopyToRightEnabled() {
        return !this.getEditorSettings().getRightsideReadonly();
    }

    public void doCopyToRight(ActionEvent ae) {
        CompoundCommand cc = new CompoundCommand();
        for (UINode uiNode : this.getSelectedUINodes()) {
            try {
                cc.add(uiNode, uiNode.getDiffNode().getCopyToRightCmd());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        cc.execute();
    }

    public void doRefresh(ActionEvent ae) {
        new RefreshAction().execute();
    }

    public boolean isRemoveRightEnabled() {
        return !this.getEditorSettings().getRightsideReadonly();
    }

    public void doRemoveRight(ActionEvent ae) {
        CompoundCommand cc = new CompoundCommand();
        for (UINode uiNode : this.getSelectedUINodes()) {
            try {
                cc.add(uiNode, uiNode.getDiffNode().getRemoveRightCmd());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        cc.execute();
    }

    public boolean isRemoveLeftEnabled() {
        return !this.getEditorSettings().getLeftsideReadonly();
    }

    public void doRemoveLeft(ActionEvent ae) {
        CompoundCommand cc = new CompoundCommand();
        for (UINode uiNode : this.getSelectedUINodes()) {
            try {
                cc.add(uiNode, uiNode.getDiffNode().getRemoveLeftCmd());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        cc.execute();
    }

    public void doFilter(ActionEvent ae) {
        ((JMTreeTableModel)this.folderTreeTable.getTreeTableModel()).setRoot(this.getRootNode());
        this.folderTreeTable.expandAll();
    }

    private EditorSettings getEditorSettings() {
        return JMeldSettings.getInstance().getEditor();
    }

    private FolderSettings getFolderSettings() {
        return JMeldSettings.getInstance().getFolder();
    }

    private Set<UINode> getSelectedUINodes() {
        HashSet<UINode> result = new HashSet<UINode>();
        for (int row : this.folderTreeTable.getSelectedRows()) {
            UINode uiNode;
            TreePath path = this.folderTreeTable.getPathForRow(row);
            if (path == null || (uiNode = (UINode)path.getLastPathComponent()) == null) continue;
            this.buildResult(result, uiNode);
        }
        return result;
    }

    private void buildResult(Set<UINode> result, UINode uiNode) {
        if (uiNode.isLeaf() && uiNode.getDiffNode() != null) {
            result.add(uiNode);
            return;
        }
        for (UINode node : uiNode.getChildren()) {
            this.buildResult(result, node);
        }
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                boolean open;
                boolean background = me.getClickCount() == 1 && me.getButton() == 2;
                boolean bl = open = me.getClickCount() == 2 || background;
                if (open) {
                    int row = ((JTable)me.getSource()).rowAtPoint(me.getPoint());
                    TreePath path = FolderDiffPanel.this.folderTreeTable.getPathForRow(row);
                    if (path == null) {
                        return;
                    }
                    UINode uiNode = (UINode)path.getLastPathComponent();
                    if (uiNode == null) {
                        return;
                    }
                    JMDiffNode diffNode = uiNode.getDiffNode();
                    if (diffNode == null) {
                        return;
                    }
                    FolderDiffPanel.this.mainPanel.openFileComparison(diffNode, background);
                    if (FolderDiffPanel.this.folderTreeTable.getSelectedRow() != row) {
                        FolderDiffPanel.this.folderTreeTable.setRowSelectionInterval(row, row);
                    }
                    FolderDiffPanel.this.folderTreeTable.requestFocus();
                }
            }
        };
    }

    @Override
    public void configurationChanged() {
        this.actionHandler.checkActions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RefreshAction
    extends SwingWorker<String, Object> {
        RefreshAction() {
        }

        @Override
        public String doInBackground() {
            FolderDiffPanel.this.diff.refresh();
            return null;
        }

        @Override
        protected void done() {
            FolderDiffPanel.this.treeTableModel = new FolderDiffTreeTableModel();
            FolderDiffPanel.this.folderTreeTable.setTreeTableModel(FolderDiffPanel.this.treeTableModel);
            FolderDiffPanel.this.treeTableModel.setRoot(FolderDiffPanel.this.getRootNode());
            FolderDiffPanel.this.folderTreeTable.expandAll();
        }
    }

    class CompoundCommand
    extends CompoundEdit {
        List<AbstractCmd> cmds;
        Map<AbstractCmd, UINode> uiNodeMap = new HashMap<AbstractCmd, UINode>();

        CompoundCommand() {
            this.cmds = new ArrayList<AbstractCmd>();
        }

        void add(UINode uiNode, AbstractCmd cmd) {
            if (cmd == null) {
                return;
            }
            this.uiNodeMap.put(cmd, uiNode);
            this.cmds.add(cmd);
        }

        void execute() {
            try {
                for (AbstractCmd cmd : this.cmds) {
                    cmd.execute();
                    this.addEdit(cmd);
                }
                this.end();
                FolderDiffPanel.this.getUndoHandler().add(this);
                this.compareContents();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.check();
        }

        public void redo() {
            super.redo();
            this.compareContents();
            this.check();
        }

        public void undo() {
            super.undo();
            this.compareContents();
            this.check();
        }

        private void check() {
            FolderDiffPanel.this.mainPanel.checkActions();
            FolderDiffPanel.this.repaint();
        }

        private void compareContents() {
            for (AbstractCmd cmd : this.cmds) {
                this.uiNodeMap.get(cmd).getDiffNode().compareContents();
            }
        }
    }
}

