/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.NavigatorView;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingworker.SwingWorker;
import org.jmeld.Version;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.settings.util.Filter;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FolderDiffPanel;
import org.jmeld.ui.JMeldContentPanelIF;
import org.jmeld.ui.NewPanelDialog;
import org.jmeld.ui.StatusBar;
import org.jmeld.ui.action.ActionHandler;
import org.jmeld.ui.action.MeldAction;
import org.jmeld.ui.search.SearchBar;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.settings.SettingsPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.SwingUtil;
import org.jmeld.ui.util.TabExitEvent;
import org.jmeld.ui.util.TabExitListenerIF;
import org.jmeld.ui.util.TabIcon;
import org.jmeld.ui.util.ToolBarBuilder;
import org.jmeld.ui.util.WidgetFactory;
import org.jmeld.util.StringUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.file.DirectoryDiff;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.node.JMDiffNode;
import org.jmeld.util.node.JMDiffNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeldPanel
extends JPanel
implements ConfigurationListenerIF {
    private static final String NEW_ACTION = "New";
    private static final String SAVE_ACTION = "Save";
    private static final String UNDO_ACTION = "Undo";
    private static final String REDO_ACTION = "Redo";
    private static final String RIGHT_ACTION = "Right";
    private static final String LEFT_ACTION = "Left";
    private static final String UP_ACTION = "Up";
    private static final String DOWN_ACTION = "Down";
    private static final String ZOOMPLUS_ACTION = "ZoomPlus";
    private static final String ZOOMMIN_ACTION = "ZoomMin";
    private static final String GOTOSELECTED_ACTION = "GoToSelected";
    private static final String GOTOFIRST_ACTION = "GoToFirst";
    private static final String GOTOLAST_ACTION = "GoToLast";
    private static final String STARTSEARCH_ACTION = "StartSearch";
    private static final String STOPSEARCH_ACTION = "StopSearch";
    private static final String NEXTSEARCH_ACTION = "NextSearch";
    private static final String PREVIOUSSEARCH_ACTION = "PreviousSearch";
    private static final String REFRESH_ACTION = "Refresh";
    private static final String MERGEMODE_ACTION = "MergeMode";
    private static final String HELP_ACTION = "Help";
    private static final String ABOUT_ACTION = "About";
    private static final String SETTINGS_ACTION = "Settings";
    private static final String EXIT_ACTION = "Exit";
    private ActionHandler actionHandler;
    private JTabbedPane tabbedPane;
    private JPanel bar;
    private SearchBar searchBar;
    private boolean mergeMode;

    public JMeldPanel() {
        this.setFocusable(true);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFocusable(false);
        this.initActions();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolBar(), "First");
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.getBar(), "Last");
        this.tabbedPane.getModel().addChangeListener(this.getChangeListener());
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    public void openComparison(List<String> fileNameList) {
        if (fileNameList.size() < 2) {
            return;
        }
        for (int i = 1; i < fileNameList.size(); ++i) {
            this.openComparison(fileNameList.get(0), fileNameList.get(i));
        }
    }

    public void openComparison(String leftName, String rightName) {
        if (!StringUtil.isEmpty(leftName) && !StringUtil.isEmpty(rightName)) {
            File leftFile = new File(leftName);
            File rightFile = new File(rightName);
            if (leftFile.isDirectory()) {
                if (rightFile.isDirectory()) {
                    this.openDirectoryComparison(leftFile, rightFile, JMeldSettings.getInstance().getFilter().getFilter("default"));
                } else {
                    this.openFileComparison(new File(leftFile, rightName), rightFile, false);
                }
            } else {
                this.openFileComparison(leftFile, rightFile, false);
            }
        }
    }

    public void openFileComparison(File leftFile, File rightFile, boolean openInBackground) {
        new NewFileComparisonPanel(leftFile, rightFile, openInBackground).execute();
    }

    public void openFileComparison(JMDiffNode diffNode, boolean openInBackground) {
        new NewFileComparisonPanel(diffNode, openInBackground).execute();
    }

    public void openDirectoryComparison(File leftFile, File rightFile, Filter filter) {
        new NewDirectoryComparisonPanel(leftFile, rightFile, filter).execute();
    }

    private JComponent getToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        ToolBarBuilder builder = new ToolBarBuilder(toolBar);
        JButton button = WidgetFactory.getToolBarButton(this.actionHandler.get(NEW_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(SAVE_ACTION));
        builder.addButton(button);
        builder.addSeparator();
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(UNDO_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(REDO_ACTION));
        builder.addButton(button);
        builder.addSpring();
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(SETTINGS_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(HELP_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(ABOUT_ACTION));
        builder.addButton(button);
        return toolBar;
    }

    private JComponent getBar() {
        CellConstraints cc = new CellConstraints();
        this.bar = new JPanel(new FormLayout("0:grow", "pref, pref, pref"));
        this.bar.add((Component)new JSeparator(), cc.xy(1, 2));
        this.bar.add((Component)StatusBar.getInstance(), cc.xy(1, 3));
        return this.bar;
    }

    private SearchBar getSearchBar() {
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this);
        }
        return this.searchBar;
    }

    public void initActions() {
        this.actionHandler = new ActionHandler();
        MeldAction action = this.actionHandler.createAction(this, NEW_ACTION);
        action.setIcon("stock_new");
        action.setToolTip("Merge 2 new files");
        action = this.actionHandler.createAction(this, SAVE_ACTION);
        action.setIcon("stock_save");
        action.setToolTip("Save the changed files");
        this.installKey("ctrl S", action);
        action = this.actionHandler.createAction(this, UNDO_ACTION);
        action.setIcon("stock_undo");
        action.setToolTip("Undo the latest change");
        this.installKey("control Z", action);
        this.installKey("control Y", action);
        action = this.actionHandler.createAction(this, REDO_ACTION);
        action.setIcon("stock_redo");
        action.setToolTip("Redo the latest change");
        this.installKey("control R", action);
        action = this.actionHandler.createAction(this, LEFT_ACTION);
        this.installKey("LEFT", action);
        this.installKey("alt LEFT", action);
        this.installKey("alt KP_LEFT", action);
        action = this.actionHandler.createAction(this, RIGHT_ACTION);
        this.installKey("RIGHT", action);
        this.installKey("alt RIGHT", action);
        this.installKey("alt KP_RIGHT", action);
        action = this.actionHandler.createAction(this, UP_ACTION);
        this.installKey("UP", action);
        this.installKey("alt UP", action);
        this.installKey("alt KP_UP", action);
        this.installKey("F7", action);
        action = this.actionHandler.createAction(this, DOWN_ACTION);
        this.installKey("DOWN", action);
        this.installKey("alt DOWN", action);
        this.installKey("alt KP_DOWN", action);
        this.installKey("F8", action);
        action = this.actionHandler.createAction(this, ZOOMPLUS_ACTION);
        this.installKey("alt EQUALS", action);
        this.installKey("shift alt EQUALS", action);
        this.installKey("alt ADD", action);
        action = this.actionHandler.createAction(this, ZOOMMIN_ACTION);
        this.installKey("alt MINUS", action);
        this.installKey("shift alt MINUS", action);
        this.installKey("alt SUBTRACT", action);
        action = this.actionHandler.createAction(this, GOTOSELECTED_ACTION);
        this.installKey("alt ENTER", action);
        action = this.actionHandler.createAction(this, GOTOFIRST_ACTION);
        this.installKey("alt HOME", action);
        action = this.actionHandler.createAction(this, GOTOLAST_ACTION);
        this.installKey("alt END", action);
        action = this.actionHandler.createAction(this, STARTSEARCH_ACTION);
        this.installKey("ctrl F", action);
        action = this.actionHandler.createAction(this, NEXTSEARCH_ACTION);
        this.installKey("F3", action);
        this.installKey("ctrl G", action);
        action = this.actionHandler.createAction(this, PREVIOUSSEARCH_ACTION);
        this.installKey("shift F3", action);
        action = this.actionHandler.createAction(this, REFRESH_ACTION);
        this.installKey("F5", action);
        action = this.actionHandler.createAction(this, MERGEMODE_ACTION);
        this.installKey("F9", action);
        action = this.actionHandler.createAction(this, HELP_ACTION);
        action.setIcon("stock_help-agent");
        this.installKey("F1", action);
        action = this.actionHandler.createAction(this, ABOUT_ACTION);
        action.setIcon("stock_about");
        action = this.actionHandler.createAction(this, SETTINGS_ACTION);
        action.setIcon("stock_preferences");
        action.setToolTip(SETTINGS_ACTION);
        action = this.actionHandler.createAction(this, EXIT_ACTION);
        this.installKey("ESCAPE", action);
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public void checkActions() {
        if (this.actionHandler != null) {
            this.actionHandler.checkActions();
        }
    }

    public void doNew(ActionEvent ae) {
        NewPanelDialog dialog = new NewPanelDialog(this);
        dialog.show();
        if (dialog.getValue().equals(NewPanelDialog.FILE_COMPARISON)) {
            this.openFileComparison(new File(dialog.getLeftFileName()), new File(dialog.getRightFileName()), false);
        } else if (dialog.getValue().equals(NewPanelDialog.DIRECTORY_COMPARISON)) {
            this.openDirectoryComparison(new File(dialog.getLeftDirectoryName()), new File(dialog.getRightDirectoryName()), dialog.getFilter());
        }
    }

    public void doSave(ActionEvent ae) {
        this.getCurrentContentPanel().doSave();
    }

    public boolean isSaveEnabled() {
        JMeldContentPanelIF panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isSaveEnabled();
    }

    public void doUndo(ActionEvent ae) {
        this.getCurrentContentPanel().doUndo();
    }

    public boolean isUndoEnabled() {
        JMeldContentPanelIF panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isUndoEnabled();
    }

    public void doRedo(ActionEvent ae) {
        this.getCurrentContentPanel().doRedo();
    }

    public boolean isRedoEnabled() {
        JMeldContentPanelIF panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isRedoEnabled();
    }

    public boolean isLeftEnabled() {
        return !JMeldSettings.getInstance().getEditor().getLeftsideReadonly();
    }

    public void doLeft(ActionEvent ae) {
        this.getCurrentContentPanel().doLeft();
        this.repaint();
    }

    public boolean isRightEnabled() {
        return !JMeldSettings.getInstance().getEditor().getRightsideReadonly();
    }

    public void doRight(ActionEvent ae) {
        this.getCurrentContentPanel().doRight();
        this.repaint();
    }

    public void doUp(ActionEvent ae) {
        this.getCurrentContentPanel().doUp();
        this.repaint();
    }

    public void doDown(ActionEvent ae) {
        this.getCurrentContentPanel().doDown();
        this.repaint();
    }

    public void doZoomPlus(ActionEvent ae) {
        this.getCurrentContentPanel().doZoom(true);
        this.repaint();
    }

    public void doZoomMin(ActionEvent ae) {
        this.getCurrentContentPanel().doZoom(false);
        this.repaint();
    }

    public void doGoToSelected(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToSelected();
        this.repaint();
    }

    public void doGoToFirst(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToFirst();
        this.repaint();
    }

    public void doGoToLast(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToLast();
        this.repaint();
    }

    public void doStartSearch(ActionEvent ae) {
        SearchBar sb = this.getSearchBar();
        CellConstraints cc = new CellConstraints();
        this.bar.add((Component)sb, cc.xy(1, 1));
        sb.activate();
        this.bar.revalidate();
    }

    public void doStopSearch(ActionEvent ae) {
        CellConstraints cc = new CellConstraints();
        this.bar.remove(this.getSearchBar());
        this.bar.revalidate();
    }

    public SearchHits doSearch(ActionEvent ae) {
        return this.getCurrentContentPanel().doSearch(this.searchBar.getCommand());
    }

    public void doNextSearch(ActionEvent ae) {
        this.getCurrentContentPanel().doNextSearch();
    }

    public void doPreviousSearch(ActionEvent ae) {
        this.getCurrentContentPanel().doPreviousSearch();
    }

    public void doRefresh(ActionEvent ae) {
        this.getCurrentContentPanel().doRefresh();
    }

    public void doMergeMode(ActionEvent ae) {
        this.mergeMode = !this.mergeMode;
        MeldAction action = this.actionHandler.get(LEFT_ACTION);
        this.installKey(this.mergeMode, "LEFT", action);
        action = this.actionHandler.get(RIGHT_ACTION);
        this.installKey(this.mergeMode, "RIGHT", action);
        action = this.actionHandler.get(UP_ACTION);
        this.installKey(this.mergeMode, "UP", action);
        action = this.actionHandler.get(DOWN_ACTION);
        this.installKey(this.mergeMode, "DOWN", action);
        this.getCurrentContentPanel().doMergeMode(this.mergeMode);
        this.requestFocus();
        if (this.mergeMode) {
            StatusBar.getInstance().setNotification(MERGEMODE_ACTION, ImageUtil.getSmallImageIcon("jmeld_mergemode-on"));
        } else {
            StatusBar.getInstance().removeNotification(MERGEMODE_ACTION);
        }
    }

    public void doHelp(ActionEvent ae) {
        try {
            URL url = HelpSet.findHelpSet(this.getClass().getClassLoader(), "jmeld");
            HelpSet helpSet = new HelpSet(this.getClass().getClassLoader(), url);
            JHelpContentViewer viewer = new JHelpContentViewer(helpSet);
            NavigatorView navigatorView = helpSet.getNavigatorView("TOC");
            JHelpNavigator navigator = (JHelpNavigator)navigatorView.createNavigator(viewer.getModel());
            JSplitPane splitPane = new JSplitPane();
            splitPane.setLeftComponent(navigator);
            splitPane.setRightComponent(viewer);
            AbstractContentPanel content = new AbstractContentPanel();
            content.setLayout(new BorderLayout());
            content.add((Component)splitPane, "Center");
            this.tabbedPane.add((Component)content, this.getTabIcon("stock_help-agent", HELP_ACTION));
            this.tabbedPane.setSelectedComponent(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doAbout(ActionEvent ae) {
        AbstractContentPanel content = new AbstractContentPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)new JButton("JMeld version: " + Version.getVersion()), "Center");
        this.tabbedPane.add((Component)content, this.getTabIcon("stock_about", ABOUT_ACTION));
        this.tabbedPane.setSelectedComponent(content);
    }

    public void doExit(ActionEvent ae) {
        if (this.getSearchBar().getParent() != null) {
            this.doStopSearch(ae);
            return;
        }
        JMeldContentPanelIF cp = this.getCurrentContentPanel();
        if (cp == null) {
            return;
        }
        if (!cp.checkExit()) {
            return;
        }
        this.doExitTab((Component)((Object)this.getCurrentContentPanel()));
    }

    public void doSettings(ActionEvent ae) {
        SettingsPanel content = new SettingsPanel(this);
        this.tabbedPane.add((Component)content, this.getTabIcon("stock_preferences", SETTINGS_ACTION));
        this.tabbedPane.setSelectedComponent(content);
    }

    private ChangeListener getChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JMeldPanel.this.checkActions();
            }
        };
    }

    public WindowListener getWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                for (int i = 0; i < JMeldPanel.this.tabbedPane.getTabCount(); ++i) {
                    JMeldContentPanelIF contentPanel = (JMeldContentPanelIF)((Object)JMeldPanel.this.tabbedPane.getComponentAt(i));
                    if (contentPanel.checkSave()) continue;
                    return;
                }
                System.exit(1);
            }
        };
    }

    private JMeldContentPanelIF getCurrentContentPanel() {
        return (JMeldContentPanelIF)((Object)this.tabbedPane.getSelectedComponent());
    }

    private void installKey(boolean enabled, String key, MeldAction action) {
        if (!enabled) {
            this.deInstallKey(key, action);
        } else {
            this.installKey(key, action);
        }
    }

    private void installKey(String key, MeldAction action) {
        SwingUtil.installKey(this, key, action);
    }

    private void deInstallKey(String key, MeldAction action) {
        SwingUtil.deInstallKey(this, key, action);
    }

    private TabIcon getTabIcon(String iconName, String text) {
        TabIcon icon = new TabIcon(ImageUtil.getSmallImageIcon(iconName), text);
        icon.addExitListener(this.getTabExitListener());
        return icon;
    }

    private TabExitListenerIF getTabExitListener() {
        return new TabExitListenerIF(){

            public boolean doExit(TabExitEvent te) {
                int tabIndex = te.getTabIndex();
                if (tabIndex == -1) {
                    return false;
                }
                return JMeldPanel.this.doExitTab(JMeldPanel.this.tabbedPane.getComponentAt(tabIndex));
            }
        };
    }

    private boolean doExitTab(Component component) {
        AbstractContentPanel content;
        if (component == null) {
            return false;
        }
        int index = this.tabbedPane.indexOfComponent(component);
        if (index == -1) {
            return false;
        }
        if (component instanceof AbstractContentPanel && !(content = (AbstractContentPanel)component).checkSave()) {
            return false;
        }
        Icon icon = this.tabbedPane.getIconAt(index);
        if (icon != null && icon instanceof TabIcon) {
            ((TabIcon)icon).exit();
        }
        this.tabbedPane.remove(component);
        return true;
    }

    @Override
    public void configurationChanged() {
        this.checkActions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NewDirectoryComparisonPanel
    extends SwingWorker<String, Object> {
        private File leftFile;
        private File rightFile;
        private Filter filter;
        private DirectoryDiff diff;

        NewDirectoryComparisonPanel(File leftFile, File rightFile, Filter filter) {
            this.leftFile = leftFile;
            this.rightFile = rightFile;
            this.filter = filter;
        }

        @Override
        public String doInBackground() {
            if (StringUtil.isEmpty(this.leftFile.getName())) {
                return "left directoryName is empty";
            }
            if (!this.leftFile.exists()) {
                return "left directoryName(" + this.leftFile.getName() + ") doesn't exist";
            }
            if (!this.leftFile.isDirectory()) {
                return "left directoryName(" + this.leftFile.getName() + ") is not a directory";
            }
            if (StringUtil.isEmpty(this.rightFile.getName())) {
                return "right directoryName is empty";
            }
            if (!this.rightFile.exists()) {
                return "right directoryName(" + this.rightFile.getName() + ") doesn't exist";
            }
            if (!this.rightFile.isDirectory()) {
                return "right directoryName(" + this.rightFile.getName() + ") is not a directory";
            }
            this.diff = new DirectoryDiff(this.leftFile, this.rightFile, this.filter, FolderDiff.Mode.TWO_WAY);
            this.diff.diff();
            return null;
        }

        @Override
        protected void done() {
            try {
                String result = (String)this.get();
                if (result != null) {
                    JOptionPane.showMessageDialog(JMeldPanel.this, result, "Error opening file", 0);
                }
                FolderDiffPanel panel = new FolderDiffPanel(JMeldPanel.this, this.diff);
                JMeldPanel.this.tabbedPane.add((Component)panel, JMeldPanel.this.getTabIcon("stock_folder", panel.getTitle()));
                JMeldPanel.this.tabbedPane.setSelectedComponent(panel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NewFileComparisonPanel
    extends SwingWorker<String, Object> {
        private JMDiffNode diffNode;
        private File leftFile;
        private File rightFile;
        private boolean openInBackground;
        private BufferDiffPanel panel;

        NewFileComparisonPanel(JMDiffNode diffNode, boolean openInBackground) {
            this.diffNode = diffNode;
            this.openInBackground = openInBackground;
        }

        NewFileComparisonPanel(File leftFile, File rightFile, boolean openInBackground) {
            this.leftFile = leftFile;
            this.rightFile = rightFile;
            this.openInBackground = openInBackground;
        }

        @Override
        public String doInBackground() {
            try {
                if (this.diffNode == null) {
                    if (StringUtil.isEmpty(this.leftFile.getName())) {
                        return "left filename is empty";
                    }
                    if (!this.leftFile.exists()) {
                        return "left filename(" + this.leftFile.getName() + ") doesn't exist";
                    }
                    if (StringUtil.isEmpty(this.rightFile.getName())) {
                        return "right filename is empty";
                    }
                    if (!this.rightFile.exists()) {
                        return "right filename(" + this.rightFile.getName() + ") doesn't exist";
                    }
                    this.diffNode = JMDiffNodeFactory.create(this.leftFile.getName(), this.leftFile, this.rightFile.getName(), this.rightFile);
                }
                this.diffNode.diff();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                String result = (String)this.get();
                if (result != null) {
                    JOptionPane.showMessageDialog(JMeldPanel.this, result, "Error opening file", 0);
                } else {
                    this.panel = new BufferDiffPanel(JMeldPanel.this);
                    this.panel.setDiffNode(this.diffNode);
                    JMeldPanel.this.tabbedPane.add((Component)this.panel, JMeldPanel.this.getTabIcon("stock_new", this.panel.getTitle()));
                    if (!this.openInBackground) {
                        JMeldPanel.this.tabbedPane.setSelectedComponent(this.panel);
                    }
                    this.panel.doGoToFirst();
                    this.panel.repaint();
                    SwingUtilities.invokeLater(this.getDoGoToFirst());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private Runnable getDoGoToFirst() {
            return new Runnable(){

                public void run() {
                    NewFileComparisonPanel.this.panel.doGoToFirst();
                    NewFileComparisonPanel.this.panel.repaint();
                }
            };
        }
    }
}

