/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.util.RevisionUtil;

public class RevisionBar
extends JComponent {
    private BufferDiffPanel diffPanel;
    private FilePanel filePanel;
    private boolean original;

    public RevisionBar(BufferDiffPanel diffPanel, FilePanel filePanel, boolean original) {
        this.diffPanel = diffPanel;
        this.filePanel = filePanel;
        this.original = original;
        this.setBorder(BorderFactory.createLineBorder(UIManager.getColor("controlShadow")));
        this.addMouseListener(this.getMouseListener());
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                Rectangle r = RevisionBar.this.getDrawableRectangle();
                if (r == null) {
                    return;
                }
                if (r.height <= 0) {
                    return;
                }
                int y = me.getY() - r.y;
                JMRevision revision = RevisionBar.this.diffPanel.getCurrentRevision();
                if (revision == null) {
                    return;
                }
                int numberOfLines = RevisionBar.this.getNumberOfLines(revision);
                int line = y * numberOfLines / r.height;
                if (line > numberOfLines) {
                    line = numberOfLines;
                }
                if (line < 0) {
                    line = 0;
                }
                int lineBefore = (y - 3) * numberOfLines / r.height;
                int lineAfter = (y + 3) * numberOfLines / r.height;
                for (JMDelta delta : revision.getDeltas()) {
                    JMChunk original = delta.getOriginal();
                    if (original.getAnchor() <= lineBefore || original.getAnchor() >= lineAfter) continue;
                    RevisionBar.this.diffPanel.doGotoDelta(delta);
                    return;
                }
                RevisionBar.this.diffPanel.doGotoLine(line);
            }
        };
    }

    private Rectangle getDrawableRectangle() {
        JScrollBar sb = this.filePanel.getScrollPane().getVerticalScrollBar();
        Rectangle r = sb.getBounds();
        r.x = 0;
        r.y = 0;
        for (Component c : sb.getComponents()) {
            if (!(c instanceof AbstractButton)) continue;
            r.y += c.getHeight();
            r.height -= 2 * c.getHeight();
            break;
        }
        return r;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clipBounds = g.getClipBounds();
        Rectangle r = this.getDrawableRectangle();
        r.x = clipBounds.x;
        r.width = clipBounds.width;
        g2.setColor(Color.white);
        g2.fill(r);
        JMRevision revision = this.diffPanel.getCurrentRevision();
        if (revision == null) {
            return;
        }
        int numberOfLines = this.getNumberOfLines(revision);
        if (numberOfLines <= 0) {
            return;
        }
        for (JMDelta delta : revision.getDeltas()) {
            JMChunk chunk = this.original ? delta.getOriginal() : delta.getRevised();
            g.setColor(RevisionUtil.getColor(delta));
            int y = r.y + r.height * chunk.getAnchor() / numberOfLines;
            int height = r.height * chunk.getSize() / numberOfLines;
            if (height <= 0) {
                height = 1;
            }
            g.fillRect(0, y, r.width, height);
        }
    }

    private int getNumberOfLines(JMRevision revision) {
        return this.original ? revision.getOrgSize() : revision.getRevSize();
    }
}

