/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.search;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.search.SearchCommand;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.StringUtil;

public class SearchBar
extends JPanel {
    private static final String CP_FOREGROUND = "JMeld.foreground";
    private static final String CP_BACKGROUND = "JMeld.background";
    private JMeldPanel meldPanel;
    private JTextField searchField;
    private JLabel searchResult;
    private Timer timer;

    public SearchBar(JMeldPanel meldPanel) {
        this.meldPanel = meldPanel;
        this.init();
    }

    private void init() {
        this.setLayout(new FlowLayout(3));
        JButton closeButton = new JButton(ImageUtil.getImageIcon("jmeld_close"));
        closeButton.setRolloverIcon(ImageUtil.getImageIcon("jmeld_close-rollover"));
        closeButton.setPressedIcon(ImageUtil.getImageIcon("jmeld_close-pressed"));
        closeButton.addActionListener(this.getCloseAction());
        this.initButton(closeButton);
        closeButton.setBorder(null);
        this.searchField = new JTextField(15);
        this.searchField.getDocument().addDocumentListener(this.getSearchAction());
        this.searchField.addKeyListener(this.getSearchKeyAction());
        JButton previousButton = new JButton("Previous", ImageUtil.getImageIcon("stock_data-previous"));
        previousButton.addActionListener(this.getPreviousAction());
        this.initButton(previousButton);
        JButton nextButton = new JButton("Next", ImageUtil.getImageIcon("stock_data-next"));
        nextButton.addActionListener(this.getNextAction());
        this.initButton(nextButton);
        this.searchResult = new JLabel();
        this.initButton(previousButton);
        this.add(closeButton);
        this.add(Box.createHorizontalStrut(5));
        this.add(new JLabel("Find:"));
        this.add(this.searchField);
        this.add(previousButton);
        this.add(nextButton);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.searchResult);
        this.timer = new Timer(500, this.executeSearch());
        this.timer.setRepeats(false);
    }

    private void initButton(AbstractButton button) {
        button.setFocusable(false);
        button.setBorderPainted(false);
        button.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    public SearchCommand getCommand() {
        return new SearchCommand(this.searchField.getText(), false);
    }

    public void activate() {
        this.searchField.requestFocus();
        this.searchField.selectAll();
    }

    private DocumentListener getSearchAction() {
        return new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                SearchBar.this.timer.restart();
            }

            public void insertUpdate(DocumentEvent e) {
                SearchBar.this.timer.restart();
            }

            public void removeUpdate(DocumentEvent e) {
                SearchBar.this.timer.restart();
            }
        };
    }

    private ActionListener executeSearch() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean notFound;
                String searchText = SearchBar.this.searchField.getText();
                SearchHits searchHits = SearchBar.this.meldPanel.doSearch(null);
                boolean bl = notFound = searchHits == null || searchHits.getSearchHits().size() == 0;
                if (notFound) {
                    if (SearchBar.this.searchField.getForeground() != Color.red) {
                        SearchBar.this.searchField.putClientProperty(SearchBar.CP_FOREGROUND, SearchBar.this.searchField.getForeground());
                        SearchBar.this.searchField.setForeground(Color.red);
                    }
                    SearchBar.this.searchResult.setIcon(ImageUtil.getImageIcon("bullet-warning"));
                    SearchBar.this.searchResult.setText("Phrase not found");
                } else {
                    Color color = (Color)SearchBar.this.searchField.getClientProperty(SearchBar.CP_FOREGROUND);
                    if (color != null) {
                        SearchBar.this.searchField.setForeground(color);
                        SearchBar.this.searchField.putClientProperty(SearchBar.CP_FOREGROUND, null);
                    }
                    if (!StringUtil.isEmpty(SearchBar.this.searchResult.getText())) {
                        SearchBar.this.searchResult.setIcon(null);
                        SearchBar.this.searchResult.setText("");
                    }
                }
            }
        };
    }

    private KeyListener getSearchKeyAction() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchBar.this.meldPanel.doNextSearch(null);
                }
            }
        };
    }

    private ActionListener getCloseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SearchBar.this.meldPanel.doStopSearch(null);
            }
        };
    }

    private ActionListener getPreviousAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SearchBar.this.meldPanel.doPreviousSearch(null);
            }
        };
    }

    private ActionListener getNextAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SearchBar.this.meldPanel.doNextSearch(null);
            }
        };
    }
}

