/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.settings;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.settings.EditorSettingsForm;
import org.jmeld.ui.util.EmptyIcon;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class EditorSettingsPanel
extends EditorSettingsForm
implements ConfigurationListenerIF {
    private static JDialog colorDialog;
    private static JColorChooser colorChooser;

    public EditorSettingsPanel() {
        this.initConfiguration();
        this.init();
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    private void init() {
        this.tabSizeSpinner.addChangeListener(this.getTabSizeChangeListener());
        this.showLineNumbersCheckBox.addActionListener(this.getShowLineNumbersAction());
        this.ignoreWhitespaceCheckBox.addActionListener(this.getIgnoreWhitespaceAction());
        this.ignoreEOLCheckBox.addActionListener(this.getIgnoreEOLAction());
        this.ignoreBlankLinesCheckBox.addActionListener(this.getIgnoreBlankLinesAction());
        this.leftsideReadonlyCheckBox.addActionListener(this.getLeftsideReadonlyAction());
        this.rightsideReadonlyCheckBox.addActionListener(this.getRightsideReadonlyAction());
        this.colorAddedButton.addActionListener(this.getColorAddedAction());
        this.colorDeletedButton.addActionListener(this.getColorDeletedAction());
        this.colorChangedButton.addActionListener(this.getColorChangedAction());
        this.restoreOriginalColorsButton.addActionListener(this.getRestoreOriginalColorsAction());
    }

    private ChangeListener getTabSizeChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setTabSize((Integer)EditorSettingsPanel.this.tabSizeSpinner.getValue());
            }
        };
    }

    private ActionListener getColorAddedAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Color color = EditorSettingsPanel.this.chooseColor(EditorSettingsPanel.this.getEditorSettings().getAddedColor());
                if (color != null) {
                    EditorSettingsPanel.this.getEditorSettings().setAddedColor(color);
                }
            }
        };
    }

    private ActionListener getColorDeletedAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Color color = EditorSettingsPanel.this.chooseColor(EditorSettingsPanel.this.getEditorSettings().getDeletedColor());
                if (color != null) {
                    EditorSettingsPanel.this.getEditorSettings().setDeletedColor(color);
                }
            }
        };
    }

    private ActionListener getColorChangedAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Color color = EditorSettingsPanel.this.chooseColor(EditorSettingsPanel.this.getEditorSettings().getChangedColor());
                if (color != null) {
                    EditorSettingsPanel.this.getEditorSettings().setChangedColor(color);
                }
            }
        };
    }

    private ActionListener getShowLineNumbersAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setShowLineNumbers(EditorSettingsPanel.this.showLineNumbersCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreWhitespaceAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreWhitespace(EditorSettingsPanel.this.ignoreWhitespaceCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreEOLAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreEOL(EditorSettingsPanel.this.ignoreEOLCheckBox.isSelected());
            }
        };
    }

    private ActionListener getIgnoreBlankLinesAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setIgnoreBlankLines(EditorSettingsPanel.this.ignoreBlankLinesCheckBox.isSelected());
            }
        };
    }

    private ActionListener getLeftsideReadonlyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setLeftsideReadonly(EditorSettingsPanel.this.leftsideReadonlyCheckBox.isSelected());
            }
        };
    }

    private ActionListener getRightsideReadonlyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().setRightsideReadonly(EditorSettingsPanel.this.rightsideReadonlyCheckBox.isSelected());
            }
        };
    }

    private ActionListener getRestoreOriginalColorsAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorSettingsPanel.this.getEditorSettings().restoreColors();
            }
        };
    }

    private Color chooseColor(Color initialColor) {
        if (colorDialog == null) {
            colorChooser = new JColorChooser(initialColor);
            colorDialog = JColorChooser.createDialog(null, "Choose color", true, colorChooser, null, null);
        }
        colorChooser.setColor(initialColor);
        colorDialog.setVisible(true);
        return colorChooser.getColor();
    }

    public void configurationChanged() {
        this.initConfiguration();
    }

    private void initConfiguration() {
        EditorSettings settings = this.getEditorSettings();
        this.colorAddedButton.setIcon(new EmptyIcon(settings.getAddedColor(), 20, 20));
        this.colorDeletedButton.setIcon(new EmptyIcon(settings.getDeletedColor(), 20, 20));
        this.colorChangedButton.setIcon(new EmptyIcon(settings.getChangedColor(), 20, 20));
        this.showLineNumbersCheckBox.setSelected(settings.getShowLineNumbers());
        this.ignoreWhitespaceCheckBox.setSelected(settings.getIgnore().ignoreWhitespace);
        this.ignoreEOLCheckBox.setSelected(settings.getIgnore().ignoreEOL);
        this.ignoreBlankLinesCheckBox.setSelected(settings.getIgnore().ignoreBlankLines);
        this.leftsideReadonlyCheckBox.setSelected(settings.getLeftsideReadonly());
        this.rightsideReadonlyCheckBox.setSelected(settings.getRightsideReadonly());
        this.tabSizeSpinner.setValue(settings.getTabSize());
    }

    private EditorSettings getEditorSettings() {
        return JMeldSettings.getInstance().getEditor();
    }
}

