/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jmeld.settings.FilterSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.settings.util.Filter;
import org.jmeld.settings.util.FilterRule;
import org.jmeld.ui.settings.FilterSettingsForm;
import org.jmeld.ui.swing.table.JMTableModel;
import org.jmeld.ui.swing.table.util.JMComboBoxEditor;
import org.jmeld.ui.swing.table.util.JMComboBoxRenderer;
import org.jmeld.util.conf.ConfigurationListenerIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSettingsPanel
extends FilterSettingsForm
implements ConfigurationListenerIF {
    JMTableModel filterTableModel;
    JMTableModel filterRuleTableModel;

    public FilterSettingsPanel() {
        this.init();
        this.initConfiguration();
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    private void init() {
        this.filterTableModel = this.getFilterTableModel();
        this.filterTable.setModel(this.filterTableModel);
        this.filterTable.setSelectionMode(0);
        ListSelectionModel selectionModel = this.filterTable.getSelectionModel();
        selectionModel.addListSelectionListener(this.getFilterSelectionAction());
        this.filterRuleTableModel = this.getFilterRuleTableModel(0);
        this.filterRuleTable.setModel(this.filterRuleTableModel);
        this.filterRuleTable.setDefaultEditor(Filter.class, new JMComboBoxEditor(this.getFilters()));
        this.filterRuleTable.setDefaultRenderer(Filter.class, new JMComboBoxRenderer(this.getFilters()));
        this.filterRuleTable.setDefaultEditor(FilterRule.Rule.class, new JMComboBoxEditor((Object[])FilterRule.Rule.values()));
        this.filterRuleTable.setDefaultRenderer(FilterRule.Rule.class, new JMComboBoxRenderer((Object[])FilterRule.Rule.values()));
        this.filterRuleTable.setAutoResizeMode(3);
        this.newFilterButton.addActionListener(this.getNewFilterAction());
        this.deleteFilterButton.addActionListener(this.getDeleteFilterAction());
        this.newFilterRuleButton.addActionListener(this.getNewFilterRuleAction());
        this.deleteFilterRuleButton.addActionListener(this.getDeleteFilterRuleAction());
        if (this.filterTable.getRowCount() > 0) {
            this.filterTable.addRowSelectionInterval(0, 0);
        }
    }

    private JMTableModel getFilterTableModel() {
        return new FilterTableModel();
    }

    private JMTableModel getFilterRuleTableModel(int filterIndex) {
        return new FilterRuleTableModel(filterIndex);
    }

    private ListSelectionListener getFilterSelectionAction() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int rowIndex = FilterSettingsPanel.this.filterTable.getSelectedRow();
                Object value = FilterSettingsPanel.this.filterTableModel.getValueAt(rowIndex, 0);
                FilterSettingsPanel.this.filterNameLabel.setText(value.toString());
                FilterSettingsPanel.this.filterRuleTableModel = FilterSettingsPanel.this.getFilterRuleTableModel(rowIndex);
                FilterSettingsPanel.this.filterRuleTable.setModel(FilterSettingsPanel.this.filterRuleTableModel);
                FilterSettingsPanel.this.filterRuleTable.doLayout();
            }
        };
    }

    private ActionListener getNewFilterAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FilterSettingsPanel.this.getFilterSettings().addFilter(new Filter("Untitled"));
                FilterSettingsPanel.this.filterTableModel.fireTableDataChanged();
            }
        };
    }

    private ActionListener getDeleteFilterAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FilterSettingsPanel.this.getFilterSettings().removeFilter(FilterSettingsPanel.this.getSelectedFilter());
                FilterSettingsPanel.this.filterTableModel.fireTableDataChanged();
            }
        };
    }

    private ActionListener getNewFilterRuleAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Filter filter = FilterSettingsPanel.this.getSelectedFilter();
                if (filter == null) {
                    return;
                }
                FilterRule newRule = new FilterRule("Untitled", FilterRule.Rule.excludes, "", true);
                FilterRule selectedFilterRule = FilterSettingsPanel.this.getSelectedFilterRule();
                if (selectedFilterRule != null) {
                    newRule.setDescription(selectedFilterRule.getDescription());
                    newRule.setRule(selectedFilterRule.getRule());
                    filter.insertRule(selectedFilterRule, newRule);
                } else {
                    filter.addRule(newRule);
                }
                FilterSettingsPanel.this.filterRuleTableModel.fireTableDataChanged();
            }
        };
    }

    private ActionListener getDeleteFilterRuleAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Filter filter = FilterSettingsPanel.this.getSelectedFilter();
                if (filter == null) {
                    return;
                }
                FilterRule rule = FilterSettingsPanel.this.getSelectedFilterRule();
                if (rule == null) {
                    return;
                }
                filter.removeRule(rule);
                FilterSettingsPanel.this.filterRuleTableModel.fireTableDataChanged();
            }
        };
    }

    @Override
    public void configurationChanged() {
        this.initConfiguration();
    }

    private void initConfiguration() {
    }

    private Filter getSelectedFilter() {
        int rowIndex = this.filterTable.getSelectedRow();
        if (rowIndex < 0 || rowIndex > this.getFilters().size()) {
            return null;
        }
        return this.getFilters().get(rowIndex);
    }

    private FilterRule getSelectedFilterRule() {
        Filter filter = this.getSelectedFilter();
        if (filter == null) {
            return null;
        }
        int rowIndex = this.filterRuleTable.getSelectedRow();
        if (rowIndex < 0 || rowIndex > filter.getRules().size()) {
            return null;
        }
        return filter.getRules().get(rowIndex);
    }

    private List<FilterRule> getRules(int filterIndex) {
        int size = this.getFilters().size();
        if (filterIndex < 0 || filterIndex >= size) {
            return Collections.emptyList();
        }
        return this.getFilters().get(filterIndex).getRules();
    }

    private List<Filter> getFilters() {
        return this.getFilterSettings().getFilters();
    }

    private FilterSettings getFilterSettings() {
        return JMeldSettings.getInstance().getFilter();
    }

    private class FilterRuleTableModel
    extends JMTableModel {
        private int filterIndex;
        private JMTableModel.Column activeColumn;
        private JMTableModel.Column descriptionColumn;
        private JMTableModel.Column ruleColumn;
        private JMTableModel.Column patternColumn;

        public FilterRuleTableModel(int filterIndex) {
            this.filterIndex = filterIndex;
            this.init();
        }

        private void init() {
            this.activeColumn = this.addColumn("active", null, "Active", Boolean.class, 5, true, null);
            this.descriptionColumn = this.addColumn("description", null, "Description", String.class, 15, true, null);
            this.ruleColumn = this.addColumn("rule", null, "Rule", FilterRule.Rule.class, 10, true, null);
            this.patternColumn = this.addColumn("pattern", null, "Pattern", String.class, -1, true, null);
        }

        public int getRowCount() {
            return FilterSettingsPanel.this.getRules(this.filterIndex).size();
        }

        public void setValueAt(Object value, int rowIndex, JMTableModel.Column column) {
            FilterRule rule = this.getRule(rowIndex);
            if (rule != null) {
                if (column == this.activeColumn) {
                    rule.setActive((Boolean)value);
                }
                if (column == this.descriptionColumn) {
                    rule.setDescription((String)value);
                }
                if (column == this.ruleColumn) {
                    rule.setRule((FilterRule.Rule)((Object)value));
                    this.fireTableCellUpdated(rowIndex, column.getColumnIndex());
                }
                if (column == this.patternColumn) {
                    if (value instanceof Filter) {
                        value = ((Filter)value).getName();
                    }
                    rule.setPattern((String)value);
                }
            }
        }

        public Object getValueAt(int rowIndex, JMTableModel.Column column) {
            FilterRule rule = this.getRule(rowIndex);
            if (rule != null) {
                if (column == this.activeColumn) {
                    return rule.isActive();
                }
                if (column == this.descriptionColumn) {
                    return rule.getDescription();
                }
                if (column == this.ruleColumn) {
                    return rule.getRule();
                }
                if (column == this.patternColumn) {
                    if (rule.getRule() == FilterRule.Rule.importFilter) {
                        return FilterSettingsPanel.this.getFilterSettings().getFilter(rule.getPattern());
                    }
                    return rule.getPattern();
                }
            }
            return "??";
        }

        public Class getColumnClass(int rowIndex, JMTableModel.Column column) {
            FilterRule rule;
            if (column == this.patternColumn && (rule = this.getRule(rowIndex)) != null && rule.getRule() == FilterRule.Rule.importFilter) {
                return Filter.class;
            }
            return null;
        }

        private FilterRule getRule(int rowIndex) {
            return (FilterRule)FilterSettingsPanel.this.getRules(this.filterIndex).get(rowIndex);
        }
    }

    private class FilterTableModel
    extends JMTableModel {
        JMTableModel.Column nameColumn = this.addColumn("name", null, "Name", String.class, -1, true, null);

        FilterTableModel() {
        }

        public int getRowCount() {
            return FilterSettingsPanel.this.getFilterSettings().getFilters().size();
        }

        public void setValueAt(Object value, int rowIndex, JMTableModel.Column column) {
            Filter filter = this.getFilter(rowIndex);
            if (filter != null && column == this.nameColumn) {
                filter.setName((String)value);
            }
        }

        public Object getValueAt(int rowIndex, JMTableModel.Column column) {
            Filter filter = this.getFilter(rowIndex);
            if (filter != null && column == this.nameColumn) {
                return filter.getName();
            }
            return "";
        }

        private Filter getFilter(int rowIndex) {
            return (Filter)FilterSettingsPanel.this.getFilters().get(rowIndex);
        }
    }
}

