/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.util.Colors;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class JMHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter
implements ConfigurationListenerIF {
    public static final JMHighlightPainter ADDED = new JMHighlightPainter(Colors.ADDED);
    public static final JMHighlightPainter ADDED_LINE;
    public static final JMHighlightPainter CHANGED;
    public static final JMHighlightPainter CHANGED2;
    public static final JMHighlightPainter DELETED;
    public static final JMHighlightPainter DELETED_LINE;
    public static final JMHighlightPainter CURRENT_SEARCH;
    public static final JMHighlightPainter SEARCH;
    private Color color;
    private boolean line;
    private boolean debug;

    private JMHighlightPainter(Color color) {
        this(color, false);
    }

    private JMHighlightPainter(Color color, boolean line) {
        super(color);
        this.color = color;
        this.line = line;
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    public void paint(Graphics g, int p0, int p1, Shape shape, JTextComponent comp) {
        Rectangle b = shape.getBounds();
        try {
            Rectangle r1 = comp.modelToView(p0);
            Rectangle r2 = comp.modelToView(p1);
            g.setColor(this.color);
            if (this.line) {
                g.drawLine(0, r1.y, b.x + b.width, r1.y);
            } else if (this == CHANGED2 || this == SEARCH || this == CURRENT_SEARCH) {
                if (r1.y == r2.y) {
                    g.fillRect(r1.x, r1.y, r2.x - r1.x, r1.height);
                } else {
                    this.debug("r1: x=%d,y=%d,width=%d,height=%d\n", r1.x, r1.y, r1.width, r1.height);
                    this.debug("r2: x=%d,y=%d,width=%d,height=%d\n", r2.x, r2.y, r2.width, r2.height);
                    int count = (r2.y - r1.y) / r1.height + 1;
                    this.debug("count = " + count, new Object[0]);
                    int y = r1.y;
                    int i = 0;
                    while (i < count) {
                        int width;
                        int x;
                        if (i == 0) {
                            x = r1.x;
                            width = b.width - b.x;
                            this.debug("first     : ", new Object[0]);
                        } else if (i == count - 1) {
                            x = b.x;
                            width = r2.x - x;
                            this.debug("last      : ", new Object[0]);
                        } else {
                            x = b.x;
                            width = b.width - b.x;
                            this.debug("in between: ", new Object[0]);
                        }
                        this.debug("x=%d,y=%d,width=%d,height=%d\n", x, y, width, r1.height);
                        g.fillRect(x, y, width, r1.height);
                        ++i;
                        y += r1.height;
                    }
                }
            } else {
                g.fillRect(0, r1.y, b.x + b.width, r2.y - r1.y);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void configurationChanged() {
        this.initConfiguration();
    }

    private void initConfiguration() {
        if (this == ADDED || this == ADDED_LINE) {
            this.color = this.getSettings().getAddedColor();
        } else if (this == DELETED || this == DELETED_LINE) {
            this.color = this.getSettings().getDeletedColor();
        } else if (this == CHANGED) {
            this.color = this.getSettings().getChangedColor();
        }
    }

    private EditorSettings getSettings() {
        return JMeldSettings.getInstance().getEditor();
    }

    private void debug(String format, Object ... args) {
        if (this.debug) {
            System.out.printf(format, args);
        }
    }

    static {
        ADDED.initConfiguration();
        ADDED_LINE = new JMHighlightPainter(Colors.ADDED, true);
        ADDED_LINE.initConfiguration();
        CHANGED = new JMHighlightPainter(Colors.CHANGED);
        CHANGED.initConfiguration();
        CHANGED2 = new JMHighlightPainter(Colors.CHANGED2);
        CHANGED2.initConfiguration();
        DELETED = new JMHighlightPainter(Colors.DELETED);
        DELETED.initConfiguration();
        DELETED_LINE = new JMHighlightPainter(Colors.DELETED, true);
        DELETED_LINE.initConfiguration();
        SEARCH = new JMHighlightPainter(Color.yellow);
        SEARCH.initConfiguration();
        CURRENT_SEARCH = new JMHighlightPainter(Color.yellow.darker());
        CURRENT_SEARCH.initConfiguration();
    }
}

