/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.util.ColorUtil;

public class LineNumberBorder
extends EmptyBorder {
    private static int MARGIN = 4;
    private FilePanel filePanel;
    private Color background;
    private Color lineColor;
    private Font font;
    private int fontWidth;
    private int fontHeight;
    private boolean enableBlame = true;

    public LineNumberBorder(FilePanel filePanel) {
        super(0, 40 + MARGIN, 0, 0);
        this.filePanel = filePanel;
        this.init();
    }

    public void enableBlame(boolean enableBlame) {
        this.enableBlame = enableBlame;
    }

    private void init() {
        this.lineColor = UIManager.getColor("Panel.background");
        if (this.lineColor == null) {
            this.lineColor = new Color(244, 242, 198);
        }
        this.background = ColorUtil.brighter(this.lineColor);
        this.font = new Font("Monospaced", 0, 10);
        FontMetrics fm = this.filePanel.getEditor().getFontMetrics(this.font);
        this.fontWidth = fm.stringWidth("0");
        this.fontHeight = fm.getHeight();
    }

    public void paintBefore(Graphics g) {
        Rectangle clip = g.getClipRect();
        g.setColor(this.background);
        g.fillRect(0, clip.y, this.left - MARGIN, clip.y + clip.height);
    }

    public void paintAfter(Graphics g, int startOffset, int endOffset) {
        Rectangle clip = g.getClipRect();
        try {
            JTextArea textArea = this.filePanel.getEditor();
            int startLine = textArea.getLineOfOffset(startOffset);
            int endLine = textArea.getLineOfOffset(endOffset);
            Rectangle r1 = textArea.modelToView(startOffset);
            int y = r1.y;
            int lineHeight = r1.height;
            int heightCorrection = (lineHeight - this.fontHeight) / 2;
            g.setColor(this.lineColor);
            g.drawLine(this.left - MARGIN, clip.y, this.left - MARGIN, clip.y + clip.height);
            g.setFont(this.font);
            g.setColor(Color.black);
            for (int line = startLine; line <= endLine; ++line) {
                String s = Integer.toString(line + 1);
                g.drawString(s, this.left - this.fontWidth * s.length() - 1 - MARGIN, (y += lineHeight) - heightCorrection);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

