/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing.table;

import java.util.HashMap;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jmeld.ui.swing.ColumnGroup;
import org.jmeld.ui.swing.GroupableTableHeader;
import org.jmeld.ui.swing.table.JMTableModel;

public class JMTable
extends JXTable {
    private int charWidth = this.getFontMetrics(this.getFont()).charWidth('W');

    public void setModel(JMTableModel tableModel) {
        super.setModel(tableModel);
        if (tableModel != null) {
            if (this.getRowHeight() < 22) {
                this.setRowHeight(22);
            }
            TableColumnModel columnModel = this.getColumnModel();
            GroupableTableHeader tableHeader = new GroupableTableHeader(columnModel);
            this.setTableHeader(tableHeader);
            HashMap<String, ColumnGroup> columnGroups = new HashMap<String, ColumnGroup>();
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                String groupName;
                int preferredWidth;
                TableColumn column = columnModel.getColumn(i);
                TableCellRenderer renderer = tableModel.getRenderer(i);
                if (renderer != null) {
                    column.setCellRenderer(renderer);
                }
                TableCellEditor editor = tableModel.getEditor(i);
                if (renderer != null) {
                    column.setCellEditor(editor);
                }
                if ((preferredWidth = this.charWidth * tableModel.getColumnSize(i)) > 0) {
                    column.setMinWidth(preferredWidth);
                    column.setMaxWidth(preferredWidth);
                    column.setPreferredWidth(preferredWidth);
                }
                if ((groupName = tableModel.getColumnGroupName(i)) == null) continue;
                ColumnGroup group = (ColumnGroup)columnGroups.get(groupName);
                if (group == null) {
                    group = new ColumnGroup(groupName);
                    columnGroups.put(groupName, group);
                }
                group.add(column);
            }
            for (ColumnGroup cg : columnGroups.values()) {
                tableHeader.addColumnGroup(cg);
            }
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Class clazz = ((JMTableModel)this.getModel()).getColumnClass(row, column);
        TableCellEditor editor = this.getDefaultEditor(clazz);
        if (editor != null) {
            return editor;
        }
        return super.getCellEditor(row, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Class clazz;
        TableCellRenderer renderer;
        TableModel model = this.getModel();
        if (model instanceof JMTableModel && (renderer = this.getDefaultRenderer(clazz = ((JMTableModel)model).getColumnClass(row, column))) != null) {
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }
}

