/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.text;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jmeld.JMeldException;
import org.jmeld.ui.text.AbstractBufferDocument;

public class FileDocument
extends AbstractBufferDocument {
    private File file;

    public FileDocument(File file) {
        this.file = file;
        try {
            this.setName(file.getCanonicalPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setName(file.getName());
        }
        this.setShortName(file.getName());
    }

    public int getBufferSize() {
        return (int)this.file.length();
    }

    protected Reader getReader() throws JMeldException {
        if (!this.file.isFile() || !this.file.canRead()) {
            throw new JMeldException("Could not open file: " + this.file);
        }
        try {
            return new FileReader(this.file);
        }
        catch (Exception ex) {
            throw new JMeldException("Could not create FileReader for : " + this.file.getName(), ex);
        }
    }

    protected Writer getWriter() throws JMeldException {
        try {
            return new FileWriter(this.file);
        }
        catch (IOException ex) {
            throw new JMeldException("Cannot create FileWriter for file: " + this.file.getName(), ex);
        }
    }

    public static void main(String[] args) {
        try {
            FileDocument fd = new FileDocument(new File(args[0]));
            fd.read();
            fd.print();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

